<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('support_ticket_attachments', function (Blueprint $table) {
            $table->id();
            
            // Parent References
            $table->foreignId('ticket_id')
                  ->constrained('support_tickets')
                  ->cascadeOnDelete();
            
            $table->foreignId('reply_id')->nullable()
                  ->comment('NULL = attached to main ticket, NOT NULL = attached to reply')
                  ->constrained('support_ticket_replies')
                  ->cascadeOnDelete();
            
            // File Information
            $table->string('file_name', 191)
                  ->comment('Original filename with extension');
            $table->string('file_path', 500)
                  ->comment('Storage path: support_tickets/{ticket_id}/{filename}');
            $table->string('file_type', 50)->nullable()
                  ->comment('MIME type: image/jpeg, application/pdf, etc.');
            $table->integer('file_size')->nullable()
                  ->comment('File size in bytes');
            
            $table->timestamp('uploaded_at')->useCurrent();
            $table->timestamps();
            
            // Indexes
            $table->index('ticket_id');
            $table->index('reply_id');
            $table->index('uploaded_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('support_ticket_attachments');
    }
};