<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('support_ticket_notes', function (Blueprint $table) {
            $table->id();
            
            $table->foreignId('ticket_id')
                  ->constrained('support_tickets')
                  ->cascadeOnDelete();
            
            $table->foreignId('staff_id')
                  ->constrained('staffs')
                  ->cascadeOnDelete();
            
            $table->text('note')->comment('Internal note (not visible to customer)');
            
            $table->timestamps();
            
            $table->index('ticket_id');
            $table->index('staff_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('support_ticket_notes');
    }
};