<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('support_ticket_reminders', function (Blueprint $table) {
            $table->id();
            
            $table->foreignId('ticket_id')
                  ->constrained('support_tickets')
                  ->cascadeOnDelete();
            
            $table->foreignId('staff_id')
                  ->comment('Staff to be reminded')
                  ->constrained('staffs')
                  ->cascadeOnDelete();
            
            $table->string('description', 500);
            $table->timestamp('remind_at')->comment('When to send reminder');
            $table->boolean('is_notified')->default(false);
            
            $table->timestamps();
            
            $table->index('ticket_id');
            $table->index('staff_id');
            $table->index('remind_at');
            $table->index('is_notified');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('support_ticket_reminders');
    }
};