<?php

namespace Modules\Support\Http\Controllers;

use App\Http\Controllers\Admin\AdminController;
use Modules\Support\Models\Ticket;
use Modules\Support\Models\Department;
use Modules\Support\Models\Priority;
use Modules\Support\Models\Status;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Exception;

class DashboardController extends AdminController
{
    /**
     * Show dashboard with statistics and overview
     */
    public function index()
    {
        try {
            // Overall statistics - MATCH VIEW EXPECTATIONS
            $stats = [
                'total' => Ticket::count(),
                'open' => Ticket::open()->count(),
                'unread' => Ticket::unread()->count(),
                'unassigned' => Ticket::unassigned()->count(),
            ];

            // Recent tickets (last 10) - RETURN ACTUAL MODELS
            $recentTickets = Ticket::with(['department', 'priority', 'status', 'assignedStaff', 'customer'])
                ->orderBy('created_at', 'desc')
                ->limit(10)
                ->get();

            return view('support::admin.dashboard', compact(
                'stats',
                'recentTickets'
            ));

        } catch (Exception $e) {
            Log::error('Dashboard Load Failed:', ['error' => $e->getMessage()]);
            return back()->with('error', 'Failed to load dashboard: ' . $e->getMessage());
        }
    }

    /**
     * Get dashboard statistics (AJAX refresh)
     */
    public function getStats()
    {
        try {
            $stats = [
                'total' => Ticket::count(),
                'open' => Ticket::open()->count(),
                'unread' => Ticket::unread()->count(),
                'unassigned' => Ticket::unassigned()->count(),
                'my_tickets' => Ticket::assignedTo($this->admin->id)->count(),
                'closed_today' => Ticket::closed()->whereDate('updated_at', today())->count(),
            ];

            return response()->json([
                'success' => true,
                'message' => 'Statistics loaded successfully',
                'stats' => $stats
            ]);

        } catch (Exception $e) {
            Log::error('Get Stats Failed:', ['error' => $e->getMessage()]);
            
            return response()->json([
                'success' => false,
                'message' => 'Failed to load statistics: ' . $e->getMessage()
            ], 500);
        }
    }
}