<?php

namespace Modules\Support\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class TicketNote extends Model
{
    protected $table = 'support_ticket_notes';

    protected $fillable = [
        'ticket_id',
        'staff_id',
        'note',
    ];

    protected $casts = [
        'ticket_id' => 'integer',
        'staff_id' => 'integer',
    ];

    public function ticket(): BelongsTo
    {
        return $this->belongsTo(Ticket::class, 'ticket_id');
    }

    public function staff(): BelongsTo
    {
        return $this->belongsTo(\App\Models\Admin\Staff::class, 'staff_id');
    }
}