<?php

namespace Modules\Support\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class TicketReminder extends Model
{
    protected $table = 'support_ticket_reminders';

    protected $fillable = [
        'ticket_id',
        'staff_id',
        'description',
        'remind_at',
        'is_notified',
    ];

    protected $casts = [
        'ticket_id' => 'integer',
        'staff_id' => 'integer',
        'remind_at' => 'datetime',
        'is_notified' => 'boolean',
    ];

    public function ticket(): BelongsTo
    {
        return $this->belongsTo(Ticket::class, 'ticket_id');
    }

    public function staff(): BelongsTo
    {
        return $this->belongsTo(\App\Models\Admin\Staff::class, 'staff_id');
    }
}