<style>
/* ========== DARK MODE VARIABLES ========== */
:root {
    --space-xl: 32px;
    --space-lg: 24px;
    --space-md: 16px;
    --navbar-height: 60px;
    --primary: #6366f1;
    --card-bg: #ffffff;
    --card-border: #e5e7eb;
    --body-bg: #f9fafb;
    --text-primary: #111827;
    --text-secondary: #6b7280;
    --text-muted: #9ca3af;
    --shadow-sm: 0 1px 3px 0 rgba(0, 0, 0, 0.1);
    --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
}

[data-theme="dark"], 
.dark-mode,
body.dark-mode,
html.dark-mode,
html[data-theme="dark"],
body[data-theme="dark"] {
    --card-bg: #1e293b;
    --card-border: #334155;
    --body-bg: #0f172a;
    --text-primary: #f1f5f9;
    --text-secondary: #cbd5e1;
    --text-muted: #94a3b8;
    --shadow-sm: 0 1px 3px 0 rgba(0, 0, 0, 0.3);
    --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.4);
}

@media (prefers-color-scheme: dark) {
    :root:not([data-theme="light"]) {
        --card-bg: #1e293b;
        --card-border: #334155;
        --body-bg: #0f172a;
        --text-primary: #f1f5f9;
        --text-secondary: #cbd5e1;
        --text-muted: #94a3b8;
        --shadow-sm: 0 1px 3px 0 rgba(0, 0, 0, 0.3);
        --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.4);
    }
}

/* ========== SUPPORT DASHBOARD - ENHANCED UI/UX ========== */

.dashboard-container {
    padding: var(--space-xl);
    min-height: calc(100vh - var(--navbar-height));
    background: var(--body-bg);
    transition: background 300ms ease;
}

/* ========== PAGE HEADER - GRADIENT BACKGROUND ========== */
.page-header {
    background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
    padding: 24px 32px;
    border-radius: 16px;
    margin-bottom: var(--space-xl);
    box-shadow: 0 8px 24px rgba(99, 102, 241, 0.3);
    animation: slideDown 600ms cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    overflow: hidden;
}

/* Decorative Pattern Overlay */
.page-header::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(135deg, transparent 0%, rgba(0, 0, 0, 0.1) 100%);
    pointer-events: none;
}

.page-header-content {
    position: relative;
    z-index: 1;
}

@keyframes slideDown {
    from { opacity: 0; transform: translateY(-20px); }
    to { opacity: 1; transform: translateY(0); }
}

.page-header h1 {
    color: white;
    font-size: 26px;
    font-weight: 700;
    display: flex;
    align-items: center;
    gap: 12px;
    margin-bottom: 6px;
    line-height: 1.2;
}

.page-header h1 svg {
    width: 28px;
    height: 28px;
    animation: iconPulse 3s ease-in-out infinite;
}

@keyframes iconPulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.05); }
}

.page-header p {
    color: rgba(255, 255, 255, 0.95);
    font-size: 14px;
    font-weight: 500;
}

/* ========== STATS GRID - COMPACT SINGLE ROW ========== */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 16px;
    margin-bottom: 28px;
    animation: fadeInUp 500ms cubic-bezier(0.4, 0, 0.2, 1) 100ms backwards;
}

@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

.stat-card {
    background: var(--card-bg);
    padding: 16px 20px;
    border-radius: 14px;
    box-shadow: var(--shadow-sm);
    border: 1px solid var(--card-border);
    transition: all 400ms cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    overflow: hidden;
    display: flex;
    align-items: center;
    gap: 14px;
}

/* Decorative Tile Pattern */
.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    width: 80px;
    height: 80px;
    background: linear-gradient(135deg, transparent 50%, rgba(99, 102, 241, 0.05) 50%);
    pointer-events: none;
}

.stat-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.12);
}

.stat-header {
    position: relative;
    z-index: 1;
    flex-shrink: 0;
}

/* Gradient Icon Containers - Smaller */
.stat-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 400ms cubic-bezier(0.4, 0, 0.2, 1);
    box-shadow: 0 3px 10px rgba(0, 0, 0, 0.15);
}

.stat-card:hover .stat-icon {
    transform: scale(1.08) rotate(5deg);
}

.stat-icon svg {
    width: 20px;
    height: 20px;
    color: white;
}

.stat-icon.blue { 
    background: linear-gradient(135deg, #3b82f6, #2563eb);
}

.stat-icon.green { 
    background: linear-gradient(135deg, #10b981, #059669);
}

.stat-icon.yellow { 
    background: linear-gradient(135deg, #f59e0b, #d97706);
}

.stat-icon.red { 
    background: linear-gradient(135deg, #ef4444, #dc2626);
}

.stat-content {
    position: relative;
    z-index: 1;
    flex: 1;
    min-width: 0;
}

.stat-value {
    font-size: 26px;
    font-weight: 800;
    color: var(--text-primary);
    line-height: 1;
    margin-bottom: 6px;
}

.stat-label {
    font-size: 11px;
    color: var(--text-secondary);
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

/* ========== RECENT TICKETS CARD ========== */
.tickets-list-card {
    background: var(--card-bg);
    padding: 28px;
    border-radius: 16px;
    box-shadow: var(--shadow-sm);
    border: 1px solid var(--card-border);
    animation: fadeInUp 500ms cubic-bezier(0.4, 0, 0.2, 1) 200ms backwards;
    transition: all 300ms ease;
}

.tickets-list-header {
    font-size: 18px;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    gap: 10px;
    padding-bottom: 16px;
    border-bottom: 2px solid var(--card-border);
}

.tickets-list-header svg {
    width: 20px;
    height: 20px;
    color: var(--primary);
}

/* Ticket Item - Enhanced */
.ticket-item {
    padding: 16px 18px;
    background: var(--body-bg);
    border-radius: 12px;
    margin-bottom: 12px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 16px;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    border: 1px solid transparent;
}

.ticket-item:last-child {
    margin-bottom: 0;
}

.ticket-item:hover {
    background: var(--card-bg);
    border-color: var(--primary);
    transform: translateX(4px);
    box-shadow: var(--shadow-sm);
}

.ticket-info {
    flex: 1;
    min-width: 0;
}

.ticket-subject {
    font-size: 14px;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 6px;
    display: flex;
    align-items: center;
    gap: 8px;
}

.ticket-subject a {
    color: var(--text-primary);
    text-decoration: none;
    transition: color 300ms;
    display: flex;
    align-items: center;
    gap: 8px;
}

.ticket-subject a:hover {
    color: var(--primary);
}

.ticket-id {
    font-family: 'Courier New', monospace;
    font-weight: 700;
    color: var(--primary);
    font-size: 13px;
}

.ticket-meta {
    font-size: 12px;
    color: var(--text-secondary);
    display: flex;
    align-items: center;
    gap: 8px;
}

.ticket-meta svg {
    width: 12px;
    height: 12px;
}

/* Status Badge - Enhanced */
.ticket-badge {
    padding: 6px 14px;
    border-radius: 8px;
    font-size: 12px;
    font-weight: 600;
    white-space: nowrap;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    transition: all 300ms;
}

.ticket-item:hover .ticket-badge {
    transform: scale(1.05);
}

/* ========== EMPTY STATE - ENHANCED ========== */
.empty-state {
    text-align: center;
    padding: 64px 24px;
    background: var(--body-bg);
    border-radius: 12px;
}

.empty-state svg {
    width: 80px;
    height: 80px;
    color: var(--text-muted);
    margin-bottom: 20px;
    opacity: 0.5;
}

.empty-state h3 {
    font-size: 18px;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 8px;
}

.empty-state p {
    color: var(--text-secondary);
    font-size: 14px;
}

/* ========== RESPONSIVE DESIGN ========== */
@media (max-width: 1200px) {
    .stats-grid {
        grid-template-columns: repeat(4, 1fr);
        gap: 12px;
    }
    
    .stat-card {
        padding: 14px 16px;
    }
    
    .stat-icon {
        width: 44px;
        height: 44px;
    }
    
    .stat-icon svg {
        width: 18px;
        height: 18px;
    }
    
    .stat-value {
        font-size: 22px;
    }
    
    .stat-label {
        font-size: 10px;
    }
}

@media (max-width: 1024px) {
    .stats-grid {
        grid-template-columns: repeat(2, 1fr);
        gap: 16px;
    }
    
    .stat-card {
        padding: 16px 18px;
    }
}

@media (max-width: 640px) {
    .dashboard-container {
        padding: var(--space-lg);
    }

    .stats-grid {
        grid-template-columns: 1fr;
        gap: 12px;
    }

    .page-header {
        padding: 20px 24px;
    }

    .page-header h1 {
        font-size: 22px;
    }

    .stat-card {
        padding: 16px 20px;
    }

    .stat-value {
        font-size: 24px;
    }

    .stat-label {
        font-size: 11px;
    }

    .ticket-item {
        flex-direction: column;
        align-items: flex-start;
    }

    .ticket-badge {
        align-self: flex-start;
    }
}
</style>

<div class="dashboard-container">
    <!-- Page Header - Enhanced -->
    <div class="page-header">
        <div class="page-header-content">
            <h1>
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                </svg>
                Support Dashboard
            </h1>
            <p>Overview of support tickets and activity</p>
        </div>
    </div>

    <!-- Stats Grid - Compact Single Row -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-header">
                <div class="stat-icon blue">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 5v2m0 4v2m0 4v2M5 5a2 2 0 00-2 2v3a2 2 0 110 4v3a2 2 0 002 2h14a2 2 0 002-2v-3a2 2 0 110-4V7a2 2 0 00-2-2H5z"/>
                    </svg>
                </div>
            </div>
            <div class="stat-content">
                <div class="stat-value">{{ $stats['total'] ?? 0 }}</div>
                <div class="stat-label">Total Tickets</div>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-header">
                <div class="stat-icon green">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
            </div>
            <div class="stat-content">
                <div class="stat-value">{{ $stats['open'] ?? 0 }}</div>
                <div class="stat-label">Open Tickets</div>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-header">
                <div class="stat-icon yellow">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                    </svg>
                </div>
            </div>
            <div class="stat-content">
                <div class="stat-value">{{ $stats['unread'] ?? 0 }}</div>
                <div class="stat-label">Unread</div>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-header">
                <div class="stat-icon red">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
            </div>
            <div class="stat-content">
                <div class="stat-value">{{ $stats['unassigned'] ?? 0 }}</div>
                <div class="stat-label">Unassigned</div>
            </div>
        </div>
    </div>

<!-- Recent Tickets - Enhanced -->
<div class="tickets-list-card">
    <div class="tickets-list-header">
        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
        </svg>
        Recent Tickets
    </div>
    
    @forelse($recentTickets as $ticket)
    <div class="ticket-item">
        <div class="ticket-info">
            <div class="ticket-subject">
                <a href="{{ route('admin.support.tickets.show', $ticket->id) }}">
                    <span class="ticket-id">#{{ $ticket->id }}</span>
                    <span>{{ $ticket->subject }}</span>
                </a>
            </div>
            <div class="ticket-meta">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                </svg>
                <span>{{ $ticket->name }}</span>
                <span>•</span>
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                <span>{{ $ticket->created_at->diffForHumans() }}</span>
            </div>
        </div>
        <span class="ticket-badge" style="background-color: {{ $ticket->status->status_color }}; color: white;">
            {{ $ticket->status->name }}
        </span>
    </div>
    @empty
    <div class="empty-state">
        <svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" d="M15 5v2m0 4v2m0 4v2M5 5a2 2 0 00-2 2v3a2 2 0 110 4v3a2 2 0 002 2h14a2 2 0 002-2v-3a2 2 0 110-4V7a2 2 0 00-2-2H5z"/>
        </svg>
        <h3>No Tickets Yet</h3>
        <p>Support tickets will appear here once they are created</p>
    </div>
    @endforelse
</div>
</div>