<style>
/* ========== DEPARTMENT EDIT FORM - ECHOPX COMPLIANT ========== */

@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes slideInRight {
    from { opacity: 0; transform: translateX(20px); }
    to { opacity: 1; transform: translateX(0); }
}

@keyframes shake {
    0%, 100% { transform: translateX(0); }
    25% { transform: translateX(-5px); }
    75% { transform: translateX(5px); }
}

/* ========== FORM CONTAINER ========== */
.form-container-main {
    padding: 32px;
    min-height: calc(100vh - 80px);
    animation: fadeInUp 500ms cubic-bezier(0.4, 0, 0.2, 1);
}

/* ========== PAGE HEADER ========== */
.page-header-styled {
    background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
    padding: 24px 32px;
    border-radius: 16px;
    margin-bottom: 32px;
    box-shadow: 0 8px 24px rgba(99, 102, 241, 0.25);
    position: relative;
    overflow: hidden;
}

.page-header-styled::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: radial-gradient(circle at top right, rgba(255, 255, 255, 0.1), transparent 60%);
    pointer-events: none;
}

.page-header-title {
    color: #ffffff;
    font-size: 24px;
    font-weight: 700;
    display: flex;
    align-items: center;
    gap: 14px;
    margin: 0;
    position: relative;
    z-index: 1;
}

.page-header-title svg {
    width: 26px;
    height: 26px;
    flex-shrink: 0;
}

/* ========== ALERT MESSAGES ========== */
.alert-styled {
    padding: 16px 20px;
    border-radius: 12px;
    margin-bottom: 24px;
    display: flex;
    align-items: flex-start;
    gap: 12px;
    animation: shake 400ms cubic-bezier(0.4, 0, 0.2, 1);
}

.alert-danger-styled {
    background: rgba(239, 68, 68, 0.12);
    color: var(--danger);
    border: 1.5px solid rgba(239, 68, 68, 0.3);
}

.alert-styled svg {
    width: 20px;
    height: 20px;
    flex-shrink: 0;
    margin-top: 2px;
}

.alert-content {
    flex: 1;
}

.alert-content strong {
    font-weight: 700;
    display: block;
    margin-bottom: 8px;
}

.alert-content ul {
    margin: 8px 0 0 0;
    padding-left: 20px;
    list-style: disc;
}

.alert-content ul li {
    margin-bottom: 4px;
    line-height: 1.5;
}

/* ========== FORM CARD ========== */
.form-card-styled {
    background: var(--card-bg);
    padding: 32px;
    border-radius: 16px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
    border: 1px solid var(--card-border);
    max-width: 800px;
    animation: slideInRight 500ms cubic-bezier(0.4, 0, 0.2, 1) 100ms backwards;
}

/* ========== FORM GROUPS ========== */
.form-group-styled {
    margin-bottom: 28px;
}

.form-label-styled {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 10px;
}

.form-label-styled svg {
    width: 16px;
    height: 16px;
    color: var(--text-secondary);
    flex-shrink: 0;
}

.form-label-styled.required::after {
    content: '*';
    color: var(--danger);
    margin-left: 4px;
    font-size: 16px;
    font-weight: 700;
}

.form-input-styled,
.form-select-styled,
.form-textarea-styled {
    width: 100%;
    padding: 12px 16px;
    border: 1.5px solid var(--card-border);
    border-radius: 12px;
    font-size: 14px;
    color: var(--text-primary);
    background: var(--card-bg);
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    line-height: 1.5;
    font-family: inherit;
}

.form-input-styled::placeholder,
.form-textarea-styled::placeholder {
    color: var(--text-muted);
}

.form-input-styled:focus,
.form-select-styled:focus,
.form-textarea-styled:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
}

.form-input-styled.input-error,
.form-textarea-styled.input-error {
    border-color: var(--danger);
    animation: shake 400ms cubic-bezier(0.4, 0, 0.2, 1);
}

.form-textarea-styled {
    min-height: 120px;
    resize: vertical;
}

/* ========== HELP TEXT ========== */
.help-text-styled {
    font-size: 12px;
    color: var(--text-secondary);
    margin-top: 8px;
    display: flex;
    align-items: center;
    gap: 6px;
    line-height: 1.5;
}

.help-text-styled svg {
    width: 12px;
    height: 12px;
    flex-shrink: 0;
}

/* ========== CHECKBOX WRAPPER ========== */
.checkbox-container {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 14px 16px;
    background: var(--body-bg);
    border-radius: 12px;
    border: 1.5px solid transparent;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    cursor: pointer;
}

.checkbox-container:hover {
    background: rgba(99, 102, 241, 0.05);
    border-color: var(--primary);
}

.checkbox-container input[type="checkbox"] {
    width: 20px;
    height: 20px;
    cursor: pointer;
    accent-color: var(--primary);
    flex-shrink: 0;
}

.checkbox-container label {
    font-size: 14px;
    font-weight: 600;
    color: var(--text-primary);
    cursor: pointer;
    user-select: none;
    line-height: 1.4;
}

/* ========== FORM ACTIONS ========== */
.form-actions-styled {
    display: flex;
    gap: 14px;
    margin-top: 32px;
    padding-top: 24px;
    border-top: 2px solid var(--card-border);
}

.btn-styled {
    padding: 12px 28px;
    border-radius: 12px;
    font-weight: 600;
    font-size: 14px;
    border: none;
    cursor: pointer;
    display: inline-flex;
    align-items: center;
    gap: 10px;
    text-decoration: none;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.btn-styled svg {
    width: 16px;
    height: 16px;
    flex-shrink: 0;
}

.btn-primary-styled {
    background: var(--primary);
    color: #ffffff;
    box-shadow: 0 2px 8px rgba(99, 102, 241, 0.25);
}

.btn-primary-styled:hover {
    background: #4f46e5;
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(99, 102, 241, 0.35);
}

.btn-primary-styled:active {
    transform: translateY(0);
}

.btn-secondary-styled {
    background: var(--body-bg);
    color: var(--text-primary);
    border: 1.5px solid var(--card-border);
}

.btn-secondary-styled:hover {
    background: var(--card-border);
    transform: translateY(-2px);
}

.btn-secondary-styled:active {
    transform: translateY(0);
}

/* ========== FORM ERROR ========== */
.form-error-styled {
    color: var(--danger);
    font-size: 12px;
    font-weight: 600;
    margin-top: 8px;
    display: flex;
    align-items: center;
    gap: 6px;
}

.form-error-styled svg {
    width: 14px;
    height: 14px;
    flex-shrink: 0;
}

/* ========== RESPONSIVE DESIGN ========== */
@media (max-width: 768px) {
    .form-container-main {
        padding: 20px;
    }

    .page-header-styled {
        padding: 20px 24px;
    }

    .page-header-title {
        font-size: 20px;
    }

    .form-card-styled {
        padding: 24px;
    }

    .form-actions-styled {
        flex-direction: column;
    }

    .btn-styled {
        width: 100%;
        justify-content: center;
    }
}

@media (max-width: 640px) {
    .form-group-styled {
        margin-bottom: 24px;
    }

    .page-header-title {
        font-size: 18px;
    }

    .checkbox-container {
        padding: 12px 14px;
    }
}
</style>

<div class="form-container-main">
    <div class="page-header-styled">
        <h1 class="page-header-title">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
            </svg>
            Edit Department
        </h1>
    </div>

    <div class="form-card-styled">
        <!-- Display Errors -->
        @if($errors->any())
        <div class="alert-styled alert-danger-styled">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
            </svg>
            <div class="alert-content">
                <strong>Validation Error:</strong>
                <ul>
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        </div>
        @endif

        <form action="{{ route('admin.support.departments.update', $department->id) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="form-group-styled">
                <label for="name" class="form-label-styled required">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/>
                    </svg>
                    Department Name
                </label>
                <input type="text" 
                       id="name" 
                       name="name" 
                       class="form-input-styled @error('name') input-error @enderror" 
                       value="{{ old('name', $department->name) }}"
                       placeholder="e.g., Technical Support, Sales, Billing"
                       required>
                <span class="help-text-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    Choose a clear, descriptive name for this support department
                </span>
                @error('name')
                    <span class="form-error-styled">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        {{ $message }}
                    </span>
                @enderror
            </div>

            <div class="form-group-styled">
                <label for="description" class="form-label-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16M4 18h7"/>
                    </svg>
                    Description
                </label>
                <textarea id="description" 
                          name="description" 
                          class="form-textarea-styled"
                          placeholder="Describe what this department handles and who should contact them...">{{ old('description', $department->description) }}</textarea>
                <span class="help-text-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    Optional: Help customers understand when to contact this department
                </span>
            </div>

            <div class="form-group-styled">
                <label for="department_order" class="form-label-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 4h13M3 8h9m-9 4h9m5-4v12m0 0l-4-4m4 4l4-4"/>
                    </svg>
                    Display Order
                </label>
                <input type="number" 
                       id="department_order" 
                       name="department_order" 
                       class="form-input-styled" 
                       value="{{ old('department_order', $department->department_order) }}"
                       min="0"
                       placeholder="0">
                <span class="help-text-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    Lower numbers appear first in department lists
                </span>
            </div>

            <div class="form-group-styled">
                <div class="checkbox-container">
                    <input type="checkbox" 
                           id="is_active" 
                           name="is_active" 
                           value="1"
                           {{ old('is_active', $department->is_active) ? 'checked' : '' }}>
                    <label for="is_active">Active</label>
                </div>
                <span class="help-text-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    Inactive departments won't accept new tickets
                </span>
            </div>

            <div class="form-group-styled">
                <div class="checkbox-container">
                    <input type="checkbox" 
                           id="show_on_client_portal" 
                           name="show_on_client_portal" 
                           value="1"
                           {{ old('show_on_client_portal', $department->show_on_client_portal) ? 'checked' : '' }}>
                    <label for="show_on_client_portal">Show on Client Portal</label>
                </div>
                <span class="help-text-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    Customers will see this department when creating tickets
                </span>
            </div>

            <div class="form-actions-styled">
                <a href="{{ route('admin.support.departments.index') }}" class="btn-styled btn-secondary-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                    Cancel
                </a>
                <button type="submit" class="btn-styled btn-primary-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/>
                    </svg>
                    Update Department
                </button>
            </div>
        </form>
    </div>
</div>