<style>
/* ========== PREDEFINED REPLY EDIT FORM - ECHOPX COMPLIANT ========== */

@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes slideInRight {
    from { opacity: 0; transform: translateX(20px); }
    to { opacity: 1; transform: translateX(0); }
}

@keyframes shake {
    0%, 100% { transform: translateX(0); }
    25% { transform: translateX(-5px); }
    75% { transform: translateX(5px); }
}

/* ========== FORM CONTAINER ========== */
.form-container-main {
    padding: 32px;
    animation: fadeInUp 500ms cubic-bezier(0.4, 0, 0.2, 1);
}

/* ========== PAGE HEADER ========== */
.page-header-styled {
    background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
    padding: 24px 32px;
    border-radius: 16px;
    margin-bottom: 32px;
    box-shadow: 0 8px 24px rgba(99, 102, 241, 0.25);
    position: relative;
    overflow: hidden;
}

.page-header-styled::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: radial-gradient(circle at top right, rgba(255, 255, 255, 0.1), transparent 60%);
    pointer-events: none;
}

.page-header-title {
    color: #ffffff;
    font-size: 24px;
    font-weight: 700;
    display: flex;
    align-items: center;
    gap: 14px;
    margin: 0;
    position: relative;
    z-index: 1;
}

.page-header-title svg {
    width: 26px;
    height: 26px;
    flex-shrink: 0;
}

/* ========== ALERT MESSAGES ========== */
.alert-styled {
    padding: 16px 20px;
    border-radius: 12px;
    margin-bottom: 24px;
    display: flex;
    align-items: flex-start;
    gap: 12px;
    animation: shake 400ms cubic-bezier(0.4, 0, 0.2, 1);
}

.alert-danger-styled {
    background: rgba(239, 68, 68, 0.12);
    color: var(--danger);
    border: 1.5px solid rgba(239, 68, 68, 0.3);
}

.alert-styled svg {
    width: 20px;
    height: 20px;
    flex-shrink: 0;
    margin-top: 2px;
}

.alert-content {
    flex: 1;
}

.alert-content strong {
    font-weight: 700;
    display: block;
    margin-bottom: 8px;
}

.alert-content ul {
    margin: 8px 0 0 0;
    padding-left: 20px;
    list-style: disc;
}

.alert-content ul li {
    margin-bottom: 4px;
    line-height: 1.5;
}

/* ========== FORM CARD ========== */
.form-card-styled {
    background: var(--card-bg);
    padding: 32px;
    border-radius: 16px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
    border: 1px solid var(--card-border);
    max-width: 900px;
    animation: slideInRight 500ms cubic-bezier(0.4, 0, 0.2, 1) 100ms backwards;
}

/* ========== FORM GROUPS ========== */
.form-group-styled {
    margin-bottom: 28px;
}

.form-label-styled {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 10px;
}

.form-label-styled svg {
    width: 16px;
    height: 16px;
    color: var(--text-secondary);
    flex-shrink: 0;
}

.form-label-styled.required::after {
    content: '*';
    color: var(--danger);
    margin-left: 4px;
    font-size: 16px;
    font-weight: 700;
}

.form-input-styled,
.form-select-styled {
    width: 100%;
    padding: 12px 16px;
    border: 1.5px solid var(--card-border);
    border-radius: 12px;
    font-size: 14px;
    color: var(--text-primary);
    background: var(--card-bg);
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    line-height: 1.5;
}

.form-input-styled::placeholder,
.form-select-styled::placeholder {
    color: var(--text-muted);
}

.form-input-styled:focus,
.form-select-styled:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
}

.form-input-styled.input-error,
.form-select-styled.input-error {
    border-color: var(--danger);
    animation: shake 400ms cubic-bezier(0.4, 0, 0.2, 1);
}

/* ========== RICH TEXT EDITOR ========== */
.editor-wrapper-styled {
    border: 1.5px solid var(--card-border);
    border-radius: 12px;
    overflow: hidden;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.editor-wrapper-styled:focus-within {
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
}

.editor-toolbar-styled {
    background: var(--body-bg);
    padding: 12px;
    border-bottom: 1.5px solid var(--card-border);
    display: flex;
    gap: 6px;
    flex-wrap: wrap;
}

.editor-btn-styled {
    padding: 8px 12px;
    border: 1.5px solid var(--card-border);
    background: var(--card-bg);
    border-radius: 8px;
    cursor: pointer;
    font-size: 13px;
    font-weight: 600;
    color: var(--text-primary);
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    font-family: inherit;
    display: inline-flex;
    align-items: center;
    gap: 4px;
}

.editor-btn-styled:hover {
    background: var(--primary);
    color: #ffffff;
    border-color: var(--primary);
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(99, 102, 241, 0.3);
}

.editor-btn-styled:active {
    transform: translateY(0);
}

.toolbar-separator {
    width: 1.5px;
    height: 28px;
    background: var(--card-border);
    margin: 0 6px;
}

.editor-content-styled {
    padding: 16px;
    min-height: 320px;
    font-size: 14px;
    color: var(--text-primary);
    outline: none;
    background: var(--card-bg);
    line-height: 1.7;
}

.editor-content-styled:empty::before {
    content: 'Type your predefined reply message here...';
    color: var(--text-muted);
}

/* ========== HELP TEXT ========== */
.help-text-styled {
    font-size: 12px;
    color: var(--text-secondary);
    margin-top: 8px;
    display: flex;
    align-items: center;
    gap: 6px;
    line-height: 1.5;
}

.help-text-styled svg {
    width: 12px;
    height: 12px;
    flex-shrink: 0;
}

/* ========== CHECKBOX WRAPPER ========== */
.checkbox-container {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 14px 16px;
    background: var(--body-bg);
    border-radius: 12px;
    border: 1.5px solid transparent;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    cursor: pointer;
}

.checkbox-container:hover {
    background: rgba(99, 102, 241, 0.05);
    border-color: var(--primary);
}

.checkbox-container input[type="checkbox"] {
    width: 20px;
    height: 20px;
    cursor: pointer;
    accent-color: var(--primary);
    flex-shrink: 0;
}

.checkbox-container label {
    font-size: 14px;
    font-weight: 600;
    color: var(--text-primary);
    cursor: pointer;
    user-select: none;
    line-height: 1.4;
}

/* ========== FORM ACTIONS ========== */
.form-actions-styled {
    display: flex;
    gap: 14px;
    margin-top: 32px;
    padding-top: 24px;
    border-top: 2px solid var(--card-border);
}

.btn-styled {
    padding: 12px 28px;
    border-radius: 12px;
    font-weight: 600;
    font-size: 14px;
    border: none;
    cursor: pointer;
    display: inline-flex;
    align-items: center;
    gap: 10px;
    text-decoration: none;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.btn-styled svg {
    width: 16px;
    height: 16px;
    flex-shrink: 0;
}

.btn-primary-styled {
    background: var(--primary);
    color: #ffffff;
    box-shadow: 0 2px 8px rgba(99, 102, 241, 0.25);
}

.btn-primary-styled:hover {
    background: #4f46e5;
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(99, 102, 241, 0.35);
}

.btn-primary-styled:active {
    transform: translateY(0);
}

.btn-secondary-styled {
    background: var(--body-bg);
    color: var(--text-primary);
    border: 1.5px solid var(--card-border);
}

.btn-secondary-styled:hover {
    background: var(--card-border);
    transform: translateY(-2px);
}

.btn-secondary-styled:active {
    transform: translateY(0);
}

/* ========== FORM ERROR ========== */
.form-error-styled {
    color: var(--danger);
    font-size: 12px;
    font-weight: 600;
    margin-top: 8px;
    display: flex;
    align-items: center;
    gap: 6px;
}

.form-error-styled svg {
    width: 14px;
    height: 14px;
    flex-shrink: 0;
}

/* ========== RESPONSIVE DESIGN ========== */
@media (max-width: 768px) {
    .form-container-main {
        padding: 20px;
    }

    .page-header-styled {
        padding: 20px 24px;
    }

    .page-header-title {
        font-size: 20px;
    }

    .form-card-styled {
        padding: 24px;
    }

    .editor-toolbar-styled {
        padding: 10px;
        gap: 4px;
    }

    .editor-btn-styled {
        padding: 6px 10px;
        font-size: 12px;
    }

    .form-actions-styled {
        flex-direction: column;
    }

    .btn-styled {
        width: 100%;
        justify-content: center;
    }
}

@media (max-width: 640px) {
    .form-group-styled {
        margin-bottom: 24px;
    }

    .page-header-title {
        font-size: 18px;
    }

    .checkbox-container {
        padding: 12px 14px;
    }

    .editor-content-styled {
        min-height: 250px;
    }
}
</style>

<div class="form-container-main">
    <div class="page-header-styled">
        <h1 class="page-header-title">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
            </svg>
            Edit Predefined Reply
        </h1>
    </div>

    <div class="form-card-styled">
        <!-- Display Errors -->
        @if($errors->any())
        <div class="alert-styled alert-danger-styled">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
            </svg>
            <div class="alert-content">
                <strong>Validation Error:</strong>
                <ul>
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        </div>
        @endif

        <form action="{{ route('admin.support.predefined-replies.update', $reply->id) }}" method="POST" id="replyForm">
            @csrf
            @method('PUT')

            <div class="form-group-styled">
                <label for="name" class="form-label-styled required">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/>
                    </svg>
                    Reply Name
                </label>
                <input type="text" 
                       id="name" 
                       name="name" 
                       class="form-input-styled @error('name') input-error @enderror" 
                       value="{{ old('name', $reply->name) }}" 
                       placeholder="e.g., Welcome Message, Refund Policy"
                       required>
                <span class="help-text-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    Internal name to identify this reply template
                </span>
                @error('name')
                    <span class="form-error-styled">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        {{ $message }}
                    </span>
                @enderror
            </div>

            <div class="form-group-styled">
                <label for="department_id" class="form-label-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                    </svg>
                    Department (Optional)
                </label>
                <select id="department_id" 
                        name="department_id" 
                        class="form-select-styled @error('department_id') input-error @enderror">
                    <option value="">All Departments</option>
                    @foreach($departments as $dept)
                    <option value="{{ $dept->id }}" {{ old('department_id', $reply->department_id) == $dept->id ? 'selected' : '' }}>
                        {{ $dept->name }}
                    </option>
                    @endforeach
                </select>
                <span class="help-text-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    If selected, this reply will only appear for tickets in this department
                </span>
                @error('department_id')
                    <span class="form-error-styled">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        {{ $message }}
                    </span>
                @enderror
            </div>

            <div class="form-group-styled">
                <label for="message" class="form-label-styled required">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                    </svg>
                    Message
                </label>
                <div class="editor-wrapper-styled">
                    <div class="editor-toolbar-styled">
                        <button type="button" class="editor-btn-styled" onclick="execCmd('bold')" title="Bold">
                            <b>B</b>
                        </button>
                        <button type="button" class="editor-btn-styled" onclick="execCmd('italic')" title="Italic">
                            <i>I</i>
                        </button>
                        <button type="button" class="editor-btn-styled" onclick="execCmd('underline')" title="Underline">
                            <u>U</u>
                        </button>
                        <button type="button" class="editor-btn-styled" onclick="execCmd('strikeThrough')" title="Strikethrough">
                            <s>S</s>
                        </button>
                        <span class="toolbar-separator"></span>
                        <button type="button" class="editor-btn-styled" onclick="execCmd('insertUnorderedList')" title="Bullet List">
                            • List
                        </button>
                        <button type="button" class="editor-btn-styled" onclick="execCmd('insertOrderedList')" title="Numbered List">
                            1. List
                        </button>
                        <span class="toolbar-separator"></span>
                        <button type="button" class="editor-btn-styled" onclick="execCmd('justifyLeft')" title="Align Left">
                            ◧
                        </button>
                        <button type="button" class="editor-btn-styled" onclick="execCmd('justifyCenter')" title="Align Center">
                            ≡
                        </button>
                        <button type="button" class="editor-btn-styled" onclick="execCmd('justifyRight')" title="Align Right">
                            ◨
                        </button>
                        <span class="toolbar-separator"></span>
                        <button type="button" class="editor-btn-styled" onclick="insertLink()" title="Insert Link">
                            🔗 Link
                        </button>
                        <button type="button" class="editor-btn-styled" onclick="execCmd('removeFormat')" title="Clear Formatting">
                            ✕ Clear
                        </button>
                    </div>
                    <div id="editor" 
                         class="editor-content-styled" 
                         contenteditable="true">{!! old('message', $reply->message) !!}</div>
                </div>
                <textarea id="message" 
                          name="message" 
                          style="display: none;" 
                          required></textarea>
                <span class="help-text-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    This message will be available in the ticket reply dropdown
                </span>
                @error('message')
                    <span class="form-error-styled">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        {{ $message }}
                    </span>
                @enderror
            </div>

            <div class="form-group-styled">
                <div class="checkbox-container">
                    <input type="checkbox" 
                           id="is_active" 
                           name="is_active" 
                           value="1"
                           {{ old('is_active', $reply->is_active) ? 'checked' : '' }}>
                    <label for="is_active">Active</label>
                </div>
                <span class="help-text-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    Inactive replies won't appear in the dropdown
                </span>
            </div>

            <div class="form-actions-styled">
                <a href="{{ route('admin.support.predefined-replies.index') }}" class="btn-styled btn-secondary-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                    Cancel
                </a>
                <button type="submit" class="btn-styled btn-primary-styled" onclick="syncEditorContent()">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/>
                    </svg>
                    Update Reply
                </button>
            </div>
        </form>
    </div>
</div>

<script>
document.getElementById('editor').addEventListener('input', function() {
    document.getElementById('message').value = this.innerHTML;
});

function execCmd(command) {
    document.execCommand(command, false, null);
    document.getElementById('editor').focus();
}

function insertLink() {
    const url = prompt('Enter URL:');
    if (url) {
        document.execCommand('createLink', false, url);
    }
    document.getElementById('editor').focus();
}

function syncEditorContent() {
    document.getElementById('message').value = document.getElementById('editor').innerHTML;
}

document.getElementById('replyForm').addEventListener('submit', function(e) {
    syncEditorContent();
});
</script>