<style>
/* ========== PREDEFINED REPLIES INDEX - ECHOPX COMPLIANT ========== */

@keyframes slideDown {
    from { opacity: 0; transform: translateY(-20px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

/* ========== MAIN CONTAINER ========== */
.replies-container-main {
    padding: 32px;
    min-height: calc(100vh - 80px);
    animation: fadeInUp 500ms cubic-bezier(0.4, 0, 0.2, 1);
}

/* ========== PAGE HEADER ========== */
.page-header-gradient {
    background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
    padding: 24px 32px;
    border-radius: 16px;
    margin-bottom: 32px;
    box-shadow: 0 8px 24px rgba(99, 102, 241, 0.25);
    animation: slideDown 600ms cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    overflow: hidden;
}

.page-header-gradient::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: radial-gradient(circle at top right, rgba(255, 255, 255, 0.1), transparent 60%);
    pointer-events: none;
}

.page-header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    position: relative;
    z-index: 1;
}

.page-title-main {
    color: #ffffff;
    font-size: 24px;
    font-weight: 700;
    display: flex;
    align-items: center;
    gap: 14px;
    margin: 0;
}

.page-title-main svg {
    width: 26px;
    height: 26px;
    flex-shrink: 0;
}

/* ========== BUTTONS ========== */
.btn-styled {
    padding: 11px 22px;
    border-radius: 12px;
    font-weight: 600;
    font-size: 14px;
    border: none;
    cursor: pointer;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    text-decoration: none;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.btn-styled svg {
    width: 16px;
    height: 16px;
    flex-shrink: 0;
}

.btn-primary-styled {
    background: #ffffff;
    color: var(--primary);
    box-shadow: 0 4px 12px rgba(255, 255, 255, 0.3);
}

.btn-primary-styled:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(255, 255, 255, 0.4);
}

.btn-sm-styled {
    padding: 9px 18px;
    font-size: 13px;
}

.btn-danger-styled {
    background: var(--danger);
    color: #ffffff;
    box-shadow: 0 2px 8px rgba(239, 68, 68, 0.25);
}

.btn-danger-styled:hover {
    background: #dc2626;
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(239, 68, 68, 0.35);
}

/* ========== TABLE CARD ========== */
.table-card-main {
    background: var(--card-bg);
    padding: 32px;
    border-radius: 16px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
    border: 1px solid var(--card-border);
    animation: fadeInUp 500ms cubic-bezier(0.4, 0, 0.2, 1) 100ms backwards;
}

/* ========== TABLE HEADER ========== */
.table-header-section {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 24px;
    padding-bottom: 18px;
    border-bottom: 2px solid var(--card-border);
}

.table-title-main {
    font-size: 20px;
    font-weight: 700;
    color: var(--text-primary);
    display: flex;
    align-items: center;
    gap: 12px;
}

.table-title-main svg {
    width: 22px;
    height: 22px;
    color: var(--primary);
    flex-shrink: 0;
}

.count-badge {
    background: rgba(99, 102, 241, 0.1);
    color: var(--primary);
    padding: 4px 12px;
    border-radius: 20px;
    font-size: 13px;
    font-weight: 700;
}

/* ========== FILTER BAR ========== */
.filter-bar-styled {
    display: flex;
    gap: 14px;
    align-items: center;
    margin-bottom: 24px;
    padding: 16px;
    background: var(--body-bg);
    border-radius: 12px;
    border: 1.5px solid var(--card-border);
}

.filter-label-styled {
    font-size: 14px;
    font-weight: 600;
    color: var(--text-primary);
    display: flex;
    align-items: center;
    gap: 8px;
    white-space: nowrap;
}

.filter-label-styled svg {
    width: 16px;
    height: 16px;
    color: var(--primary);
}

.filter-select-styled {
    padding: 10px 14px;
    border-radius: 10px;
    border: 1.5px solid var(--card-border);
    background: var(--card-bg);
    color: var(--text-primary);
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    min-width: 220px;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.filter-select-styled:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
}

.filter-select-styled:hover {
    border-color: var(--primary);
}

/* ========== TABLE STYLING ========== */
.table-wrapper {
    overflow-x: auto;
    border-radius: 12px;
    border: 1px solid var(--card-border);
}

table.replies-table {
    width: 100%;
    border-collapse: separate;
    border-spacing: 0;
}

table.replies-table thead th {
    background: var(--body-bg);
    padding: 14px 16px;
    text-align: left;
    font-weight: 600;
    font-size: 13px;
    color: var(--text-secondary);
    text-transform: uppercase;
    letter-spacing: 0.05em;
    border-bottom: 2px solid var(--card-border);
    white-space: nowrap;
}

table.replies-table thead th:first-child {
    border-top-left-radius: 12px;
}

table.replies-table thead th:last-child {
    border-top-right-radius: 12px;
}

table.replies-table tbody tr {
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    border-bottom: 1px solid var(--card-border);
}

table.replies-table tbody tr:last-child {
    border-bottom: none;
}

table.replies-table tbody tr:hover {
    background: rgba(99, 102, 241, 0.04);
}

table.replies-table tbody td {
    padding: 14px 16px;
    font-size: 14px;
    color: var(--text-primary);
}

/* ========== MESSAGE PREVIEW ========== */
.message-preview-styled {
    max-width: 400px;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
    color: var(--text-secondary);
    font-size: 13px;
    line-height: 1.5;
}

/* ========== BADGES ========== */
.badge-styled {
    padding: 6px 12px;
    border-radius: 12px;
    font-size: 11px;
    font-weight: 700;
    display: inline-flex;
    align-items: center;
    gap: 6px;
    text-transform: uppercase;
    letter-spacing: 0.03em;
}

.badge-success-styled {
    background: rgba(34, 197, 94, 0.12);
    color: var(--success);
    border: 1px solid rgba(34, 197, 94, 0.3);
}

.badge-success-styled svg {
    width: 12px;
    height: 12px;
}

.badge-secondary-styled {
    background: var(--body-bg);
    color: var(--text-secondary);
    border: 1px solid var(--card-border);
}

/* ========== TOGGLE SWITCH ========== */
.toggle-switch-container {
    position: relative;
    width: 48px;
    height: 26px;
    display: inline-block;
}

.toggle-switch-container input {
    opacity: 0;
    width: 0;
    height: 0;
}

.toggle-slider-styled {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: var(--body-bg);
    transition: 400ms cubic-bezier(0.4, 0, 0.2, 1);
    border-radius: 26px;
    border: 2px solid var(--card-border);
}

.toggle-slider-styled:before {
    position: absolute;
    content: "";
    height: 18px;
    width: 18px;
    left: 2px;
    bottom: 2px;
    background: #ffffff;
    transition: 400ms cubic-bezier(0.4, 0, 0.2, 1);
    border-radius: 50%;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
}

input:checked + .toggle-slider-styled {
    background: var(--success);
    border-color: var(--success);
}

input:checked + .toggle-slider-styled:before {
    transform: translateX(22px);
}

.toggle-slider-styled:hover {
    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
}

/* ========== ACTION BUTTONS ========== */
.action-buttons-group {
    display: flex;
    gap: 8px;
}

.btn-icon-styled {
    width: 36px;
    height: 36px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    border: none;
    cursor: pointer;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.btn-icon-styled svg {
    width: 16px;
    height: 16px;
}

.btn-edit-styled {
    background: rgba(99, 102, 241, 0.12);
    color: var(--primary);
}

.btn-edit-styled:hover {
    background: var(--primary);
    color: #ffffff;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(99, 102, 241, 0.3);
}

.btn-delete-styled {
    background: rgba(239, 68, 68, 0.12);
    color: var(--danger);
}

.btn-delete-styled:hover {
    background: var(--danger);
    color: #ffffff;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(239, 68, 68, 0.3);
}

/* ========== CHECKBOX STYLING ========== */
input[type="checkbox"] {
    width: 18px;
    height: 18px;
    cursor: pointer;
    accent-color: var(--primary);
    border-radius: 4px;
}

/* ========== EMPTY STATE ========== */
.empty-state-styled {
    text-align: center;
    padding: 80px 20px;
}

.empty-state-styled svg {
    width: 80px;
    height: 80px;
    color: var(--text-muted);
    margin-bottom: 20px;
    opacity: 0.6;
}

.empty-state-styled h3 {
    font-size: 20px;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 12px;
}

.empty-state-styled p {
    color: var(--text-secondary);
    font-size: 14px;
    line-height: 1.6;
}

/* ========== PAGINATION ========== */
.pagination-container {
    margin-top: 28px;
}

.pagination-wrapper {
    display: flex;
    justify-content: center;
    gap: 10px;
    flex-wrap: wrap;
}

.pagination-btn {
    padding: 10px 18px;
    border-radius: 10px;
    font-weight: 600;
    font-size: 13px;
    border: 1.5px solid var(--card-border);
    background: var(--card-bg);
    color: var(--text-primary);
    cursor: pointer;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.pagination-btn:hover:not(:disabled) {
    background: var(--primary);
    color: #ffffff;
    border-color: var(--primary);
    transform: translateY(-2px);
}

.pagination-btn.active {
    background: var(--primary);
    color: #ffffff;
    border-color: var(--primary);
}

.pagination-btn:disabled {
    opacity: 0.5;
    cursor: not-allowed;
}

/* ========== RESPONSIVE DESIGN ========== */
@media (max-width: 768px) {
    .replies-container-main {
        padding: 20px;
    }

    .page-header-gradient {
        padding: 20px 24px;
    }

    .page-header-content {
        flex-direction: column;
        gap: 16px;
        align-items: flex-start;
    }

    .btn-primary-styled {
        width: 100%;
        justify-content: center;
    }

    .table-card-main {
        padding: 20px;
    }

    .table-header-section {
        flex-direction: column;
        align-items: flex-start;
        gap: 16px;
    }

    .filter-bar-styled {
        flex-direction: column;
        align-items: flex-start;
    }

    .filter-select-styled {
        width: 100%;
    }

    .btn-sm-styled {
        width: 100%;
        justify-content: center;
    }

    .table-wrapper {
        border-radius: 0;
        margin: 0 -20px;
    }

    .message-preview-styled {
        max-width: 200px;
    }
}

@media (max-width: 640px) {
    .page-title-main {
        font-size: 20px;
    }

    .action-buttons-group {
        flex-direction: column;
    }

    .pagination-wrapper {
        gap: 6px;
    }

    .pagination-btn {
        padding: 8px 14px;
        font-size: 12px;
    }

    .message-preview-styled {
        max-width: 150px;
    }
}
</style>

<div class="replies-container-main">
    <!-- Page Header -->
    <div class="page-header-gradient">
        <div class="page-header-content">
            <h1 class="page-title-main">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"/>
                </svg>
                Predefined Replies
            </h1>
            <a href="{{ route('admin.support.predefined-replies.create') }}" class="btn-styled btn-primary-styled">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4"/>
                </svg>
                Add Reply
            </a>
        </div>
    </div>

    <!-- Table Card -->
    <div class="table-card-main">
        <div class="table-header-section">
            <div class="table-title-main">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 5H7a2 2 0 00-2 2v11a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                </svg>
                All Predefined Replies
                <span class="count-badge" id="totalCount">0</span>
            </div>
            <button class="btn-styled btn-sm-styled btn-danger-styled" id="bulkDeleteBtn" style="display: none;" onclick="bulkDelete()">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                </svg>
                Delete Selected
            </button>
        </div>

        <!-- Filter Bar -->
        <div class="filter-bar-styled">
            <label class="filter-label-styled">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586a1 1 0 01-.293.707l-6.414 6.414a1 1 0 00-.293.707V17l-4 4v-6.586a1 1 0 00-.293-.707L3.293 7.293A1 1 0 013 6.586V4z"/>
                </svg>
                Filter by Department:
            </label>
            <select id="departmentFilter" class="filter-select-styled" onchange="loadReplies()">
                <option value="">All Departments</option>
                @foreach($departments as $dept)
                <option value="{{ $dept->id }}">{{ $dept->name }}</option>
                @endforeach
            </select>
        </div>

        <div class="table-wrapper">
            <table class="replies-table dt-table" id="repliesTable">
                <thead>
                    <tr>
                        <th style="width: 50px;">
                            <input type="checkbox" id="selectAll" onchange="toggleSelectAll(this)">
                        </th>
                        <th>Name</th>
                        <th>Message Preview</th>
                        <th>Department</th>
                        <th>Active</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody id="repliesTableBody">
                    <!-- Data populated via AJAX -->
                </tbody>
            </table>
        </div>

        <div id="paginationContainer" class="pagination-container"></div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
let currentPage = 1;
let selectedIds = [];

$(document).ready(function() {
    loadReplies();
});

function loadReplies() {
    const filters = {
        department_id: $('#departmentFilter').val(),
        page: currentPage
    };

    $.ajax({
        url: '{{ route("admin.support.predefined-replies.data") }}',
        type: 'GET',
        data: filters,
        success: function(response) {
            renderReplies(response.data);
            renderPagination(response);
            updateCounts(response);
        },
        error: function() {
            showToast('Error loading predefined replies', 'error');
        }
    });
}

function renderReplies(replies) {
    const tbody = $('#repliesTableBody');
    tbody.empty();

    if (!replies || replies.length === 0) {
        tbody.append(`
            <tr>
                <td colspan="7">
                    <div class="empty-state-styled">
                        <svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"/>
                        </svg>
                        <h3>No Predefined Replies Found</h3>
                        <p>Create your first reply template to speed up customer responses</p>
                    </div>
                </td>
            </tr>
        `);
        return;
    }

    replies.forEach(reply => {
        const messagePreview = reply.message_preview;
        
        const departmentBadge = reply.department_name ? 
            `<span class="badge-styled badge-success-styled">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/>
                </svg>
                ${reply.department_name}
            </span>` : 
            `<span class="badge-styled badge-secondary-styled">All Departments</span>`;
        
        const row = `
            <tr>
                <td>
                    <input type="checkbox" class="reply-checkbox" value="${reply.id}" onchange="toggleSelection(this)">
                </td>
                <td><strong>${reply.name}</strong></td>
                <td>
                    <div class="message-preview-styled" title="${reply.message_preview}">
                        ${messagePreview}
                    </div>
                </td>
                <td>${departmentBadge}</td>
                <td>
                    <label class="toggle-switch-container">
                        <input type="checkbox" ${reply.is_active ? 'checked' : ''} 
                               onchange="toggleActive(${reply.id}, this)">
                        <span class="toggle-slider-styled"></span>
                    </label>
                </td>
                <td>${reply.created_at}</td>
                <td>
                    <div class="action-buttons-group">
                        <button class="btn-icon-styled btn-edit-styled" onclick="editReply(${reply.id})" title="Edit">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                            </svg>
                        </button>
                        <button class="btn-icon-styled btn-delete-styled" onclick="deleteReply(${reply.id})" title="Delete">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                            </svg>
                        </button>
                    </div>
                </td>
            </tr>
        `;
        tbody.append(row);
    });
}

function stripHtml(html) {
    const tmp = document.createElement('div');
    tmp.innerHTML = html;
    return tmp.textContent || tmp.innerText || '';
}

function renderPagination(response) {
    const container = $('#paginationContainer');
    container.empty();

    if (response.last_page <= 1) return;

    let html = '<div class="pagination-wrapper">';
    html += `<button class="pagination-btn ${currentPage === 1 ? 'active' : ''}" 
                     onclick="changePage(${currentPage - 1})" ${currentPage === 1 ? 'disabled' : ''}>Previous</button>`;

    for (let i = 1; i <= response.last_page; i++) {
        if (i === 1 || i === response.last_page || (i >= currentPage - 2 && i <= currentPage + 2)) {
            html += `<button class="pagination-btn ${i === currentPage ? 'active' : ''}" 
                             onclick="changePage(${i})">${i}</button>`;
        }
    }

    html += `<button class="pagination-btn ${currentPage === response.last_page ? 'active' : ''}" 
                     onclick="changePage(${currentPage + 1})" ${currentPage === response.last_page ? 'disabled' : ''}>Next</button>`;
    html += '</div>';
    container.html(html);
}

function updateCounts(response) {
    $('#totalCount').text(response.total);
}

function changePage(page) {
    if (page < 1) return;
    currentPage = page;
    loadReplies();
}

function toggleSelection(checkbox) {
    const id = parseInt(checkbox.value);
    if (checkbox.checked) {
        selectedIds.push(id);
    } else {
        selectedIds = selectedIds.filter(item => item !== id);
    }
    $('#bulkDeleteBtn').toggle(selectedIds.length > 0);
}

function toggleSelectAll(checkbox) {
    $('.reply-checkbox').prop('checked', checkbox.checked);
    selectedIds = checkbox.checked ? 
        $('.reply-checkbox').map(function() { return parseInt(this.value); }).get() : [];
    $('#bulkDeleteBtn').toggle(selectedIds.length > 0);
}

function editReply(id) {
    window.location.href = `{{ route('admin.support.predefined-replies.edit', ':id') }}`.replace(':id', id);
}

function deleteReply(id) {
    if (!confirm('Are you sure you want to delete this predefined reply?')) return;

    $.ajax({
        url: `{{ route('admin.support.predefined-replies.destroy', ':id') }}`.replace(':id', id),
        type: 'DELETE',
        data: { _token: '{{ csrf_token() }}' },
        success: function(response) {
            showToast(response.message || 'Reply deleted successfully', 'success');
            loadReplies();
        },
        error: function(xhr) {
            showToast('Error: ' + (xhr.responseJSON?.message || 'Failed to delete'), 'error');
        }
    });
}

function bulkDelete() {
    if (selectedIds.length === 0) return;
    if (!confirm(`Delete ${selectedIds.length} predefined replies?`)) return;

    $.ajax({
        url: '{{ route("admin.support.predefined-replies.bulk-delete") }}',
        type: 'POST',
        data: {
            _token: '{{ csrf_token() }}',
            ids: selectedIds
        },
        success: function(response) {
            showToast(response.message || 'Replies deleted successfully', 'success');
            selectedIds = [];
            $('#selectAll').prop('checked', false);
            $('#bulkDeleteBtn').hide();
            loadReplies();
        },
        error: function(xhr) {
            showToast('Error: ' + (xhr.responseJSON?.message || 'Failed to delete'), 'error');
        }
    });
}

function toggleActive(id, checkbox) {
    $.ajax({
        url: `{{ route('admin.support.predefined-replies.toggle-active', ':id') }}`.replace(':id', id),
        type: 'POST',
        data: { _token: '{{ csrf_token() }}' },
        success: function(response) {
            showToast('Reply updated successfully', 'success');
        },
        error: function() {
            checkbox.checked = !checkbox.checked;
            showToast('Error toggling status', 'error');
        }
    });
}
</script>