<style>
/* ========== PRIORITY EDIT FORM - ECHOPX COMPLIANT ========== */

@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes slideInRight {
    from { opacity: 0; transform: translateX(20px); }
    to { opacity: 1; transform: translateX(0); }
}

@keyframes shake {
    0%, 100% { transform: translateX(0); }
    25% { transform: translateX(-5px); }
    75% { transform: translateX(5px); }
}

/* ========== FORM CONTAINER ========== */
.form-container-main {
    padding: 32px;
    animation: fadeInUp 500ms cubic-bezier(0.4, 0, 0.2, 1);
}

/* ========== PAGE HEADER ========== */
.page-header-styled {
    background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
    padding: 24px 32px;
    border-radius: 16px;
    margin-bottom: 32px;
    box-shadow: 0 8px 24px rgba(99, 102, 241, 0.25);
    position: relative;
    overflow: hidden;
}

.page-header-styled::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: radial-gradient(circle at top right, rgba(255, 255, 255, 0.1), transparent 60%);
    pointer-events: none;
}

.page-header-title {
    color: #ffffff;
    font-size: 24px;
    font-weight: 700;
    display: flex;
    align-items: center;
    gap: 14px;
    margin: 0;
    position: relative;
    z-index: 1;
}

.page-header-title svg {
    width: 26px;
    height: 26px;
    flex-shrink: 0;
}

/* ========== ALERT MESSAGES ========== */
.alert-styled {
    padding: 16px 20px;
    border-radius: 12px;
    margin-bottom: 24px;
    display: flex;
    align-items: flex-start;
    gap: 12px;
    animation: shake 400ms cubic-bezier(0.4, 0, 0.2, 1);
}

.alert-danger-styled {
    background: rgba(239, 68, 68, 0.12);
    color: var(--danger);
    border: 1.5px solid rgba(239, 68, 68, 0.3);
}

.alert-styled svg {
    width: 20px;
    height: 20px;
    flex-shrink: 0;
    margin-top: 2px;
}

.alert-content {
    flex: 1;
}

.alert-content strong {
    font-weight: 700;
    display: block;
    margin-bottom: 8px;
}

.alert-content ul {
    margin: 8px 0 0 0;
    padding-left: 20px;
    list-style: disc;
}

.alert-content ul li {
    margin-bottom: 4px;
    line-height: 1.5;
}

/* ========== FORM CARD ========== */
.form-card-styled {
    background: var(--card-bg);
    padding: 32px;
    border-radius: 16px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
    border: 1px solid var(--card-border);
    max-width: 800px;
    animation: slideInRight 500ms cubic-bezier(0.4, 0, 0.2, 1) 100ms backwards;
}

/* ========== FORM GROUPS ========== */
.form-group-styled {
    margin-bottom: 28px;
}

.form-label-styled {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 10px;
}

.form-label-styled svg {
    width: 16px;
    height: 16px;
    color: var(--text-secondary);
    flex-shrink: 0;
}

.form-input-styled {
    width: 100%;
    padding: 12px 16px;
    border: 1.5px solid var(--card-border);
    border-radius: 12px;
    font-size: 14px;
    color: var(--text-primary);
    background: var(--card-bg);
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    line-height: 1.5;
}

.form-input-styled::placeholder {
    color: var(--text-muted);
}

.form-input-styled:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
}

.form-input-styled.is-invalid {
    border-color: var(--danger);
    animation: shake 400ms cubic-bezier(0.4, 0, 0.2, 1);
}

/* ========== COLOR PICKER ========== */
.color-picker-container {
    display: flex;
    gap: 14px;
    align-items: center;
    flex-wrap: wrap;
}

.color-input-styled {
    width: 80px;
    height: 48px;
    border: 1.5px solid var(--card-border);
    border-radius: 10px;
    cursor: pointer;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.color-input-styled:hover {
    border-color: var(--primary);
    box-shadow: 0 4px 12px rgba(99, 102, 241, 0.2);
}

.color-preview-box {
    width: 48px;
    height: 48px;
    border-radius: 10px;
    border: 2px solid var(--card-border);
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.color-preview-box:hover {
    transform: scale(1.05);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
}

.color-hex-input {
    width: 140px;
    padding: 12px 16px;
    border: 1.5px solid var(--card-border);
    border-radius: 10px;
    font-size: 13px;
    font-family: 'Courier New', monospace;
    font-weight: 600;
    color: var(--text-primary);
    background: var(--body-bg);
    text-align: center;
    text-transform: uppercase;
}

/* ========== CHECKBOX WRAPPER ========== */
.checkbox-container {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 14px 16px;
    background: var(--body-bg);
    border-radius: 12px;
    border: 1.5px solid transparent;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    cursor: pointer;
}

.checkbox-container:hover {
    background: rgba(99, 102, 241, 0.05);
    border-color: var(--primary);
}

.checkbox-container input[type="checkbox"] {
    width: 20px;
    height: 20px;
    cursor: pointer;
    accent-color: var(--primary);
    flex-shrink: 0;
}

.checkbox-container label {
    font-size: 14px;
    font-weight: 600;
    color: var(--text-primary);
    cursor: pointer;
    user-select: none;
    line-height: 1.4;
}

/* ========== FORM ACTIONS ========== */
.form-actions-styled {
    display: flex;
    gap: 14px;
    margin-top: 32px;
    padding-top: 24px;
    border-top: 2px solid var(--card-border);
}

.btn-styled {
    padding: 12px 28px;
    border-radius: 12px;
    font-weight: 600;
    font-size: 14px;
    border: none;
    cursor: pointer;
    display: inline-flex;
    align-items: center;
    gap: 10px;
    text-decoration: none;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.btn-styled svg {
    width: 16px;
    height: 16px;
    flex-shrink: 0;
}

.btn-primary-styled {
    background: var(--primary);
    color: #ffffff;
    box-shadow: 0 2px 8px rgba(99, 102, 241, 0.25);
}

.btn-primary-styled:hover {
    background: #4f46e5;
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(99, 102, 241, 0.35);
}

.btn-primary-styled:active {
    transform: translateY(0);
}

.btn-secondary-styled {
    background: var(--body-bg);
    color: var(--text-primary);
    border: 1.5px solid var(--card-border);
}

.btn-secondary-styled:hover {
    background: var(--card-border);
    transform: translateY(-2px);
}

.btn-secondary-styled:active {
    transform: translateY(0);
}

/* ========== FORM ERROR ========== */
.form-error-styled {
    color: var(--danger);
    font-size: 12px;
    font-weight: 600;
    margin-top: 8px;
    display: flex;
    align-items: center;
    gap: 6px;
}

.form-error-styled svg {
    width: 14px;
    height: 14px;
    flex-shrink: 0;
}

/* ========== RESPONSIVE DESIGN ========== */
@media (max-width: 768px) {
    .form-container-main {
        padding: 20px;
    }

    .page-header-styled {
        padding: 20px 24px;
    }

    .page-header-title {
        font-size: 20px;
    }

    .form-card-styled {
        padding: 24px;
    }

    .color-picker-container {
        flex-direction: column;
        align-items: flex-start;
    }

    .color-hex-input {
        width: 100%;
    }

    .form-actions-styled {
        flex-direction: column;
    }

    .btn-styled {
        width: 100%;
        justify-content: center;
    }
}

@media (max-width: 640px) {
    .form-group-styled {
        margin-bottom: 24px;
    }

    .page-header-title {
        font-size: 18px;
    }

    .checkbox-container {
        padding: 12px 14px;
    }
}
</style>

<div class="form-container-main">
    <div class="page-header-styled">
        <h1 class="page-header-title">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
            </svg>
            Edit Priority
        </h1>
    </div>

    <div class="form-card-styled">
        <!-- Display Errors -->
        @if($errors->any())
        <div class="alert-styled alert-danger-styled">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
            </svg>
            <div class="alert-content">
                <strong>Validation Error:</strong>
                <ul>
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        </div>
        @endif

        @if(session('error'))
        <div class="alert-styled alert-danger-styled">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
            </svg>
            <div class="alert-content">
                {{ session('error') }}
            </div>
        </div>
        @endif

        <form action="{{ route('admin.support.priorities.update', $priority->id) }}" method="POST" autocomplete="off">
            @csrf
            @method('PUT')

            <div class="form-group-styled">
                <label for="name" class="form-label-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 21v-4m0 0V5a2 2 0 012-2h6.5l1 1H21l-3 6 3 6h-8.5l-1-1H5a2 2 0 00-2 2zm9-13.5V9"/>
                    </svg>
                    Priority Name
                </label>
                <input type="text" 
                       id="name" 
                       name="name" 
                       class="form-input-styled @error('name') is-invalid @enderror" 
                       value="{{ old('name', $priority->name) }}" 
                       required>
                @error('name')
                    <span class="form-error-styled">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        {{ $message }}
                    </span>
                @enderror
            </div>

            <div class="form-group-styled">
                <label for="color" class="form-label-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M7 21a4 4 0 01-4-4V5a2 2 0 012-2h4a2 2 0 012 2v12a4 4 0 01-4 4zm0 0h12a2 2 0 002-2v-4a2 2 0 00-2-2h-2.343M11 7.343l1.657-1.657a2 2 0 012.828 0l2.829 2.829a2 2 0 010 2.828l-8.486 8.485M7 17h.01"/>
                    </svg>
                    Color
                </label>
                <div class="color-picker-container">
                    <input type="color" 
                           id="color" 
                           name="color" 
                           class="color-input-styled" 
                           value="{{ old('color', $priority->color) }}" 
                           onchange="updatePreview(this)">
                    <div class="color-preview-box" 
                         id="colorPreview" 
                         style="background-color: {{ old('color', $priority->color) }};"></div>
                    <input type="text" 
                           id="colorHex" 
                           class="color-hex-input" 
                           value="{{ old('color', $priority->color) }}" 
                           readonly>
                </div>
                @error('color')
                    <span class="form-error-styled">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        {{ $message }}
                    </span>
                @enderror
            </div>

            <div class="form-group-styled">
                <label for="priority_order" class="form-label-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 4h13M3 8h9m-9 4h9m5-4v12m0 0l-4-4m4 4l4-4"/>
                    </svg>
                    Display Order
                </label>
                <input type="number" 
                       id="priority_order" 
                       name="priority_order" 
                       class="form-input-styled @error('priority_order') is-invalid @enderror" 
                       value="{{ old('priority_order', $priority->priority_order) }}" 
                       min="0">
                @error('priority_order')
                    <span class="form-error-styled">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        {{ $message }}
                    </span>
                @enderror
            </div>

            <div class="form-group-styled">
                <div class="checkbox-container">
                    <input type="checkbox" 
                           id="is_active" 
                           name="is_active" 
                           value="1"
                           {{ old('is_active', $priority->is_active) ? 'checked' : '' }}>
                    <label for="is_active">Active</label>
                </div>
            </div>

            <div class="form-actions-styled">
                <a href="{{ route('admin.support.priorities.index') }}" class="btn-styled btn-secondary-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                    Cancel
                </a>
                <button type="submit" class="btn-styled btn-primary-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/>
                    </svg>
                    Update Priority
                </button>
            </div>
        </form>
    </div>
</div>

<script>
function updatePreview(input) {
    const color = input.value;
    document.getElementById('colorPreview').style.backgroundColor = color;
    document.getElementById('colorHex').value = color;
}
</script>