<style>
/* ========== STATUSES INDEX - ECHOPX COMPLIANT ========== */

@keyframes slideDown {
    from { opacity: 0; transform: translateY(-20px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

/* ========== MAIN CONTAINER ========== */
.statuses-container-main {
    padding: 32px;
    min-height: calc(100vh - 80px);
    animation: fadeInUp 500ms cubic-bezier(0.4, 0, 0.2, 1);
}

/* ========== PAGE HEADER ========== */
.page-header-gradient {
    background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
    padding: 24px 32px;
    border-radius: 16px;
    margin-bottom: 32px;
    box-shadow: 0 8px 24px rgba(99, 102, 241, 0.25);
    animation: slideDown 600ms cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    overflow: hidden;
}

.page-header-gradient::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: radial-gradient(circle at top right, rgba(255, 255, 255, 0.1), transparent 60%);
    pointer-events: none;
}

.page-header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    position: relative;
    z-index: 1;
}

.page-title-main {
    color: #ffffff;
    font-size: 24px;
    font-weight: 700;
    display: flex;
    align-items: center;
    gap: 14px;
    margin: 0;
}

.page-title-main svg {
    width: 26px;
    height: 26px;
    flex-shrink: 0;
}

/* ========== BUTTONS ========== */
.btn-styled {
    padding: 11px 22px;
    border-radius: 12px;
    font-weight: 600;
    font-size: 14px;
    border: none;
    cursor: pointer;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    text-decoration: none;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.btn-styled svg {
    width: 16px;
    height: 16px;
    flex-shrink: 0;
}

.btn-primary-styled {
    background: #ffffff;
    color: var(--primary);
    box-shadow: 0 4px 12px rgba(255, 255, 255, 0.3);
}

.btn-primary-styled:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(255, 255, 255, 0.4);
}

.btn-sm-styled {
    padding: 9px 18px;
    font-size: 13px;
}

.btn-danger-styled {
    background: var(--danger);
    color: #ffffff;
    box-shadow: 0 2px 8px rgba(239, 68, 68, 0.25);
}

.btn-danger-styled:hover {
    background: #dc2626;
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(239, 68, 68, 0.35);
}

.btn-success-styled {
    background: var(--success);
    color: #ffffff;
    box-shadow: 0 2px 8px rgba(34, 197, 94, 0.25);
}

.btn-success-styled:hover {
    background: #16a34a;
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(34, 197, 94, 0.35);
}

/* ========== TABLE CARD ========== */
.table-card-main {
    background: var(--card-bg);
    padding: 32px;
    border-radius: 16px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
    border: 1px solid var(--card-border);
    animation: fadeInUp 500ms cubic-bezier(0.4, 0, 0.2, 1) 100ms backwards;
}

/* ========== TABLE HEADER ========== */
.table-header-section {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 24px;
    padding-bottom: 18px;
    border-bottom: 2px solid var(--card-border);
}

.table-title-main {
    font-size: 20px;
    font-weight: 700;
    color: var(--text-primary);
    display: flex;
    align-items: center;
    gap: 12px;
}

.table-title-main svg {
    width: 22px;
    height: 22px;
    color: var(--primary);
    flex-shrink: 0;
}

.count-badge {
    background: rgba(99, 102, 241, 0.1);
    color: var(--primary);
    padding: 4px 12px;
    border-radius: 20px;
    font-size: 13px;
    font-weight: 700;
}

.table-actions {
    display: flex;
    gap: 12px;
}

/* ========== TABLE STYLING ========== */
.table-wrapper {
    overflow-x: auto;
    border-radius: 12px;
    border: 1px solid var(--card-border);
}

table.statuses-table {
    width: 100%;
    border-collapse: separate;
    border-spacing: 0;
}

table.statuses-table thead th {
    background: var(--body-bg);
    padding: 14px 16px;
    text-align: left;
    font-weight: 600;
    font-size: 13px;
    color: var(--text-secondary);
    text-transform: uppercase;
    letter-spacing: 0.05em;
    border-bottom: 2px solid var(--card-border);
    white-space: nowrap;
}

table.statuses-table thead th:first-child {
    border-top-left-radius: 12px;
}

table.statuses-table thead th:last-child {
    border-top-right-radius: 12px;
}

table.statuses-table tbody tr {
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    border-bottom: 1px solid var(--card-border);
    cursor: move;
}

table.statuses-table tbody tr:last-child {
    border-bottom: none;
}

table.statuses-table tbody tr:hover {
    background: rgba(99, 102, 241, 0.04);
}

table.statuses-table tbody tr.dragging {
    opacity: 0.5;
    background: rgba(99, 102, 241, 0.1);
}

table.statuses-table tbody td {
    padding: 14px 16px;
    font-size: 14px;
    color: var(--text-primary);
}

/* ========== COLOR SWATCH ========== */
.color-swatch-styled {
    width: 36px;
    height: 36px;
    border-radius: 10px;
    border: 2px solid var(--card-border);
    display: inline-block;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.color-swatch-styled:hover {
    transform: scale(1.1);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
}

.color-info {
    display: flex;
    align-items: center;
    gap: 12px;
}

.color-hex {
    font-size: 12px;
    font-family: 'Courier New', monospace;
    color: var(--text-secondary);
    font-weight: 600;
}

/* ========== DRAG HANDLE ========== */
.drag-handle-styled {
    cursor: move;
    color: var(--text-muted);
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 4px;
    border-radius: 6px;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.drag-handle-styled:hover {
    color: var(--primary);
    background: rgba(99, 102, 241, 0.1);
}

.drag-handle-styled svg {
    width: 18px;
    height: 18px;
}

/* ========== BADGES ========== */
.badge-styled {
    padding: 6px 12px;
    border-radius: 12px;
    font-size: 11px;
    font-weight: 700;
    display: inline-flex;
    align-items: center;
    gap: 6px;
    text-transform: uppercase;
    letter-spacing: 0.03em;
}

.badge-styled svg {
    width: 12px;
    height: 12px;
}

.badge-success-styled {
    background: rgba(34, 197, 94, 0.12);
    color: var(--success);
    border: 1px solid rgba(34, 197, 94, 0.3);
}

.badge-warning-styled {
    background: rgba(251, 191, 36, 0.12);
    color: #d97706;
    border: 1px solid rgba(251, 191, 36, 0.3);
}

.badge-muted {
    color: var(--text-muted);
    font-size: 18px;
    font-weight: 400;
}

/* ========== TOGGLE SWITCH ========== */
.toggle-switch-container {
    position: relative;
    width: 48px;
    height: 26px;
    display: inline-block;
}

.toggle-switch-container input {
    opacity: 0;
    width: 0;
    height: 0;
}

.toggle-slider-styled {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: var(--body-bg);
    transition: 400ms cubic-bezier(0.4, 0, 0.2, 1);
    border-radius: 26px;
    border: 2px solid var(--card-border);
}

.toggle-slider-styled:before {
    position: absolute;
    content: "";
    height: 18px;
    width: 18px;
    left: 2px;
    bottom: 2px;
    background: #ffffff;
    transition: 400ms cubic-bezier(0.4, 0, 0.2, 1);
    border-radius: 50%;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
}

input:checked + .toggle-slider-styled {
    background: var(--success);
    border-color: var(--success);
}

input:checked + .toggle-slider-styled:before {
    transform: translateX(22px);
}

.toggle-slider-styled:hover {
    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
}

/* ========== ACTION BUTTONS ========== */
.action-buttons-group {
    display: flex;
    gap: 8px;
}

.btn-icon-styled {
    width: 36px;
    height: 36px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    border: none;
    cursor: pointer;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.btn-icon-styled svg {
    width: 16px;
    height: 16px;
}

.btn-default-styled {
    background: rgba(251, 191, 36, 0.12);
    color: #d97706;
}

.btn-default-styled:hover {
    background: #fbbf24;
    color: #ffffff;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(251, 191, 36, 0.3);
}

.btn-edit-styled {
    background: rgba(99, 102, 241, 0.12);
    color: var(--primary);
}

.btn-edit-styled:hover {
    background: var(--primary);
    color: #ffffff;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(99, 102, 241, 0.3);
}

.btn-delete-styled {
    background: rgba(239, 68, 68, 0.12);
    color: var(--danger);
}

.btn-delete-styled:hover {
    background: var(--danger);
    color: #ffffff;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(239, 68, 68, 0.3);
}

/* ========== CHECKBOX STYLING ========== */
input[type="checkbox"] {
    width: 18px;
    height: 18px;
    cursor: pointer;
    accent-color: var(--primary);
    border-radius: 4px;
}

/* ========== EMPTY STATE ========== */
.empty-state-styled {
    text-align: center;
    padding: 80px 20px;
}

.empty-state-styled svg {
    width: 80px;
    height: 80px;
    color: var(--text-muted);
    margin-bottom: 20px;
    opacity: 0.6;
}

.empty-state-styled h3 {
    font-size: 20px;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 12px;
}

.empty-state-styled p {
    color: var(--text-secondary);
    font-size: 14px;
    line-height: 1.6;
}

/* ========== PAGINATION ========== */
.pagination-container {
    margin-top: 28px;
}

.pagination-wrapper {
    display: flex;
    justify-content: center;
    gap: 10px;
    flex-wrap: wrap;
}

.pagination-btn {
    padding: 10px 18px;
    border-radius: 10px;
    font-weight: 600;
    font-size: 13px;
    border: 1.5px solid var(--card-border);
    background: var(--card-bg);
    color: var(--text-primary);
    cursor: pointer;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.pagination-btn:hover:not(:disabled) {
    background: var(--primary);
    color: #ffffff;
    border-color: var(--primary);
    transform: translateY(-2px);
}

.pagination-btn.active {
    background: var(--primary);
    color: #ffffff;
    border-color: var(--primary);
}

.pagination-btn:disabled {
    opacity: 0.5;
    cursor: not-allowed;
}

/* ========== RESPONSIVE DESIGN ========== */
@media (max-width: 768px) {
    .statuses-container-main {
        padding: 20px;
    }

    .page-header-gradient {
        padding: 20px 24px;
    }

    .page-header-content {
        flex-direction: column;
        gap: 16px;
        align-items: flex-start;
    }

    .btn-primary-styled {
        width: 100%;
        justify-content: center;
    }

    .table-card-main {
        padding: 20px;
    }

    .table-header-section {
        flex-direction: column;
        align-items: flex-start;
        gap: 16px;
    }

    .table-actions {
        width: 100%;
        flex-direction: column;
    }

    .btn-sm-styled {
        width: 100%;
        justify-content: center;
    }

    .table-wrapper {
        border-radius: 0;
        margin: 0 -20px;
    }
}

@media (max-width: 640px) {
    .page-title-main {
        font-size: 20px;
    }

    .action-buttons-group {
        flex-direction: column;
    }

    .pagination-wrapper {
        gap: 6px;
    }

    .pagination-btn {
        padding: 8px 14px;
        font-size: 12px;
    }
}
</style>

<div class="statuses-container-main">
    <!-- Page Header -->
    <div class="page-header-gradient">
        <div class="page-header-content">
            <h1 class="page-title-main">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                Ticket Statuses
            </h1>
            <a href="{{ route('admin.support.statuses.create') }}" class="btn-styled btn-primary-styled">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4"/>
                </svg>
                Add Status
            </a>
        </div>
    </div>

    <!-- Table Card -->
    <div class="table-card-main">
        <div class="table-header-section">
            <div class="table-title-main">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 5H7a2 2 0 00-2 2v11a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                </svg>
                All Statuses
                <span class="count-badge" id="totalCount">0</span>
            </div>
            <div class="table-actions">
                <button class="btn-styled btn-sm-styled btn-danger-styled" id="bulkDeleteBtn" style="display: none;" onclick="bulkDelete()">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                    </svg>
                    Delete Selected
                </button>
                <button class="btn-styled btn-sm-styled btn-success-styled" onclick="saveOrder()">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/>
                    </svg>
                    Save Order
                </button>
            </div>
        </div>

        <div class="table-wrapper">
            <table class="statuses-table dt-table" id="statusesTable">
                <thead>
                    <tr>
                        <th style="width: 50px;"></th>
                        <th style="width: 50px;">
                            <input type="checkbox" id="selectAll" onchange="toggleSelectAll(this)">
                        </th>
                        <th>Name</th>
                        <th>Color</th>
                        <th>Default</th>
                        <th>Client Change</th>
                        <th>Tickets</th>
                        <th>Active</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody id="statusesTableBody">
                    <!-- Data populated via AJAX -->
                </tbody>
            </table>
        </div>

        <div id="paginationContainer" class="pagination-container"></div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>
<script>
let currentPage = 1;
let selectedIds = [];
let sortable;

$(document).ready(function() {
    loadStatuses();
    initDragDrop();
});

function initDragDrop() {
    const tbody = document.getElementById('statusesTableBody');
    sortable = new Sortable(tbody, {
        animation: 150,
        handle: '.drag-handle',
        ghostClass: 'dragging',
        onEnd: function(evt) {
            // Order changed
        }
    });
}

function loadStatuses() {
    $.ajax({
        url: '{{ route("admin.support.statuses.data") }}',
        type: 'GET',
        data: { page: currentPage },
        success: function(response) {
            renderStatuses(response.data);
            renderPagination(response);
            updateCounts(response);
        },
        error: function() {
            alert('Error loading statuses');
        }
    });
}

function renderStatuses(statuses) {
    const tbody = $('#statusesTableBody');
    tbody.empty();

    if (!statuses || statuses.length === 0) {
        tbody.append(`
            <tr>
                <td colspan="10">
                    <div class="empty-state-styled">
                        <svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        <h3>No Statuses Found</h3>
                        <p>Create your first status to get started with ticket management</p>
                    </div>
                </td>
            </tr>
        `);
        return;
    }

    statuses.forEach(status => {
        const checkIcon = '<svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/></svg>';
        
        const row = `
            <tr data-id="${status.id}">
                <td>
                    <div class="drag-handle drag-handle-styled">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M4 8h16M4 16h16"/>
                        </svg>
                    </div>
                </td>
                <td>
                    <input type="checkbox" class="status-checkbox" value="${status.id}" onchange="toggleSelection(this)">
                </td>
                <td><strong>${status.name}</strong></td>
                <td>
                    <div class="color-info">
                        <span class="color-swatch-styled" style="background-color: ${status.status_color};"></span>
                        <span class="color-hex">${status.status_color}</span>
                    </div>
                </td>
                <td>
                    ${status.is_default ? 
                        `<span class="badge-styled badge-success-styled">${checkIcon}Default</span>` : 
                        '<span class="badge-muted">—</span>'
                    }
                </td>
                <td>
                    ${status.allow_client_change ? 
                        `<span class="badge-styled badge-success-styled">${checkIcon}Yes</span>` : 
                        '<span class="badge-styled badge-warning-styled">No</span>'
                    }
                </td>
                <td><strong>${status.tickets_count || 0}</strong></td>
                <td>
                    <label class="toggle-switch-container">
                        <input type="checkbox" ${status.is_active ? 'checked' : ''} 
                               onchange="toggleActive(${status.id}, this)">
                        <span class="toggle-slider-styled"></span>
                    </label>
                </td>
                <td>${status.created_at}</td>
                <td>
                    <div class="action-buttons-group">
                        ${!status.is_default ? 
                            `<button class="btn-icon-styled btn-default-styled" onclick="setDefault(${status.id})" title="Set as Default">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/>
                                </svg>
                            </button>` : ''
                        }
                        <button class="btn-icon-styled btn-edit-styled" onclick="editStatus(${status.id})" title="Edit">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                            </svg>
                        </button>
                        ${!status.is_default ? 
                            `<button class="btn-icon-styled btn-delete-styled" onclick="deleteStatus(${status.id})" title="Delete">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                                </svg>
                            </button>` : ''
                        }
                    </div>
                </td>
            </tr>
        `;
        tbody.append(row);
    });
}

function renderPagination(response) {
    const container = $('#paginationContainer');
    container.empty();

    if (response.last_page <= 1) return;

    let html = '<div class="pagination-wrapper">';
    html += `<button class="pagination-btn ${currentPage === 1 ? 'active' : ''}" 
                     onclick="changePage(${currentPage - 1})" ${currentPage === 1 ? 'disabled' : ''}>Previous</button>`;

    for (let i = 1; i <= response.last_page; i++) {
        if (i === 1 || i === response.last_page || (i >= currentPage - 2 && i <= currentPage + 2)) {
            html += `<button class="pagination-btn ${i === currentPage ? 'active' : ''}" 
                             onclick="changePage(${i})">${i}</button>`;
        }
    }

    html += `<button class="pagination-btn ${currentPage === response.last_page ? 'active' : ''}" 
                     onclick="changePage(${currentPage + 1})" ${currentPage === response.last_page ? 'disabled' : ''}>Next</button>`;
    html += '</div>';
    container.html(html);
}

function updateCounts(response) {
    $('#totalCount').text(response.total);
}

function changePage(page) {
    if (page < 1) return;
    currentPage = page;
    loadStatuses();
}

function toggleSelection(checkbox) {
    const id = parseInt(checkbox.value);
    if (checkbox.checked) {
        selectedIds.push(id);
    } else {
        selectedIds = selectedIds.filter(item => item !== id);
    }
    $('#bulkDeleteBtn').toggle(selectedIds.length > 0);
}

function toggleSelectAll(checkbox) {
    $('.status-checkbox').prop('checked', checkbox.checked);
    selectedIds = checkbox.checked ? 
        $('.status-checkbox').map(function() { return parseInt(this.value); }).get() : [];
    $('#bulkDeleteBtn').toggle(selectedIds.length > 0);
}

function editStatus(id) {
    window.location.href = `{{ route('admin.support.statuses.edit', ':id') }}`.replace(':id', id);
}

function deleteStatus(id) {
    if (!confirm('Are you sure you want to delete this status?')) return;

    $.ajax({
        url: `{{ route('admin.support.statuses.destroy', ':id') }}`.replace(':id', id),
        type: 'DELETE',
        data: { _token: '{{ csrf_token() }}' },
        success: function(response) {
            alert(response.message || 'Status deleted successfully');
            loadStatuses();
        },
        error: function(xhr) {
            alert('Error: ' + (xhr.responseJSON?.message || 'Failed to delete'));
        }
    });
}

function bulkDelete() {
    if (selectedIds.length === 0) return;
    if (!confirm(`Delete ${selectedIds.length} statuses?`)) return;

    $.ajax({
        url: '{{ route("admin.support.statuses.bulk-delete") }}',
        type: 'POST',
        data: {
            _token: '{{ csrf_token() }}',
            ids: selectedIds
        },
        success: function(response) {
            alert(response.message || 'Statuses deleted successfully');
            selectedIds = [];
            $('#selectAll').prop('checked', false);
            $('#bulkDeleteBtn').hide();
            loadStatuses();
        },
        error: function(xhr) {
            alert('Error: ' + (xhr.responseJSON?.message || 'Failed to delete'));
        }
    });
}

function toggleActive(id, checkbox) {
    $.ajax({
        url: `{{ route('admin.support.statuses.toggle-active', ':id') }}`.replace(':id', id),
        type: 'POST',
        data: { _token: '{{ csrf_token() }}' },
        success: function(response) {
            // Success - no alert needed for better UX
        },
        error: function() {
            checkbox.checked = !checkbox.checked;
            alert('Error toggling status');
        }
    });
}

function setDefault(id) {
    if (!confirm('Set this as the default status? The current default will be changed.')) return;

    $.ajax({
        url: `{{ route('admin.support.statuses.set-default', ':id') }}`.replace(':id', id),
        type: 'POST',
        data: { _token: '{{ csrf_token() }}' },
        success: function(response) {
            alert(response.message || 'Default status updated successfully');
            loadStatuses();
        },
        error: function(xhr) {
            alert('Error: ' + (xhr.responseJSON?.message || 'Failed to set default'));
        }
    });
}

function saveOrder() {
    const order = [];
    $('#statusesTableBody tr').each(function(index) {
        const id = $(this).data('id');
        if (id) {
            order.push({ id: id, order: index + 1 });
        }
    });

    $.ajax({
        url: '{{ route("admin.support.statuses.reorder") }}',
        type: 'POST',
        data: {
            _token: '{{ csrf_token() }}',
            order: order
        },
        success: function(response) {
            alert(response.message || 'Order saved successfully');
        },
        error: function() {
            alert('Error saving order');
        }
    });
}
</script>