<style>
/* ========== DARK MODE VARIABLES ========== */
:root {
    --bg-primary: #f8fafc;
    --bg-secondary: #ffffff;
    --bg-tertiary: #f1f5f9;
    --text-primary: #1e293b;
    --text-secondary: #64748b;
    --border-color: #e2e8f0;
    --border-hover: #cbd5e1;
    --input-bg: #ffffff;
    --input-border: #e2e8f0;
    --shadow-color: rgba(0, 0, 0, 0.06);
    --editor-bg: #ffffff;
    --editor-border: #e2e8f0;
    --checkbox-bg: linear-gradient(135deg, #f8fafc, #f1f5f9);
    --checkbox-hover-bg: linear-gradient(135deg, #eef2ff, #e0e7ff);
}

[data-theme="dark"], 
.dark-mode,
body.dark-mode,
html.dark-mode,
html[data-theme="dark"],
body[data-theme="dark"] {
    --bg-primary: #0f172a;
    --bg-secondary: #1e293b;
    --bg-tertiary: #334155;
    --text-primary: #f1f5f9;
    --text-secondary: #cbd5e1;
    --border-color: #334155;
    --border-hover: #475569;
    --input-bg: #1e293b;
    --input-border: #334155;
    --shadow-color: rgba(0, 0, 0, 0.3);
    --editor-bg: #1e293b;
    --editor-border: #334155;
    --checkbox-bg: linear-gradient(135deg, #1e293b, #334155);
    --checkbox-hover-bg: linear-gradient(135deg, #312e81, #3730a3);
}

/* Auto-detect system dark mode */
@media (prefers-color-scheme: dark) {
    :root:not([data-theme="light"]) {
        --bg-primary: #0f172a;
        --bg-secondary: #1e293b;
        --bg-tertiary: #334155;
        --text-primary: #f1f5f9;
        --text-secondary: #cbd5e1;
        --border-color: #334155;
        --border-hover: #475569;
        --input-bg: #1e293b;
        --input-border: #334155;
        --shadow-color: rgba(0, 0, 0, 0.3);
        --editor-bg: #1e293b;
        --editor-border: #334155;
        --checkbox-bg: linear-gradient(135deg, #1e293b, #334155);
        --checkbox-hover-bg: linear-gradient(135deg, #312e81, #3730a3);
    }
}

/* ========== SUPPORT TICKET CREATE - REDESIGNED ========== */

* {
    box-sizing: border-box;
}

.ticket-create-wrapper {
    padding: 32px;
    min-height: calc(100vh - 60px);
    background: var(--bg-primary);
    animation: fadeInUp 500ms cubic-bezier(0.4, 0, 0.2, 1);
    transition: background 300ms ease;
}

@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes slideDown {
    from { opacity: 0; transform: translateY(-20px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes errorSlide {
    from { opacity: 0; transform: translateY(-8px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes shake {
    0%, 100% { transform: translateX(0); }
    25% { transform: translateX(-6px); }
    75% { transform: translateX(6px); }
}

@keyframes fileSlideIn {
    from { opacity: 0; transform: translateX(-20px); }
    to { opacity: 1; transform: translateX(0); }
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

@keyframes successSlide {
    from { opacity: 0; transform: translateY(-20px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.7; }
}

@keyframes gradientShift {
    0% { background-position: 0% 50%; }
    50% { background-position: 100% 50%; }
    100% { background-position: 0% 50%; }
}

/* ========== PAGE HEADER ========== */
.create-page-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 50%, #f093fb 100%);
    background-size: 200% 200%;
    animation: gradientShift 8s ease infinite, slideDown 600ms cubic-bezier(0.4, 0, 0.2, 1);
    padding: 28px 32px;
    border-radius: 20px;
    margin-bottom: 28px;
    box-shadow: 0 10px 40px rgba(102, 126, 234, 0.35);
    position: relative;
    overflow: hidden;
}

.create-page-header::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -10%;
    width: 350px;
    height: 350px;
    background: radial-gradient(circle, rgba(255,255,255,0.15) 0%, transparent 70%);
    border-radius: 50%;
    pointer-events: none;
}

.create-page-header::after {
    content: '';
    position: absolute;
    bottom: -30%;
    left: 10%;
    width: 200px;
    height: 200px;
    background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
    border-radius: 50%;
    pointer-events: none;
}

.header-content-main {
    position: relative;
    z-index: 1;
}

.page-title-create {
    color: #ffffff;
    font-size: 26px;
    font-weight: 800;
    display: flex;
    align-items: center;
    gap: 14px;
    margin: 0 0 8px 0;
    line-height: 1.2;
    text-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.page-title-create svg {
    width: 28px;
    height: 28px;
    flex-shrink: 0;
    background: rgba(255,255,255,0.2);
    padding: 6px;
    border-radius: 10px;
    width: 40px;
    height: 40px;
}

.page-subtitle-create {
    color: rgba(255, 255, 255, 0.95);
    font-size: 15px;
    font-weight: 500;
    line-height: 1.4;
    margin: 0;
    padding-left: 54px;
}

/* ========== SUCCESS MESSAGE ========== */
.success-message-box {
    display: flex;
    align-items: center;
    gap: 14px;
    padding: 16px 22px;
    background: linear-gradient(135deg, #10b981, #059669);
    color: #ffffff;
    border-radius: 14px;
    font-size: 15px;
    font-weight: 600;
    margin-bottom: 24px;
    animation: successSlide 500ms cubic-bezier(0.4, 0, 0.2, 1);
    box-shadow: 0 6px 20px rgba(16, 185, 129, 0.35);
}

.success-message-box svg {
    width: 22px;
    height: 22px;
    flex-shrink: 0;
}

/* ========== FORM CARD ========== */
.create-form-card {
    background: var(--bg-secondary);
    padding: 36px;
    border-radius: 20px;
    box-shadow: 0 4px 20px var(--shadow-color);
    border: 1px solid var(--border-color);
    animation: fadeInUp 500ms cubic-bezier(0.4, 0, 0.2, 1) 100ms backwards;
    transition: all 300ms ease;
}

/* ========== CHECKBOX TOGGLE ========== */
.checkbox-toggle-wrapper {
    display: flex;
    align-items: center;
    gap: 14px;
    padding: 16px 20px;
    background: var(--checkbox-bg);
    border-radius: 14px;
    margin-bottom: 28px;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    border: 2px solid transparent;
    cursor: pointer;
}

.checkbox-toggle-wrapper:hover {
    background: var(--checkbox-hover-bg);
    border-color: #818cf8;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(129, 140, 248, 0.2);
}

.checkbox-toggle-wrapper input[type="checkbox"] {
    width: 22px;
    height: 22px;
    cursor: pointer;
    accent-color: #667eea;
    border-radius: 6px;
}

.checkbox-toggle-label {
    font-size: 15px;
    color: var(--text-primary);
    cursor: pointer;
    user-select: none;
    font-weight: 600;
}

/* ========== SECTION HEADERS ========== */
.section-header-main {
    display: flex;
    align-items: center;
    gap: 12px;
    margin: 32px 0 24px 0;
    padding-bottom: 14px;
    border-bottom: 2px solid var(--border-color);
    position: relative;
}

.section-header-main::after {
    content: '';
    position: absolute;
    bottom: -2px;
    left: 0;
    width: 60px;
    height: 2px;
    background: linear-gradient(90deg, #667eea, #764ba2);
    border-radius: 2px;
}

.section-header-main:first-of-type {
    margin-top: 0;
}

.section-header-main svg {
    width: 22px;
    height: 22px;
    color: #667eea;
    flex-shrink: 0;
}

.section-title-main {
    font-size: 18px;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0;
}

/* ========== FORM GRID ========== */
.form-grid-main {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 24px;
}

@media (max-width: 768px) {
    .form-grid-main {
        grid-template-columns: 1fr;
    }
}

.form-group-main {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.form-group-main.full-width {
    grid-column: 1 / -1;
}

/* ========== FORM LABELS ========== */
.form-label-main {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    font-weight: 700;
    color: var(--text-primary);
    transition: color 300ms ease;
}

.form-label-main.required::after {
    content: '*';
    color: #ef4444;
    margin-left: 2px;
    font-weight: 700;
}

.label-icon-main {
    width: 18px;
    height: 18px;
    color: #667eea;
    flex-shrink: 0;
}

/* ========== FORM INPUTS ========== */
.form-input-main,
.form-select-main,
.form-textarea-main {
    width: 100%;
    padding: 13px 18px;
    font-size: 15px;
    border: 2px solid var(--input-border);
    border-radius: 12px;
    background: var(--input-bg);
    color: var(--text-primary);
    transition: all 250ms cubic-bezier(0.4, 0, 0.2, 1);
    font-family: inherit;
}

/* Native Select Enhancements */
.form-select-main {
    cursor: pointer;
    appearance: none;
    -webkit-appearance: none;
    -moz-appearance: none;
    background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' viewBox='0 0 12 12'%3E%3Cpath fill='%23667eea' d='M6 9L1 4h10z'/%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: right 18px center;
    padding-right: 45px;
}

/* Make select options scrollable with better visibility */
.form-select-main option {
    background: var(--input-bg);
    color: var(--text-primary);
    padding: 12px 18px;
}

.form-select-main option:hover,
.form-select-main option:focus,
.form-select-main option:checked {
    background: #667eea;
    color: #ffffff;
}

.form-input-main:focus,
.form-select-main:focus,
.form-textarea-main:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
    background: var(--input-bg);
}

.form-input-main:hover,
.form-select-main:hover,
.form-textarea-main:hover {
    border-color: var(--border-hover);
}

.form-textarea-main {
    min-height: 160px;
    resize: vertical;
    line-height: 1.6;
}

/* ========== SELECT OPTIONS COLOR FIX ========== */
.form-select-main option {
    background: var(--input-bg);
    color: var(--text-primary);
    padding: 10px 18px;
}

/* Ensure dropdown options are visible in both light and dark modes */
.form-select-main option:checked {
    background: #667eea;
    color: #ffffff;
    font-weight: 600;
}

.form-select-main option:hover {
    background: var(--bg-tertiary);
    color: var(--text-primary);
}

/* ========== ERROR STATES ========== */
.input-error-main {
    border-color: #ef4444 !important;
    background: rgba(239, 68, 68, 0.05);
    animation: shake 400ms ease-in-out;
}

.form-error-main {
    display: flex;
    align-items: center;
    gap: 8px;
    color: #ef4444;
    font-size: 13px;
    font-weight: 600;
    animation: errorSlide 300ms cubic-bezier(0.4, 0, 0.2, 1);
    margin-top: -4px;
}

.form-error-main svg {
    width: 16px;
    height: 16px;
    flex-shrink: 0;
}

/* ========== RICH TEXT EDITOR ========== */
.editor-container-main {
    border: 2px solid var(--editor-border);
    border-radius: 14px;
    overflow: hidden;
    background: var(--editor-bg);
    transition: all 250ms cubic-bezier(0.4, 0, 0.2, 1);
}

.editor-container-main:focus-within {
    border-color: #667eea;
    box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
}

.editor-toolbar-main {
    display: flex;
    flex-wrap: wrap;
    gap: 6px;
    padding: 12px;
    background: var(--bg-tertiary);
    border-bottom: 1px solid var(--border-color);
}

.editor-btn-main {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 38px;
    height: 38px;
    border: none;
    background: var(--input-bg);
    color: var(--text-primary);
    border-radius: 8px;
    cursor: pointer;
    transition: all 200ms cubic-bezier(0.4, 0, 0.2, 1);
    padding: 0;
}

.editor-btn-main:hover {
    background: #667eea;
    color: #ffffff;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.25);
}

.editor-btn-main:active {
    transform: translateY(0);
}

.editor-btn-main svg {
    width: 18px;
    height: 18px;
}

.editor-content-main {
    min-height: 200px;
    max-height: 400px;
    overflow-y: auto;
    padding: 18px;
    font-size: 15px;
    line-height: 1.7;
    color: var(--text-primary);
    background: var(--editor-bg);
}

.editor-content-main:focus {
    outline: none;
}

.editor-content-main:empty::before {
    content: 'Describe your issue in detail...';
    color: var(--text-secondary);
    pointer-events: none;
}

/* ========== FILE UPLOAD ========== */
.file-upload-area-main {
    border: 2px dashed var(--border-color);
    border-radius: 14px;
    padding: 32px;
    text-align: center;
    cursor: pointer;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    background: var(--bg-tertiary);
}

.file-upload-area-main:hover {
    border-color: #667eea;
    background: var(--checkbox-hover-bg);
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(102, 126, 234, 0.15);
}

.file-icon-main {
    width: 48px;
    height: 48px;
    color: #667eea;
    margin: 0 auto 16px;
}

.file-upload-text-main {
    font-size: 15px;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 6px;
}

.file-upload-hint-main {
    font-size: 13px;
    color: var(--text-secondary);
}

.uploaded-files-list {
    display: flex;
    flex-direction: column;
    gap: 12px;
    margin-top: 16px;
}

.uploaded-file-item {
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 12px;
    padding: 14px 18px;
    background: var(--bg-tertiary);
    border: 1px solid var(--border-color);
    border-radius: 12px;
    animation: fileSlideIn 300ms cubic-bezier(0.4, 0, 0.2, 1);
    transition: all 200ms ease;
}

.uploaded-file-item:hover {
    background: var(--checkbox-hover-bg);
    transform: translateX(4px);
}

.file-info-main {
    display: flex;
    align-items: center;
    gap: 12px;
    flex: 1;
    min-width: 0;
}

.file-info-main svg {
    width: 20px;
    height: 20px;
    color: #667eea;
    flex-shrink: 0;
}

.file-name-main {
    font-size: 14px;
    font-weight: 600;
    color: var(--text-primary);
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

.file-size-main {
    font-size: 13px;
    color: var(--text-secondary);
    flex-shrink: 0;
}

.remove-file-btn {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 32px;
    height: 32px;
    border: none;
    background: rgba(239, 68, 68, 0.1);
    color: #ef4444;
    border-radius: 8px;
    cursor: pointer;
    transition: all 200ms cubic-bezier(0.4, 0, 0.2, 1);
    flex-shrink: 0;
}

.remove-file-btn:hover {
    background: #ef4444;
    color: #ffffff;
    transform: scale(1.05);
}

.remove-file-btn svg {
    width: 16px;
    height: 16px;
}

/* ========== FORM ACTIONS ========== */
.form-actions-main {
    display: flex;
    gap: 14px;
    justify-content: flex-end;
    margin-top: 32px;
    padding-top: 28px;
    border-top: 1px solid var(--border-color);
}

.btn-main-form {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 14px 28px;
    font-size: 15px;
    font-weight: 700;
    border-radius: 12px;
    cursor: pointer;
    transition: all 250ms cubic-bezier(0.4, 0, 0.2, 1);
    border: none;
    text-decoration: none;
}

.btn-main-form svg {
    width: 18px;
    height: 18px;
}

.btn-primary-form {
    background: linear-gradient(135deg, #667eea, #764ba2);
    color: #ffffff;
    box-shadow: 0 4px 14px rgba(102, 126, 234, 0.4);
}

.btn-primary-form:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 24px rgba(102, 126, 234, 0.5);
}

.btn-primary-form:active {
    transform: translateY(0);
}

.btn-secondary-form {
    background: var(--bg-tertiary);
    color: var(--text-primary);
    border: 2px solid var(--border-color);
}

.btn-secondary-form:hover {
    background: var(--border-color);
    border-color: var(--border-hover);
    transform: translateY(-2px);
    box-shadow: 0 4px 14px var(--shadow-color);
}

/* ========== LOADING OVERLAY ========== */
.loading-overlay-create {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.7);
    backdrop-filter: blur(4px);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 9999;
    opacity: 0;
    visibility: hidden;
    transition: all 300ms ease;
}

.loading-overlay-create.active {
    opacity: 1;
    visibility: visible;
}

.loading-content {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 20px;
}

.loading-spinner-create {
    width: 60px;
    height: 60px;
    border: 4px solid rgba(255, 255, 255, 0.2);
    border-top-color: #ffffff;
    border-radius: 50%;
    animation: spin 800ms linear infinite;
}

.loading-text {
    color: #ffffff;
    font-size: 16px;
    font-weight: 600;
}

/* ========== SELECT2 STYLING (Customer dropdown only) ========== */
/* Only style Select2 for customer search dropdown */
#customer_id + .select2-container--default .select2-selection--single {
    background-color: var(--input-bg);
    border: 2px solid var(--input-border);
    border-radius: 12px;
    height: 48px;
    padding: 8px 18px;
    transition: all 250ms cubic-bezier(0.4, 0, 0.2, 1);
}

#customer_id + .select2-container--default .select2-selection--single:hover {
    border-color: var(--border-hover);
}

#customer_id + .select2-container--default.select2-container--focus .select2-selection--single {
    border-color: #667eea;
    box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
}

#customer_id + .select2-container--default .select2-selection--single .select2-selection__rendered {
    color: var(--text-primary);
    line-height: 30px;
    padding-left: 0;
}

#customer_id + .select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 46px;
    right: 10px;
}

/* Select2 Dropdown */
.select2-dropdown {
    background-color: var(--bg-secondary);
    border: 2px solid var(--border-color);
    border-radius: 12px;
    box-shadow: 0 8px 24px var(--shadow-color);
    margin-top: 4px;
}

/* Select2 Results Container - Scrollable */
.select2-results {
    max-height: 280px;
    overflow-y: auto;
}

/* Custom Scrollbar for Select2 */
.select2-results::-webkit-scrollbar {
    width: 8px;
}

.select2-results::-webkit-scrollbar-track {
    background: var(--bg-tertiary);
    border-radius: 4px;
}

.select2-results::-webkit-scrollbar-thumb {
    background: #667eea;
    border-radius: 4px;
}

.select2-results::-webkit-scrollbar-thumb:hover {
    background: #5568d3;
}

/* Select2 Options */
.select2-container--default .select2-results__option {
    background-color: var(--bg-secondary);
    color: var(--text-primary);
    padding: 12px 18px;
    transition: all 150ms ease;
}

.select2-container--default .select2-results__option--highlighted {
    background-color: #667eea;
    color: #ffffff;
}

.select2-container--default .select2-results__option[aria-selected="true"] {
    background-color: var(--bg-tertiary);
    color: var(--text-primary);
    font-weight: 600;
}

/* Select2 Search */
.select2-container--default .select2-search--dropdown .select2-search__field {
    background-color: var(--input-bg);
    border: 2px solid var(--input-border);
    border-radius: 8px;
    color: var(--text-primary);
    padding: 8px 12px;
    margin: 8px;
    width: calc(100% - 16px);
}

.select2-container--default .select2-search--dropdown .select2-search__field:focus {
    border-color: #667eea;
    outline: none;
}

/* Select2 Clear Button */
.select2-container--default .select2-selection--single .select2-selection__clear {
    color: var(--text-secondary);
    font-size: 18px;
    margin-right: 10px;
}

.select2-container--default .select2-selection--single .select2-selection__clear:hover {
    color: #ef4444;
}

[data-theme="dark"] .select2-container--default .select2-search--dropdown .select2-search__field,
.dark-mode .select2-container--default .select2-search--dropdown .select2-search__field,
body.dark-mode .select2-container--default .select2-search--dropdown .select2-search__field {
    background-color: var(--input-bg);
    border-color: var(--input-border);
    color: var(--text-primary);
}

/* Auto-detect system dark mode for Select2 */
@media (prefers-color-scheme: dark) {
    :root:not([data-theme="light"]) .select2-container--default .select2-selection--single {
        background-color: var(--input-bg);
        border-color: var(--input-border);
        color: var(--text-primary);
    }
    
    :root:not([data-theme="light"]) .select2-container--default .select2-selection--single .select2-selection__rendered {
        color: var(--text-primary);
    }
    
    :root:not([data-theme="light"]) .select2-dropdown {
        background-color: var(--bg-secondary);
        border-color: var(--border-color);
    }
    
    :root:not([data-theme="light"]) .select2-container--default .select2-results__option {
        background-color: var(--bg-secondary);
        color: var(--text-primary);
    }
    
    :root:not([data-theme="light"]) .select2-container--default .select2-results__option--highlighted {
        background-color: #667eea;
        color: #ffffff;
    }
    
    :root:not([data-theme="light"]) .select2-container--default .select2-search--dropdown .select2-search__field {
        background-color: var(--input-bg);
        border-color: var(--input-border);
        color: var(--text-primary);
    }
}

/* ========== RESPONSIVE DESIGN ========== */
@media (max-width: 1024px) {
    .form-grid-main {
        grid-template-columns: 1fr;
        gap: 20px;
    }
    
    .create-form-card {
        padding: 28px;
    }
}

@media (max-width: 768px) {
    .ticket-create-wrapper {
        padding: 20px 16px;
    }
    
    .create-page-header {
        padding: 20px;
        margin-bottom: 20px;
        border-radius: 16px;
    }
    
    .page-title-create {
        font-size: 22px;
        gap: 12px;
    }
    
    .page-title-create svg {
        width: 32px;
        height: 32px;
    }
    
    .page-subtitle-create {
        padding-left: 44px;
        font-size: 14px;
    }
    
    .create-form-card {
        padding: 20px;
        border-radius: 16px;
    }
    
    .form-grid-main {
        gap: 18px;
    }
    
    .section-header-main {
        margin: 24px 0 18px 0;
    }
    
    .form-actions-main {
        flex-direction: column;
        gap: 12px;
    }
    
    .btn-main-form {
        width: 100%;
        justify-content: center;
        padding: 16px 24px;
    }
    
    .editor-content-main {
        min-height: 150px;
    }
    
    .file-upload-area-main {
        padding: 24px 16px;
    }
    
    .file-icon-main {
        width: 40px;
        height: 40px;
    }
}

@media (max-width: 480px) {
    .ticket-create-wrapper {
        padding: 16px 12px;
    }
    
    .create-page-header {
        padding: 16px;
        margin-bottom: 16px;
    }
    
    .page-title-create {
        font-size: 20px;
        flex-direction: column;
        align-items: flex-start;
        gap: 8px;
    }
    
    .page-subtitle-create {
        padding-left: 0;
        font-size: 13px;
    }
    
    .create-form-card {
        padding: 16px;
    }
    
    .form-input-main,
    .form-select-main,
    .form-textarea-main {
        padding: 12px 16px;
        font-size: 14px;
    }
    
    .form-label-main {
        font-size: 13px;
    }
    
    .checkbox-toggle-wrapper {
        padding: 12px 16px;
    }
    
    .checkbox-toggle-label {
        font-size: 14px;
    }
}
</style>

<div class="ticket-create-wrapper">
    <!-- Page Header -->
    <div class="create-page-header">
        <div class="header-content-main">
            <h1 class="page-title-create">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4"/>
                </svg>
                Create New Ticket
            </h1>
            <p class="page-subtitle-create">Open a new support ticket for your customer</p>
        </div>
    </div>

    <!-- Success Message -->
    @if(session('success'))
    <div class="success-message-box">
        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
        </svg>
        {{ session('success') }}
    </div>
    @endif

    <!-- Form Card -->
    <div class="create-form-card">
        <form id="ticketForm" method="POST" action="{{ route('admin.support.tickets.store') }}" enctype="multipart/form-data">
            @csrf

            <!-- Toggle: Create Without Contact -->
            <div class="checkbox-toggle-wrapper" onclick="document.getElementById('withoutContact').click()">
                <input type="checkbox" 
                       id="withoutContact" 
                       name="without_contact" 
                       value="1"
                       onchange="toggleContactFields()"
                       {{ old('without_contact') ? 'checked' : '' }}>
                <label class="checkbox-toggle-label" for="withoutContact">
                    Create ticket without existing contact
                </label>
            </div>

            <!-- Section: Ticket Information -->
            <div class="section-header-main">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                </svg>
                <h2 class="section-title-main">Ticket Information</h2>
            </div>

            <div class="form-grid-main">
                <!-- Subject -->
                <div class="form-group-main full-width">
                    <label class="form-label-main required" for="subject">
                        <svg class="label-icon-main" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z"/>
                        </svg>
                        Subject
                    </label>
                    <input type="text" 
                           id="subject" 
                           name="subject" 
                           class="form-input-main @error('subject') input-error-main @enderror" 
                           value="{{ old('subject') }}"
                           placeholder="Brief description of the issue" 
                           required>
                    @error('subject')
                        <span class="form-error-main">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </span>
                    @enderror
                </div>

                <!-- Contact (Conditional) -->
                <div id="contactGroup" class="form-group-main" style="{{ old('without_contact') ? 'display:none;' : '' }}">
                    <label class="form-label-main required" for="customer_id">
                        <svg class="label-icon-main" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                        </svg>
                        Contact
                    </label>
                    <select id="customer_id" 
                            name="customer_id" 
                            class="form-select-main @error('customer_id') input-error-main @enderror"
                            onchange="fillCustomerInfo()"
                            {{ old('without_contact') ? '' : 'required' }}>
                        <option value="">Select a contact</option>
                        @if(old('customer_id'))
                            <option value="{{ old('customer_id') }}" selected>Loading...</option>
                        @endif
                    </select>
                    @error('customer_id')
                        <span class="form-error-main">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </span>
                    @enderror
                </div>

                <!-- Name (Conditional) -->
                <div id="nameGroup" class="form-group-main" style="{{ old('without_contact') ? '' : 'display:none;' }}">
                    <label class="form-label-main required" for="name">
                        <svg class="label-icon-main" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                        </svg>
                        Name
                    </label>
                    <input type="text" 
                           id="name" 
                           name="name" 
                           class="form-input-main @error('name') input-error-main @enderror" 
                           value="{{ old('name') }}"
                           placeholder="Customer name"
                           {{ old('without_contact') ? 'required' : '' }}>
                    @error('name')
                        <span class="form-error-main">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </span>
                    @enderror
                </div>

                <!-- Email (Conditional) -->
                <div id="emailGroup" class="form-group-main" style="{{ old('without_contact') ? '' : 'display:none;' }}">
                    <label class="form-label-main required" for="email">
                        <svg class="label-icon-main" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                        </svg>
                        Email
                    </label>
                    <input type="email" 
                           id="email" 
                           name="email" 
                           class="form-input-main @error('email') input-error-main @enderror" 
                           value="{{ old('email') }}"
                           placeholder="customer@example.com"
                           {{ old('without_contact') ? 'required' : '' }}>
                    @error('email')
                        <span class="form-error-main">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </span>
                    @enderror
                </div>

                <!-- Department -->
                <div class="form-group-main">
                    <label class="form-label-main required" for="department_id">
                        <svg class="label-icon-main" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                        </svg>
                        Department
                    </label>
                    <select id="department_id" 
                            name="department_id" 
                            class="form-select-main @error('department_id') input-error-main @enderror" 
                            required>
                        <option value="">Select department</option>
                        @foreach($departments as $department)
                            <option value="{{ $department->id }}" {{ old('department_id') == $department->id ? 'selected' : '' }}>
                                {{ $department->name }}
                            </option>
                        @endforeach
                    </select>
                    @error('department_id')
                        <span class="form-error-main">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </span>
                    @enderror
                </div>

                <!-- Priority -->
                <div class="form-group-main">
                    <label class="form-label-main required" for="priority_id">
                        <svg class="label-icon-main" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                        </svg>
                        Priority
                    </label>
                    <select id="priority_id" 
                            name="priority_id" 
                            class="form-select-main @error('priority_id') input-error-main @enderror" 
                            required>
                        <option value="">Select priority</option>
                        @foreach($priorities as $priority)
                            <option value="{{ $priority->id }}" {{ old('priority_id') == $priority->id ? 'selected' : '' }}>
                                {{ $priority->name }}
                            </option>
                        @endforeach
                    </select>
                    @error('priority_id')
                        <span class="form-error-main">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </span>
                    @enderror
                </div>

                <!-- Status -->
                <div class="form-group-main">
                    <label class="form-label-main required" for="status_id">
                        <svg class="label-icon-main" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        Status
                    </label>
                    <select id="status_id" 
                            name="status_id" 
                            class="form-select-main @error('status_id') input-error-main @enderror" 
                            required>
                        <option value="">Select status</option>
                        @foreach($statuses as $status)
                            <option value="{{ $status->id }}" {{ old('status_id') == $status->id ? 'selected' : '' }}>
                                {{ $status->name }}
                            </option>
                        @endforeach
                    </select>
                    @error('status_id')
                        <span class="form-error-main">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </span>
                    @enderror
                </div>

                <!-- Assigned To -->
                <div class="form-group-main">
                    <label class="form-label-main" for="assigned_to">
                        <svg class="label-icon-main" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                        </svg>
                        Assigned To
                    </label>
                    <select id="assigned_to" 
                            name="assigned_to" 
                            class="form-select-main @error('assigned_to') input-error-main @enderror">
                        <option value="">Unassigned</option>
                        @foreach($staff as $member)
                            <option value="{{ $member->id }}" {{ old('assigned_to') == $member->id ? 'selected' : '' }}>
                                {{ $member->first_name }} {{ $member->last_name }}
                            </option>
                        @endforeach
                    </select>
                    @error('assigned_to')
                        <span class="form-error-main">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </span>
                    @enderror
                </div>

                <!-- Message -->
                <div class="form-group-main full-width">
                    <label class="form-label-main required" for="message">
                        <svg class="label-icon-main" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                        </svg>
                        Message
                    </label>
                    <div class="editor-container-main">
                        <div class="editor-toolbar-main">
                            <button type="button" class="editor-btn-main" onclick="execCmd('bold')" title="Bold">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M6 4h8a4 4 0 014 4 4 4 0 01-4 4H6z M6 12h9a4 4 0 014 4 4 4 0 01-4 4H6z"/>
                                </svg>
                            </button>
                            <button type="button" class="editor-btn-main" onclick="execCmd('italic')" title="Italic">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M10 4h4m-4 16h4M12 4l-4 16"/>
                                </svg>
                            </button>
                            <button type="button" class="editor-btn-main" onclick="execCmd('underline')" title="Underline">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M6 3v7a6 6 0 006 6 6 6 0 006-6V3M4 21h16"/>
                                </svg>
                            </button>
                            <button type="button" class="editor-btn-main" onclick="execCmd('insertUnorderedList')" title="Bullet List">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M8 6h13M8 12h13M8 18h13M3 6h.01M3 12h.01M3 18h.01"/>
                                </svg>
                            </button>
                            <button type="button" class="editor-btn-main" onclick="execCmd('insertOrderedList')" title="Numbered List">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M7 8h14M7 12h14M7 16h14M3 8l1.5-1v4M3 16h2.5M3 12h1l1.5 2"/>
                                </svg>
                            </button>
                            <button type="button" class="editor-btn-main" onclick="execCmd('createLink', prompt('Enter URL:'))" title="Insert Link">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"/>
                                </svg>
                            </button>
                        </div>
                        <div id="editor" 
                             class="editor-content-main" 
                             contenteditable="true">{{ old('message') }}</div>
                    </div>
                    <textarea id="message" 
                              name="message" 
                              class="@error('message') input-error-main @enderror"
                              style="display: none;" 
                              required></textarea>
                    @error('message')
                        <span class="form-error-main">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </span>
                    @enderror
                </div>

                <!-- File Attachments -->
                <div class="form-group-main full-width">
                    <label class="form-label-main">
                        <svg class="label-icon-main" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"/>
                        </svg>
                        Attachments
                    </label>
                    <div class="file-upload-area-main" onclick="document.getElementById('attachments').click()">
                        <svg class="file-icon-main" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"/>
                        </svg>
                        <div class="file-upload-text-main">Click to upload or drag and drop</div>
                        <div class="file-upload-hint-main">PDF, DOC, DOCX, JPG, PNG (Max 10MB per file)</div>
                        <input type="file" 
                               id="attachments" 
                               name="attachments[]" 
                               multiple 
                               onchange="handleFiles(this)"
                               accept=".pdf,.doc,.docx,.jpg,.jpeg,.png,.gif">
                    </div>
                    <div id="uploadedFiles" class="uploaded-files-list"></div>
                </div>

                <!-- Form Actions -->
                <div class="form-actions-main">
                    <a href="{{ route('admin.support.tickets.index') }}" class="btn-main-form btn-secondary-form">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                        Cancel
                    </a>
                    <button type="submit" class="btn-main-form btn-primary-form">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/>
                        </svg>
                        Create Ticket
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Loading Overlay -->
<div class="loading-overlay-create" id="loadingOverlay">
    <div class="loading-content">
        <div class="loading-spinner-create"></div>
        <span class="loading-text">Creating ticket...</span>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<script>
$(document).ready(function() {
    // Initialize Select2 ONLY for Customer (with AJAX search)
    $('#customer_id').select2({
        placeholder: 'Search for a contact...',
        allowClear: true,
        ajax: {
            url: '{{ route("admin.support.tickets.search-customers") }}',
            dataType: 'json',
            delay: 250,
            data: function(params) {
                return { q: params.term };
            },
            processResults: function(data) {
                return { results: data };
            }
        },
        minimumInputLength: 0
    });

    // Remove Select2 from other dropdowns - use native selects
    // They look better and are more responsive

    // Sync editor content
    $('#editor').on('input', function() {
        $('#message').val($(this).html());
    });

    // Form submission
    $('#ticketForm').on('submit', function(e) {
        $('#message').val($('#editor').html());
        
        const message = $('#message').val().trim();
        if (!message || message === '' || message === '<br>') {
            e.preventDefault();
            alert('Please enter a ticket message');
            $('#editor').focus();
            return false;
        }
        
        $('#loadingOverlay').addClass('active');
    });

    // Set old message
    @if(old('message'))
        $('#editor').html('{!! old('message') !!}');
    @endif
});

function toggleContactFields() {
    const checked = $('#withoutContact').is(':checked');
    
    if (checked) {
        $('#contactGroup').slideUp(300);
        $('#nameGroup').slideDown(300).css('display', 'block');
        $('#emailGroup').slideDown(300).css('display', 'block');
        $('#customer_id').val(null).trigger('change');
        $('#name').attr('required', true);
        $('#email').attr('required', true);
    } else {
        $('#contactGroup').slideDown(300).css('display', 'block');
        $('#nameGroup').slideUp(300);
        $('#emailGroup').slideUp(300);
        $('#name').val('').attr('required', false);
        $('#email').val('').attr('required', false);
    }
}

function fillCustomerInfo() {
    const customerId = $('#customer_id').val();
    
    if (!customerId) return;

    $.ajax({
        url: '{{ route("admin.support.tickets.get-customer-info", ":id") }}'.replace(':id', customerId),
        type: 'GET',
        success: function(response) {
            if (response.success) {
                $('#name').val(response.customer.name);
                $('#email').val(response.customer.email);
            }
        },
        error: function() {
            console.error('Failed to load customer info');
        }
    });
}

function execCmd(command, value = null) {
    document.execCommand(command, false, value);
    $('#editor').focus();
    $('#editor').trigger('input');
}

function handleFiles(input) {
    const files = input.files;
    const container = $('#uploadedFiles');
    container.empty();

    Array.from(files).forEach((file, index) => {
        const fileItem = `
            <div class="uploaded-file-item" data-index="${index}">
                <div class="file-info-main">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                    </svg>
                    <span class="file-name-main">${file.name}</span>
                    <span class="file-size-main">${formatFileSize(file.size)}</span>
                </div>
                <button type="button" class="remove-file-btn" onclick="removeFile(${index})" title="Remove file">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                </button>
            </div>
        `;
        container.append(fileItem);
    });
}

function removeFile(index) {
    const input = document.getElementById('attachments');
    const dt = new DataTransfer();
    
    Array.from(input.files).forEach((file, i) => {
        if (i !== index) dt.items.add(file);
    });
    
    input.files = dt.files;
    handleFiles(input);
}

function formatFileSize(bytes) {
    if (bytes === 0) return '0 Bytes';
    const k = 1024;
    const sizes = ['Bytes', 'KB', 'MB', 'GB'];
    const i = Math.floor(Math.log(bytes) / Math.log(k));
    return Math.round(bytes / Math.pow(k, i) * 100) / 100 + ' ' + sizes[i];
}
</script>