<style>
/* ========== REQUEST HISTORY - ECHOPX COMPLIANT (NO HEADER) ========== */

@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes slideInLeft {
    from { opacity: 0; transform: translateX(-20px); }
    to { opacity: 1; transform: translateX(0); }
}

/* ========== HISTORY ITEMS ========== */
.history-item-main {
    background: var(--body-bg);
    padding: 24px;
    border-radius: 12px;
    margin-bottom: 20px;
    border-left: 4px solid transparent;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    animation: slideInLeft 400ms cubic-bezier(0.4, 0, 0.2, 1);
}

.history-item-main:hover {
    transform: translateX(4px);
    box-shadow: var(--shadow-sm);
}

.history-item-main.staff-reply {
    border-left-color: var(--primary);
    background: var(--body-bg);
}

.history-item-main.customer-reply {
    border-left-color: var(--success);
    background: rgba(34, 197, 94, 0.03);
}

/* ========== HISTORY META ========== */
.history-meta-section {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 16px;
    gap: 16px;
    flex-wrap: wrap;
}

.history-author-main {
    display: flex;
    align-items: center;
    gap: 12px;
    flex-wrap: wrap;
}

.history-author-avatar {
    width: 44px;
    height: 44px;
    border-radius: 50%;
    background: linear-gradient(135deg, #6366f1, #4f46e5);
    color: #ffffff;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    font-size: 16px;
    flex-shrink: 0;
    box-shadow: 0 4px 12px rgba(99, 102, 241, 0.25);
}

.history-author-avatar.customer-avatar {
    background: linear-gradient(135deg, #22c55e, #16a34a);
    box-shadow: 0 4px 12px rgba(34, 197, 94, 0.25);
}

.history-author-info {
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.history-author-name {
    font-weight: 600;
    color: var(--text-primary);
    font-size: 15px;
    line-height: 1.2;
}

.author-badge-styled {
    padding: 4px 10px;
    border-radius: 6px;
    font-size: 10px;
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 0.05em;
    background: var(--primary);
    color: #ffffff;
    display: inline-block;
    box-shadow: 0 2px 4px rgba(99, 102, 241, 0.2);
}

.history-time-main {
    font-size: 13px;
    color: var(--text-secondary);
    display: flex;
    align-items: center;
    gap: 6px;
}

.history-time-main svg {
    width: 14px;
    height: 14px;
    flex-shrink: 0;
}

/* ========== HISTORY MESSAGE ========== */
.history-message-content {
    font-size: 14px;
    color: var(--text-primary);
    line-height: 1.7;
    margin-bottom: 16px;
    word-wrap: break-word;
}

.history-message-content:last-child {
    margin-bottom: 0;
}

/* ========== ATTACHMENTS ========== */
.history-attachments-section {
    display: flex;
    flex-wrap: wrap;
    gap: 12px;
    margin-top: 16px;
}

.attachment-item-styled {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 10px 16px;
    background: var(--card-bg);
    border-radius: 10px;
    border: 1px solid var(--card-border);
    font-size: 13px;
    font-weight: 500;
    color: var(--text-primary);
    text-decoration: none;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    max-width: 280px;
}

.attachment-item-styled svg {
    width: 16px;
    height: 16px;
    color: var(--primary);
    flex-shrink: 0;
}

.attachment-item-styled:hover {
    background: var(--primary);
    color: #ffffff;
    border-color: var(--primary);
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(99, 102, 241, 0.3);
}

.attachment-item-styled:hover svg {
    color: #ffffff;
}

.attachment-file-name {
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

/* ========== POSTED LABEL ========== */
.posted-label {
    display: flex;
    align-items: center;
    gap: 6px;
    font-size: 11px;
    font-weight: 600;
    color: var(--text-muted);
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.posted-label svg {
    width: 12px;
    height: 12px;
}

/* ========== NO REPLIES MESSAGE ========== */
.no-replies-message {
    display: none;
}

/* ========== RESPONSIVE DESIGN ========== */
@media (max-width: 768px) {
    .history-item-main {
        padding: 20px;
    }

    .history-meta-section {
        flex-direction: column;
        align-items: flex-start;
    }

    .history-author-avatar {
        width: 40px;
        height: 40px;
        font-size: 15px;
    }

    .attachment-item-styled {
        max-width: 100%;
    }
}

@media (max-width: 640px) {
    .history-item-main {
        padding: 16px;
    }

    .history-author-main {
        width: 100%;
    }

    .history-author-avatar {
        width: 36px;
        height: 36px;
        font-size: 14px;
    }

    .history-time-main {
        font-size: 12px;
    }

    .attachment-item-styled {
        font-size: 12px;
        padding: 8px 14px;
    }
}
</style>

<!-- Original Ticket Message -->
<div class="history-item-main {{ $ticket->customer_id ? 'customer-reply' : 'staff-reply' }}">
    <div class="history-meta-section">
        <div class="history-author-main">
            <div class="history-author-avatar {{ $ticket->customer_id ? 'customer-avatar' : '' }}">
                {{ strtoupper(substr($ticket->submitter_name, 0, 1)) }}
            </div>
            <div class="history-author-info">
                <div class="history-author-name">
                    {{ $ticket->submitter_name }}
                    @if(!$ticket->customer_id)
                    <span class="author-badge-styled">STAFF</span>
                    @endif
                </div>
                <div class="posted-label">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4"/>
                    </svg>
                    Original Ticket
                </div>
            </div>
        </div>
        <div class="history-time-main">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
            </svg>
            {{ $ticket->created_at->format('M d, Y g:i A') }}
        </div>
    </div>
    <div class="history-message-content">
        {!! nl2br(e($ticket->message)) !!}
    </div>
    
    @if($ticket->attachments->count() > 0)
    <div class="history-attachments-section">
        @foreach($ticket->attachments as $attachment)
        <a href="{{ route('admin.support.tickets.download', $attachment->id) }}" 
           class="attachment-item-styled"
           target="_blank"
           title="{{ $attachment->file_name }}">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"/>
            </svg>
            <span class="attachment-file-name">{{ $attachment->file_name }}</span>
        </a>
        @endforeach
    </div>
    @endif
</div>

<!-- Replies -->
@forelse($ticket->replies as $reply)
<div class="history-item-main {{ $reply->staff_id ? 'staff-reply' : 'customer-reply' }}">
    <div class="history-meta-section">
        <div class="history-author-main">
            <div class="history-author-avatar {{ $reply->staff_id ? '' : 'customer-avatar' }}">
                {{ strtoupper(substr($reply->submitter_name, 0, 1)) }}
            </div>
            <div class="history-author-info">
                <div class="history-author-name">
                    {{ $reply->submitter_name }}
                    @if($reply->staff_id)
                    <span class="author-badge-styled">STAFF</span>
                    @endif
                </div>
                <div class="posted-label">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 10h10a8 8 0 018 8v2M3 10l6 6m-6-6l6-6"/>
                    </svg>
                    Reply
                </div>
            </div>
        </div>
        <div class="history-time-main">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
            </svg>
            {{ $reply->replied_at->format('M d, Y g:i A') }}
        </div>
    </div>
    <div class="history-message-content">
        {!! $reply->message !!}
    </div>
    
    @if($reply->attachments->count() > 0)
    <div class="history-attachments-section">
        @foreach($reply->attachments as $attachment)
        <a href="{{ route('admin.support.tickets.download', $attachment->id) }}" 
           class="attachment-item-styled"
           target="_blank"
           title="{{ $attachment->file_name }}">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"/>
            </svg>
            <span class="attachment-file-name">{{ $attachment->file_name }}</span>
        </a>
        @endforeach
    </div>
    @endif
</div>
@empty
<div class="no-replies-message">
    <!-- No replies yet - silent, no visual indicator needed -->
</div>
@endforelse