<style>
/* ========== OTHER TICKETS TAB - ECHOPX COMPLIANT ========== */

.other-tickets-wrapper {
    padding: 0;
}

@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes slideInRight {
    from { opacity: 0; transform: translateX(20px); }
    to { opacity: 1; transform: translateX(0); }
}

/* ========== HEADER SECTION ========== */
.other-tickets-header-section {
    display: flex;
    align-items: center;
    gap: 12px;
    font-size: 18px;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 24px;
    padding-bottom: 18px;
    border-bottom: 2px solid var(--card-border);
}

.other-tickets-header-section svg {
    width: 22px;
    height: 22px;
    color: var(--primary);
    flex-shrink: 0;
}

.customer-name-highlight {
    color: var(--primary);
    font-weight: 700;
}

/* ========== TABLE SECTION ========== */
.other-tickets-table-container {
    overflow-x: auto;
    border-radius: 12px;
    border: 1px solid var(--card-border);
    animation: fadeInUp 500ms cubic-bezier(0.4, 0, 0.2, 1) 100ms backwards;
}

.other-tickets-table-styled {
    width: 100%;
    border-collapse: separate;
    border-spacing: 0;
}

.other-tickets-table-styled thead th {
    background: var(--body-bg);
    padding: 14px 16px;
    text-align: left;
    font-weight: 600;
    font-size: 13px;
    color: var(--text-secondary);
    text-transform: uppercase;
    letter-spacing: 0.05em;
    border-bottom: 2px solid var(--card-border);
    white-space: nowrap;
}

.other-tickets-table-styled thead th:first-child {
    border-top-left-radius: 12px;
}

.other-tickets-table-styled thead th:last-child {
    border-top-right-radius: 12px;
}

.other-tickets-table-styled tbody tr {
    border-bottom: 1px solid var(--card-border);
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.other-tickets-table-styled tbody tr:last-child {
    border-bottom: none;
}

.other-tickets-table-styled tbody tr:hover {
    background: rgba(99, 102, 241, 0.04);
    transform: translateX(4px);
}

.other-tickets-table-styled tbody td {
    padding: 14px 16px;
    font-size: 14px;
    color: var(--text-primary);
}

/* ========== TICKET NUMBER LINK ========== */
.ticket-number-link {
    color: var(--primary);
    text-decoration: none;
    font-weight: 700;
    font-family: 'Courier New', monospace;
    font-size: 14px;
    padding: 6px 12px;
    background: rgba(99, 102, 241, 0.1);
    border-radius: 8px;
    border: 1px solid rgba(99, 102, 241, 0.2);
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    display: inline-block;
}

.ticket-number-link:hover {
    background: var(--primary);
    color: #ffffff;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(99, 102, 241, 0.3);
}

/* ========== SUBJECT CELL ========== */
.subject-text {
    font-weight: 500;
    color: var(--text-primary);
    line-height: 1.4;
}

/* ========== STATUS & PRIORITY BADGES ========== */
.badge-styled {
    padding: 5px 12px;
    border-radius: 8px;
    font-size: 11px;
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 0.05em;
    display: inline-block;
    color: #ffffff;
    border: 1px solid rgba(0, 0, 0, 0.1);
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

/* ========== METADATA CELLS ========== */
.metadata-cell {
    display: flex;
    align-items: center;
    gap: 8px;
    color: var(--text-secondary);
    font-size: 13px;
}

.metadata-cell svg {
    width: 14px;
    height: 14px;
    flex-shrink: 0;
    opacity: 0.7;
}

/* ========== EMPTY STATE ========== */
.empty-other-tickets-styled {
    text-align: center;
    padding: 60px 24px;
    animation: fadeInUp 500ms cubic-bezier(0.4, 0, 0.2, 1);
}

.empty-other-tickets-icon {
    width: 72px;
    height: 72px;
    color: var(--text-muted);
    margin: 0 auto 16px;
    opacity: 0.6;
}

.empty-other-tickets-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 8px;
}

.empty-other-tickets-subtitle {
    font-size: 14px;
    color: var(--text-secondary);
    line-height: 1.5;
}

/* ========== RESPONSIVE DESIGN ========== */
@media (max-width: 768px) {
    .other-tickets-header-section {
        font-size: 16px;
        flex-wrap: wrap;
    }

    .other-tickets-table-container {
        border-radius: 0;
        margin: 0 -16px;
    }

    .other-tickets-table-styled {
        font-size: 13px;
    }

    .other-tickets-table-styled thead th,
    .other-tickets-table-styled tbody td {
        padding: 10px 12px;
    }
}

@media (max-width: 640px) {
    .empty-other-tickets-styled {
        padding: 40px 20px;
    }

    .empty-other-tickets-icon {
        width: 56px;
        height: 56px;
    }

    .metadata-cell {
        flex-direction: column;
        align-items: flex-start;
        gap: 4px;
    }
}
</style>

<div class="other-tickets-wrapper">
    <!-- Header -->
    <div class="other-tickets-header-section">
        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" d="M15 5v2m0 4v2m0 4v2M5 5a2 2 0 00-2 2v3a2 2 0 110 4v3a2 2 0 002 2h14a2 2 0 002-2v-3a2 2 0 110-4V7a2 2 0 00-2-2H5z"/>
        </svg>
        <span>Other Tickets from <span class="customer-name-highlight">{{ $ticket->submitter_name }}</span></span>
    </div>

    <!-- Table -->
    <div class="other-tickets-table-container" id="otherTicketsWrapper">
        <table class="other-tickets-table-styled">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Subject</th>
                    <th>Department</th>
                    <th>Status</th>
                    <th>Priority</th>
                    <th>Last Reply</th>
                    <th>Created</th>
                </tr>
            </thead>
            <tbody id="otherTicketsBody">
                <!-- Data loaded via AJAX -->
            </tbody>
        </table>
    </div>

    <!-- Empty State -->
    <div id="emptyOtherTickets" class="empty-other-tickets-styled" style="display: none;">
        <svg class="empty-other-tickets-icon" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" d="M15 5v2m0 4v2m0 4v2M5 5a2 2 0 00-2 2v3a2 2 0 110 4v3a2 2 0 002 2h14a2 2 0 002-2v-3a2 2 0 110-4V7a2 2 0 00-2-2H5z"/>
        </svg>
        <div class="empty-other-tickets-title">No other tickets found</div>
        <div class="empty-other-tickets-subtitle">This customer doesn't have any other tickets</div>
    </div>
</div>

<script>
$(document).ready(function() {
    loadOtherTickets();
});

function loadOtherTickets() {
    $.ajax({
        url: '{{ route("admin.support.tickets.other-tickets.data", $ticket->id) }}',
        type: 'GET',
        success: function(response) {
            if (response.data) {
                renderOtherTickets(response.data);
            }
        },
        error: function() {
            console.error('Error loading other tickets');
            $('#otherTicketsWrapper').hide();
            $('#emptyOtherTickets').show();
        }
    });
}

function renderOtherTickets(tickets) {
    const tbody = $('#otherTicketsBody');
    const wrapper = $('#otherTicketsWrapper');
    const emptyState = $('#emptyOtherTickets');
    
    tbody.empty();
    
    if (!tickets || tickets.length === 0) {
        wrapper.hide();
        emptyState.show();
        return;
    }
    
    wrapper.show();
    emptyState.hide();
    
    tickets.forEach(ticket => {
        const row = `
            <tr>
                <td>
                    <a href="${ticket.url}" class="ticket-number-link">#${ticket.id}</a>
                </td>
                <td>
                    <span class="subject-text">${escapeHtml(ticket.subject)}</span>
                </td>
                <td>${ticket.department_name || 'N/A'}</td>
                <td>
                    <span class="badge-styled status-badge-dynamic" data-color="${ticket.status_color}">
                        ${ticket.status_name}
                    </span>
                </td>
                <td>
                    <span class="badge-styled priority-badge-dynamic" data-color="${ticket.priority_color}">
                        ${ticket.priority_name}
                    </span>
                </td>
                <td>
                    <div class="metadata-cell">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        <span>${ticket.last_reply_time || 'No Reply'}</span>
                    </div>
                </td>
                <td>
                    <div class="metadata-cell">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                        </svg>
                        <span>${ticket.created_at}</span>
                    </div>
                </td>
            </tr>
        `;
        tbody.append(row);
    });
    
    // Apply dynamic colors to badges after rendering
    applyBadgeColors();
}

function applyBadgeColors() {
    // Apply status badge colors
    $('.status-badge-dynamic').each(function() {
        const color = $(this).data('color');
        if (color) {
            $(this).css('background-color', color);
        }
    });
    
    // Apply priority badge colors
    $('.priority-badge-dynamic').each(function() {
        const color = $(this).data('color');
        if (color) {
            $(this).css('background-color', color);
        }
    });
}

function escapeHtml(text) {
    const map = {
        '&': '&amp;',
        '<': '&lt;',
        '>': '&gt;',
        '"': '&quot;',
        "'": '&#039;'
    };
    return text.replace(/[&<>"']/g, m => map[m]);
}
</script>