<style>
/* ========== REMINDERS TAB - ECHOPX COMPLIANT ========== */

.reminders-wrapper {
    padding: 0;
}

@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes slideInRight {
    from { opacity: 0; transform: translateX(20px); }
    to { opacity: 1; transform: translateX(0); }
}

@keyframes modalFadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}

@keyframes modalSlideIn {
    from { opacity: 0; transform: translateY(-30px) scale(0.95); }
    to { opacity: 1; transform: translateY(0) scale(1); }
}

/* ========== HEADER SECTION ========== */
.reminders-header-section {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 24px;
    padding-bottom: 18px;
    border-bottom: 2px solid var(--card-border);
}

.reminders-title-main {
    font-size: 18px;
    font-weight: 700;
    color: var(--text-primary);
    display: flex;
    align-items: center;
    gap: 10px;
}

.reminders-title-main svg {
    width: 20px;
    height: 20px;
    color: var(--primary);
    flex-shrink: 0;
}

.btn-set-reminder-styled {
    padding: 11px 22px;
    background: var(--primary);
    color: #ffffff;
    border: none;
    border-radius: 10px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 8px;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    box-shadow: 0 2px 8px rgba(99, 102, 241, 0.25);
}

.btn-set-reminder-styled svg {
    width: 16px;
    height: 16px;
}

.btn-set-reminder-styled:hover {
    background: #4f46e5;
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(99, 102, 241, 0.35);
}

.btn-set-reminder-styled:active {
    transform: translateY(0);
}

/* ========== TABLE SECTION ========== */
.reminders-table-container {
    overflow-x: auto;
    border-radius: 12px;
    border: 1px solid var(--card-border);
}

.reminders-table-styled {
    width: 100%;
    border-collapse: separate;
    border-spacing: 0;
}

.reminders-table-styled thead th {
    background: var(--body-bg);
    padding: 14px 16px;
    text-align: left;
    font-weight: 600;
    font-size: 13px;
    color: var(--text-secondary);
    text-transform: uppercase;
    letter-spacing: 0.05em;
    border-bottom: 2px solid var(--card-border);
    white-space: nowrap;
}

.reminders-table-styled thead th:first-child {
    border-top-left-radius: 12px;
}

.reminders-table-styled thead th:last-child {
    border-top-right-radius: 12px;
}

.reminders-table-styled tbody tr {
    border-bottom: 1px solid var(--card-border);
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.reminders-table-styled tbody tr:last-child {
    border-bottom: none;
}

.reminders-table-styled tbody tr:hover {
    background: rgba(99, 102, 241, 0.04);
}

.reminders-table-styled tbody td {
    padding: 14px 16px;
    font-size: 14px;
    color: var(--text-primary);
}

/* ========== NOTIFIED BADGES ========== */
.notified-badge-styled {
    padding: 5px 12px;
    border-radius: 8px;
    font-size: 11px;
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 0.05em;
    display: inline-flex;
    align-items: center;
    gap: 6px;
}

.notified-badge-styled svg {
    width: 12px;
    height: 12px;
}

.notified-yes-styled {
    background: rgba(34, 197, 94, 0.12);
    color: #16a34a;
    border: 1px solid rgba(34, 197, 94, 0.2);
}

.notified-no-styled {
    background: rgba(251, 191, 36, 0.12);
    color: #d97706;
    border: 1px solid rgba(251, 191, 36, 0.2);
}

/* ========== ACTION BUTTON ========== */
.btn-delete-reminder {
    background: rgba(239, 68, 68, 0.12);
    border: none;
    color: var(--danger);
    cursor: pointer;
    padding: 8px;
    border-radius: 8px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.btn-delete-reminder svg {
    width: 16px;
    height: 16px;
}

.btn-delete-reminder:hover {
    background: var(--danger);
    color: #ffffff;
    transform: scale(1.1);
}

/* ========== EMPTY STATE ========== */
.empty-reminders-styled {
    text-align: center;
    padding: 60px 24px;
    animation: fadeInUp 500ms cubic-bezier(0.4, 0, 0.2, 1);
}

.empty-reminders-icon {
    width: 72px;
    height: 72px;
    color: var(--text-muted);
    margin: 0 auto 16px;
    opacity: 0.6;
}

.empty-reminders-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 8px;
}

.empty-reminders-subtitle {
    font-size: 14px;
    color: var(--text-secondary);
    line-height: 1.5;
}

/* ========== MODAL OVERLAY ========== */
.modal-overlay-styled {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.65);
    backdrop-filter: blur(8px);
    z-index: 9998;
    align-items: center;
    justify-content: center;
}

.modal-overlay-styled.active {
    display: flex;
    animation: modalFadeIn 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.modal-content-styled {
    background: var(--card-bg);
    padding: 32px;
    border-radius: 16px;
    width: 90%;
    max-width: 520px;
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
    animation: modalSlideIn 400ms cubic-bezier(0.4, 0, 0.2, 1);
    border: 1px solid var(--card-border);
}

/* ========== MODAL HEADER ========== */
.modal-header-styled {
    font-size: 20px;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 28px;
    padding-bottom: 18px;
    border-bottom: 2px solid var(--card-border);
    display: flex;
    align-items: center;
    gap: 12px;
}

.modal-header-styled svg {
    width: 24px;
    height: 24px;
    color: var(--primary);
    flex-shrink: 0;
}

/* ========== FORM GROUPS ========== */
.form-group-styled {
    margin-bottom: 24px;
}

.form-label-styled {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 10px;
}

.form-label-styled svg {
    width: 16px;
    height: 16px;
    color: var(--text-secondary);
}

.form-input-styled,
.form-textarea-styled {
    width: 100%;
    padding: 12px 16px;
    border: 1.5px solid var(--card-border);
    border-radius: 10px;
    font-size: 14px;
    color: var(--text-primary);
    background: var(--card-bg);
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    line-height: 1.5;
}

.form-input-styled::placeholder,
.form-textarea-styled::placeholder {
    color: var(--text-muted);
}

.form-textarea-styled {
    min-height: 120px;
    resize: vertical;
    font-family: inherit;
}

.form-input-styled:focus,
.form-textarea-styled:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
}

/* ========== MODAL ACTIONS ========== */
.modal-actions-styled {
    display: flex;
    gap: 12px;
    justify-content: flex-end;
    margin-top: 28px;
}

.btn-modal-styled {
    padding: 11px 24px;
    border: none;
    border-radius: 10px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    display: flex;
    align-items: center;
    gap: 8px;
}

.btn-modal-styled svg {
    width: 16px;
    height: 16px;
}

.btn-cancel-styled {
    background: var(--body-bg);
    color: var(--text-primary);
    border: 1.5px solid var(--card-border);
}

.btn-cancel-styled:hover {
    background: var(--card-border);
    transform: translateY(-2px);
}

.btn-save-styled {
    background: var(--primary);
    color: #ffffff;
    box-shadow: 0 2px 8px rgba(99, 102, 241, 0.25);
}

.btn-save-styled:hover {
    background: #4f46e5;
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(99, 102, 241, 0.35);
}

.btn-modal-styled:active {
    transform: translateY(0);
}

/* ========== RESPONSIVE DESIGN ========== */
@media (max-width: 768px) {
    .reminders-header-section {
        flex-direction: column;
        align-items: flex-start;
        gap: 16px;
    }

    .btn-set-reminder-styled {
        width: 100%;
        justify-content: center;
    }

    .modal-content-styled {
        padding: 24px;
    }

    .modal-header-styled {
        font-size: 18px;
    }

    .modal-actions-styled {
        flex-direction: column;
    }

    .btn-modal-styled {
        width: 100%;
        justify-content: center;
    }

    .reminders-table-container {
        border-radius: 0;
        margin: 0 -16px;
    }
}

@media (max-width: 640px) {
    .reminders-table-styled {
        font-size: 13px;
    }

    .reminders-table-styled thead th,
    .reminders-table-styled tbody td {
        padding: 10px 12px;
    }

    .empty-reminders-styled {
        padding: 40px 20px;
    }

    .empty-reminders-icon {
        width: 56px;
        height: 56px;
    }
}
</style>

<div class="reminders-wrapper">
    <!-- Reminders Header -->
    <div class="reminders-header-section">
        <div class="reminders-title-main">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"/>
            </svg>
            Ticket Reminders
        </div>
        <button class="btn-set-reminder-styled" onclick="openReminderModal()">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4"/>
            </svg>
            Set Reminder
        </button>
    </div>

    <!-- Reminders Table -->
    <div class="reminders-table-container" id="remindersTableWrapper">
        <table class="reminders-table-styled" id="remindersTable">
            <thead>
                <tr>
                    <th>Description</th>
                    <th>Date</th>
                    <th>Remind</th>
                    <th>Notified?</th>
                    <th style="width: 80px;">Actions</th>
                </tr>
            </thead>
            <tbody id="remindersTableBody">
                <!-- Data loaded via AJAX -->
            </tbody>
        </table>
    </div>

    <!-- Empty State -->
    <div id="emptyReminders" class="empty-reminders-styled" style="display: none;">
        <svg class="empty-reminders-icon" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"/>
        </svg>
        <div class="empty-reminders-title">No reminders found</div>
        <div class="empty-reminders-subtitle">Set a reminder to get notified about this ticket</div>
    </div>
</div>

<!-- Reminder Modal -->
<div id="reminderModal" class="modal-overlay-styled">
    <div class="modal-content-styled">
        <div class="modal-header-styled">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"/>
            </svg>
            Set Ticket Reminder
        </div>
        
        <form id="reminderForm" onsubmit="submitReminder(event)">
            <div class="form-group-styled">
                <label class="form-label-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                    </svg>
                    Description
                </label>
                <textarea id="reminderDescription" 
                          name="description" 
                          class="form-textarea-styled" 
                          placeholder="What should we remind you about?"
                          required></textarea>
            </div>
            
            <div class="form-group-styled">
                <label class="form-label-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                    </svg>
                    Remind At
                </label>
                <input type="datetime-local" 
                       id="reminderDate" 
                       name="remind_at" 
                       class="form-input-styled" 
                       required>
            </div>
            
            <div class="modal-actions-styled">
                <button type="button" class="btn-modal-styled btn-cancel-styled" onclick="closeReminderModal()">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                    Cancel
                </button>
                <button type="submit" class="btn-modal-styled btn-save-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/>
                    </svg>
                    Set Reminder
                </button>
            </div>
        </form>
    </div>
</div>

<script>
$(document).ready(function() {
    loadReminders();
    
    // Set minimum datetime to now
    const now = new Date();
    now.setMinutes(now.getMinutes() - now.getTimezoneOffset());
    $('#reminderDate').attr('min', now.toISOString().slice(0, 16));
});

function loadReminders() {
    $.ajax({
        url: '{{ route("admin.support.tickets.reminders.data", $ticket->id) }}',
        type: 'GET',
        success: function(response) {
            if (response.data) {
                renderReminders(response.data);
            }
        },
        error: function() {
            console.error('Error loading reminders');
        }
    });
}

function renderReminders(reminders) {
    const tbody = $('#remindersTableBody');
    const wrapper = $('#remindersTableWrapper');
    const emptyState = $('#emptyReminders');
    
    tbody.empty();
    
    if (reminders.length === 0) {
        wrapper.hide();
        emptyState.show();
        return;
    }
    
    wrapper.show();
    emptyState.hide();
    
    reminders.forEach(reminder => {
        const notifiedIcon = reminder.is_notified 
            ? '<svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/></svg>'
            : '<svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>';
        
        const row = `
            <tr>
                <td>${escapeHtml(reminder.description)}</td>
                <td>${reminder.remind_at}</td>
                <td>${reminder.staff_name || 'N/A'}</td>
                <td>
                    <span class="notified-badge-styled ${reminder.is_notified ? 'notified-yes-styled' : 'notified-no-styled'}">
                        ${notifiedIcon}
                        ${reminder.is_notified ? 'Yes' : 'No'}
                    </span>
                </td>
                <td>
                    <button onclick="deleteReminder(${reminder.id})" 
                            class="btn-delete-reminder"
                            title="Delete reminder">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                        </svg>
                    </button>
                </td>
            </tr>
        `;
        tbody.append(row);
    });
}

function openReminderModal() {
    $('#reminderModal').addClass('active');
    $('#reminderForm')[0].reset();
}

function closeReminderModal() {
    $('#reminderModal').removeClass('active');
}

function submitReminder(event) {
    event.preventDefault();
    
    showLoading();
    
    const formData = {
        _token: '{{ csrf_token() }}',
        description: $('#reminderDescription').val(),
        remind_at: $('#reminderDate').val()
    };
    
    $.ajax({
        url: '{{ route("admin.support.tickets.reminders.store", $ticket->id) }}',
        type: 'POST',
        data: formData,
        success: function(response) {
            hideLoading();
            if (response.success) {
                closeReminderModal();
                loadReminders();
                showToast(response.message || 'Reminder set successfully', 'success');
            } else {
                showToast(response.message || 'Error setting reminder', 'error');
            }
        },
        error: function(xhr) {
            hideLoading();
            showToast('Error setting reminder: ' + (xhr.responseJSON?.message || 'Unknown error'), 'error');
        }
    });
}

function deleteReminder(reminderId) {
    if (!confirm('Are you sure you want to delete this reminder?')) return;
    
    showLoading();
    
    $.ajax({
        url: '{{ route("admin.support.tickets.reminders.destroy", [$ticket->id, ":reminderId"]) }}'.replace(':reminderId', reminderId),
        type: 'DELETE',
        data: {
            _token: '{{ csrf_token() }}'
        },
        success: function(response) {
            hideLoading();
            if (response.success) {
                loadReminders();
                showToast('Reminder deleted successfully', 'success');
            } else {
                showToast(response.message || 'Error deleting reminder', 'error');
            }
        },
        error: function(xhr) {
            hideLoading();
            showToast('Error deleting reminder: ' + (xhr.responseJSON?.message || 'Unknown error'), 'error');
        }
    });
}

function escapeHtml(text) {
    const map = {
        '&': '&amp;',
        '<': '&lt;',
        '>': '&gt;',
        '"': '&quot;',
        "'": '&#039;'
    };
    return text.replace(/[&<>"']/g, m => map[m]);
}
</script>