<style>
/* ========== REPLY FORM - ECHOPX COMPLIANT ========== */

.reply-form-wrapper {
    padding: 0;
}

@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes fileSlideIn {
    from { opacity: 0; transform: translateX(-20px); }
    to { opacity: 1; transform: translateX(0); }
}

/* ========== SECTION HEADERS ========== */
.reply-section-header {
    display: flex;
    align-items: center;
    gap: 10px;
    font-size: 16px;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 16px;
    padding-bottom: 12px;
    border-bottom: 2px solid var(--card-border);
}

.reply-section-header svg {
    width: 18px;
    height: 18px;
    color: var(--primary);
    flex-shrink: 0;
}

.reply-section-label {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 12px;
}

.reply-section-label svg {
    width: 16px;
    height: 16px;
    color: var(--text-secondary);
    flex-shrink: 0;
}

/* ========== PREDEFINED REPLIES ========== */
.predefined-wrapper {
    margin-bottom: 24px;
}

.predefined-select-styled {
    width: 100%;
    padding: 12px 40px 12px 16px;
    border: 1.5px solid var(--card-border);
    border-radius: 12px;
    font-size: 14px;
    background: var(--card-bg);
    color: var(--text-primary);
    cursor: pointer;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    appearance: none;
    background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' viewBox='0 0 12 12'%3E%3Cpath fill='%236b7280' d='M6 9L1 4h10L6 9z'/%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: right 16px center;
    background-size: 12px;
}

.predefined-select-styled:hover {
    border-color: var(--primary);
}

.predefined-select-styled:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
}

/* ========== RICH TEXT EDITOR ========== */
.editor-container-styled {
    border: 1.5px solid var(--card-border);
    border-radius: 12px;
    overflow: hidden;
    margin-bottom: 24px;
    background: var(--card-bg);
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.editor-container-styled:focus-within {
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
}

.editor-toolbar-styled {
    background: var(--body-bg);
    padding: 12px;
    border-bottom: 1.5px solid var(--card-border);
    display: flex;
    gap: 6px;
    flex-wrap: wrap;
}

.editor-btn-styled {
    padding: 8px 14px;
    border: 1px solid var(--card-border);
    background: var(--card-bg);
    border-radius: 8px;
    cursor: pointer;
    font-size: 13px;
    font-weight: 600;
    color: var(--text-primary);
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    display: flex;
    align-items: center;
    gap: 6px;
    line-height: 1;
    min-height: 36px;
}

.editor-btn-styled svg {
    width: 14px;
    height: 14px;
}

.editor-btn-styled:hover {
    background: var(--primary);
    color: #ffffff;
    border-color: var(--primary);
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(99, 102, 241, 0.3);
}

.editor-btn-styled:active {
    transform: translateY(0);
}

.editor-content-styled {
    padding: 16px;
    min-height: 200px;
    font-size: 14px;
    color: var(--text-primary);
    outline: none;
    background: var(--card-bg);
    line-height: 1.7;
}

.editor-content-styled:empty::before {
    content: 'Type your reply here...';
    color: var(--text-muted);
}

/* ========== FILE ATTACHMENTS ========== */
.attachments-wrapper {
    margin-bottom: 24px;
}

.file-upload-styled {
    border: 2px dashed var(--card-border);
    border-radius: 12px;
    padding: 32px 24px;
    text-align: center;
    cursor: pointer;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    background: var(--body-bg);
}

.file-upload-styled:hover {
    border-color: var(--primary);
    background: rgba(99, 102, 241, 0.05);
    transform: translateY(-3px);
    box-shadow: 0 4px 16px rgba(99, 102, 241, 0.15);
}

.file-upload-icon {
    width: 48px;
    height: 48px;
    margin: 0 auto 14px;
    color: var(--primary);
    opacity: 0.7;
}

.file-upload-text {
    font-size: 14px;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 6px;
}

.file-upload-hint {
    font-size: 12px;
    color: var(--text-secondary);
}

.uploaded-files-list {
    margin-top: 16px;
}

.uploaded-file-styled {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 12px 16px;
    background: var(--body-bg);
    border: 1px solid var(--card-border);
    border-radius: 10px;
    margin-bottom: 10px;
    animation: fileSlideIn 300ms cubic-bezier(0.4, 0, 0.2, 1);
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.uploaded-file-styled:hover {
    border-color: var(--primary);
    transform: translateX(4px);
}

.file-info-styled {
    display: flex;
    align-items: center;
    gap: 12px;
    flex: 1;
    min-width: 0;
}

.file-info-styled svg {
    width: 20px;
    height: 20px;
    color: var(--primary);
    flex-shrink: 0;
}

.file-name-styled {
    font-size: 14px;
    font-weight: 600;
    color: var(--text-primary);
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

.file-remove-btn {
    background: rgba(239, 68, 68, 0.12);
    border: none;
    color: var(--danger);
    cursor: pointer;
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 8px;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    flex-shrink: 0;
}

.file-remove-btn svg {
    width: 16px;
    height: 16px;
}

.file-remove-btn:hover {
    background: var(--danger);
    color: #ffffff;
    transform: scale(1.1);
}

/* ========== CC SECTION ========== */
.cc-wrapper {
    margin-bottom: 24px;
}

.cc-input-styled {
    width: 100%;
    padding: 12px 16px;
    border: 1.5px solid var(--card-border);
    border-radius: 12px;
    font-size: 14px;
    background: var(--card-bg);
    color: var(--text-primary);
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    line-height: 1.5;
}

.cc-input-styled::placeholder {
    color: var(--text-muted);
}

.cc-input-styled:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
}

.cc-hint {
    display: flex;
    align-items: center;
    gap: 6px;
    font-size: 12px;
    color: var(--text-secondary);
    margin-top: 8px;
}

.cc-hint svg {
    width: 12px;
    height: 12px;
    flex-shrink: 0;
}

/* ========== OPTIONS SECTION ========== */
.options-wrapper {
    display: flex;
    flex-direction: column;
    gap: 14px;
    margin-bottom: 28px;
}

.checkbox-option-styled {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 14px 16px;
    background: var(--body-bg);
    border-radius: 12px;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    border: 2px solid transparent;
    cursor: pointer;
}

.checkbox-option-styled:hover {
    background: rgba(99, 102, 241, 0.05);
    border-color: var(--primary);
}

.checkbox-option-styled input[type="checkbox"] {
    width: 20px;
    height: 20px;
    cursor: pointer;
    accent-color: var(--primary);
    flex-shrink: 0;
}

.checkbox-option-styled label {
    font-size: 14px;
    font-weight: 600;
    color: var(--text-primary);
    cursor: pointer;
    user-select: none;
    line-height: 1.4;
}

/* ========== FORM ACTIONS ========== */
.reply-actions-styled {
    display: flex;
    justify-content: flex-end;
    align-items: center;
    padding-top: 24px;
    border-top: 2px solid var(--card-border);
}

.status-change-wrapper {
    display: flex;
    align-items: center;
    gap: 14px;
}

.status-label-styled {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    font-weight: 600;
    color: var(--text-primary);
}

.status-label-styled svg {
    width: 16px;
    height: 16px;
    color: var(--text-secondary);
}

.status-select-styled {
    padding: 10px 36px 10px 14px;
    border: 1.5px solid var(--card-border);
    border-radius: 10px;
    font-size: 13px;
    font-weight: 600;
    background: var(--card-bg);
    color: var(--text-primary);
    cursor: pointer;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    appearance: none;
    background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' viewBox='0 0 12 12'%3E%3Cpath fill='%236b7280' d='M6 9L1 4h10L6 9z'/%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: right 12px center;
    background-size: 12px;
}

.status-select-styled:hover {
    border-color: var(--primary);
}

.status-select-styled:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
}

.btn-submit-styled {
    padding: 12px 28px;
    background: var(--primary);
    color: #ffffff;
    border: none;
    border-radius: 12px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 10px;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    box-shadow: 0 2px 8px rgba(99, 102, 241, 0.25);
}

.btn-submit-styled svg {
    width: 16px;
    height: 16px;
}

.btn-submit-styled:hover {
    background: #4f46e5;
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(99, 102, 241, 0.35);
}

.btn-submit-styled:active {
    transform: translateY(0);
}

/* ========== RESPONSIVE DESIGN ========== */
@media (max-width: 768px) {
    .reply-section-header {
        font-size: 15px;
    }

    .editor-toolbar-styled {
        gap: 4px;
    }

    .editor-btn-styled {
        padding: 7px 12px;
        font-size: 12px;
        min-height: 32px;
    }

    .reply-actions-styled {
        flex-direction: column;
        gap: 16px;
        align-items: stretch;
    }

    .status-change-wrapper {
        width: 100%;
        justify-content: space-between;
    }

    .btn-submit-styled {
        width: 100%;
        justify-content: center;
    }

    .checkbox-option-styled label {
        font-size: 13px;
    }
}

@media (max-width: 640px) {
    .file-upload-styled {
        padding: 24px 20px;
    }

    .file-upload-icon {
        width: 40px;
        height: 40px;
    }

    .editor-content-styled {
        min-height: 160px;
    }
}
</style>

<div class="reply-form-wrapper">
    <form id="replyForm" onsubmit="submitReply(event)">
        <!-- Predefined Replies Section -->
        <div class="predefined-wrapper">
            <label class="reply-section-label">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16M4 18h7"/>
                </svg>
                Quick Replies
            </label>
            <select class="predefined-select-styled" id="predefinedReply" onchange="insertPredefinedReply()">
                <option value="">Insert predefined reply</option>
                @foreach($predefinedReplies ?? [] as $reply)
                <option value="{{ $reply->id }}" data-message="{{ $reply->message }}">
                    {{ $reply->name }}
                </option>
                @endforeach
            </select>
        </div>

        <!-- Rich Text Editor Section -->
        <div class="predefined-wrapper">
            <label class="reply-section-label">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                </svg>
                Reply Message
            </label>
            <div class="editor-container-styled">
                <div class="editor-toolbar-styled">
                    <button type="button" class="editor-btn-styled" onclick="execCmd('bold')" title="Bold">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M6 4h8a4 4 0 014 4 4 4 0 01-4 4H6z"/>
                            <path stroke-linecap="round" stroke-linejoin="round" d="M6 12h9a4 4 0 014 4 4 4 0 01-4 4H6z"/>
                        </svg>
                    </button>
                    <button type="button" class="editor-btn-styled" onclick="execCmd('italic')" title="Italic">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M10 4h4m-4 16h4M8 4l-2 16m10-16l2 16"/>
                        </svg>
                    </button>
                    <button type="button" class="editor-btn-styled" onclick="execCmd('underline')" title="Underline">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M17 8V4m0 0H7m10 0c0 6.627-5.373 12-12 12m12-12v4M7 4v8a5 5 0 0010 0V4"/>
                        </svg>
                    </button>
                    <button type="button" class="editor-btn-styled" onclick="execCmd('insertUnorderedList')" title="Bullet List">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16M4 18h16"/>
                        </svg>
                    </button>
                    <button type="button" class="editor-btn-styled" onclick="execCmd('insertOrderedList')" title="Numbered List">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M3 4h13M3 8h9m-9 4h9m5-4v12m0 0l-4-4m4 4l4-4"/>
                        </svg>
                    </button>
                    <button type="button" class="editor-btn-styled" onclick="execCmd('createLink')" title="Insert Link">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"/>
                        </svg>
                    </button>
                </div>
                <div id="replyEditor" class="editor-content-styled" contenteditable="true"></div>
            </div>
        </div>

        <!-- Hidden textarea for form submission -->
        <textarea id="replyMessage" name="message" style="display: none;"></textarea>

        <!-- File Attachments Section -->
        <div class="attachments-wrapper">
            <label class="reply-section-label">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"/>
                </svg>
                Attachments
            </label>
            <div class="file-upload-styled" onclick="document.getElementById('replyAttachments').click()">
                <svg class="file-upload-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"/>
                </svg>
                <div class="file-upload-text">Click to upload files</div>
                <div class="file-upload-hint">PDF, DOC, Images (Max 10MB per file)</div>
                <input type="file" id="replyAttachments" name="attachments[]" multiple style="display: none;" onchange="handleReplyFiles(this)">
            </div>
            <div id="replyUploadedFiles" class="uploaded-files-list"></div>
        </div>

        <!-- CC Section -->
        <div class="cc-wrapper">
            <label class="reply-section-label">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                </svg>
                CC
            </label>
            <input type="text" 
                   id="cc" 
                   name="cc" 
                   class="cc-input-styled" 
                   placeholder="Additional email addresses (comma-separated)">
            <div class="cc-hint">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                Separate multiple emails with commas
            </div>
        </div>

        <!-- Options Section -->
        <div class="options-wrapper">
            <div class="checkbox-option-styled">
                <input type="checkbox" id="assignToMe" name="assign_to_me">
                <label for="assignToMe">Assign this ticket to me automatically</label>
            </div>
            <div class="checkbox-option-styled">
                <input type="checkbox" id="returnToList" name="return_to_list" checked>
                <label for="returnToList">Return to ticket list after response is submitted</label>
            </div>
        </div>

        <!-- Form Actions -->
        <div class="reply-actions-styled">
            {{-- <div class="status-change-wrapper">
                <span class="status-label-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    Ticket Status
                </span>
                <select id="statusChange" name="status_id" class="status-select-styled">
                    @foreach($statuses ?? [] as $status)
                    <option value="{{ $status->id }}" {{ $ticket->status_id == $status->id ? 'selected' : '' }}>
                        {{ $status->name }}
                    </option>
                    @endforeach
                </select>
            </div> --}}
            <button type="submit" class="btn-submit-styled">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"/>
                </svg>
                Add Response
            </button>
        </div>
    </form>
</div>

<script>
function insertPredefinedReply() {
    const select = $('#predefinedReply');
    const selectedOption = select.find('option:selected');
    const message = selectedOption.data('message');
    
    if (message) {
        $('#replyEditor').html(message);
        select.val('');
    }
}

function execCmd(command) {
    if (command === 'createLink') {
        const url = prompt('Enter URL:');
        if (url) {
            document.execCommand(command, false, url);
        }
    } else {
        document.execCommand(command, false, null);
    }
    $('#replyEditor').focus();
}

function handleReplyFiles(input) {
    const files = input.files;
    const container = $('#replyUploadedFiles');
    container.empty();

    Array.from(files).forEach((file, index) => {
        const fileItem = `
            <div class="uploaded-file-styled">
                <div class="file-info-styled">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                    </svg>
                    <span class="file-name-styled">${file.name}</span>
                </div>
                <button type="button" onclick="removeReplyFile(${index})" class="file-remove-btn" title="Remove file">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                </button>
            </div>
        `;
        container.append(fileItem);
    });
}

function removeReplyFile(index) {
    const input = document.getElementById('replyAttachments');
    const dt = new DataTransfer();
    
    Array.from(input.files).forEach((file, i) => {
        if (i !== index) dt.items.add(file);
    });
    
    input.files = dt.files;
    handleReplyFiles(input);
}

function submitReply(event) {
    event.preventDefault();
    
    const message = $('#replyEditor').html();
    if (!message || message.trim() === '') {
        showToast('Please enter a reply message', 'error');
        return;
    }
    
    $('#replyMessage').val(message);
    
    showLoading();
    
    const formData = new FormData($('#replyForm')[0]);
    
    $.ajax({
        url: '{{ route("admin.support.tickets.reply", $ticket->id) }}',
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        success: function(response) {
            hideLoading();
            if (response.success) {
                showToast(response.message || 'Reply added successfully', 'success');
                
                setTimeout(function() {
                    if ($('#returnToList').is(':checked')) {
                        window.location.href = '{{ route("admin.support.tickets.index") }}';
                    } else {
                        location.reload();
                    }
                }, 1000);
            } else {
                showToast(response.message || 'Error adding reply', 'error');
            }
        },
        error: function(xhr) {
            hideLoading();
            showToast('Error adding reply: ' + (xhr.responseJSON?.message || 'Unknown error'), 'error');
        }
    });
}
</script>