<style>
/* ========== TICKET SIDEBAR - ECHOPX COMPLIANT ========== */

.sidebar-card-redesign {
    background: var(--card-bg);
    padding: 28px;
    border-radius: 16px;
    box-shadow: var(--shadow-sm);
    border: 1px solid var(--card-border);
    animation: fadeInUp 500ms cubic-bezier(0.4, 0, 0.2, 1) 150ms backwards;
}

@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

/* ========== SIDEBAR HEADER ========== */
.sidebar-header-redesign {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 28px;
    padding-bottom: 20px;
    border-bottom: 2px solid var(--card-border);
}

.sidebar-title-redesign {
    font-size: 18px;
    font-weight: 700;
    color: var(--text-primary);
    display: flex;
    align-items: center;
    gap: 10px;
    line-height: 1.2;
}

.sidebar-title-redesign svg {
    width: 20px;
    height: 20px;
    color: var(--primary);
    flex-shrink: 0;
}

.btn-save-sidebar {
    padding: 10px 20px;
    background: var(--primary);
    color: #ffffff;
    border: none;
    border-radius: 10px;
    font-size: 13px;
    font-weight: 600;
    cursor: pointer;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    display: flex;
    align-items: center;
    gap: 8px;
    box-shadow: 0 2px 8px rgba(99, 102, 241, 0.25);
}

.btn-save-sidebar svg {
    width: 14px;
    height: 14px;
}

.btn-save-sidebar:hover {
    background: #4f46e5;
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(99, 102, 241, 0.35);
}

.btn-save-sidebar:active {
    transform: translateY(0);
}

/* ========== FORM GROUPS ========== */
.sidebar-group-redesign {
    margin-bottom: 24px;
}

.sidebar-group-redesign:last-child {
    margin-bottom: 0;
}

.sidebar-label-redesign {
    display: flex;
    align-items: center;
    gap: 6px;
    font-size: 13px;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 10px;
    line-height: 1.2;
}

.sidebar-label-redesign svg {
    width: 14px;
    height: 14px;
    color: var(--text-secondary);
    flex-shrink: 0;
}

/* ========== FORM INPUTS ========== */
.sidebar-input-redesign,
.sidebar-select-redesign {
    width: 100%;
    padding: 11px 14px;
    border: 1.5px solid var(--card-border);
    border-radius: 10px;
    font-size: 14px;
    color: var(--text-primary);
    background: var(--card-bg);
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    line-height: 1.4;
}

.sidebar-input-redesign::placeholder {
    color: var(--text-muted);
}

.sidebar-input-redesign:focus,
.sidebar-select-redesign:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
}

.sidebar-input-redesign:disabled,
.sidebar-input-redesign:read-only {
    background: var(--body-bg);
    opacity: 0.7;
    cursor: not-allowed;
}

.sidebar-select-redesign {
    cursor: pointer;
    appearance: none;
    background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' viewBox='0 0 12 12'%3E%3Cpath fill='%236b7280' d='M6 9L1 4h10L6 9z'/%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: right 12px center;
    background-size: 12px;
    padding-right: 36px;
}

.sidebar-select-redesign:hover {
    border-color: var(--primary);
}

/* ========== DISPLAY VALUES ========== */
.sidebar-value-redesign {
    font-size: 14px;
    color: var(--text-primary);
    font-weight: 500;
    padding: 11px 14px;
    background: var(--body-bg);
    border-radius: 10px;
    border: 1.5px solid var(--card-border);
    line-height: 1.4;
}

/* ========== FORM HINTS ========== */
.sidebar-hint-redesign {
    font-size: 11px;
    color: var(--text-muted);
    display: flex;
    align-items: flex-start;
    gap: 6px;
    margin-top: 8px;
    line-height: 1.4;
}

.sidebar-hint-redesign svg {
    width: 12px;
    height: 12px;
    flex-shrink: 0;
    margin-top: 2px;
}

/* ========== SECTION DIVIDER ========== */
.sidebar-divider-redesign {
    height: 1px;
    background: var(--card-border);
    margin: 28px 0;
}

/* ========== RESPONSIVE ========== */
@media (max-width: 1024px) {
    .sidebar-card-redesign {
        padding: 24px;
    }

    .sidebar-header-redesign {
        margin-bottom: 24px;
        padding-bottom: 16px;
    }

    .sidebar-group-redesign {
        margin-bottom: 20px;
    }
}

@media (max-width: 768px) {
    .sidebar-title-redesign {
        font-size: 16px;
    }

    .btn-save-sidebar {
        padding: 9px 16px;
        font-size: 12px;
    }
}
</style>

<div class="sidebar-card-redesign">
    <!-- Sidebar Header -->
    <div class="sidebar-header-redesign">
        <div class="sidebar-title-redesign">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
            </svg>
            Ticket Information
        </div>
        <button type="button" class="btn-save-sidebar" onclick="saveTicketInfo()">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/>
            </svg>
            Save
        </button>
    </div>

    <form id="ticketInfoForm">
        <!-- Tags -->
        <div class="sidebar-group-redesign">
            <label class="sidebar-label-redesign">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/>
                </svg>
                Tags
            </label>
            <input type="text" 
                   id="tags" 
                   name="tags" 
                   class="sidebar-input-redesign" 
                   placeholder="Add tags..."
                   value="{{ $ticket->tags ?? '' }}">
        </div>

        <!-- Subject -->
        <div class="sidebar-group-redesign">
            <label class="sidebar-label-redesign">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z"/>
                </svg>
                Subject
            </label>
            <input type="text" 
                   id="subject" 
                   name="subject" 
                   class="sidebar-input-redesign" 
                   value="{{ $ticket->subject }}"
                   readonly>
        </div>

        <div class="sidebar-divider-redesign"></div>

        <!-- Contact -->
        <div class="sidebar-group-redesign">
            <label class="sidebar-label-redesign">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                </svg>
                Contact
            </label>
            <div class="sidebar-value-redesign">{{ $ticket->submitter_name }}</div>
        </div>

        <!-- Name -->
        <div class="sidebar-group-redesign">
            <label class="sidebar-label-redesign">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M5.121 17.804A13.937 13.937 0 0112 16c2.5 0 4.847.655 6.879 1.804M15 10a3 3 0 11-6 0 3 3 0 016 0z"/>
                </svg>
                Name
            </label>
            <input type="text" 
                   class="sidebar-input-redesign" 
                   value="{{ $ticket->name }}"
                   disabled>
        </div>

        <!-- Email -->
        <div class="sidebar-group-redesign">
            <label class="sidebar-label-redesign">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                </svg>
                Email Address
            </label>
            <input type="email" 
                   class="sidebar-input-redesign" 
                   value="{{ $ticket->email }}"
                   disabled>
        </div>

        <div class="sidebar-divider-redesign"></div>

        <!-- Department -->
        <div class="sidebar-group-redesign">
            <label class="sidebar-label-redesign">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                </svg>
                Department
            </label>
            <select id="department_id" name="department_id" class="sidebar-select-redesign">
                @foreach($departments ?? [] as $dept)
                <option value="{{ $dept->id }}" {{ $ticket->department_id == $dept->id ? 'selected' : '' }}>
                    {{ $dept->name }}
                </option>
                @endforeach
            </select>
        </div>

        <!-- Assign Ticket -->
        <div class="sidebar-group-redesign">
            <label class="sidebar-label-redesign">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                </svg>
                Assign Ticket
            </label>
            <select id="assigned_to" name="assigned_to" class="sidebar-select-redesign">
                <option value="">Unassigned</option>
                @foreach($staff ?? [] as $s)
                <option value="{{ $s->id }}" {{ $ticket->assigned_to == $s->id ? 'selected' : '' }}>
                    {{ $s->full_name }}
                </option>
                @endforeach
            </select>
            <div class="sidebar-hint-redesign">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                Default is current user if left unassigned
            </div>
        </div>

        <!-- Priority -->
        <div class="sidebar-group-redesign">
            <label class="sidebar-label-redesign">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                </svg>
                Priority
            </label>
            <select id="priority_id" name="priority_id" class="sidebar-select-redesign">
                @foreach($priorities ?? [] as $priority)
                <option value="{{ $priority->id }}" {{ $ticket->priority_id == $priority->id ? 'selected' : '' }}>
                    {{ $priority->name }}
                </option>
                @endforeach
            </select>
        </div>

        <!-- Status -->
        <div class="sidebar-group-redesign">
            <label class="sidebar-label-redesign">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                Status
            </label>
            <select id="status_id" name="status_id" class="sidebar-select-redesign">
                @foreach($statuses ?? [] as $status)
                <option value="{{ $status->id }}" {{ $ticket->status_id == $status->id ? 'selected' : '' }}>
                    {{ $status->name }}
                </option>
                @endforeach
            </select>
        </div>

        <div class="sidebar-divider-redesign"></div>

        <!-- CC -->
        <div class="sidebar-group-redesign">
            <label class="sidebar-label-redesign">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                </svg>
                CC
            </label>
            <input type="text" 
                   id="cc" 
                   name="cc" 
                   class="sidebar-input-redesign" 
                   placeholder="email1@example.com, email2@example.com"
                   value="{{ $ticket->cc ?? '' }}">
            <div class="sidebar-hint-redesign">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                Separate multiple emails with commas
            </div>
        </div>

        <!-- Merge Ticket # -->
        <div class="sidebar-group-redesign">
            <label class="sidebar-label-redesign">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4"/>
                </svg>
                Merge Ticket #
            </label>
            <input type="text" 
                   id="merge_ticket_id" 
                   name="merge_ticket_id" 
                   class="sidebar-input-redesign" 
                   placeholder="example: 5 or 5,6">
            <div class="sidebar-hint-redesign">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                Enter ticket ID(s) to merge into this ticket
            </div>
        </div>

        <div class="sidebar-divider-redesign"></div>

        <!-- Created At -->
        <div class="sidebar-group-redesign">
            <label class="sidebar-label-redesign">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4"/>
                </svg>
                Created At
            </label>
            <div class="sidebar-value-redesign">{{ $ticket->created_at->format('M d, Y g:i A') }}</div>
        </div>

        <!-- Last Updated -->
        <div class="sidebar-group-redesign">
            <label class="sidebar-label-redesign">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                </svg>
                Last Updated
            </label>
            <div class="sidebar-value-redesign">{{ $ticket->updated_at->format('M d, Y g:i A') }}</div>
        </div>

        @if($ticket->last_reply)
        <!-- Last Reply -->
        <div class="sidebar-group-redesign">
            <label class="sidebar-label-redesign">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                Last Reply
            </label>
            <div class="sidebar-value-redesign">{{ $ticket->last_reply_time }}</div>
        </div>
        @endif
    </form>
</div>

<script>
function saveTicketInfo() {
    showLoading();
    
    const formData = {
        _token: '{{ csrf_token() }}',
        tags: $('#tags').val(),
        department_id: $('#department_id').val(),
        assigned_to: $('#assigned_to').val(),
        priority_id: $('#priority_id').val(),
        status_id: $('#status_id').val(),
        cc: $('#cc').val(),
        merge_ticket_id: $('#merge_ticket_id').val()
    };
    
    $.ajax({
        url: '{{ route("admin.support.tickets.update-info", $ticket->id) }}',
        type: 'POST',
        data: formData,
        success: function(response) {
            hideLoading();
            if (response.success) {
                showToast(response.message || 'Ticket information updated successfully', 'success');
                setTimeout(function() {
                    location.reload();
                }, 1000);
            } else {
                showToast(response.message || 'Error updating ticket information', 'error');
            }
        },
        error: function(xhr) {
            hideLoading();
            showToast('Error updating ticket information: ' + (xhr.responseJSON?.message || 'Unknown error'), 'error');
        }
    });
}
</script>