<style>
/* ========== SUPPORT TICKET SHOW - ECHOPX COMPLIANT ========== */

.ticket-show-wrapper {
    padding: var(--space-xl);
    min-height: calc(100vh - 60px);
    animation: fadeInUp 500ms cubic-bezier(0.4, 0, 0.2, 1);
}

@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes slideDown {
    from { opacity: 0; transform: translateY(-20px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* ========== TICKET HEADER ========== */
.ticket-header-main {
    background: var(--card-bg);
    padding: 24px 28px;
    border-radius: 16px;
    margin-bottom: var(--space-xl);
    box-shadow: var(--shadow-sm);
    border: 1px solid var(--card-border);
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 24px;
    animation: slideDown 600ms cubic-bezier(0.4, 0, 0.2, 1);
    flex-wrap: wrap;
}

.ticket-header-left-section {
    flex: 1;
    min-width: 0;
}

.ticket-title-section {
    font-size: 22px;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 12px;
    display: flex;
    align-items: center;
    gap: 12px;
    flex-wrap: wrap;
    line-height: 1.3;
}

.ticket-number-display {
    color: var(--primary);
    font-family: 'Courier New', monospace;
    font-weight: 700;
    font-size: 18px;
    background: rgba(99, 102, 241, 0.1);
    padding: 6px 12px;
    border-radius: 8px;
    border: 1px solid rgba(99, 102, 241, 0.2);
}

/* ========== STATUS DROPDOWN - WHITE BG + COLORED TEXT/BORDER ========== */
.status-dropdown-container {
    position: relative;
    display: inline-block;
}

.status-select-main {
    padding: 8px 36px 8px 14px;
    border-radius: 8px;
    font-size: 13px;
    font-weight: 600;
    cursor: pointer;
    background: #ffffff !important;
    appearance: none;
    -webkit-appearance: none;
    -moz-appearance: none;
    background-repeat: no-repeat;
    background-position: right 12px center;
    background-size: 12px;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    outline: none;
    border-width: 2px;
    border-style: solid;
}

.status-select-main:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.12);
}

.status-select-main:focus {
    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.15);
}

.status-select-main:disabled {
    opacity: 0.65;
    cursor: not-allowed;
    transform: none;
}

.status-select-main option {
    background: #ffffff;
    color: #1f2937;
    padding: 10px 14px;
    font-weight: 600;
}

.ticket-meta-section {
    display: flex;
    gap: 24px;
    font-size: 13px;
    color: var(--text-secondary);
    flex-wrap: wrap;
}

.ticket-meta-item-main {
    display: flex;
    align-items: center;
    gap: 8px;
}

.ticket-meta-item-main svg {
    width: 16px;
    height: 16px;
    color: var(--text-muted);
    flex-shrink: 0;
}

.ticket-header-actions-section {
    display: flex;
    gap: 12px;
}

.btn-icon-header {
    width: 42px;
    height: 42px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    border: none;
    cursor: pointer;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.btn-icon-header svg {
    width: 18px;
    height: 18px;
}

.btn-link-action {
    background: rgba(59, 130, 246, 0.12);
    color: var(--primary);
    border: 1px solid rgba(59, 130, 246, 0.2);
}

.btn-link-action:hover {
    background: var(--primary);
    color: #ffffff;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
}

.btn-delete-action {
    background: rgba(239, 68, 68, 0.12);
    color: var(--danger);
    border: 1px solid rgba(239, 68, 68, 0.2);
}

.btn-delete-action:hover {
    background: var(--danger);
    color: #ffffff;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(239, 68, 68, 0.3);
}

/* ========== MAIN LAYOUT ========== */
.ticket-main-layout-grid {
    display: grid;
    grid-template-columns: 1fr 380px;
    gap: 24px;
    animation: fadeInUp 500ms cubic-bezier(0.4, 0, 0.2, 1) 100ms backwards;
}

/* ========== LEFT COLUMN - CONTENT ========== */
.ticket-content-section {
    display: flex;
    flex-direction: column;
    gap: 24px;
}

/* ========== TAB NAVIGATION ========== */
.tab-navigation-main {
    background: var(--card-bg);
    padding: 18px 24px;
    border-radius: 16px;
    box-shadow: var(--shadow-sm);
    border: 1px solid var(--card-border);
    display: flex;
    gap: 12px;
    flex-wrap: wrap;
}

.tab-button-main {
    padding: 11px 20px;
    border: none;
    background: transparent;
    color: var(--text-secondary);
    font-size: 14px;
    font-weight: 600;
    border-radius: 10px;
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 8px;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.tab-button-main svg {
    width: 16px;
    height: 16px;
}

.tab-button-main:hover {
    background: var(--body-bg);
    color: var(--text-primary);
    transform: translateY(-2px);
}

.tab-button-main.active {
    background: var(--primary);
    color: #ffffff;
    box-shadow: 0 4px 12px rgba(99, 102, 241, 0.3);
}

/* ========== TAB CONTENT CARD ========== */
.tab-content-card-main {
    background: var(--card-bg);
    padding: 32px;
    border-radius: 16px;
    box-shadow: var(--shadow-sm);
    border: 1px solid var(--card-border);
}

.tab-panel-main {
    display: none;
}

.tab-panel-main.active {
    display: block;
}

/* ========== HISTORY SECTION ========== */
.history-section-main {
    background: var(--card-bg);
    padding: 32px;
    border-radius: 16px;
    box-shadow: var(--shadow-sm);
    border: 1px solid var(--card-border);
}

.history-header-main {
    font-size: 20px;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 24px;
    display: flex;
    align-items: center;
    gap: 12px;
}

.history-header-main svg {
    width: 22px;
    height: 22px;
    color: var(--primary);
}

.history-item-main {
    padding: 24px;
    background: var(--body-bg);
    border-radius: 12px;
    margin-bottom: 18px;
    border-left: 4px solid transparent;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.history-item-main:hover {
    transform: translateX(4px);
    box-shadow: var(--shadow-sm);
}

.history-item-main.staff-reply {
    border-left-color: var(--primary);
}

.history-item-main.customer-reply {
    border-left-color: var(--success);
}

.history-meta-main {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 14px;
}

.history-author-main {
    font-weight: 600;
    color: var(--text-primary);
    display: flex;
    align-items: center;
    gap: 10px;
}

.author-badge-main {
    padding: 4px 10px;
    border-radius: 6px;
    font-size: 10px;
    font-weight: 700;
    text-transform: uppercase;
    background: var(--primary);
    color: #ffffff;
    letter-spacing: 0.05em;
}

.history-time-main {
    font-size: 12px;
    color: var(--text-secondary);
    display: flex;
    align-items: center;
    gap: 6px;
}

.history-time-main svg {
    width: 14px;
    height: 14px;
}

.history-message-main {
    font-size: 14px;
    color: var(--text-primary);
    line-height: 1.7;
    margin-bottom: 14px;
}

.history-attachments-main {
    display: flex;
    flex-wrap: wrap;
    gap: 12px;
}

.attachment-item-main {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 10px 14px;
    background: var(--card-bg);
    border-radius: 8px;
    border: 1px solid var(--card-border);
    font-size: 13px;
    color: var(--text-primary);
    text-decoration: none;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.attachment-item-main:hover {
    background: var(--body-bg);
    transform: translateY(-2px);
    box-shadow: var(--shadow-sm);
}

.attachment-item-main svg {
    width: 16px;
    height: 16px;
    color: var(--primary);
}

/* ========== RIGHT COLUMN - SIDEBAR ========== */
.ticket-sidebar-main {
    position: sticky;
    top: 24px;
    height: fit-content;
}

.sidebar-card-main {
    background: var(--card-bg);
    padding: 28px;
    border-radius: 16px;
    box-shadow: var(--shadow-sm);
    border: 1px solid var(--card-border);
}

.sidebar-header-main {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 24px;
    padding-bottom: 18px;
    border-bottom: 2px solid var(--card-border);
}

.sidebar-title-main {
    font-size: 18px;
    font-weight: 700;
    color: var(--text-primary);
    display: flex;
    align-items: center;
    gap: 10px;
}

.sidebar-title-main svg {
    width: 20px;
    height: 20px;
    color: var(--primary);
}

.btn-save-main {
    padding: 10px 18px;
    background: var(--primary);
    color: #ffffff;
    border: none;
    border-radius: 10px;
    font-size: 13px;
    font-weight: 600;
    cursor: pointer;
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
    display: flex;
    align-items: center;
    gap: 6px;
}

.btn-save-main svg {
    width: 14px;
    height: 14px;
}

.btn-save-main:hover {
    background: #4f46e5;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(99, 102, 241, 0.3);
}

.sidebar-group-main {
    margin-bottom: 24px;
}

.sidebar-label-main {
    display: flex;
    align-items: center;
    gap: 6px;
    font-size: 13px;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 10px;
}

.sidebar-label-main svg {
    width: 14px;
    height: 14px;
    color: var(--text-secondary);
}

.sidebar-input-main,
.sidebar-select-main {
    width: 100%;
    padding: 11px 14px;
    border: 1.5px solid var(--card-border);
    border-radius: 10px;
    font-size: 13px;
    color: var(--text-primary);
    background: var(--card-bg);
    transition: all 300ms cubic-bezier(0.4, 0, 0.2, 1);
}

.sidebar-input-main:focus,
.sidebar-select-main:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
}

.sidebar-input-main:disabled {
    background: var(--body-bg);
    opacity: 0.65;
    cursor: not-allowed;
}

.sidebar-value-main {
    font-size: 14px;
    color: var(--text-primary);
    font-weight: 500;
    padding: 11px 14px;
    background: var(--body-bg);
    border-radius: 10px;
}

/* ========== LOADING OVERLAY ========== */
.loading-overlay-show {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.65);
    backdrop-filter: blur(8px);
    z-index: 9999;
    align-items: center;
    justify-content: center;
}

.loading-overlay-show.active {
    display: flex;
}

.loading-spinner-show {
    width: 60px;
    height: 60px;
    border: 6px solid rgba(255, 255, 255, 0.2);
    border-top: 6px solid var(--primary);
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

/* ========== RESPONSIVE DESIGN ========== */
@media (max-width: 1024px) {
    .ticket-main-layout-grid {
        grid-template-columns: 1fr;
    }

    .ticket-sidebar-main {
        position: relative;
        top: 0;
    }
}

@media (max-width: 768px) {
    .ticket-show-wrapper {
        padding: var(--space-lg);
    }

    .ticket-header-main {
        padding: 20px 24px;
        flex-direction: column;
        align-items: flex-start;
    }

    .ticket-title-section {
        font-size: 18px;
    }

    .ticket-number-display {
        font-size: 16px;
    }

    .ticket-header-actions-section {
        width: 100%;
        justify-content: flex-end;
    }

    .tab-navigation-main {
        overflow-x: auto;
        flex-wrap: nowrap;
        padding: 16px 20px;
    }

    .tab-button-main {
        flex-shrink: 0;
    }

    .tab-content-card-main,
    .history-section-main,
    .sidebar-card-main {
        padding: 24px;
    }
}

@media (max-width: 640px) {
    .ticket-meta-section {
        flex-direction: column;
        gap: 12px;
    }

    .ticket-header-actions-section {
        gap: 8px;
    }

    .btn-icon-header {
        width: 38px;
        height: 38px;
    }
}
</style>

<div class="ticket-show-wrapper">
    <!-- Ticket Header -->
    <div class="ticket-header-main">
        <div class="ticket-header-left-section">
            <div class="ticket-title-section">
                <span class="ticket-number-display">{{ $ticket->display_number }}</span>
                <span>{{ $ticket->subject }}</span>
                
                <!-- Merged Badge -->
                @if($ticket->is_merged)
                    <div>{!! $ticket->merged_badge !!}</div>
                @endif
                
                <!-- STATUS DROPDOWN -->
                <div class="status-dropdown-container">
                    <select id="statusDropdown" 
                            class="status-select-main" 
                            data-color="{{ $ticket->status->color }}"
                            style="color: {{ $ticket->status->color }} !important; border-color: {{ $ticket->status->color }} !important;"
                            onchange="changeStatusInstantly(this.value)"
                            {{ $ticket->is_merged ? 'disabled' : '' }}>
                        @foreach($statuses as $status)
                            <option value="{{ $status->id }}" 
                                    data-color="{{ $status->color }}"
                                    {{ $ticket->status_id == $status->id ? 'selected' : '' }}>
                                {{ $status->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="ticket-meta-section">
                <div class="ticket-meta-item-main">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                    </svg>
                    <span>{{ $ticket->submitter_name }}</span>
                </div>
                <div class="ticket-meta-item-main">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                    </svg>
                    <span>{{ $ticket->created_at->format('M d, Y g:i A') }}</span>
                </div>
                <div class="ticket-meta-item-main">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z"/>
                    </svg>
                    <span>{{ $ticket->replies_count }} Replies</span>
                </div>
            </div>
        </div>
        <div class="ticket-header-actions-section">
            <button class="btn-icon-header btn-link-action" onclick="copyTicketLink()" title="Copy Public Link">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"/>
                </svg>
            </button>
            <button class="btn-icon-header btn-delete-action" onclick="deleteTicket({{ $ticket->id }})" title="Delete Ticket">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                </svg>
            </button>
        </div>
    </div>

    <!-- Main Layout -->
    <div class="ticket-main-layout-grid">
        <!-- Left Column - Content -->
        <div class="ticket-content-section">
            <!-- Tab Navigation -->
            <div class="tab-navigation-main">
                <button class="tab-button-main active" onclick="switchTab('reply')" data-tab="reply">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 10h10a8 8 0 018 8v2M3 10l6 6m-6-6l6-6"/>
                    </svg>
                    Add Reply
                </button>
                <button class="tab-button-main" onclick="switchTab('notes')" data-tab="notes">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                    </svg>
                    Add Note
                </button>
                <button class="tab-button-main" onclick="switchTab('reminders')" data-tab="reminders">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"/>
                    </svg>
                    Reminders
                </button>
                <button class="tab-button-main" onclick="switchTab('other-tickets')" data-tab="other-tickets">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 5v2m0 4v2m0 4v2M5 5a2 2 0 00-2 2v3a2 2 0 110 4v3a2 2 0 002 2h14a2 2 0 002-2v-3a2 2 0 110-4V7a2 2 0 00-2-2H5z"/>
                    </svg>
                    Other Tickets
                </button>
            </div>

            <!-- Tab Content -->
            <div class="tab-content-card-main">
                <!-- Add Reply Tab -->
                <div id="reply-tab" class="tab-panel-main active">
                    @include('support::admin.tickets.partials._reply_form')
                </div>

                <!-- Add Note Tab -->
                <div id="notes-tab" class="tab-panel-main">
                    @include('support::admin.tickets.partials._notes')
                </div>

                <!-- Reminders Tab -->
                <div id="reminders-tab" class="tab-panel-main">
                    @include('support::admin.tickets.partials._reminders')
                </div>

                <!-- Other Tickets Tab -->
                <div id="other-tickets-tab" class="tab-panel-main">
                    @include('support::admin.tickets.partials._other_tickets')
                </div>
            </div>

            <!-- Request History -->
            <div class="history-section-main">
                <div class="history-header-main">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    Request History
                </div>
                @include('support::admin.tickets.partials._history')
            </div>
        </div>

        <!-- Right Column - Sidebar -->
        <div class="ticket-sidebar-main">
            @include('support::admin.tickets.partials._sidebar')
        </div>
    </div>
</div>

<!-- Loading Overlay -->
<div class="loading-overlay-show" id="loadingOverlay">
    <div class="loading-spinner-show"></div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
// Tab switching function
function switchTab(tabName) {
    $('.tab-button-main').removeClass('active');
    $(`.tab-button-main[data-tab="${tabName}"]`).addClass('active');
    $('.tab-panel-main').removeClass('active');
    $(`#${tabName}-tab`).addClass('active');
}

// Copy ticket link function
function copyTicketLink() {
    const url = '{{ route("client.support.view-by-key", $ticket->ticket_key) }}';
    navigator.clipboard.writeText(url).then(() => {
        showToast('Ticket link copied to clipboard!', 'success');
    }).catch(() => {
        alert('Ticket link: ' + url);
    });
}

// Delete ticket function
function deleteTicket(id) {
    if (!confirm('Are you sure you want to delete this ticket?')) return;

    showLoading();
    $.ajax({
        url: `{{ route('admin.support.tickets.destroy', ':id') }}`.replace(':id', id),
        type: 'DELETE',
        data: { _token: '{{ csrf_token() }}' },
        success: function(response) {
            hideLoading();
            showToast(response.message || 'Ticket deleted successfully', 'success');
            setTimeout(() => {
                window.location.href = '{{ route("admin.support.tickets.index") }}';
            }, 1000);
        },
        error: function() {
            hideLoading();
            showToast('Error deleting ticket', 'error');
        }
    });
}

// Show/hide loading overlay
function showLoading() {
    $('#loadingOverlay').addClass('active');
}

function hideLoading() {
    $('#loadingOverlay').removeClass('active');
}

/**
 * INSTANT STATUS CHANGE
 */
function changeStatusInstantly(statusId) {
    const dropdown = document.getElementById('statusDropdown');
    const selectedOption = dropdown.options[dropdown.selectedIndex];
    const newColor = selectedOption.getAttribute('data-color');
    const statusName = selectedOption.textContent.trim();
    
    const originalStatusId = '{{ $ticket->status_id }}';
    const originalColor = dropdown.getAttribute('data-color');
    
    dropdown.disabled = true;
    dropdown.style.opacity = '0.6';
    showLoading();
    
    $.ajax({
        url: '{{ route("admin.support.tickets.change-status", $ticket->id) }}',
        type: 'POST',
        data: {
            _token: '{{ csrf_token() }}',
            status_id: statusId
        },
        success: function(response) {
            hideLoading();
            dropdown.disabled = false;
            dropdown.style.opacity = '1';
            
            if (response.success) {
                dropdown.style.color = newColor;
                dropdown.style.borderColor = newColor;
                dropdown.setAttribute('data-color', newColor);
                
                setDropdownArrow(dropdown, newColor);
                
                showToast('Status updated to: ' + statusName, 'success');
                
                setTimeout(function() {
                    location.reload();
                }, 1000);
            } else {
                dropdown.value = originalStatusId;
                dropdown.style.color = originalColor;
                dropdown.style.borderColor = originalColor;
                showToast(response.message || 'Failed to update status', 'error');
            }
        },
        error: function(xhr) {
            hideLoading();
            dropdown.disabled = false;
            dropdown.style.opacity = '1';
            
            dropdown.value = originalStatusId;
            dropdown.style.color = originalColor;
            dropdown.style.borderColor = originalColor;
            
            const errorMessage = xhr.responseJSON?.message || 'Error updating status';
            showToast(errorMessage, 'error');
        }
    });
}

/**
 * Show toast notification
 */
function showToast(message, type) {
    const bgColor = type === 'success' ? '#22c55e' : 
                    type === 'error' ? '#ef4444' : 
                    type === 'warning' ? '#f59e0b' : '#3b82f6';
    
    const toast = $('<div>')
        .css({
            position: 'fixed',
            top: '24px',
            right: '24px',
            background: bgColor,
            color: '#ffffff',
            padding: '14px 24px',
            borderRadius: '12px',
            boxShadow: '0 8px 24px rgba(0, 0, 0, 0.2)',
            zIndex: '10000',
            fontSize: '14px',
            fontWeight: '600',
            opacity: '0',
            transform: 'translateX(400px)',
            transition: 'all 400ms cubic-bezier(0.4, 0, 0.2, 1)'
        })
        .text(message)
        .appendTo('body');
    
    setTimeout(() => {
        toast.css({ opacity: '1', transform: 'translateX(0)' });
    }, 10);
    
    setTimeout(() => {
        toast.css({ opacity: '0', transform: 'translateX(400px)' });
        setTimeout(() => toast.remove(), 400);
    }, 3000);
}

// Set colored arrow on page load
$(document).ready(function() {
    const dropdown = document.getElementById('statusDropdown');
    if (dropdown) {
        const color = dropdown.getAttribute('data-color');
        setDropdownArrow(dropdown, color);
    }
});

// Helper function to set arrow color
function setDropdownArrow(dropdown, color) {
    const hex = color.replace('#', '');
    const r = parseInt(hex.substr(0, 2), 16);
    const g = parseInt(hex.substr(2, 2), 16);
    const b = parseInt(hex.substr(4, 2), 16);
    
    const svg = `<svg xmlns='http://www.w3.org/2000/svg' width='12' height='12' viewBox='0 0 12 12'><path fill='rgb(${r},${g},${b})' d='M6 9L1 4h10L6 9z'/></svg>`;
    const encoded = 'data:image/svg+xml;base64,' + btoa(svg);
    
    dropdown.style.backgroundImage = `url("${encoded}")`;
}
</script>