<?php

use Illuminate\Support\Facades\Route;
use Modules\Support\Http\Controllers\DashboardController;
use Modules\Support\Http\Controllers\TicketController;
use Modules\Support\Http\Controllers\TicketNoteController;
use Modules\Support\Http\Controllers\TicketReminderController;
use Modules\Support\Http\Controllers\DepartmentController;
use Modules\Support\Http\Controllers\PriorityController;
use Modules\Support\Http\Controllers\StatusController;
use Modules\Support\Http\Controllers\PredefinedReplyController;
use Modules\Support\Http\Controllers\TicketClientController;
use App\Http\Middleware\EnsureIsAdmin;

/*
|--------------------------------------------------------------------------
| ADMIN ROUTES - Support Module
|--------------------------------------------------------------------------
*/

Route::prefix('admin/support')
    ->middleware(['web', EnsureIsAdmin::class])
    ->name('admin.support.')
    ->group(function () {
        
        // ============================================
        // DASHBOARD
        // ============================================
        Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
        Route::get('/stats', [DashboardController::class, 'getStats'])->name('stats');
        
        // ============================================
        // TICKETS MANAGEMENT
        // ============================================
        Route::prefix('tickets')->name('tickets.')->group(function () {
            // List tickets
            Route::get('/', [TicketController::class, 'index'])->name('index');
            
            // DataTable endpoint (AJAX)
            Route::get('/data', [TicketController::class, 'dataTable'])->name('data');
            
            // Create ticket (MUST come before /{id})
            Route::get('/create', [TicketController::class, 'create'])->name('create');
            Route::post('/', [TicketController::class, 'store'])->name('store');
            
            // Export tickets (MUST come before /{id})
            Route::get('/export', [TicketController::class, 'export'])->name('export');
            
            // Bulk actions (MUST come before /{id})
            Route::post('/bulk-delete', [TicketController::class, 'bulkDelete'])->name('bulk-delete');
            Route::post('/bulk-assign', [TicketController::class, 'bulkAssign'])->name('bulk-assign');
            Route::post('/bulk-change-status', [TicketController::class, 'bulkChangeStatus'])->name('bulk-change-status');
            Route::post('/bulk-change-priority', [TicketController::class, 'bulkChangePriority'])->name('bulk-change-priority');
            
            // Search helpers (MUST come before /{id})
            Route::get('/search-customers', [TicketController::class, 'searchCustomers'])->name('search-customers');
            Route::get('/search-staff', [TicketController::class, 'searchStaff'])->name('search-staff');
            Route::get('/get-customer-info/{customerId}', [TicketController::class, 'getCustomerInfo'])->name('get-customer-info');
            
            // Download attachment (MUST come before /{id})
            Route::get('/download/{attachmentId}', [TicketController::class, 'downloadAttachment'])->name('download');
            
            // View ticket details
            Route::get('/{id}', [TicketController::class, 'show'])->name('show');
            
            // Edit ticket
            Route::get('/{id}/edit', [TicketController::class, 'edit'])->name('edit');
            Route::put('/{id}', [TicketController::class, 'update'])->name('update');
            
            // Delete ticket
            Route::delete('/{id}', [TicketController::class, 'destroy'])->name('destroy');
            
            // Single ticket actions (AJAX)
            Route::post('/{id}/reply', [TicketController::class, 'addReply'])->name('reply');
            Route::post('/{id}/assign', [TicketController::class, 'assign'])->name('assign');
            Route::post('/{id}/change-status', [TicketController::class, 'changeStatus'])->name('change-status');
            Route::post('/{id}/change-priority', [TicketController::class, 'changePriority'])->name('change-priority');
            Route::post('/{id}/merge', [TicketController::class, 'merge'])->name('merge');
            Route::post('/{id}/mark-read', [TicketController::class, 'markAsRead'])->name('mark-read');
            
            // ============================================
            // TICKET NOTES (NEW - Internal Notes)
            // ============================================
            Route::get('/{id}/notes', [TicketNoteController::class, 'index'])->name('notes.index');
            Route::post('/{id}/notes', [TicketNoteController::class, 'store'])->name('notes.store');
            Route::delete('/{id}/notes/{noteId}', [TicketNoteController::class, 'destroy'])->name('notes.destroy');
            
            // ============================================
            // TICKET REMINDERS (NEW)
            // ============================================
            Route::get('/{id}/reminders', [TicketReminderController::class, 'index'])->name('reminders.index');
            Route::get('/{id}/reminders/data', [TicketReminderController::class, 'dataTable'])->name('reminders.data');
            Route::post('/{id}/reminders', [TicketReminderController::class, 'store'])->name('reminders.store');
            Route::delete('/{id}/reminders/{reminderId}', [TicketReminderController::class, 'destroy'])->name('reminders.destroy');
            
            // ============================================
            // OTHER TICKETS FROM SAME CONTACT (NEW)
            // ============================================
            Route::get('/{id}/other-tickets', [TicketController::class, 'getOtherTickets'])->name('other-tickets.data');
            
            // ============================================
            // UPDATE TICKET INFO FROM SIDEBAR (NEW)
            // ============================================
            Route::post('/{id}/update-info', [TicketController::class, 'updateTicketInfo'])->name('update-info');
        });
        
        // ============================================
        // DEPARTMENTS MANAGEMENT
        // ============================================
        Route::prefix('departments')->name('departments.')->group(function () {
            Route::get('/', [DepartmentController::class, 'index'])->name('index');
            Route::get('/data', [DepartmentController::class, 'dataTable'])->name('data');
            Route::get('/create', [DepartmentController::class, 'create'])->name('create');
            Route::post('/', [DepartmentController::class, 'store'])->name('store');
            Route::post('/bulk-delete', [DepartmentController::class, 'bulkDelete'])->name('bulk-delete');
            Route::get('/search', [DepartmentController::class, 'search'])->name('search');
            Route::get('/{id}/edit', [DepartmentController::class, 'edit'])->name('edit');
            Route::put('/{id}', [DepartmentController::class, 'update'])->name('update');
            Route::delete('/{id}', [DepartmentController::class, 'destroy'])->name('destroy');
            Route::post('/{id}/toggle-active', [DepartmentController::class, 'toggleActive'])->name('toggle-active');
        });
        
        // ============================================
        // PRIORITIES MANAGEMENT
        // ============================================
        Route::prefix('priorities')->name('priorities.')->group(function () {
            Route::get('/', [PriorityController::class, 'index'])->name('index');
            Route::get('/data', [PriorityController::class, 'dataTable'])->name('data');
            Route::get('/create', [PriorityController::class, 'create'])->name('create');
            Route::post('/', [PriorityController::class, 'store'])->name('store');
            Route::post('/bulk-delete', [PriorityController::class, 'bulkDelete'])->name('bulk-delete');
            Route::get('/{id}/edit', [PriorityController::class, 'edit'])->name('edit');
            Route::put('/{id}', [PriorityController::class, 'update'])->name('update');
            Route::delete('/{id}', [PriorityController::class, 'destroy'])->name('destroy');
            Route::post('/{id}/toggle-active', [PriorityController::class, 'toggleActive'])->name('toggle-active');
            Route::post('/reorder', [PriorityController::class, 'reorder'])->name('reorder');
        });
        
        // ============================================
        // STATUSES MANAGEMENT
        // ============================================
        Route::prefix('statuses')->name('statuses.')->group(function () {
            Route::get('/', [StatusController::class, 'index'])->name('index');
            Route::get('/data', [StatusController::class, 'dataTable'])->name('data');
            Route::get('/create', [StatusController::class, 'create'])->name('create');
            Route::post('/', [StatusController::class, 'store'])->name('store');
            Route::post('/bulk-delete', [StatusController::class, 'bulkDelete'])->name('bulk-delete');
            Route::get('/{id}/edit', [StatusController::class, 'edit'])->name('edit');
            Route::put('/{id}', [StatusController::class, 'update'])->name('update');
            Route::delete('/{id}', [StatusController::class, 'destroy'])->name('destroy');
            Route::post('/{id}/toggle-active', [StatusController::class, 'toggleActive'])->name('toggle-active');
            Route::post('/{id}/set-default', [StatusController::class, 'setAsDefault'])->name('set-default');
            Route::post('/reorder', [StatusController::class, 'reorder'])->name('reorder');
        });
        
        // ============================================
        // PREDEFINED REPLIES MANAGEMENT
        // ============================================
        Route::prefix('predefined-replies')->name('predefined-replies.')->group(function () {
            Route::get('/', [PredefinedReplyController::class, 'index'])->name('index');
            Route::get('/data', [PredefinedReplyController::class, 'dataTable'])->name('data');
            Route::get('/create', [PredefinedReplyController::class, 'create'])->name('create');
            Route::post('/', [PredefinedReplyController::class, 'store'])->name('store');
            Route::post('/bulk-delete', [PredefinedReplyController::class, 'bulkDelete'])->name('bulk-delete');
            Route::get('/get/{id}', [PredefinedReplyController::class, 'getReply'])->name('get');
            Route::get('/search', [PredefinedReplyController::class, 'search'])->name('search');
            Route::get('/{id}/edit', [PredefinedReplyController::class, 'edit'])->name('edit');
            Route::put('/{id}', [PredefinedReplyController::class, 'update'])->name('update');
            Route::delete('/{id}', [PredefinedReplyController::class, 'destroy'])->name('destroy');
            Route::post('/{id}/toggle-active', [PredefinedReplyController::class, 'toggleActive'])->name('toggle-active');
        });
    });

/*
|--------------------------------------------------------------------------
| CLIENT ROUTES - Support Portal
|--------------------------------------------------------------------------
*/

// Public routes (no authentication required - via ticket_key)
Route::prefix('support')->name('client.support.')->group(function () {
    
    // ============================================
    // TICKET ACCESS VIA KEY (Public)
    // ============================================
    // View ticket via ticket key (public access)
    Route::get('/ticket/{key}', [TicketClientController::class, 'viewByKey'])->name('view-by-key');
    
    // Submit reply via ticket key (public)
    Route::post('/ticket/{key}/reply', [TicketClientController::class, 'replyByKey'])->name('reply-by-key');
    
    // Download attachment via ticket key (public)
    Route::get('/ticket/{key}/download/{attachmentId}', [TicketClientController::class, 'downloadByKey'])->name('download-by-key');
    
    // Change status via ticket key (if allowed)
    Route::post('/ticket/{key}/change-status', [TicketClientController::class, 'changeStatusByKey'])->name('change-status-by-key');
});

// Authenticated client routes (require customer login)
Route::prefix('support')->middleware(['web', 'auth:web'])->name('client.support.')->group(function () {
    
    // ============================================
    // MY TICKETS (Authenticated Only)
    // ============================================
    // List my tickets
    Route::get('/my-tickets', [TicketClientController::class, 'myTickets'])->name('my-tickets');
    
    // Create new ticket
    Route::get('/open-ticket', [TicketClientController::class, 'openTicket'])->name('open-ticket');
    Route::post('/submit-ticket', [TicketClientController::class, 'submitTicket'])->name('submit-ticket');
    
    // View my ticket (authenticated)
    Route::get('/tickets/{id}', [TicketClientController::class, 'view'])->name('view');
    
    // Add reply to my ticket
    Route::post('/tickets/{id}/reply', [TicketClientController::class, 'addReply'])->name('add-reply');
    
    // Download attachment from my ticket
    Route::get('/tickets/{id}/download/{attachmentId}', [TicketClientController::class, 'download'])->name('download');
    
    // Change status of my ticket (if allowed)
    Route::post('/tickets/{id}/change-status', [TicketClientController::class, 'changeStatus'])->name('change-status');
});