<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Remove soft deletes from tasks table
     */
    public function up(): void
    {
        if (Schema::hasTable('module_tasks') && Schema::hasColumn('module_tasks', 'deleted_at')) {
            Schema::table('module_tasks', function (Blueprint $table) {
                $table->dropColumn('deleted_at');
            });
        }
    }

    /**
     * Reverse - add back soft deletes
     */
    public function down(): void
    {
        if (Schema::hasTable('module_tasks') && !Schema::hasColumn('module_tasks', 'deleted_at')) {
            Schema::table('module_tasks', function (Blueprint $table) {
                $table->softDeletes();
            });
        }
    }
};
