<?php

namespace Modules\Tasks\Models;

use Illuminate\Database\Eloquent\Model;

class TaskComment extends Model
{
    protected $table = 'module_task_comments';

    protected $fillable = [
        'task_id',
        'admin_id',
        'comment',
        'portal_visible',
    ];

    protected $casts = [
        'portal_visible' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // ==================== RELATIONSHIPS ====================

    public function task()
    {
        return $this->belongsTo(Task::class, 'task_id');
    }

    public function admin()
    {
        return $this->belongsTo('App\Models\Admin', 'admin_id');
    }
}
