<style>
/* ========================================
   Task Create Form - Theme-Aware Design
   NUCLEAR FIX for Status Dropdown
   ======================================== */

/* Page Animation */
.form-page {
    max-width: 900px;
    margin: 0 auto;
    padding: 2rem;
    animation: fadeInUp 0.5s ease;
}

@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

/* ========== HEADER ========== */
.form-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 2rem;
    padding-bottom: 1.5rem;
    border-bottom: 2px solid #e5e7eb;
}

.btn-back {
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: #3b82f6;
    border: none;
    border-radius: 0.375rem;
    text-decoration: none;
    color: #ffffff;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.25);
}

.btn-back:hover {
    background: #2563eb;
    transform: translateX(-5px) scale(1.05);
    box-shadow: 0 6px 20px rgba(59, 130, 246, 0.35);
}

.btn-back svg {
    width: 18px;
    height: 18px;
}

.form-header h1 {
    font-size: 1.25rem;
    font-weight: 700;
    color: #111827;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    margin: 0;
}

.header-icon {
    width: 24px;
    height: 24px;
    color: #3b82f6;
    animation: iconPulse 2s ease-in-out infinite;
}

@keyframes iconPulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.1); }
}

/* ========== ALERTS ========== */
.alert-errors {
    background: #fee2e2;
    border: 2px solid #ef4444;
    border-radius: 0.5rem;
    padding: 1.5rem;
    margin-bottom: 2rem;
    color: #ef4444;
    animation: shake 0.5s ease;
}

@keyframes shake {
    0%, 100% { transform: translateX(0); }
    25% { transform: translateX(-10px); }
    75% { transform: translateX(10px); }
}

.alert-errors ul {
    margin: 0;
    padding-left: 2rem;
}

.alert-errors li {
    margin: 0.25rem 0;
    font-weight: 600;
    font-size: 0.875rem;
}

.alert-errors svg {
    width: 14px;
    height: 14px;
    display: inline;
    vertical-align: middle;
    margin-right: 0.25rem;
}

/* ========== FORM CARD ========== */
.form-card {
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 0.5rem;
    overflow: hidden;
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    animation: fadeInUp 0.5s ease 0.2s backwards;
}

.form-card-body {
    padding: 2rem;
}

/* ========== FORM ELEMENTS ========== */
.form-group {
    margin-bottom: 1.5rem;
    position: relative;
}

.form-label {
    display: flex;
    align-items: center;
    gap: 0.25rem;
    font-size: 0.875rem;
    font-weight: 600;
    color: #111827;
    margin-bottom: 0.5rem;
}

.label-icon {
    width: 14px;
    height: 14px;
    color: #3b82f6;
}

.required {
    color: #ef4444;
    font-weight: 700;
}

/* Base Input Styles */
.form-input, .form-textarea {
    width: 100%;
    padding: 10px 14px;
    background: #ffffff;
    border: 1.5px solid #d1d5db;
    border-radius: 0.375rem;
    font-size: 1rem;
    color: #111827;
    transition: all 0.3s ease;
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
}

.form-input:focus, .form-textarea:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px #dbeafe;
    background: #ffffff;
    transform: translateY(-2px);
}

.form-input::placeholder, .form-textarea::placeholder {
    color: #9ca3af;
    font-style: italic;
}

/* Select Dropdown */
.form-select {
    width: 100%;
    padding: 10px 40px 10px 14px;
    background: #ffffff;
    border: 1.5px solid #d1d5db;
    border-radius: 0.375rem;
    font-size: 1rem;
    color: #111827;
    cursor: pointer;
    transition: all 0.3s ease;
    -webkit-appearance: none;
    -moz-appearance: none;
    appearance: none;
    background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' viewBox='0 0 24 24' fill='none' stroke='%233b82f6' stroke-width='2'%3E%3Cpath d='M6 9l6 6 6-6'/%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: right 12px center;
    background-size: 16px;
}

.form-select:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px #dbeafe;
    background-color: #ffffff;
    transform: translateY(-2px);
}

.form-select option {
    padding: 1rem;
    font-size: 1rem;
    background: #ffffff;
    color: #111827;
}

/* ========================================
   STATUS DROPDOWN - NUCLEAR FIX VERSION
   ======================================== */
.status-select-wrapper {
    position: relative;
}

.status-select {
    width: 100%;
    padding: 10px 14px;
    background: #ffffff;
    border: 1.5px solid #d1d5db;
    border-radius: 0.375rem;
    font-size: 1rem;
    font-weight: 600;
    color: #111827;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.status-select:hover {
    border-color: #3b82f6;
    background: #ffffff;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.15);
}

.status-icon {
    width: 16px;
    height: 16px;
    flex-shrink: 0;
}

.status-text {
    flex: 1;
    color: #111827;
}

.status-arrow {
    width: 14px;
    height: 14px;
    color: #6b7280;
    transition: transform 0.3s ease;
}

.status-select.active .status-arrow {
    transform: rotate(180deg);
}

/* Status Dropdown Container */
.status-dropdown {
    display: none;
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    margin-top: 0.5rem;
    background: #ffffff;
    border: 1.5px solid #e5e7eb;
    border-radius: 0.375rem;
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
    z-index: 100;
    overflow: hidden;
    animation: dropdownSlide 0.3s ease;
}

@keyframes dropdownSlide {
    from { opacity: 0; transform: translateY(-10px); }
    to { opacity: 1; transform: translateY(0); }
}

.status-dropdown.active {
    display: block;
}

/* ========================================
   CRITICAL FIX: Status Option Text
   Maximum specificity + fallback colors
   ======================================== */

/* Base status option - NO color here */
.status-option {
    padding: 12px 14px;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    cursor: pointer;
    transition: all 0.2s ease;
    font-size: 0.875rem;
    border-bottom: 1px solid #e5e7eb;
}

.status-option:last-child {
    border-bottom: none;
}

.status-option:hover {
    background: #f3f4f6;
    padding-left: 18px;
}

.status-option.selected {
    background: #dbeafe;
}

/* NUCLEAR FIX: Force text visibility with multiple fallbacks */
.status-dropdown .status-option span,
div.status-option > span {
    /* Primary theme-aware color */
    color: #111827 !important;
    font-weight: 600 !important;
    display: inline-block !important;
    opacity: 1 !important;
    visibility: visible !important;
}

/* Dark theme override - explicit light text */
[data-theme="dark"] .status-dropdown .status-option span,
[data-theme="dark"] div.status-option > span {
    color: #f1f5f9 !important;
}

/* Light theme override - explicit dark text */
[data-theme="light"] .status-dropdown .status-option span,
[data-theme="light"] div.status-option > span {
    color: #1e293b !important;
}

/* Icon-specific colors (keep icons colored) */
.status-option .status-icon {
    flex-shrink: 0;
}

/* Backlog - Gray */
.status-option.backlog .status-icon { 
    color: #9ca3af;
}

/* To Do - Dark Gray */
.status-option.todo .status-icon { 
    color: #6b7280;
}

/* In Progress - Blue */
.status-option.inprogress .status-icon { 
    color: #3b82f6;
}

/* Review - Orange/Amber */
.status-option.review .status-icon { 
    color: #f59e0b;
}

/* Done - Green */
.status-option.done .status-icon { 
    color: #10b981;
}

/* Blocked - Red */
.status-option.blocked .status-icon { 
    color: #ef4444;
}

/* Selected state - stronger text color */
.status-option.selected span {
    color: #3b82f6 !important;
    font-weight: 700 !important;
}

/* Hidden native select */
select#status_id {
    position: absolute;
    opacity: 0;
    pointer-events: none;
    height: 0;
    width: 0;
}

/* ========== TEXTAREA ========== */
.form-textarea {
    min-height: 120px;
    resize: vertical;
    font-family: inherit;
    line-height: 1.6;
}

/* ========== ERROR MESSAGES ========== */
.form-error {
    color: #ef4444;
    font-size: 0.75rem;
    margin-top: 0.25rem;
    display: flex;
    align-items: center;
    gap: 0.25rem;
    font-weight: 600;
    animation: shake 0.3s ease;
}

.error-icon {
    width: 12px;
    height: 12px;
}

/* ========== GRID LAYOUTS ========== */
.form-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 1rem;
}

.form-row-3 {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 1rem;
}

/* ========== CHECKBOX ========== */
.form-checkbox {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 1rem;
    background: #ffffff;
    border: 1.5px solid #d1d5db;
    border-radius: 0.375rem;
    transition: all 0.3s ease;
    cursor: pointer;
}

.form-checkbox:hover {
    background: #ffffff;
    border-color: #3b82f6;
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.1);
}

.form-checkbox input[type="checkbox"] {
    width: 18px;
    height: 18px;
    cursor: pointer;
    accent-color: #3b82f6;
}

.form-checkbox label {
    margin: 0;
    cursor: pointer;
    font-weight: 600;
    font-size: 0.875rem;
    color: #111827;
    flex: 1;
}

.form-checkbox svg {
    width: 14px;
    height: 14px;
    color: #10b981;
}

/* ========== HELPER TEXT ========== */
.helper-text {
    display: flex;
    align-items: center;
    gap: 0.25rem;
    margin-top: 0.25rem;
    font-size: 0.75rem;
    color: #9ca3af;
}

.helper-icon {
    width: 12px;
    height: 12px;
}

/* ========== INPUT WITH ICON ========== */
.input-with-icon {
    position: relative;
}

.input-icon {
    position: absolute;
    left: 14px;
    top: 50%;
    transform: translateY(-50%);
    width: 16px;
    height: 16px;
    color: #9ca3af;
    pointer-events: none;
}

.input-with-icon .form-input {
    padding-left: 42px;
}

/* ========== FORM ACTIONS ========== */
.form-actions {
    padding: 1.5rem 2rem;
    border-top: 1.5px solid #e5e7eb;
    display: flex;
    gap: 0.5rem;
    background: #f3f4f6;
}

.btn-submit {
    padding: 12px 24px;
    background: #3b82f6;
    color: #ffffff;
    border: none;
    border-radius: 0.375rem;
    font-weight: 700;
    font-size: 0.875rem;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 0.25rem;
    box-shadow: 0 4px 15px rgba(59, 130, 246, 0.25);
}

.btn-submit:hover {
    background: #2563eb;
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(59, 130, 246, 0.35);
}

.btn-submit:active {
    transform: translateY(-1px);
}

.btn-icon {
    width: 14px;
    height: 14px;
}

.btn-cancel {
    padding: 12px 24px;
    background: #ffffff;
    color: #6b7280;
    border: 1.5px solid #e5e7eb;
    border-radius: 0.375rem;
    font-weight: 700;
    font-size: 0.875rem;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 0.25rem;
    transition: all 0.3s ease;
}

.btn-cancel:hover {
    background: #f3f4f6;
    border-color: #9ca3af;
    color: #111827;
    transform: translateY(-2px);
}

/* ========================================
   SELECT2 OVERRIDES - NUCLEAR FIX
   ======================================== */
.select2-container--default .select2-selection--multiple {
    background: #ffffff !important;
    border: 1.5px solid #d1d5db !important;
    border-radius: 0.375rem;
    min-height: 48px;
    padding: 6px 10px;
    transition: all 0.3s ease;
}

.select2-container--default.select2-container--focus .select2-selection--multiple {
    border-color: #3b82f6 !important;
    box-shadow: 0 0 0 3px #dbeafe !important;
    background: #ffffff !important;
}

/* Selected tags - force white text */
.select2-container--default .select2-selection--multiple .select2-selection__choice {
    background: #3b82f6 !important;
    border: none !important;
    border-radius: 0.25rem;
    padding: 4px 10px;
    margin: 4px;
    font-weight: 600;
    font-size: 0.75rem;
}

.select2-container--default .select2-selection--multiple .select2-selection__choice,
.select2-container--default .select2-selection--multiple .select2-selection__choice span {
    color: #ffffff !important;
}

.select2-container--default .select2-selection--multiple .select2-selection__choice__remove {
    color: #ffffff !important;
    margin-right: 0.25rem;
    font-weight: bold;
}

.select2-container--default .select2-selection--multiple .select2-selection__choice__remove:hover {
    color: rgba(255, 255, 255, 0.7) !important;
}

/* Dropdown container */
.select2-dropdown {
    background: #ffffff !important;
    border: 1.5px solid #e5e7eb !important;
    border-radius: 0.375rem;
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
    animation: dropdownSlide 0.3s ease;
}

/* Dropdown options - FORCE text visibility */
.select2-container--default .select2-results__option {
    padding: 10px 14px !important;
    background: #ffffff !important;
    font-weight: 500;
    font-size: 0.875rem;
}

.select2-container--default .select2-results__option,
.select2-container--default .select2-results__option span {
    color: #111827 !important;
}

/* Dark theme Select2 fix */
[data-theme="dark"] .select2-container--default .select2-results__option,
[data-theme="dark"] .select2-container--default .select2-results__option span {
    color: #f1f5f9 !important;
}

/* Light theme Select2 fix */
[data-theme="light"] .select2-container--default .select2-results__option,
[data-theme="light"] .select2-container--default .select2-results__option span {
    color: #1e293b !important;
}

/* Highlighted option */
.select2-container--default .select2-results__option--highlighted[aria-selected] {
    background: #dbeafe !important;
}

.select2-container--default .select2-results__option--highlighted[aria-selected],
.select2-container--default .select2-results__option--highlighted[aria-selected] span {
    color: #111827 !important;
    font-weight: 600 !important;
}

/* Selected option */
.select2-container--default .select2-results__option[aria-selected=true] {
    background: #d1fae5 !important;
}

.select2-container--default .select2-results__option[aria-selected=true],
.select2-container--default .select2-results__option[aria-selected=true] span {
    color: #10b981 !important;
    font-weight: 600 !important;
}

/* Search field */
.select2-search--dropdown .select2-search__field {
    background: #ffffff !important;
    border: 1.5px solid #d1d5db !important;
    border-radius: 0.25rem;
    padding: 0.5rem;
}

.select2-search--dropdown .select2-search__field,
.select2-search--dropdown .select2-search__field::placeholder {
    color: #111827 !important;
}

[data-theme="dark"] .select2-search--dropdown .select2-search__field {
    color: #f1f5f9 !important;
}

.select2-search--dropdown .select2-search__field:focus {
    outline: none;
    border-color: #3b82f6 !important;
}

/* Placeholder */
.select2-container--default .select2-selection--multiple .select2-selection__placeholder {
    color: #9ca3af !important;
}

/* ========== LOADING STATE ========== */
@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

.btn-submit.loading {
    pointer-events: none;
    opacity: 0.7;
}

.btn-submit.loading::after {
    content: '';
    width: 14px;
    height: 14px;
    border: 2px solid #ffffff;
    border-top-color: transparent;
    border-radius: 50%;
    animation: spin 0.6s linear infinite;
    margin-left: 0.25rem;
}

/* ========== FILE UPLOAD STYLES ========== */
.label-hint {
    font-size: 12px;
    font-weight: 400;
    color: #9ca3af;
    margin-left: 8px;
}

.file-upload-wrapper {
    margin-top: 8px;
}

.file-upload-area {
    border: 2px dashed #e5e7eb;
    border-radius: 0.5rem;
    padding: 32px 20px;
    text-align: center;
    cursor: pointer;
    transition: all 0.3s ease;
    background: #ffffff;
}

.file-upload-area:hover,
.file-upload-area.dragover {
    border-color: #3b82f6;
    background: #dbeafe;
}

.file-upload-area.dragover {
    transform: scale(1.01);
}

.file-upload-icon {
    width: 48px;
    height: 48px;
    color: #9ca3af;
    margin: 0 auto 12px;
    display: block;
}

.file-upload-text {
    font-size: 14px;
    color: #6b7280;
    margin-bottom: 6px;
}

.file-upload-text strong {
    color: #3b82f6;
}

.file-upload-hint {
    font-size: 12px;
    color: #9ca3af;
}

.file-input {
    display: none;
}

.file-preview-list {
    margin-top: 12px;
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.file-preview-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 12px 16px;
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 0.375rem;
    animation: fadeInUp 0.3s ease;
}

.file-preview-icon {
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: #dbeafe;
    border-radius: 0.25rem;
    color: #3b82f6;
    flex-shrink: 0;
}

.file-preview-icon svg {
    width: 20px;
    height: 20px;
}

.file-preview-icon.image {
    background: #d1fae5;
    color: #10b981;
}

.file-preview-icon.document {
    background: #fef3c7;
    color: #f59e0b;
}

.file-preview-icon.archive {
    background: #dbeafe;
    color: #3b82f6;
}

.file-preview-thumbnail {
    width: 40px;
    height: 40px;
    border-radius: 0.25rem;
    object-fit: cover;
    flex-shrink: 0;
}

.file-preview-info {
    flex: 1;
    min-width: 0;
}

.file-preview-name {
    font-size: 14px;
    font-weight: 600;
    color: #111827;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.file-preview-size {
    font-size: 12px;
    color: #9ca3af;
}

.file-preview-remove {
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: transparent;
    border: 1px solid transparent;
    border-radius: 0.25rem;
    color: #9ca3af;
    cursor: pointer;
    transition: all 0.2s ease;
}

.file-preview-remove:hover {
    background: #fee2e2;
    border-color: #ef4444;
    color: #ef4444;
}

.file-preview-remove svg {
    width: 18px;
    height: 18px;
}

.file-limit-warning {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 10px 14px;
    background: #fef3c7;
    border: 1px solid #f59e0b;
    border-radius: 0.375rem;
    margin-top: 12px;
    font-size: 13px;
    font-weight: 500;
    color: #f59e0b;
}

.file-limit-warning svg {
    width: 18px;
    height: 18px;
    flex-shrink: 0;
}

/* ========== ITEMS USED STYLES ========== */
.items-section {
    margin-top: 24px;
    border-top: 1px solid #e5e7eb;
    padding-top: 24px;
}

.items-section-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 16px;
}

.items-table-wrapper {
    overflow-x: auto;
    border: 1px solid #e5e7eb;
    border-radius: 0.375rem;
}

.items-table {
    width: 100%;
    border-collapse: collapse;
    min-width: 800px;
}

.items-table th {
    background: #f3f4f6;
    padding: 12px 14px;
    text-align: left;
    font-size: 12px;
    font-weight: 600;
    color: #6b7280;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    border-bottom: 1px solid #e5e7eb;
}

.items-table td {
    padding: 12px 14px;
    border-bottom: 1px solid #e5e7eb;
    vertical-align: middle;
}

.items-table tr:last-child td {
    border-bottom: none;
}

.items-table .item-product {
    min-width: 200px;
}

.items-table .item-qty {
    width: 90px;
}

.items-table .item-price {
    width: 110px;
}

.items-table .item-tax {
    min-width: 160px;
}

.items-table .item-total {
    width: 120px;
    font-weight: 600;
    color: #3b82f6;
}

.items-table .item-actions {
    width: 60px;
    text-align: center;
}

.items-table select,
.items-table input {
    width: 100%;
    padding: 8px 10px;
    background: #ffffff;
    border: 1px solid #d1d5db;
    border-radius: 0.25rem;
    font-size: 13px;
    color: #111827;
}

.items-table select:focus,
.items-table input:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 2px #dbeafe;
}

.btn-add-item {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 8px 14px;
    background: #10b981;
    color: white;
    border: none;
    border-radius: 0.375rem;
    font-size: 13px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.2s ease;
}

.btn-add-item:hover {
    background: #059669;
    transform: translateY(-1px);
}

.btn-add-item svg {
    width: 16px;
    height: 16px;
}

.btn-remove-item {
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: transparent;
    border: 1px solid transparent;
    border-radius: 0.25rem;
    color: #9ca3af;
    cursor: pointer;
    transition: all 0.2s ease;
}

.btn-remove-item:hover {
    background: #fee2e2;
    border-color: #ef4444;
    color: #ef4444;
}

.btn-remove-item svg {
    width: 18px;
    height: 18px;
}

.items-empty {
    padding: 32px;
    text-align: center;
    color: #9ca3af;
}

.items-empty svg {
    width: 48px;
    height: 48px;
    margin-bottom: 12px;
    opacity: 0.5;
}

.items-footer {
    display: flex;
    justify-content: flex-end;
    padding: 16px;
    background: #f3f4f6;
    border-top: 1px solid #e5e7eb;
}

.items-totals-box {
    min-width: 280px;
}

.items-totals-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 8px 0;
    font-size: 14px;
}

.items-totals-row + .items-totals-row {
    border-top: 1px solid #e5e7eb;
}

.items-totals-row.grand-total {
    padding-top: 12px;
    margin-top: 8px;
    border-top: 2px solid #e5e7eb;
}

.items-totals-row.grand-total .totals-label {
    font-size: 16px;
    font-weight: 700;
}

.items-totals-row.grand-total .totals-value {
    font-size: 20px;
    font-weight: 700;
    color: #3b82f6;
}

.items-total {
    display: flex;
    align-items: center;
    gap: 16px;
    font-size: 16px;
}

.items-total-label, .totals-label {
    font-weight: 500;
    color: #6b7280;
}

.items-total-value, .totals-value {
    font-weight: 700;
    color: #3b82f6;
    font-size: 18px;
}

.totals-value.tax {
    color: #10b981;
}

/* Tax Badges */
.tax-badges-wrapper {
    display: flex;
    flex-wrap: wrap;
    gap: 6px;
    align-items: center;
    min-height: 36px;
}

.tax-badge {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 4px 8px;
    background: linear-gradient(to bottom, #fef2f2, #fee2e2);
    border: 1px solid #fecaca;
    border-radius: 6px;
    font-size: 11px;
    font-weight: 600;
    color: #991b1b;
    white-space: nowrap;
}

.tax-badge .remove-tax {
    cursor: pointer;
    font-size: 14px;
    line-height: 1;
    opacity: 0.7;
    margin-left: 2px;
    transition: opacity 0.2s ease;
}

.tax-badge .remove-tax:hover {
    opacity: 1;
}

.add-tax-btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 28px;
    height: 28px;
    background: #f3f4f6;
    border: 2px dashed #e5e7eb;
    border-radius: 6px;
    cursor: pointer;
    color: #9ca3af;
    font-size: 18px;
    font-weight: 400;
    transition: all 0.2s ease;
}

.add-tax-btn:hover {
    background: #dbeafe;
    color: #3b82f6;
    border-color: #3b82f6;
}

/* Tax Dropdown */
.tax-dropdown {
    position: fixed;
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 10px;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
    z-index: 1001;
    min-width: 220px;
    max-height: 280px;
    overflow-y: auto;
    display: none;
}

.tax-dropdown.show {
    display: block;
}

.tax-dropdown-item {
    padding: 12px 16px;
    cursor: pointer;
    font-size: 13px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 1px solid #e5e7eb;
    transition: background 0.15s ease;
    color: #111827;
}

.tax-dropdown-item:last-child {
    border-bottom: none;
}

.tax-dropdown-item:hover {
    background: #f3f4f6;
}

.tax-dropdown-item.selected {
    background: #dbeafe;
}

.tax-dropdown-item .tax-rate {
    color: #9ca3af;
    font-size: 12px;
}

.tax-dropdown-item .check-mark {
    color: #3b82f6;
    font-weight: bold;
}

/* ========== RESPONSIVE ========== */
@media (max-width: 768px) {
    .form-page {
        padding: 1rem;
    }
    
    .form-row, .form-row-3 {
        grid-template-columns: 1fr;
    }
    
    .form-card-body {
        padding: 1.5rem;
    }
    
    .form-actions {
        flex-direction: column;
        padding: 1rem;
    }
    
    .btn-submit, .btn-cancel {
        width: 100%;
        justify-content: center;
    }
}
</style>

<div class="form-page">
    <div class="form-header">
        <a href="{{ route('admin.tasks.index') }}" class="btn-back">
            <svg fill="none" stroke="currentColor" stroke-width="2.5" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"/>
            </svg>
        </a>
        <h1>
            <svg class="header-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"/>
            </svg>
            Create New Task
        </h1>
    </div>

    @if($errors->any())
    <div class="alert-errors">
        <ul>
            @foreach($errors->all() as $error)
            <li>
                <svg fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                </svg>
                {{ $error }}
            </li>
            @endforeach
        </ul>
    </div>
    @endif

    <form action="{{ route('admin.tasks.store') }}" method="POST" id="taskForm" enctype="multipart/form-data">
        @csrf
        <div class="form-card">
            <div class="form-card-body">
                <!-- Task Title -->
                <div class="form-group">
                    <label class="form-label">
                        <svg class="label-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z"/>
                        </svg>
                        Task Title <span class="required">*</span>
                    </label>
                    <div class="input-with-icon">
                        <svg class="input-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.232 5.232l3.536 3.536m-2.036-5.036a2.5 2.5 0 113.536 3.536L6.5 21.036H3v-3.572L16.732 3.732z"/>
                        </svg>
                        <input type="text" name="title" class="form-input" value="{{ old('title') }}" placeholder="Enter a clear, descriptive task title..." required autocomplete="off">
                    </div>
                    @error('title')
                    <div class="form-error">
                        <svg class="error-icon" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                        </svg>
                        {{ $message }}
                    </div>
                    @enderror
                </div>

                <!-- Task Type & Related Item Row -->
                <div class="form-row">
                    <!-- Task Type -->
                    <div class="form-group">
                        <label class="form-label">
                            <svg class="label-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/>
                            </svg>
                            Task Type <span class="required">*</span>
                        </label>
                        <select name="task_type" id="taskType" class="form-select" required onchange="loadRelatedItems()">
                            @foreach($taskTypes as $key => $label)
                            <option value="{{ $key }}" {{ (old('task_type', $selectedType ?? 'general') == $key) ? 'selected' : '' }}>
                                {{ $label }}
                            </option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Related Item (Dynamic) -->
                    <div class="form-group" id="relatedItemGroup" style="display: none;">
                        <label class="form-label" id="relatedItemLabel">
                            <svg class="label-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-6l-2-2H5a2 2 0 00-2 2z"/>
                            </svg>
                            <span id="relatedItemLabelText">Select Item</span>
                        </label>
                        <select id="relatedItemSelect" class="form-select">
                            <option value="">-- Select --</option>
                        </select>
                        <input type="hidden" name="project_id" id="projectIdField">
                        <input type="hidden" name="service_id" id="serviceIdField">
                        <input type="hidden" name="contract_id" id="contractIdField">
                        <input type="hidden" name="support_ticket_id" id="supportTicketIdField">
                        <input type="hidden" name="related_name" id="relatedNameField">
                        <div id="relatedItemMessage" class="form-hint" style="color: #f59e0b;"></div>
                    </div>
                </div>

                <!-- Status Row -->
                <div class="form-row">
                    <!-- Status - COMPLETELY FIXED VERSION -->
                    <div class="form-group">
                        <label class="form-label">
                            <svg class="label-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            Status <span class="required">*</span>
                        </label>
                        <div class="status-select-wrapper">
                            <div class="status-select" id="statusSelect">
                                <svg class="status-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                                </svg>
                                <span class="status-text">Select Status</span>
                                <svg class="status-arrow" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"/>
                                </svg>
                            </div>
                            <div class="status-dropdown" id="statusDropdown">
                                @foreach($statuses as $status)
                                <div class="status-option {{ strtolower(str_replace(' ', '', $status->label)) }}" 
                                    data-value="{{ $status->id }}" 
                                    data-label="{{ $status->label }}"
                                    onclick="selectStatus(this)">
                                    
                                    @if(strtolower($status->label) === 'backlog')
                                        {{-- Inbox/Archive icon --}}
                                        <svg class="status-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M5 8h14M5 8a2 2 0 110-4h14a2 2 0 110 4M5 8v10a2 2 0 002 2h10a2 2 0 002-2V8m-9 4h4"/>
                                        </svg>
                                        
                                    @elseif(strtolower($status->label) === 'to do')
                                        {{-- Checkbox icon --}}
                                        <svg class="status-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                                        </svg>
                                        
                                    @elseif(strtolower($status->label) === 'in progress')
                                        {{-- Lightning/Zap icon --}}
                                        <svg class="status-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                                        </svg>
                                        
                                    @elseif(strtolower($status->label) === 'review')
                                        {{-- Eye/Magnifying glass icon --}}
                                        <svg class="status-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                                        </svg>
                                        
                                    @elseif(strtolower($status->label) === 'done')
                                        {{-- Checkmark circle icon --}}
                                        <svg class="status-icon" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                        </svg>
                                        
                                    @elseif(strtolower($status->label) === 'blocked')
                                        {{-- Stop/Pause icon --}}
                                        <svg class="status-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"/>
                                        </svg>
                                        
                                    @else
                                        {{-- Default fallback icon --}}
                                        <svg class="status-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z"/>
                                        </svg>
                                    @endif
                                    
                                    <span>{{ $status->label }}</span>
                                </div>
                                @endforeach
                            </div>
                            <select name="status_id" id="status_id" required>
                                @foreach($statuses as $index => $status)
                                <option value="{{ $status->id }}" {{ old('status_id', $index == 0 ? $status->id : '') == $status->id ? 'selected' : '' }}>
                                    {{ $status->label }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        @error('status_id')
                        <div class="form-error">
                            <svg class="error-icon" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                            </svg>
                            {{ $message }}
                        </div>
                        @enderror
                    </div>
                </div>

                <!-- Description -->
                <div class="form-group">
                    <label class="form-label">
                        <svg class="label-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16M4 18h7"/>
                        </svg>
                        Description
                    </label>
                    <textarea name="description" class="form-textarea" placeholder="Provide detailed task description, acceptance criteria, and any relevant notes...">{{ old('description') }}</textarea>
                    <div class="helper-text">
                        <svg class="helper-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        Add details that help team members understand and complete this task
                    </div>
                </div>

                <!-- Priority, Start, Due Date Row -->
                <div class="form-row-3">
                    <div class="form-group">
                        <label class="form-label">
                            <svg class="label-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                            </svg>
                            Priority <span class="required">*</span>
                        </label>
                        <select name="priority" class="form-select" required>
                            <option value="low" {{ old('priority') == 'low' ? 'selected' : '' }}>Low Priority</option>
                            <option value="medium" {{ old('priority', 'medium') == 'medium' ? 'selected' : '' }}>Medium Priority</option>
                            <option value="high" {{ old('priority') == 'high' ? 'selected' : '' }}>High Priority</option>
                            <option value="critical" {{ old('priority') == 'critical' ? 'selected' : '' }}>Critical Priority</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label class="form-label">
                            <svg class="label-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                            </svg>
                            Planned Start
                        </label>
                        <input type="date" name="planned_start_date" class="form-input" value="{{ old('planned_start_date') }}">
                    </div>

                    <div class="form-group">
                        <label class="form-label">
                            <svg class="label-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            Due Date
                        </label>
                        <input type="date" name="due_date" class="form-input" value="{{ old('due_date') }}">
                    </div>
                </div>

                <!-- Hours & Rate Row -->
                <div class="form-row-3">
                    <div class="form-group">
                        <label class="form-label">
                            <svg class="label-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            Estimated Hours
                        </label>
                        <input type="number" name="estimated_hours" class="form-input" step="0.5" min="0" placeholder="e.g., 8.5" value="{{ old('estimated_hours') }}">
                    </div>

                    <div class="form-group">
                        <label class="form-label">
                            <svg class="label-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            Hourly Rate
                        </label>
                        <input type="number" name="hourly_rate" class="form-input" step="0.01" min="0" placeholder="e.g., 50.00" value="{{ old('hourly_rate') }}">
                    </div>

                    <div class="form-group">
                        <label class="form-label" style="visibility: hidden;">Spacer</label>
                        <div class="form-checkbox">
                            <input type="checkbox" name="is_billable" id="is_billable" value="1" {{ old('is_billable', true) ? 'checked' : '' }}>
                            <label for="is_billable">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                Is Billable
                            </label>
                        </div>
                    </div>
                </div>

                <!-- Assigned Team -->
                <div class="form-group">
                    <label class="form-label">
                        <svg class="label-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                        </svg>
                        Assigned To (Multiple)
                    </label>
                    <select name="assignees[]" id="assigned-select" class="form-select" multiple>
                        @foreach($admins as $admin)
                        <option value="{{ $admin->id }}" {{ in_array($admin->id, old('assignees', [])) ? 'selected' : '' }}>
                            {{ $admin->name }}
                        </option>
                        @endforeach
                    </select>
                    <div class="helper-text">
                        <svg class="helper-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                        </svg>
                        Select one or more team members to assign this task
                    </div>
                </div>

                <!-- Managed By -->
                <div class="form-group">
                    <label class="form-label">
                        <svg class="label-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                            <path stroke-linecap="round" stroke-linejoin="round" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                        </svg>
                        Managed By
                    </label>
                    <select name="followers[]" id="managed-select" class="form-select" multiple>
                        @foreach($admins as $admin)
                        <option value="{{ $admin->id }}" {{ in_array($admin->id, old('followers', [])) ? 'selected' : '' }}>
                            {{ $admin->name }}
                        </option>
                        @endforeach
                    </select>
                    <div class="helper-text">
                        <svg class="helper-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                        </svg>
                        Select team members who will manage/oversee this task
                    </div>
                </div>

                <!-- File Attachments Section -->
                <div class="form-group" style="margin-top: 24px;">
                    <label class="form-label">
                        <svg class="label-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"/>
                        </svg>
                        Attachments
                        <span class="label-hint">(Max 10 files, 1MB each)</span>
                    </label>
                    
                    <div class="file-upload-wrapper">
                        <div class="file-upload-area" id="dropZone">
                            <svg class="file-upload-icon" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M3 16.5v2.25A2.25 2.25 0 005.25 21h13.5A2.25 2.25 0 0021 18.75V16.5m-13.5-9L12 3m0 0l4.5 4.5M12 3v13.5"/>
                            </svg>
                            <div class="file-upload-text">
                                <strong>Click to upload</strong> or drag and drop
                            </div>
                            <div class="file-upload-hint">
                                PDF, DOC, XLS, Images, ZIP (Max 1MB per file)
                            </div>
                            <input 
                                type="file" 
                                name="attachments[]" 
                                id="fileInput" 
                                class="file-input" 
                                multiple
                                accept=".jpg,.jpeg,.png,.gif,.webp,.pdf,.doc,.docx,.xls,.xlsx,.csv,.ppt,.pptx,.txt,.zip,.rar"
                            >
                        </div>
                        
                        <div class="file-preview-list" id="filePreviewList"></div>
                        
                        <div class="file-limit-warning" id="fileLimitWarning" style="display: none;">
                            <svg fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                            </svg>
                            Maximum 10 files allowed
                        </div>
                    </div>
                    
                    @error('attachments')
                    <div class="form-error">
                        <svg class="error-icon" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                        </svg>
                        {{ $message }}
                    </div>
                    @enderror
                    @error('attachments.*')
                    <div class="form-error">
                        <svg class="error-icon" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                        </svg>
                        {{ $message }}
                    </div>
                    @enderror
                </div>

                <!-- Items Used Section -->
                @if(isset($products) && $products->count() > 0)
                <div class="items-section">
                    <div class="items-section-header">
                        <label class="form-label" style="margin-bottom: 0;">
                            <svg class="label-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"/>
                            </svg>
                            Items / Products Used
                        </label>
                        <button type="button" class="btn-add-item" onclick="addItemRow()">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4"/>
                            </svg>
                            Add Item
                        </button>
                    </div>
                    
                    <div class="items-table-wrapper">
                        <table class="items-table" id="itemsTable">
                            <thead>
                                <tr>
                                    <th class="item-product">Product</th>
                                    <th class="item-qty">Qty</th>
                                    <th class="item-price">Unit Price</th>
                                    <th class="item-tax">Taxes</th>
                                    <th class="item-total">Amount</th>
                                    <th class="item-actions"></th>
                                </tr>
                            </thead>
                            <tbody id="itemsBody">
                                <!-- Items will be added here dynamically -->
                            </tbody>
                        </table>
                        <div class="items-empty" id="itemsEmpty">
                            <svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"/>
                            </svg>
                            <p>No items added yet. Click "Add Item" to add products used in this task.</p>
                        </div>
                    </div>
                    
                    <div class="items-footer" id="itemsFooter" style="display: none;">
                        <div class="items-totals-box">
                            <div class="items-totals-row">
                                <span class="totals-label">Subtotal</span>
                                <span class="totals-value" id="itemsSubtotal">0.00</span>
                            </div>
                            <div class="items-totals-row">
                                <span class="totals-label">Tax</span>
                                <span class="totals-value tax" id="itemsTax">0.00</span>
                            </div>
                            <div class="items-totals-row grand-total">
                                <span class="totals-label">Grand Total</span>
                                <span class="totals-value" id="grandTotal">0.00</span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Tax Dropdown (shared) -->
                <div class="tax-dropdown" id="taxDropdown"></div>
                @endif
            </div>

            <div class="form-actions">
                <button type="submit" class="btn-submit">
                    <svg class="btn-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/>
                    </svg>
                    Create Task
                </button>
                <a href="{{ route('admin.tasks.index') }}" class="btn-cancel">
                    <svg class="btn-icon" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                    Cancel
                </a>
            </div>
        </div>
    </form>
</div>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Select2 -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
// ========================================
// Status Dropdown Functionality
// ========================================
const statusSelect = document.getElementById('statusSelect');
const statusDropdown = document.getElementById('statusDropdown');
const hiddenSelect = document.getElementById('status_id');

// Auto-select first status on page load
document.addEventListener('DOMContentLoaded', function() {
    const firstOption = document.querySelector('.status-option');
    if (firstOption && !hiddenSelect.value) {
        selectStatus(firstOption);
    }
    
    // Fallback: directly set first option value if still empty
    if (!hiddenSelect.value && hiddenSelect.options.length > 1) {
        hiddenSelect.selectedIndex = 1; // Index 1 because index 0 is "Select Status"
    }
});

// Toggle dropdown
statusSelect.addEventListener('click', function(e) {
    e.stopPropagation();
    statusSelect.classList.toggle('active');
    statusDropdown.classList.toggle('active');
});

// Close dropdown when clicking outside
document.addEventListener('click', function(e) {
    if (!statusSelect.contains(e.target) && !statusDropdown.contains(e.target)) {
        statusSelect.classList.remove('active');
        statusDropdown.classList.remove('active');
    }
});

// Select status option
function selectStatus(element) {
    const value = element.getAttribute('data-value');
    const label = element.getAttribute('data-label');
    const icon = element.querySelector('.status-icon').cloneNode(true);
    
    // Update display
    const statusText = statusSelect.querySelector('.status-text');
    statusText.textContent = label;
    
    // Update icon
    const currentIcon = statusSelect.querySelector('.status-icon');
    currentIcon.replaceWith(icon.cloneNode(true));
    
    // Update hidden select
    hiddenSelect.value = value;
    
    // Update selected state
    document.querySelectorAll('.status-option').forEach(opt => opt.classList.remove('selected'));
    element.classList.add('selected');
    
    // Close dropdown
    statusSelect.classList.remove('active');
    statusDropdown.classList.remove('active');
}

// ========================================
// Select2 Initialization
// ========================================
$(document).ready(function() {
    $('#assigned-select').select2({
        placeholder: 'Select team members to assign',
        allowClear: true,
        closeOnSelect: false,
        width: '100%'
    });

    $('#managed-select').select2({
        placeholder: 'Select team members to manage',
        allowClear: true,
        closeOnSelect: false,
        width: '100%'
    });
    
    // ========================================
    // Form Validation
    // ========================================
    $('#taskForm').on('submit', function(e) {
        let isValid = true;
        let errorMessages = [];
        
        // Check required fields
        const title = $('input[name="title"]').val()?.trim();
        const taskType = $('#taskType').val();
        const statusId = $('#status_id').val();
        const priority = $('select[name="priority"]').val();
        
        // Basic required fields
        if (!title) {
            errorMessages.push('Task Title is required');
            isValid = false;
        }
        
        if (!taskType) {
            errorMessages.push('Task Type is required');
            isValid = false;
        }
        
        if (!statusId) {
            errorMessages.push('Status is required');
            isValid = false;
        }
        
        if (!priority) {
            errorMessages.push('Priority is required');
            isValid = false;
        }
        
        // Check related ID based on task type (only if not general)
        if (taskType && taskType !== 'general') {
            const projectId = $('#projectIdField').val();
            const serviceId = $('#serviceIdField').val();
            const contractId = $('#contractIdField').val();
            
            if (taskType === 'project' && !projectId) {
                errorMessages.push('Please select a Project');
                isValid = false;
            } else if (taskType === 'service' && !serviceId) {
                errorMessages.push('Please select a Service');
                isValid = false;
            } else if (taskType === 'contract' && !contractId) {
                errorMessages.push('Please select a Contract');
                isValid = false;
            }
        }
        
        if (!isValid) {
            e.preventDefault();
            if (errorMessages.length > 0) {
                alert('Please fix the following errors:\n\n• ' + errorMessages.join('\n• '));
            } else {
                alert('Please fill in all required fields marked with *');
            }
        }
        
        if (isValid) {
            // Add loading state
            $('.btn-submit').addClass('loading');
            $('.btn-submit').prop('disabled', true);
        }
        
        return isValid;
    });

    // ========================================
    // File Upload Functionality (Max 10 Files)
    // ========================================
  const dropZone = document.getElementById('dropZone');
    const fileInput = document.getElementById('fileInput');
    const filePreviewList = document.getElementById('filePreviewList');
    const fileLimitWarning = document.getElementById('fileLimitWarning');
    const MAX_FILES = 10;
    const MAX_SIZE = 1 * 1024 * 1024; // 1MB
    let selectedFiles = new DataTransfer();

    // Click to upload
    if (dropZone) {
        dropZone.addEventListener('click', () => fileInput.click());

        // Drag and drop events
        dropZone.addEventListener('dragover', (e) => {
            e.preventDefault();
            dropZone.classList.add('dragover');
        });

        dropZone.addEventListener('dragleave', (e) => {
            e.preventDefault();
            dropZone.classList.remove('dragover');
        });

        dropZone.addEventListener('drop', (e) => {
            e.preventDefault();
            dropZone.classList.remove('dragover');
            handleFiles(e.dataTransfer.files);
        });
    }

    // File input change
    if (fileInput) {
        fileInput.addEventListener('change', (e) => {
            handleFiles(e.target.files);
        });
    }

    function handleFiles(files) {
        const allowedTypes = [
            'image/jpeg', 'image/png', 'image/gif', 'image/webp',
            'application/pdf',
            'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
            'application/vnd.ms-excel', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
            'text/csv',
            'application/vnd.ms-powerpoint', 'application/vnd.openxmlformats-officedocument.presentationml.presentation',
            'text/plain',
            'application/zip', 'application/x-rar-compressed'
        ];

        Array.from(files).forEach(file => {
            // Check max files limit
            if (selectedFiles.files.length >= MAX_FILES) {
                fileLimitWarning.style.display = 'flex';
                return;
            }

            // Check file size
            if (file.size > MAX_SIZE) {
                alert(`File "${file.name}" exceeds 1MB limit`);
                return;
            }

            // Check file type
            if (!allowedTypes.includes(file.type) && !file.name.match(/\.(rar)$/i)) {
                alert(`File type not allowed: ${file.name}`);
                return;
            }

            // Add to DataTransfer
            selectedFiles.items.add(file);
        });

        // Update file input
        fileInput.files = selectedFiles.files;
        
        // Show/hide warning
        fileLimitWarning.style.display = selectedFiles.files.length >= MAX_FILES ? 'flex' : 'none';
        
        // Render previews
        renderFilePreviews();
    }

    function renderFilePreviews() {
        filePreviewList.innerHTML = '';

        Array.from(selectedFiles.files).forEach((file, index) => {
            const item = document.createElement('div');
            item.className = 'file-preview-item';
            
            const iconClass = getFileIconClass(file.type, file.name);
            const icon = getFileIcon(file.type, file.name);
            
            item.innerHTML = `
                <div class="file-preview-icon ${iconClass}">
                    ${icon}
                </div>
                <div class="file-preview-info">
                    <div class="file-preview-name">${escapeHtml(file.name)}</div>
                    <div class="file-preview-size">${formatFileSize(file.size)}</div>
                </div>
                <button type="button" class="file-preview-remove" data-index="${index}" title="Remove file">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                </button>
            `;

            // Add image thumbnail if applicable
            if (file.type.startsWith('image/')) {
                const reader = new FileReader();
                reader.onload = (e) => {
                    const iconDiv = item.querySelector('.file-preview-icon');
                    iconDiv.outerHTML = `<img src="${e.target.result}" class="file-preview-thumbnail" alt="${escapeHtml(file.name)}">`;
                };
                reader.readAsDataURL(file);
            }

            filePreviewList.appendChild(item);
        });

        // Add remove handlers
        document.querySelectorAll('.file-preview-remove').forEach(btn => {
            btn.addEventListener('click', (e) => {
                e.preventDefault();
                const index = parseInt(btn.dataset.index);
                removeFile(index);
            });
        });
    }

    function removeFile(index) {
        const newFiles = new DataTransfer();
        Array.from(selectedFiles.files).forEach((file, i) => {
            if (i !== index) {
                newFiles.items.add(file);
            }
        });
        selectedFiles = newFiles;
        fileInput.files = selectedFiles.files;
        fileLimitWarning.style.display = selectedFiles.files.length >= MAX_FILES ? 'flex' : 'none';
        renderFilePreviews();
    }

    function getFileIconClass(mimeType, fileName) {
        if (mimeType.startsWith('image/')) return 'image';
        if (mimeType.includes('pdf') || mimeType.includes('word') || mimeType.includes('document')) return 'document';
        if (mimeType.includes('zip') || mimeType.includes('rar') || fileName.match(/\.(zip|rar)$/i)) return 'archive';
        return '';
    }

    function getFileIcon(mimeType, fileName) {
        if (mimeType.startsWith('image/')) {
            return `<svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
            </svg>`;
        }
        if (mimeType.includes('pdf')) {
            return `<svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"/>
            </svg>`;
        }
        if (mimeType.includes('zip') || mimeType.includes('rar') || fileName.match(/\.(zip|rar)$/i)) {
            return `<svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M5 8h14M5 8a2 2 0 110-4h14a2 2 0 110 4M5 8v10a2 2 0 002 2h10a2 2 0 002-2V8m-9 4h4"/>
            </svg>`;
        }
        return `<svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
        </svg>`;
    }

    function formatFileSize(bytes) {
        if (bytes >= 1073741824) return (bytes / 1073741824).toFixed(2) + ' GB';
        if (bytes >= 1048576) return (bytes / 1048576).toFixed(2) + ' MB';
        if (bytes >= 1024) return (bytes / 1024).toFixed(2) + ' KB';
        return bytes + ' bytes';
    }

    function escapeHtml(text) {
        const div = document.createElement('div');
        div.textContent = text;
        return div.innerHTML;
    }
});

// ========================================
// Items Used Functionality with Tax Support
// ========================================
const products = @json($products ?? []);
const taxesList = @json($taxes ?? []);
let itemIndex = 0;
let currentTaxCell = null;

function addItemRow(existingItem = null) {
    const tbody = document.getElementById('itemsBody');
    const emptyState = document.getElementById('itemsEmpty');
    const footer = document.getElementById('itemsFooter');
    
    if (!tbody) return;
    
    // Hide empty state, show footer
    emptyState.style.display = 'none';
    footer.style.display = 'flex';
    
    const row = document.createElement('tr');
    row.id = `item-row-${itemIndex}`;
    row.dataset.rowIndex = itemIndex;
    
    const productId = existingItem?.product_id || '';
    const quantity = existingItem?.quantity || '1';
    const unitPrice = existingItem?.unit_price || '';
    const taxIds = existingItem?.tax_ids || [];
    
    row.innerHTML = `
        <td class="item-product">
            <select name="items[${itemIndex}][product_id]" class="item-product-select" onchange="updateItemPrice(${itemIndex})" required>
                <option value="">Select Product</option>
                ${products.map(p => `<option value="${p.id}" data-price="${p.sale_price || p.purchase_price || 0}" ${p.id == productId ? 'selected' : ''}>${p.name} (${p.sku || 'N/A'})</option>`).join('')}
            </select>
        </td>
        <td class="item-qty">
            <input type="number" name="items[${itemIndex}][quantity]" value="${quantity}" min="0.01" step="0.01" class="item-quantity" oninput="calculateItemTotal(${itemIndex})" required>
        </td>
        <td class="item-price">
            <input type="number" name="items[${itemIndex}][unit_price]" value="${unitPrice}" min="0" step="0.01" class="item-unit-price" oninput="calculateItemTotal(${itemIndex})" placeholder="0.00">
        </td>
        <td class="item-tax">
            <input type="hidden" name="items[${itemIndex}][tax_ids]" class="tax-ids-hidden" value="[]">
            <div class="tax-badges-wrapper">
                <span class="add-tax-btn" onclick="showTaxDropdown(this, ${itemIndex})">+</span>
            </div>
        </td>
        <td class="item-total">
            <span id="item-total-${itemIndex}">0.00</span>
        </td>
        <td class="item-actions">
            <button type="button" class="btn-remove-item" onclick="removeItemRow(${itemIndex})" title="Remove">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                </svg>
            </button>
        </td>
    `;
    
    tbody.appendChild(row);
    
    // Load existing taxes if any - must do this BEFORE calculating total
    if (existingItem?.tax_ids) {
        renderTaxBadges(row, existingItem.tax_ids);
    }
    
    // Auto-set price if product selected
    const currentIndex = itemIndex;
    itemIndex++;
    
    if (productId) {
        updateItemPrice(currentIndex);
    } else {
        calculateItemTotal(currentIndex);
    }
}

function updateItemPrice(index) {
    const select = document.querySelector(`#item-row-${index} .item-product-select`);
    const priceInput = document.querySelector(`#item-row-${index} .item-unit-price`);
    
    if (select && priceInput) {
        const selectedOption = select.options[select.selectedIndex];
        const price = selectedOption.dataset.price || 0;
        
        // Only auto-fill if price input is empty
        if (!priceInput.value) {
            priceInput.value = parseFloat(price).toFixed(2);
        }
        
        calculateItemTotal(index);
    }
}

function calculateItemTotal(index) {
    const row = document.getElementById(`item-row-${index}`);
    if (!row) return;
    
    const qtyInput = row.querySelector('.item-quantity');
    const priceInput = row.querySelector('.item-unit-price');
    const totalSpan = document.getElementById(`item-total-${index}`);
    const taxIdsHidden = row.querySelector('.tax-ids-hidden');
    
    if (qtyInput && priceInput && totalSpan) {
        const qty = parseFloat(qtyInput.value) || 0;
        const price = parseFloat(priceInput.value) || 0;
        const subtotal = qty * price;
        
        // Calculate tax
        let taxAmount = 0;
        const taxIds = parseTaxIds(taxIdsHidden?.value);
        taxIds.forEach(taxId => {
            const tax = getTaxById(taxId);
            if (tax) {
                taxAmount += (subtotal * tax.rate) / 100;
            }
        });
        
        const total = subtotal + taxAmount;
        totalSpan.textContent = total.toFixed(2);
        calculateGrandTotal();
    }
}

function removeItemRow(index) {
    const row = document.getElementById(`item-row-${index}`);
    if (row) {
        row.remove();
        calculateGrandTotal();
        
        // Show empty state if no items left
        const tbody = document.getElementById('itemsBody');
        if (tbody && tbody.children.length === 0) {
            document.getElementById('itemsEmpty').style.display = 'block';
            document.getElementById('itemsFooter').style.display = 'none';
        }
    }
}

function calculateGrandTotal() {
    let subtotal = 0;
    let totalTax = 0;
    
    document.querySelectorAll('#itemsBody tr').forEach(row => {
        const qtyInput = row.querySelector('.item-quantity');
        const priceInput = row.querySelector('.item-unit-price');
        const taxIdsHidden = row.querySelector('.tax-ids-hidden');
        
        if (qtyInput && priceInput) {
            const qty = parseFloat(qtyInput.value) || 0;
            const price = parseFloat(priceInput.value) || 0;
            const rowSubtotal = qty * price;
            subtotal += rowSubtotal;
            
            // Calculate tax for this row
            const taxIds = parseTaxIds(taxIdsHidden?.value);
            taxIds.forEach(taxId => {
                const tax = getTaxById(taxId);
                if (tax) {
                    totalTax += (rowSubtotal * tax.rate) / 100;
                }
            });
        }
    });
    
    const grandTotal = subtotal + totalTax;
    
    const subtotalEl = document.getElementById('itemsSubtotal');
    const taxEl = document.getElementById('itemsTax');
    const grandTotalEl = document.getElementById('grandTotal');
    
    if (subtotalEl) subtotalEl.textContent = subtotal.toFixed(2);
    if (taxEl) taxEl.textContent = totalTax.toFixed(2);
    if (grandTotalEl) grandTotalEl.textContent = grandTotal.toFixed(2);
}

// Tax Helper Functions
function parseTaxIds(taxIds) {
    if (!taxIds) return [];
    if (Array.isArray(taxIds)) return taxIds.map(String);
    if (typeof taxIds === 'string') {
        try { 
            const p = JSON.parse(taxIds); 
            return Array.isArray(p) ? p.map(String) : [String(p)]; 
        } catch(e) { 
            return taxIds.split(',').map(id => id.trim()).filter(Boolean); 
        }
    }
    return [String(taxIds)];
}

function getTaxById(id) {
    return taxesList.find(t => String(t.id) === String(id));
}

function showTaxDropdown(btn, rowIndex) {
    const row = document.getElementById(`item-row-${rowIndex}`);
    currentTaxCell = row.querySelector('.item-tax');
    
    const selectedIds = parseTaxIds(row.querySelector('.tax-ids-hidden').value);
    const dropdown = document.getElementById('taxDropdown');
    const rect = btn.getBoundingClientRect();
    
    dropdown.style.top = (rect.bottom + 5) + 'px';
    dropdown.style.left = Math.min(rect.left, window.innerWidth - 240) + 'px';
    
    let html = '';
    if (taxesList.length === 0) {
        html = '<div style="padding: 14px; color: #666; text-align: center;">No taxes available</div>';
    } else {
        taxesList.forEach(tax => {
            const isSelected = selectedIds.includes(String(tax.id));
            html += `<div class="tax-dropdown-item ${isSelected ? 'selected' : ''}" data-tax-id="${tax.id}" data-row-index="${rowIndex}">
                <span>${tax.name}</span>
                <span style="display: flex; align-items: center; gap: 8px;">
                    <span class="tax-rate">${tax.rate}%</span>
                    ${isSelected ? '<span class="check-mark">✓</span>' : ''}
                </span>
            </div>`;
        });
    }
    
    dropdown.innerHTML = html;
    dropdown.classList.add('show');
    
    dropdown.querySelectorAll('.tax-dropdown-item').forEach(item => {
        item.addEventListener('click', function() {
            toggleTax(this.dataset.taxId, this.dataset.rowIndex);
        });
    });
}

function toggleTax(taxId, rowIndex) {
    const row = document.getElementById(`item-row-${rowIndex}`);
    const hidden = row.querySelector('.tax-ids-hidden');
    let selectedIds = parseTaxIds(hidden.value);
    
    const idx = selectedIds.indexOf(String(taxId));
    if (idx > -1) {
        selectedIds.splice(idx, 1);
    } else {
        selectedIds.push(String(taxId));
    }
    
    renderTaxBadges(row, selectedIds);
    document.getElementById('taxDropdown').classList.remove('show');
}

function renderTaxBadges(row, taxIds) {
    const container = row.querySelector('.tax-badges-wrapper');
    const hidden = row.querySelector('.tax-ids-hidden');
    const rowIndex = row.dataset.rowIndex;
    const ids = parseTaxIds(taxIds);
    
    let html = '';
    ids.forEach(id => {
        const tax = getTaxById(id);
        if (tax) {
            html += `<span class="tax-badge" data-id="${tax.id}">
                ${tax.rate}% ${tax.name}
                <span class="remove-tax" onclick="removeTax(event, '${tax.id}', '${rowIndex}')">×</span>
            </span>`;
        }
    });
    html += `<span class="add-tax-btn" onclick="showTaxDropdown(this, ${rowIndex})">+</span>`;
    
    container.innerHTML = html;
    hidden.value = JSON.stringify(ids);
    
    calculateItemTotal(parseInt(rowIndex));
}

function removeTax(event, taxId, rowIndex) {
    event.stopPropagation();
    const row = document.getElementById(`item-row-${rowIndex}`);
    const hidden = row.querySelector('.tax-ids-hidden');
    let selectedIds = parseTaxIds(hidden.value);
    
    const idx = selectedIds.indexOf(String(taxId));
    if (idx > -1) {
        selectedIds.splice(idx, 1);
    }
    
    renderTaxBadges(row, selectedIds);
}

// Close tax dropdown when clicking outside
document.addEventListener('click', function(e) {
    if (!e.target.closest('.tax-dropdown') && !e.target.closest('.add-tax-btn')) {
        document.getElementById('taxDropdown')?.classList.remove('show');
    }
});

// ========== TASK TYPE & RELATED ITEMS ==========
function loadRelatedItems() {
    const taskType = document.getElementById('taskType').value;
    const relatedGroup = document.getElementById('relatedItemGroup');
    const relatedSelect = document.getElementById('relatedItemSelect');
    const relatedLabel = document.getElementById('relatedItemLabelText');
    const relatedMessage = document.getElementById('relatedItemMessage');
    
    // Clear previous values
    document.getElementById('projectIdField').value = '';
    document.getElementById('serviceIdField').value = '';
    document.getElementById('contractIdField').value = '';
    document.getElementById('supportTicketIdField').value = '';
    document.getElementById('relatedNameField').value = '';
    relatedSelect.innerHTML = '<option value="">-- Select --</option>';
    relatedMessage.textContent = '';
    
    if (taskType === 'general') {
        relatedGroup.style.display = 'none';
        return;
    }
    
    // Show loading
    relatedGroup.style.display = 'block';
    relatedSelect.innerHTML = '<option value="">Loading...</option>';
    
    // Set label based on type
    const labels = {
        'project': 'Select Project',
        'service': 'Select Service',
        'contract': 'Select Contract',
        'support': 'Select Support Ticket'
    };
    relatedLabel.textContent = labels[taskType] || 'Select Item';
    
    // Fetch related items
    fetch('{{ route("admin.tasks.related-items") }}?type=' + taskType)
        .then(response => response.json())
        .then(data => {
            relatedSelect.innerHTML = '<option value="">-- Select --</option>';
            
            if (!data.available) {
                relatedMessage.textContent = data.message;
                relatedMessage.style.color = '#ef4444';
                return;
            }
            
            if (data.items.length === 0) {
                relatedMessage.textContent = data.message;
                relatedMessage.style.color = '#f59e0b';
                return;
            }
            
            relatedMessage.textContent = '';
            data.items.forEach(item => {
                const option = document.createElement('option');
                option.value = item.id;
                option.textContent = item.name;
                option.dataset.name = item.name;
                relatedSelect.appendChild(option);
            });
        })
        .catch(error => {
            console.error('Error loading related items:', error);
            relatedMessage.textContent = 'Error loading items';
            relatedMessage.style.color = '#ef4444';
        });
}

// Handle related item selection
document.getElementById('relatedItemSelect')?.addEventListener('change', function() {
    const taskType = document.getElementById('taskType').value;
    const selectedOption = this.options[this.selectedIndex];
    const selectedId = this.value;
    const selectedName = selectedOption.dataset.name || selectedOption.textContent;
    
    // Clear all
    document.getElementById('projectIdField').value = '';
    document.getElementById('serviceIdField').value = '';
    document.getElementById('contractIdField').value = '';
    document.getElementById('supportTicketIdField').value = '';
    
    // Set the appropriate field
    if (selectedId) {
        document.getElementById('relatedNameField').value = selectedName;
        
        switch(taskType) {
            case 'project':
                document.getElementById('projectIdField').value = selectedId;
                break;
            case 'service':
                document.getElementById('serviceIdField').value = selectedId;
                break;
            case 'contract':
                document.getElementById('contractIdField').value = selectedId;
                break;
            case 'support':
                document.getElementById('supportTicketIdField').value = selectedId;
                break;
        }
    }
});

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    loadRelatedItems();
});
</script>