<style>
/* Tasks Index - Fully Responsive */
.tasks-page { padding: 2rem; animation: fadeIn 0.4s ease; }
@keyframes fadeIn { from { opacity: 0; transform: translateY(10px); } to { opacity: 1; transform: translateY(0); } }
@keyframes slideIn { from { opacity: 0; transform: translateX(-20px); } to { opacity: 1; transform: translateX(0); } }
@keyframes pulse { 0%, 100% { transform: scale(1); } 50% { transform: scale(1.05); } }
@keyframes spin { to { transform: rotate(360deg); } }

/* Page Header */
.page-header { background: #3b82f6; padding: 1.5rem 2rem; border-radius: 0.5rem; margin-bottom: 1.5rem; box-shadow: 0 4px 6px -1px rgba(0,0,0,0.1); }
.header-content { display: flex; justify-content: space-between; align-items: center; gap: 1.5rem; flex-wrap: wrap; }
.header-left h1 { color: white; font-size: 1.25rem; font-weight: 700; margin: 0 0 4px 0; display: flex; align-items: center; gap: 0.5rem; }
.header-left h1 svg { width: 20px; height: 20px; }
.header-left p { color: rgba(255,255,255,0.9); font-size: 0.875rem; margin: 0; }

/* Search */
.header-search { flex: 1; max-width: 320px; min-width: 200px; position: relative; }
.header-search svg { position: absolute; left: 12px; top: 50%; transform: translateY(-50%); width: 14px; height: 14px; color: rgba(255,255,255,0.7); pointer-events: none; }
.header-search input { width: 100%; padding: 8px 12px 8px 32px; border-radius: 0.375rem; border: 1px solid rgba(255,255,255,0.3); font-size: 0.875rem; background: rgba(255,255,255,0.15); color: white; }
.header-search input::placeholder { color: rgba(255,255,255,0.7); }
.header-search input:focus { outline: none; background: white; color: #1a202c !important; border-color: white; }

/* Button */
.btn-primary { padding: 8px 16px; background: white; color: #3b82f6; border: none; border-radius: 0.375rem; font-size: 0.875rem; font-weight: 600; text-decoration: none; display: flex; align-items: center; gap: 6px; cursor: pointer; white-space: nowrap; }
.btn-primary:hover { transform: translateY(-1px); box-shadow: 0 4px 6px -1px rgba(0,0,0,0.1); }
.btn-primary svg { width: 14px; height: 14px; }

/* Stats */
.stats-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 1rem; margin-bottom: 1.5rem; }
.stat-card { background: #fff; border: 1px solid #e5e7eb; border-radius: 0.5rem; padding: 1rem 1.5rem; display: flex; align-items: center; gap: 1rem; transition: all 0.3s ease; animation: slideIn 0.3s ease; }
.stat-card:hover { transform: translateY(-2px) scale(1.02); box-shadow: 0 4px 6px -1px rgba(0,0,0,0.1); }
.stat-icon { width: 36px; height: 36px; border-radius: 0.375rem; display: flex; align-items: center; justify-content: center; flex-shrink: 0; }
.stat-icon svg { width: 18px; height: 18px; color: white; }
.stat-icon-primary { background: #3b82f6; }
.stat-icon-success { background: #10b981; }
.stat-icon-danger { background: #ef4444; }
.stat-content h3 { font-size: 1.25rem; font-weight: 700; color: #111827; margin: 0; }
.stat-content p { font-size: 0.75rem; color: #9ca3af; margin: 2px 0 0 0; text-transform: uppercase; letter-spacing: 0.05em; font-weight: 600; }

/* Filters */
.filters-card { background: #fff; border: 1px solid #e5e7eb; padding: 1rem 1.5rem; border-radius: 0.5rem; margin-bottom: 1.5rem; }
.filters-row { display: flex; gap: 1rem; align-items: center; flex-wrap: wrap; }
.quick-filters { display: flex; gap: 0.5rem; flex-wrap: wrap; }
.filter-btn { padding: 8px 14px; border: 1px solid #e5e7eb; background: #fff; color: #6b7280; border-radius: 0.375rem; font-size: 0.875rem; font-weight: 600; cursor: pointer; }
.filter-btn:hover { border-color: #3b82f6; color: #3b82f6; }
.filter-btn.active { background: #3b82f6; color: white; border-color: #3b82f6; }
.per-page { display: flex; align-items: center; gap: 0.5rem; margin-left: auto; }
.per-page label { font-size: 0.875rem; color: #6b7280; font-weight: 600; }
.per-page select { padding: 8px 12px; border: 1px solid #d1d5db; background: #fff; color: #111827; border-radius: 0.375rem; font-size: 0.875rem; cursor: pointer; }

/* Table Card */
.table-card { background: #fff; border: 1px solid #e5e7eb; border-radius: 0.5rem; padding: 1.5rem; }
.table-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem; padding-bottom: 1rem; border-bottom: 1px solid #e5e7eb; flex-wrap: wrap; gap: 0.5rem; }
.table-title { font-size: 1.125rem; font-weight: 700; color: #111827; display: flex; align-items: center; gap: 0.5rem; }
.table-title svg { width: 18px; height: 18px; color: #3b82f6; }
.pagination-info { font-size: 0.875rem; color: #9ca3af; font-weight: 600; }

/* Table */
.table-responsive { overflow-x: auto; -webkit-overflow-scrolling: touch; }
.data-table { width: 100%; border-collapse: separate; border-spacing: 0; }
.data-table thead th { background: #fff; padding: 12px 1rem; text-align: left; font-size: 0.875rem; font-weight: 600; color: #6b7280; border-bottom: 2px solid #e5e7eb; white-space: nowrap; cursor: pointer; }
.data-table thead th:hover { color: #3b82f6; }
.data-table thead th.sortable::after { content: '⇅'; margin-left: 4px; opacity: 0.3; font-size: 10px; }
.data-table thead th.sorting-asc::after { content: '↑'; opacity: 1; color: #3b82f6; }
.data-table thead th.sorting-desc::after { content: '↓'; opacity: 1; color: #3b82f6; }
.data-table tbody tr { border-bottom: 1px solid #e5e7eb; }
.data-table tbody tr:hover { background: #f9fafb; }
.data-table tbody tr.overdue-row { background: #fee2e2; }
.data-table tbody tr.overdue-row:hover { background: #fecaca; }
.data-table tbody td { padding: 14px 1rem; font-size: 0.9375rem; color: #111827; vertical-align: middle; }

/* Mobile Cards */
.mobile-cards { display: none; }
.task-card { background: #fff; border: 1px solid #e5e7eb; border-radius: 0.5rem; padding: 1rem; margin-bottom: 1rem; }
.task-card.overdue-card { background: #fee2e2; border-color: #fecaca; }
.task-card-header { display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 0.75rem; gap: 0.5rem; }
.task-card-id { font-weight: 700; color: #3b82f6; font-size: 0.875rem; }
.task-card-title { font-weight: 600; color: #111827; font-size: 1rem; margin-bottom: 0.75rem; line-height: 1.4; }
.task-card-meta { display: grid; grid-template-columns: repeat(2, 1fr); gap: 0.5rem 1rem; margin-bottom: 0.75rem; }
.task-card-meta-item { display: flex; flex-direction: column; gap: 2px; }
.task-card-meta-label { font-size: 0.7rem; color: #9ca3af; text-transform: uppercase; font-weight: 600; }
.task-card-meta-value { font-size: 0.875rem; color: #374151; font-weight: 500; }
.task-card-footer { display: flex; justify-content: space-between; align-items: center; padding-top: 0.75rem; border-top: 1px solid #e5e7eb; gap: 0.5rem; }
.task-card-badges { display: flex; gap: 0.5rem; flex-wrap: wrap; }

/* Badges */
.badge { padding: 4px 10px; border-radius: 12px; font-size: 0.7rem; font-weight: 600; text-transform: uppercase; display: inline-block; }
.badge-low { background: #d1fae5; color: #059669; }
.badge-medium { background: #dbeafe; color: #2563eb; }
.badge-high { background: #fef3c7; color: #d97706; }
.badge-critical { background: #fee2e2; color: #dc2626; }
.badge-info { background: #dbeafe; color: #2563eb; }

/* Actions */
.actions { display: flex; gap: 4px; }
.btn-icon { width: 32px; height: 32px; border: none; border-radius: 0.375rem; display: flex; align-items: center; justify-content: center; cursor: pointer; transition: all 0.2s ease; }
.btn-icon svg { width: 14px; height: 14px; }
.btn-icon:hover { transform: translateY(-1px) scale(1.1); }
.btn-view { background: #dbeafe; color: #3b82f6; }
.btn-view:hover { background: #3b82f6; color: white; }
.btn-edit { background: #fef3c7; color: #f59e0b; }
.btn-edit:hover { background: #f59e0b; color: white; }
.btn-delete { background: #fee2e2; color: #ef4444; }
.btn-delete:hover { background: #ef4444; color: white; }

/* Pagination */
.pagination { display: flex; justify-content: center; align-items: center; gap: 0.5rem; margin-top: 2rem; padding-top: 1.5rem; border-top: 1px solid #e5e7eb; flex-wrap: wrap; }
.page-btn { padding: 8px 14px; border: 1px solid #e5e7eb; background: #fff; color: #6b7280; border-radius: 0.375rem; font-size: 0.875rem; font-weight: 600; cursor: pointer; }
.page-btn:hover:not(:disabled) { border-color: #3b82f6; color: #3b82f6; }
.page-btn:disabled { opacity: 0.4; cursor: not-allowed; }
.page-btn.active { background: #3b82f6; color: white; border-color: #3b82f6; }

/* Empty & Loading */
.empty-state { text-align: center; padding: 64px 20px; }
.empty-state svg { width: 64px; height: 64px; color: #9ca3af; margin-bottom: 16px; }
.empty-state h3 { font-size: 1.125rem; color: #6b7280; margin-bottom: 8px; font-weight: 600; }
.empty-state p { font-size: 0.875rem; color: #9ca3af; }
.loading-spinner { display: flex; justify-content: center; align-items: center; padding: 3rem; }
.loading-spinner::after { content: ''; width: 32px; height: 32px; border: 3px solid #e5e7eb; border-top-color: #3b82f6; border-radius: 50%; animation: spin 0.8s linear infinite; }

/* Responsive */
@media (max-width: 1200px) {
    .stats-grid { grid-template-columns: repeat(4, 1fr); gap: 0.75rem; }
    .stat-card { padding: 0.875rem 1rem; }
    .stat-content h3 { font-size: 1.125rem; }
}
@media (max-width: 992px) {
    .tasks-page { padding: 1.5rem; }
    .header-left { flex: 0 0 100%; margin-bottom: 1rem; }
    .header-search { flex: 1; max-width: none; }
    .stats-grid { grid-template-columns: repeat(2, 1fr); }
    .data-table thead th, .data-table tbody td { padding: 10px 0.75rem; font-size: 0.8125rem; }
}
@media (max-width: 768px) {
    .tasks-page { padding: 1rem; }
    .page-header { padding: 1rem 1.25rem; }
    .header-left h1 { font-size: 1.125rem; }
    .header-search { order: 3; flex: 0 0 100%; }
    .stats-grid { grid-template-columns: repeat(2, 1fr); gap: 0.75rem; }
    .stat-card { padding: 0.75rem; gap: 0.75rem; }
    .stat-icon { width: 32px; height: 32px; }
    .stat-icon svg { width: 16px; height: 16px; }
    .stat-content h3 { font-size: 1rem; }
    .stat-content p { font-size: 0.65rem; }
    .filters-card { padding: 1rem; }
    .filters-row { flex-direction: column; align-items: stretch; gap: 0.75rem; }
    .quick-filters { width: 100%; overflow-x: auto; padding-bottom: 0.25rem; -webkit-overflow-scrolling: touch; }
    .filter-btn { padding: 6px 12px; font-size: 0.8125rem; flex-shrink: 0; }
    .per-page { margin-left: 0; }
    .table-card { padding: 1rem; }
    .table-header { flex-direction: column; align-items: flex-start; }
    .table-responsive { display: none; }
    .mobile-cards { display: block; }
    .page-btn { padding: 6px 10px; font-size: 0.8125rem; }
}
@media (max-width: 480px) {
    .tasks-page { padding: 0.75rem; }
    .page-header { padding: 1rem; border-radius: 0.375rem; }
    .header-left h1 { font-size: 1rem; }
    .btn-primary span { display: none; }
    .btn-primary svg { width: 16px; height: 16px; }
    .stats-grid { gap: 0.5rem; }
    .stat-card { padding: 0.625rem; gap: 0.5rem; }
    .stat-icon { width: 28px; height: 28px; }
    .stat-icon svg { width: 14px; height: 14px; }
    .stat-content h3 { font-size: 0.9375rem; }
    .stat-content p { font-size: 0.6rem; }
    .filter-btn { padding: 6px 10px; font-size: 0.75rem; }
    .task-card { padding: 0.875rem; }
    .task-card-footer { flex-direction: column; align-items: flex-start; gap: 0.75rem; }
    .task-card-badges { width: 100%; }
    .actions { width: 100%; justify-content: flex-end; }
    .btn-icon { width: 36px; height: 36px; }
    .page-btn:not(.page-nav):not(.active) { display: none; }
}
</style>

<div class="tasks-page">
    <div class="page-header">
        <div class="header-content">
            <div class="header-left">
                <h1>
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/></svg>
                    Tasks Management
                </h1>
                <p>Track and manage all your tasks</p>
            </div>
            <a href="{{ route('admin.tasks.create') }}" class="btn-primary">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4"/></svg>
                <span>Create Task</span>
            </a>
            <div class="header-search">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/></svg>
                <input type="text" id="searchInput" placeholder="Search tasks...">
            </div>
        </div>
    </div>

    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon stat-icon-primary"><svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/></svg></div>
            <div class="stat-content"><h3 id="totalTasks">{{ $stats['total'] }}</h3><p>Total Tasks</p></div>
        </div>
        <div class="stat-card">
            <div class="stat-icon stat-icon-primary"><svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/></svg></div>
            <div class="stat-content"><h3 id="myTasks">{{ $stats['my_tasks'] }}</h3><p>My Tasks</p></div>
        </div>
        <div class="stat-card">
            <div class="stat-icon stat-icon-danger"><svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg></div>
            <div class="stat-content"><h3 id="overdueTasks">{{ $stats['overdue'] }}</h3><p>Overdue</p></div>
        </div>
        <div class="stat-card">
            <div class="stat-icon stat-icon-success"><svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg></div>
            <div class="stat-content"><h3 id="completedTasks">{{ $stats['completed'] }}</h3><p>Completed</p></div>
        </div>
    </div>

    <div class="filters-card">
        <div class="filters-row">
            <div class="quick-filters">
                <button class="filter-btn active" onclick="applyFilter(this, 'all')">All</button>
                <button class="filter-btn" onclick="applyFilter(this, 'my_tasks')">My Tasks</button>
                <button class="filter-btn" onclick="applyFilter(this, 'overdue')">Overdue</button>
                <button class="filter-btn" onclick="applyFilter(this, 'completed')">Completed</button>
            </div>
            <div class="per-page">
                <label>Show:</label>
                <select id="perPageSelect" onchange="changePerPage(this.value)">
                    <option value="15" selected>15</option>
                    <option value="25">25</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                </select>
            </div>
        </div>
    </div>

    <div class="table-card">
        <div class="table-header">
            <h3 class="table-title">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"/></svg>
                All Tasks
            </h3>
            <div class="pagination-info" id="paginationInfo">Showing 0-0 of 0 tasks</div>
        </div>

        <div class="table-responsive">
            <table class="data-table">
                <thead>
                    <tr>
                        <th style="width:40px;"><input type="checkbox" id="selectAll" onchange="toggleSelectAll(this)"></th>
                        <th class="sortable" data-column="id">ID</th>
                        <th class="sortable" data-column="title">Title</th>
                        <th class="sortable" data-column="project_id">Project</th>
                        <th class="sortable" data-column="priority">Priority</th>
                        <th class="sortable" data-column="status_id">Status</th>
                        <th class="sortable" data-column="due_date">Due Date</th>
                        <th>Assigned To</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody id="tasksBody"></tbody>
            </table>
        </div>
        <div class="mobile-cards" id="mobileCards"></div>
        <div class="pagination" id="pagination" style="display:none;"></div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
let currentPage=1,perPage=15,totalRecords=0,lastPage=1,sortColumn='id',sortDirection='desc',selectedIds=[],currentFilter='all';

$(document).ready(function(){
    loadTasks();
    let searchTimeout;
    $('#searchInput').on('keyup',function(){clearTimeout(searchTimeout);searchTimeout=setTimeout(()=>{currentPage=1;loadTasks();},500);});
    $('.sortable').on('click',function(){
        const column=$(this).data('column');
        if(sortColumn===column){sortDirection=sortDirection==='asc'?'desc':'asc';}else{sortColumn=column;sortDirection='asc';}
        $('.sortable').removeClass('sorting-asc sorting-desc');$(this).addClass('sorting-'+sortDirection);loadTasks();
    });
});

function loadTasks(){
    $('#tasksBody').html('<tr><td colspan="9"><div class="loading-spinner"></div></td></tr>');
    $('#mobileCards').html('<div class="loading-spinner"></div>');
    $.ajax({
        url:'{{ route("admin.tasks.data") }}',type:'GET',
        data:{search:$('#searchInput').val(),filter_type:currentFilter,page:currentPage,per_page:perPage,sort:sortColumn,dir:sortDirection},
        success:function(r){renderTasks(r.data);renderMobileCards(r.data);updatePagination(r);},
        error:function(xhr){const m=xhr.responseJSON?.message||'Error';$('#tasksBody').html('<tr><td colspan="9"><div class="empty-state"><h3>Error</h3><p>'+m+'</p></div></td></tr>');$('#mobileCards').html('<div class="empty-state"><h3>Error</h3><p>'+m+'</p></div>');}
    });
}

function escapeHtml(t){if(!t)return'';const d=document.createElement('div');d.textContent=t;return d.innerHTML;}

function renderTasks(tasks){
    const tbody=$('#tasksBody');tbody.empty();
    if(tasks.length===0){tbody.append('<tr><td colspan="9"><div class="empty-state"><svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/></svg><h3>No Tasks Found</h3><p>No tasks match your criteria.</p></div></td></tr>');return;}
    tasks.forEach(task=>{
        const rc=task.is_overdue?'overdue-row':'';
        const ad=task.owners_count>1?'<span title="'+task.assignees_list+'">'+task.owner_display+' <span class="badge badge-info" style="font-size:10px;">+'+(task.owners_count-1)+'</span></span>':task.owner_display;
        tbody.append('<tr class="'+rc+'"><td><input type="checkbox" class="task-checkbox" value="'+task.id+'" onchange="toggleSelection(this)"></td><td><strong>#'+task.id+'</strong></td><td><strong>'+escapeHtml(task.title)+'</strong></td><td>'+escapeHtml(task.project_display)+'</td><td><span class="badge badge-'+task.priority+'">'+task.priority_display+'</span></td><td><span class="badge badge-info">'+task.status_display+'</span></td><td>'+task.due_date_display+'</td><td>'+ad+'</td><td><div class="actions"><a href="'+task._show_url+'" class="btn-icon btn-view" title="View"><svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/><path stroke-linecap="round" stroke-linejoin="round" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/></svg></a><a href="'+task._edit_url+'" class="btn-icon btn-edit" title="Edit"><svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/></svg></a><button class="btn-icon btn-delete" onclick="deleteTask('+task.id+')" title="Delete"><svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/></svg></button></div></td></tr>');
    });
}

function renderMobileCards(tasks){
    const c=$('#mobileCards');c.empty();
    if(tasks.length===0){c.html('<div class="empty-state"><svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/></svg><h3>No Tasks Found</h3><p>No tasks match your criteria.</p></div>');return;}
    tasks.forEach(task=>{
        const cc=task.is_overdue?'task-card overdue-card':'task-card';
        c.append('<div class="'+cc+'"><div class="task-card-header"><span class="task-card-id">#'+task.id+'</span><div class="task-card-badges"><span class="badge badge-'+task.priority+'">'+task.priority_display+'</span><span class="badge badge-info">'+task.status_display+'</span></div></div><div class="task-card-title">'+escapeHtml(task.title)+'</div><div class="task-card-meta"><div class="task-card-meta-item"><span class="task-card-meta-label">Project</span><span class="task-card-meta-value">'+escapeHtml(task.project_display)+'</span></div><div class="task-card-meta-item"><span class="task-card-meta-label">Due Date</span><span class="task-card-meta-value">'+task.due_date_display+'</span></div><div class="task-card-meta-item"><span class="task-card-meta-label">Assigned To</span><span class="task-card-meta-value">'+escapeHtml(task.owner_display)+(task.owners_count>1?' +'+(task.owners_count-1):'')+'</span></div></div><div class="task-card-footer"><div class="actions"><a href="'+task._show_url+'" class="btn-icon btn-view"><svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/><path stroke-linecap="round" stroke-linejoin="round" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/></svg></a><a href="'+task._edit_url+'" class="btn-icon btn-edit"><svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/></svg></a><button class="btn-icon btn-delete" onclick="deleteTask('+task.id+')"><svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/></svg></button></div></div></div>');
    });
}

function updatePagination(r){
    totalRecords=r.total||0;currentPage=r.current_page||1;lastPage=r.last_page||1;
    const s=totalRecords===0?0:((currentPage-1)*perPage)+1,e=Math.min(currentPage*perPage,totalRecords);
    $('#paginationInfo').text('Showing '+s+'-'+e+' of '+totalRecords+' tasks');
    const p=$('#pagination');if(lastPage<=1){p.hide();return;}p.show().empty();
    p.append('<button class="page-btn page-nav" onclick="goToPage('+(currentPage-1)+')" '+(currentPage===1?'disabled':'')+'>← Prev</button>');
    const max=5;let sp=Math.max(1,currentPage-Math.floor(max/2)),ep=Math.min(lastPage,sp+max-1);
    if(ep-sp<max-1)sp=Math.max(1,ep-max+1);
    if(sp>1){p.append('<button class="page-btn" onclick="goToPage(1)">1</button>');if(sp>2)p.append('<span style="padding:0 4px;color:#9ca3af;">...</span>');}
    for(let i=sp;i<=ep;i++)p.append('<button class="page-btn '+(i===currentPage?'active':'')+'" onclick="goToPage('+i+')">'+i+'</button>');
    if(ep<lastPage){if(ep<lastPage-1)p.append('<span style="padding:0 4px;color:#9ca3af;">...</span>');p.append('<button class="page-btn" onclick="goToPage('+lastPage+')">'+lastPage+'</button>');}
    p.append('<button class="page-btn page-nav" onclick="goToPage('+(currentPage+1)+')" '+(currentPage===lastPage?'disabled':'')+'>Next →</button>');
}

function goToPage(pg){if(pg<1||pg>lastPage)return;currentPage=pg;loadTasks();$('.table-card')[0].scrollIntoView({behavior:'smooth',block:'start'});}
function changePerPage(v){perPage=parseInt(v);currentPage=1;loadTasks();}
function applyFilter(btn,type){$('.filter-btn').removeClass('active');$(btn).addClass('active');currentFilter=type;currentPage=1;loadTasks();}
function toggleSelection(cb){const id=parseInt(cb.value);if(cb.checked)selectedIds.push(id);else selectedIds=selectedIds.filter(i=>i!==id);}
function toggleSelectAll(cb){$('.task-checkbox').prop('checked',cb.checked);selectedIds=cb.checked?$('.task-checkbox').map(function(){return parseInt(this.value);}).get():[];}
function deleteTask(id){if(!confirm('Are you sure you want to delete this task?'))return;$.ajax({url:'/admin/tasks/'+id,type:'DELETE',headers:{'X-CSRF-TOKEN':$('meta[name="csrf-token"]').attr('content')},success:function(r){if(r.success){loadTasks();updateStats();}},error:function(xhr){alert('Delete failed: '+(xhr.responseJSON?.message||'Error'));}});}
function updateStats(){$.ajax({url:'{{ route("admin.tasks.stats") }}',type:'GET',success:function(s){$('#totalTasks').text(s.total);$('#myTasks').text(s.my_tasks);$('#overdueTasks').text(s.overdue);$('#completedTasks').text(s.completed);}});}
</script>
