<?php

use Illuminate\Support\Facades\Route;
use Modules\Tasks\Http\Controllers\TaskController;
use Modules\Tasks\Http\Controllers\TimeLogController;
use App\Http\Middleware\EnsureIsAdmin;

// ==================== TASKS ====================
Route::prefix('admin/tasks')
    ->middleware([EnsureIsAdmin::class])
    ->name('admin.tasks.')
    ->group(function () {
        // List & Data
        Route::get('/', [TaskController::class, 'index'])->name('index');
        Route::get('/data', [TaskController::class, 'dataTable'])->name('data');
        Route::get('/stats', [TaskController::class, 'stats'])->name('stats');
        Route::get('/related-items', [TaskController::class, 'getRelatedItems'])->name('related-items');

        // Bulk Operations
        Route::post('/bulk-delete', [TaskController::class, 'bulkDelete'])->name('bulk-delete');
        Route::post('/bulk-status', [TaskController::class, 'bulkStatusUpdate'])->name('bulk-status');
        
        // CRUD
        Route::get('/create', [TaskController::class, 'create'])->name('create');
        Route::post('/', [TaskController::class, 'store'])->name('store');
        Route::get('/{id}', [TaskController::class, 'show'])->name('show');
        Route::get('/{id}/edit', [TaskController::class, 'edit'])->name('edit');
        Route::put('/{id}', [TaskController::class, 'update'])->name('update');
        Route::delete('/{id}', [TaskController::class, 'destroy'])->name('destroy');
        
        // Timer Actions (with GPS tracking)
        Route::post('/{id}/start-timer', [TaskController::class, 'startTimer'])->name('start-timer');
        Route::post('/{id}/pause-timer', [TaskController::class, 'pauseTimer'])->name('pause-timer');
        Route::post('/{id}/resume-timer', [TaskController::class, 'resumeTimer'])->name('resume-timer');
        Route::post('/{id}/stop-timer', [TaskController::class, 'stopTimer'])->name('stop-timer');
        
        // Task Comments & Attachments
         Route::post('/{id}/comment', [TaskController::class, 'addComment'])->name('comment');
        Route::post('/{id}/attach', [TaskController::class, 'attachFile'])->name('attach');
        Route::post('/{id}/upload-attachments', [TaskController::class, 'uploadAttachments'])->name('upload-attachments');  // ← ADD THIS LINE HERE
        Route::get('/attachment/{attachmentId}/download', [TaskController::class, 'downloadAttachment'])->name('download-attachment');
        Route::get('/attachment/{attachmentId}/preview', [TaskController::class, 'previewAttachment'])->name('preview-attachment');
        Route::delete('/{id}/attachment/{attachmentId}', [TaskController::class, 'deleteAttachment'])->name('delete-attachment');
    });

// ==================== TIME LOGS ====================
Route::prefix('admin/timelogs')
    ->middleware([EnsureIsAdmin::class])
    ->name('admin.timelogs.')
    ->group(function () {
        Route::get('/', [TimeLogController::class, 'index'])->name('index');
        Route::get('/data', [TimeLogController::class, 'dataTable'])->name('data');
        Route::get('/stats', [TimeLogController::class, 'stats'])->name('stats');
        Route::get('/{id}', [TimeLogController::class, 'show'])->name('show');
        Route::delete('/{id}', [TimeLogController::class, 'destroy'])->name('destroy');
        Route::post('/bulk-delete', [TimeLogController::class, 'bulkDelete'])->name('bulk-delete');
    });
