<?php

return [
    'name' => 'AdvancedEmail',
    'version' => '1.0.0',
    
    /*
    |--------------------------------------------------------------------------
    | Permissions
    |--------------------------------------------------------------------------
    | These permissions will be seeded when the module is installed
    */
    'permissions' => [
        // My Settings
        'advancedemail.settings.view' => 'View My Email Settings',
        'advancedemail.settings.edit' => 'Edit My Email Settings',
        
        // Staff Management (Admin)
        'advancedemail.staff.view' => 'View Staff Email Settings',
        'advancedemail.staff.edit' => 'Edit Staff Email Settings',
        'advancedemail.staff.delete' => 'Delete Staff Email Settings',
        'advancedemail.staff.permissions' => 'Manage Staff Email Permissions',
        
        // Logs
        'advancedemail.logs.view' => 'View Email Logs',
        'advancedemail.logs.delete' => 'Delete Email Logs',
        'advancedemail.activity.view' => 'View Activity Logs',
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Menu Items
    |--------------------------------------------------------------------------
    | These menus will be inserted when the module is installed
    */
    'menu' => [
        [
            'name' => 'Email Settings',
            'icon' => 'envelope-open-text',
            'permission' => 'advancedemail.settings.view',
            'children' => [
                ['name' => 'My Email Settings', 'route' => 'admin.advancedemail.settings.index', 'permission' => 'advancedemail.settings.view'],
                ['name' => 'Manage Staff Emails', 'route' => 'admin.advancedemail.staff.index', 'permission' => 'advancedemail.staff.view'],
                ['name' => 'Email Logs', 'route' => 'admin.advancedemail.logs.index', 'permission' => 'advancedemail.logs.view'],
                ['name' => 'Activity Log', 'route' => 'admin.advancedemail.activity.index', 'permission' => 'advancedemail.activity.view'],
            ],
        ],
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Default Email Settings
    |--------------------------------------------------------------------------
    */
    'default_mailer' => env('MAIL_MAILER', 'smtp'),
    
    /*
    |--------------------------------------------------------------------------
    | Encryption Options
    |--------------------------------------------------------------------------
    */
    'encryption_options' => [
        '' => 'None',
        'ssl' => 'SSL',
        'tls' => 'TLS',
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Email Log Settings
    |--------------------------------------------------------------------------
    */
    'log_enabled' => true,
    'log_retention_days' => 30,
    
    /*
    |--------------------------------------------------------------------------
    | Common SMTP Ports
    |--------------------------------------------------------------------------
    */
    'common_ports' => [
        '25' => 'Port 25 (Standard)',
        '465' => 'Port 465 (SSL)',
        '587' => 'Port 587 (TLS)',
        '2525' => 'Port 2525 (Alternative)',
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Supported Email Types
    |--------------------------------------------------------------------------
    */
    'email_types' => [
        'invoice' => 'Invoice Emails',
        'proposal' => 'Proposal Emails',
        'estimate' => 'Estimate Emails',
        'task' => 'Task Notifications',
        'project' => 'Project Notifications',
        'general' => 'General Emails',
    ],
];
