<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Staff Email Settings Table
        Schema::create('staff_email_settings', function (Blueprint $table) {
            $table->id();
            $table->integer('staff_id')->unsigned();
            $table->string('email')->nullable();
            $table->string('from_name')->nullable();
            $table->enum('mail_driver', ['smtp', 'sendmail', 'mail'])->default('smtp');
            $table->string('smtp_host')->nullable();
            $table->integer('smtp_port')->default(587);
            $table->enum('smtp_encryption', ['', 'ssl', 'tls'])->default('tls');
            $table->string('smtp_username')->nullable();
            $table->text('smtp_password')->nullable(); // Encrypted
            $table->string('email_charset')->default('utf-8');
            $table->boolean('is_active')->default(false);
            $table->boolean('is_verified')->default(false);
            $table->timestamp('last_verified_at')->nullable();
            $table->timestamps();
            
            $table->unique('staff_id');
            $table->index('staff_id');
        });

        // Email Activity Log Table
        Schema::create('email_activity_logs', function (Blueprint $table) {
            $table->id();
            $table->integer('staff_id')->unsigned();
            $table->integer('target_staff_id')->unsigned()->nullable();
            $table->string('action');
            $table->text('description')->nullable();
            $table->string('ip_address')->nullable();
            $table->text('user_agent')->nullable();
            $table->timestamps();
            
            $table->index('staff_id');
            $table->index('target_staff_id');
            $table->index('action');
        });

        // Email Send Log Table
        Schema::create('email_send_logs', function (Blueprint $table) {
            $table->id();
            $table->integer('staff_id')->unsigned();
            $table->string('from_email');
            $table->string('to_email');
            $table->string('cc_email')->nullable();
            $table->string('bcc_email')->nullable();
            $table->string('subject');
            $table->string('email_type')->default('general'); // invoice, proposal, estimate, task, project
            $table->unsignedBigInteger('related_id')->nullable(); // Related record ID
            $table->enum('status', ['pending', 'sent', 'failed'])->default('pending');
            $table->text('error_message')->nullable();
            $table->timestamps();
            
            $table->index('staff_id');
            $table->index(['email_type', 'related_id']);
            $table->index('status');
        });

        // Staff Email Permissions Table (Admin can enable/disable staff email configuration)
        Schema::create('staff_email_permissions', function (Blueprint $table) {
            $table->id();
            $table->integer('staff_id')->unsigned();
            $table->boolean('can_configure_email')->default(false);
            $table->boolean('use_own_email_for_invoices')->default(true);
            $table->boolean('use_own_email_for_proposals')->default(true);
            $table->boolean('use_own_email_for_estimates')->default(true);
            $table->boolean('use_own_email_for_tasks')->default(true);
            $table->boolean('use_own_email_for_projects')->default(true);
            $table->integer('granted_by')->unsigned()->nullable();
            $table->timestamps();
            
            $table->unique('staff_id');
            $table->index('staff_id');
            $table->index('granted_by');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('staff_email_permissions');
        Schema::dropIfExists('email_send_logs');
        Schema::dropIfExists('email_activity_logs');
        Schema::dropIfExists('staff_email_settings');
    }
};
