<?php

namespace Modules\AdvancedEmail\Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class AdvancedEmailSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Register Permissions
        $this->registerPermissions();
    }

    /**
     * Register all advanced email permissions
     */
    protected function registerPermissions(): void
    {
        $permissions = config('advancedemail.permissions', []);
        
        foreach ($permissions as $name => $description) {
            Permission::firstOrCreate(
                ['name' => $name, 'guard_name' => 'admin'],
                ['name' => $name, 'guard_name' => 'admin']
            );
        }
    }
}
