<?php

use Modules\AdvancedEmail\Services\AdvancedEmailService;

if (!function_exists('advancedEmailService')) {
    /**
     * Get the AdvancedEmailService instance
     */
    function advancedEmailService(): AdvancedEmailService
    {
        return app(AdvancedEmailService::class);
    }
}

if (!function_exists('configureStaffMailer')) {
    /**
     * Configure mailer for staff
     */
    function configureStaffMailer(int $staffId, string $emailType = 'general'): bool
    {
        return advancedEmailService()->configureMailer($staffId, $emailType);
    }
}

if (!function_exists('restoreDefaultMailer')) {
    /**
     * Restore default mailer configuration
     */
    function restoreDefaultMailer(): void
    {
        advancedEmailService()->restoreMailer();
    }
}

if (!function_exists('hasActiveEmailSettings')) {
    /**
     * Check if staff has active email settings
     */
    function hasActiveEmailSettings(int $staffId): bool
    {
        return advancedEmailService()->hasActiveSettings($staffId);
    }
}

if (!function_exists('sendEmailWithStaffSettings')) {
    /**
     * Send email using staff settings
     */
    function sendEmailWithStaffSettings($mailable, string $to, array $options = []): bool
    {
        return advancedEmailService()->sendEmail($mailable, $to, $options);
    }
}

if (!function_exists('getStaffFromEmail')) {
    /**
     * Get the "from" email for a staff member
     */
    function getStaffFromEmail(int $staffId): ?string
    {
        $settings = \Modules\AdvancedEmail\Models\StaffEmailSetting::where('staff_id', $staffId)
            ->where('is_active', true)
            ->first();
        
        return $settings ? $settings->email : null;
    }


    


    }
