<?php

namespace Modules\AdvancedEmail\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Admin\Staff;

class EmailActivityLog extends Model
{
    protected $table = 'email_activity_logs';

    protected $fillable = [
        'staff_id',
        'target_staff_id',
        'action',
        'description',
        'ip_address',
        'user_agent',
    ];

    /**
     * Relationship to staff who performed the action
     */
    public function staff()
    {
        return $this->belongsTo(Staff::class, 'staff_id', 'id');
    }

    /**
     * Relationship to target staff
     */
    public function targetStaff()
    {
        return $this->belongsTo(Staff::class, 'target_staff_id', 'id');
    }

    /**
     * Log an activity
     */
    public static function logActivity($action, $description = null, $targetStaffId = null)
    {
        $user = auth()->guard('admin')->user();
        $staffId = null;
        
        if ($user) {
            $staffId = $user->staffid ?? ($user->staff ? $user->staff->id : $user->id);
        }

        return static::create([
            'staff_id' => $staffId,
            'target_staff_id' => $targetStaffId,
            'action' => $action,
            'description' => $description,
            'ip_address' => request()->ip(),
            'user_agent' => request()->userAgent(),
        ]);
    }

    /**
     * Get action label
     */
    public function getActionLabelAttribute()
    {
        $labels = [
            'settings_created' => 'Email Settings Created',
            'settings_updated' => 'Email Settings Updated',
            'settings_deleted' => 'Email Settings Deleted',
            'permission_granted' => 'Permission Granted',
            'permission_revoked' => 'Permission Revoked',
            'test_email_sent' => 'Test Email Sent',
            'test_email_success' => 'Test Email Successful',
            'test_email_failed' => 'Test Email Failed',
            'settings_verified' => 'Settings Verified',
            'settings_activated' => 'Settings Activated',
            'settings_deactivated' => 'Settings Deactivated',
        ];

        return $labels[$this->action] ?? ucwords(str_replace('_', ' ', $this->action));
    }
}
