<style>
    :root {
        --module-primary: #4e73df;
        --module-success: #1cc88a;
        --module-danger: #e74a3b;
        --module-warning: #f6c23e;
        --module-info: #36b9cc;
        --module-secondary: #858796;
        --module-light: #f8f9fc;
        --module-dark: #5a5c69;
        --module-border: #e3e6f0;
        --module-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
    }

    .module-card {
        background: #fff;
        border-radius: 0.35rem;
        box-shadow: var(--module-shadow);
        border: 1px solid var(--module-border);
        margin-bottom: 1.5rem;
    }

    .module-card-header {
        background: linear-gradient(135deg, var(--module-primary), #224abe);
        color: #fff;
        padding: 1rem 1.25rem;
        border-radius: 0.35rem 0.35rem 0 0;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .module-card-header h5 {
        margin: 0;
        font-weight: 600;
    }

    .module-card-body {
        padding: 1.25rem;
    }

    .module-btn {
        padding: 0.5rem 1rem;
        border-radius: 0.35rem;
        font-weight: 500;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        border: none;
        cursor: pointer;
        transition: all 0.2s;
    }

    .module-btn-primary {
        background: var(--module-primary);
        color: #fff;
    }

    .module-btn-primary:hover {
        background: #224abe;
        color: #fff;
    }

    .module-btn-danger {
        background: var(--module-danger);
        color: #fff;
    }

    .module-btn-danger:hover {
        background: #c23321;
        color: #fff;
    }

    .module-btn-secondary {
        background: var(--module-secondary);
        color: #fff;
    }

    .module-btn-secondary:hover {
        background: #6c6e7e;
        color: #fff;
    }

    .module-btn-sm {
        padding: 0.25rem 0.75rem;
        font-size: 0.875rem;
    }

    .module-table {
        width: 100%;
        border-collapse: collapse;
    }

    .module-table th {
        background: var(--module-light);
        padding: 0.75rem;
        text-align: left;
        font-weight: 600;
        color: var(--module-dark);
        border-bottom: 2px solid var(--module-border);
    }

    .module-table td {
        padding: 0.75rem;
        border-bottom: 1px solid var(--module-border);
        vertical-align: middle;
    }

    .module-table tbody tr:hover {
        background: var(--module-light);
    }

    .module-badge {
        padding: 0.35rem 0.65rem;
        border-radius: 0.25rem;
        font-size: 0.75rem;
        font-weight: 600;
        display: inline-block;
    }

    .module-badge-primary {
        background: rgba(78, 115, 223, 0.1);
        color: var(--module-primary);
    }

    .module-badge-success {
        background: rgba(28, 200, 138, 0.1);
        color: var(--module-success);
    }

    .module-badge-warning {
        background: rgba(246, 194, 62, 0.1);
        color: #c49b1a;
    }

    .module-badge-danger {
        background: rgba(231, 74, 59, 0.1);
        color: var(--module-danger);
    }

    .module-badge-info {
        background: rgba(54, 185, 204, 0.1);
        color: var(--module-info);
    }

    .module-badge-secondary {
        background: rgba(133, 135, 150, 0.1);
        color: var(--module-secondary);
    }

    .module-form-group {
        margin-bottom: 1rem;
    }

    .module-label {
        display: block;
        margin-bottom: 0.5rem;
        font-weight: 500;
        color: var(--module-dark);
    }

    .module-input, .module-select {
        width: 100%;
        padding: 0.5rem 0.75rem;
        border: 1px solid var(--module-border);
        border-radius: 0.35rem;
        font-size: 0.875rem;
        transition: border-color 0.2s;
    }

    .module-input:focus, .module-select:focus {
        outline: none;
        border-color: var(--module-primary);
        box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
    }

    .module-alert {
        padding: 1rem 1.25rem;
        border-radius: 0.35rem;
        margin-bottom: 1rem;
    }

    .module-alert-success {
        background: rgba(28, 200, 138, 0.1);
        border: 1px solid var(--module-success);
        color: #0f6848;
    }

    .module-alert-danger {
        background: rgba(231, 74, 59, 0.1);
        border: 1px solid var(--module-danger);
        color: #a32b1f;
    }

    .filter-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
        gap: 1rem;
        margin-bottom: 1rem;
    }

    .stats-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
        gap: 1rem;
        margin-bottom: 1.5rem;
    }

    .stat-card {
        background: var(--module-light);
        padding: 1rem;
        border-radius: 0.35rem;
        text-align: center;
        border-left: 4px solid var(--module-primary);
    }

    .stat-card.success { border-left-color: var(--module-success); }
    .stat-card.warning { border-left-color: var(--module-warning); }
    .stat-card.info { border-left-color: var(--module-info); }
    .stat-card.danger { border-left-color: var(--module-danger); }

    .stat-value {
        font-size: 1.5rem;
        font-weight: 700;
        color: var(--module-dark);
    }

    .stat-label {
        font-size: 0.75rem;
        color: var(--module-secondary);
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .staff-info {
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }

    .staff-avatar {
        width: 32px;
        height: 32px;
        border-radius: 50%;
        object-fit: cover;
        background: var(--module-primary);
        display: flex;
        align-items: center;
        justify-content: center;
        color: #fff;
        font-weight: 600;
        font-size: 0.75rem;
    }

    .action-text {
        max-width: 300px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }

    .description-text {
        max-width: 400px;
        font-size: 0.875rem;
        color: var(--module-secondary);
    }

    .header-actions {
        display: flex;
        gap: 0.5rem;
    }

    .pagination-wrapper {
        display: flex;
        justify-content: center;
        margin-top: 1rem;
    }

    .empty-state {
        text-align: center;
        padding: 3rem;
        color: var(--module-secondary);
    }

    .empty-state i {
        font-size: 3rem;
        margin-bottom: 1rem;
        opacity: 0.5;
    }

    .ip-info {
        font-size: 0.75rem;
        color: var(--module-secondary);
    }
</style>

<div class="container-fluid">
    @if(session('success'))
        <div class="module-alert module-alert-success">
            <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
        </div>
    @endif

    @if(session('error'))
        <div class="module-alert module-alert-danger">
            <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
        </div>
    @endif

    <!-- Stats Cards -->
    <div class="stats-row">
        <div class="stat-card">
            <div class="stat-value">{{ $stats['total'] ?? 0 }}</div>
            <div class="stat-label">Total Activities</div>
        </div>
        <div class="stat-card success">
            <div class="stat-value">{{ $stats['settings_created'] ?? 0 }}</div>
            <div class="stat-label">Settings Created</div>
        </div>
        <div class="stat-card warning">
            <div class="stat-value">{{ $stats['settings_updated'] ?? 0 }}</div>
            <div class="stat-label">Settings Updated</div>
        </div>
        <div class="stat-card info">
            <div class="stat-value">{{ $stats['test_emails'] ?? 0 }}</div>
            <div class="stat-label">Test Emails Sent</div>
        </div>
    </div>

    <div class="module-card">
        <div class="module-card-header">
            <h5><i class="fas fa-history me-2"></i>Activity Logs</h5>
            <div class="header-actions">
                <form action="{{ route('admin.advancedemail.activity.clear-old', 30) }}" method="POST" style="display: inline;" onsubmit="return confirm('Clear logs older than 30 days?')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="module-btn module-btn-secondary module-btn-sm">
                        <i class="fas fa-calendar-minus"></i> Clear Old (30+ days)
                    </button>
                </form>
                <form action="{{ route('admin.advancedemail.activity.clear-all') }}" method="POST" style="display: inline;" onsubmit="return confirm('Are you sure you want to clear ALL activity logs? This cannot be undone.')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="module-btn module-btn-danger module-btn-sm">
                        <i class="fas fa-trash"></i> Clear All
                    </button>
                </form>
            </div>
        </div>
        <div class="module-card-body">
            <!-- Filters -->
            <form action="{{ route('admin.advancedemail.activity.index') }}" method="GET">
                <div class="filter-row">
                    <div class="module-form-group" style="margin-bottom: 0;">
                        <input type="text" name="search" class="module-input" placeholder="Search description..." value="{{ request('search') }}">
                    </div>
                    <div class="module-form-group" style="margin-bottom: 0;">
                        <select name="action" class="module-select">
                            <option value="">All Actions</option>
                            <option value="settings_created" {{ request('action') == 'settings_created' ? 'selected' : '' }}>Settings Created</option>
                            <option value="settings_updated" {{ request('action') == 'settings_updated' ? 'selected' : '' }}>Settings Updated</option>
                            <option value="settings_deleted" {{ request('action') == 'settings_deleted' ? 'selected' : '' }}>Settings Deleted</option>
                            <option value="settings_activated" {{ request('action') == 'settings_activated' ? 'selected' : '' }}>Settings Activated</option>
                            <option value="settings_deactivated" {{ request('action') == 'settings_deactivated' ? 'selected' : '' }}>Settings Deactivated</option>
                            <option value="test_email_sent" {{ request('action') == 'test_email_sent' ? 'selected' : '' }}>Test Email Sent</option>
                            <option value="test_email_failed" {{ request('action') == 'test_email_failed' ? 'selected' : '' }}>Test Email Failed</option>
                            <option value="permission_granted" {{ request('action') == 'permission_granted' ? 'selected' : '' }}>Permission Granted</option>
                            <option value="permission_revoked" {{ request('action') == 'permission_revoked' ? 'selected' : '' }}>Permission Revoked</option>
                        </select>
                    </div>
                    <div class="module-form-group" style="margin-bottom: 0;">
                        <select name="staff_id" class="module-select">
                            <option value="">All Staff</option>
                            @foreach($staffList as $staff)
                                <option value="{{ $staff->staffid }}" {{ request('staff_id') == $staff->staffid ? 'selected' : '' }}>
                                    {{ $staff->firstname }} {{ $staff->lastname }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="module-form-group" style="margin-bottom: 0;">
                        <input type="date" name="date_from" class="module-input" value="{{ request('date_from') }}" placeholder="From Date">
                    </div>
                    <div class="module-form-group" style="margin-bottom: 0;">
                        <input type="date" name="date_to" class="module-input" value="{{ request('date_to') }}" placeholder="To Date">
                    </div>
                    <div class="module-form-group" style="margin-bottom: 0;">
                        <button type="submit" class="module-btn module-btn-primary" style="width: 100%;">
                            <i class="fas fa-filter"></i> Filter
                        </button>
                    </div>
                </div>
            </form>

            @if($logs->count() > 0)
                <div class="table-responsive">
                    <table class="module-table">
                        <thead>
                            <tr>
                                <th>Date/Time</th>
                                <th>Staff</th>
                                <th>Action</th>
                                <th>Description</th>
                                <th>Target Staff</th>
                                <th>IP Address</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($logs as $log)
                                <tr>
                                    <td>
                                        <strong>{{ $log->created_at->format('M d, Y') }}</strong><br>
                                        <small class="text-muted">{{ $log->created_at->format('h:i A') }}</small>
                                    </td>
                                    <td>
                                        @if($log->staff)
                                            <div class="staff-info">
                                                @if($log->staff->profile_image)
                                                    <img src="{{ asset('uploads/staff_profile_images/' . $log->staff->profile_image) }}" alt="" class="staff-avatar">
                                                @else
                                                    <div class="staff-avatar">
                                                        {{ strtoupper(substr($log->staff->firstname, 0, 1)) }}{{ strtoupper(substr($log->staff->lastname, 0, 1)) }}
                                                    </div>
                                                @endif
                                                <div>
                                                    <strong>{{ $log->staff->firstname }} {{ $log->staff->lastname }}</strong>
                                                </div>
                                            </div>
                                        @else
                                            <span class="text-muted">System</span>
                                        @endif
                                    </td>
                                    <td>
                                        @php
                                            $actionBadges = [
                                                'settings_created' => 'success',
                                                'settings_updated' => 'warning',
                                                'settings_deleted' => 'danger',
                                                'settings_activated' => 'success',
                                                'settings_deactivated' => 'secondary',
                                                'test_email_sent' => 'info',
                                                'test_email_failed' => 'danger',
                                                'permission_granted' => 'success',
                                                'permission_revoked' => 'warning',
                                                'type_permissions_updated' => 'info'
                                            ];
                                            $badgeClass = $actionBadges[$log->action] ?? 'secondary';
                                        @endphp
                                        <span class="module-badge module-badge-{{ $badgeClass }}">
                                            {{ ucwords(str_replace('_', ' ', $log->action)) }}
                                        </span>
                                    </td>
                                    <td>
                                        <div class="description-text" title="{{ $log->description }}">
                                            {{ $log->description }}
                                        </div>
                                    </td>
                                    <td>
                                        @if($log->target_staff_id && $log->targetStaff)
                                            <span class="module-badge module-badge-primary">
                                                {{ $log->targetStaff->firstname }} {{ $log->targetStaff->lastname }}
                                            </span>
                                        @elseif($log->target_staff_id)
                                            <span class="text-muted">Staff #{{ $log->target_staff_id }}</span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="ip-info">
                                            {{ $log->ip_address ?? '-' }}
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="pagination-wrapper">
                    {{ $logs->appends(request()->query())->links() }}
                </div>
            @else
                <div class="empty-state">
                    <i class="fas fa-history"></i>
                    <h5>No Activity Logs Found</h5>
                    <p>Activity logs will appear here when email settings are configured or modified.</p>
                </div>
            @endif
        </div>
    </div>
</div>
