<style>
:root {
    --primary: #3b82f6;
    --primary-dark: #2563eb;
    --success: #10b981;
    --danger: #ef4444;
    --warning: #f59e0b;
    --info: #06b6d4;
    --card-bg: #ffffff;
    --card-border: #e5e7eb;
    --text-primary: #1f2937;
    --text-secondary: #6b7280;
    --text-muted: #9ca3af;
    --hover-bg: #f9fafb;
    --input-border: #d1d5db;
    --input-focus: #3b82f6;
}

.module-container {
    max-width: 1400px;
    margin: 0 auto;
    padding: 20px;
}

.module-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 24px;
    flex-wrap: wrap;
    gap: 16px;
}

.module-header h1 {
    font-size: 24px;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0;
}

.header-actions {
    display: flex;
    gap: 12px;
    flex-wrap: wrap;
}

.module-card {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 12px;
    margin-bottom: 20px;
    overflow: hidden;
}

.module-card-header {
    padding: 16px 20px;
    border-bottom: 1px solid var(--card-border);
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 12px;
}

.module-card-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0;
}

.module-card-body {
    padding: 0;
}

.module-btn {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 8px 14px;
    border-radius: 8px;
    font-size: 13px;
    font-weight: 500;
    cursor: pointer;
    border: none;
    text-decoration: none;
    transition: all 0.2s;
}

.module-btn-sm {
    padding: 6px 10px;
    font-size: 12px;
}

.module-btn-primary {
    background: var(--primary);
    color: white;
}

.module-btn-secondary {
    background: #f3f4f6;
    color: var(--text-primary);
    border: 1px solid var(--card-border);
}

.module-btn-danger {
    background: var(--danger);
    color: white;
}

.module-btn-success {
    background: var(--success);
    color: white;
}

.module-table {
    width: 100%;
    border-collapse: collapse;
}

.module-table th {
    background: var(--hover-bg);
    padding: 12px 16px;
    text-align: left;
    font-size: 12px;
    font-weight: 600;
    color: var(--text-secondary);
    text-transform: uppercase;
    border-bottom: 1px solid var(--card-border);
}

.module-table td {
    padding: 12px 16px;
    border-bottom: 1px solid var(--card-border);
    font-size: 14px;
    color: var(--text-primary);
}

.module-table tbody tr:hover {
    background: var(--hover-bg);
}

.module-badge {
    display: inline-flex;
    align-items: center;
    gap: 4px;
    padding: 4px 10px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 500;
}

.module-badge-success { background: #d1fae5; color: #065f46; }
.module-badge-danger { background: #fee2e2; color: #991b1b; }
.module-badge-warning { background: #fef3c7; color: #92400e; }
.module-badge-info { background: #dbeafe; color: #1e40af; }

.module-alert {
    padding: 12px 16px;
    border-radius: 8px;
    margin-bottom: 16px;
    font-size: 14px;
}

.module-alert-success { background: #d1fae5; color: #065f46; border: 1px solid #a7f3d0; }
.module-alert-danger { background: #fee2e2; color: #991b1b; border: 1px solid #fecaca; }

.filter-section {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
    gap: 12px;
    padding: 16px 20px;
    background: var(--hover-bg);
    border-bottom: 1px solid var(--card-border);
}

.module-input, .module-select {
    width: 100%;
    padding: 8px 12px;
    border: 1px solid var(--input-border);
    border-radius: 6px;
    font-size: 13px;
    color: var(--text-primary);
    background: white;
}

.module-input:focus, .module-select:focus {
    outline: none;
    border-color: var(--input-focus);
}

.email-cell {
    max-width: 200px;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

.subject-cell {
    max-width: 250px;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

.empty-state {
    text-align: center;
    padding: 60px 20px;
    color: var(--text-muted);
}

.pagination-wrapper {
    padding: 16px 20px;
    border-top: 1px solid var(--card-border);
}

.stats-mini {
    display: flex;
    gap: 16px;
    flex-wrap: wrap;
}

.stat-mini-item {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 13px;
}

.stat-mini-value {
    font-weight: 600;
}
</style>

<div class="module-container">
    <div class="module-header">
        <h1><i class="fa fa-history"></i> Email Send Logs</h1>
        <div class="header-actions">
            <a href="{{ route('admin.advancedemail.logs.export', request()->query()) }}" class="module-btn module-btn-secondary">
                <i class="fa fa-download"></i> Export CSV
            </a>
            <form action="{{ route('admin.advancedemail.logs.clear-all') }}" method="POST" 
                  onsubmit="return confirm('Are you sure you want to clear all logs?');" style="display: inline;">
                @csrf
                <button type="submit" class="module-btn module-btn-danger">
                    <i class="fa fa-trash"></i> Clear All
                </button>
            </form>
        </div>
    </div>

    @if(session('success'))
        <div class="module-alert module-alert-success">
            <i class="fa fa-check-circle"></i> {{ session('success') }}
        </div>
    @endif

    <div class="module-card">
        <!-- Filters -->
        <form method="GET" class="filter-section">
            <input type="text" name="search" class="module-input" placeholder="Search email or subject..." 
                   value="{{ request('search') }}">
            <select name="status" class="module-select">
                <option value="">All Status</option>
                <option value="sent" {{ request('status') == 'sent' ? 'selected' : '' }}>Sent</option>
                <option value="failed" {{ request('status') == 'failed' ? 'selected' : '' }}>Failed</option>
                <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
            </select>
            <select name="email_type" class="module-select">
                <option value="">All Types</option>
                @foreach($emailTypes as $key => $label)
                    <option value="{{ $key }}" {{ request('email_type') == $key ? 'selected' : '' }}>{{ $label }}</option>
                @endforeach
            </select>
            <select name="staff_id" class="module-select">
                <option value="">All Staff</option>
                @foreach($staffList as $member)
                    <option value="{{ $member->staffid }}" {{ request('staff_id') == $member->staffid ? 'selected' : '' }}>
                        {{ $member->firstname }} {{ $member->lastname }}
                    </option>
                @endforeach
            </select>
            <input type="date" name="date_from" class="module-input" value="{{ request('date_from') }}" placeholder="From Date">
            <input type="date" name="date_to" class="module-input" value="{{ request('date_to') }}" placeholder="To Date">
            <button type="submit" class="module-btn module-btn-primary">
                <i class="fa fa-filter"></i> Filter
            </button>
            <a href="{{ route('admin.advancedemail.logs.index') }}" class="module-btn module-btn-secondary">
                <i class="fa fa-times"></i> Clear
            </a>
        </form>

        <div class="module-card-header">
            <h3 class="module-card-title">Showing {{ $logs->count() }} of {{ $logs->total() }} logs</h3>
            <div class="stats-mini">
                <div class="stat-mini-item">
                    <span class="module-badge module-badge-success">
                        <i class="fa fa-check"></i>
                        <span class="stat-mini-value">{{ $logs->where('status', 'sent')->count() }}</span> Sent
                    </span>
                </div>
                <div class="stat-mini-item">
                    <span class="module-badge module-badge-danger">
                        <i class="fa fa-times"></i>
                        <span class="stat-mini-value">{{ $logs->where('status', 'failed')->count() }}</span> Failed
                    </span>
                </div>
            </div>
        </div>

        <div class="module-card-body">
            @if($logs->isEmpty())
                <div class="empty-state">
                    <i class="fa fa-inbox" style="font-size: 48px; opacity: 0.3;"></i>
                    <p>No email logs found.</p>
                </div>
            @else
                <table class="module-table">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Staff</th>
                            <th>From</th>
                            <th>To</th>
                            <th>Subject</th>
                            <th>Type</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($logs as $log)
                            <tr>
                                <td>
                                    <small>{{ $log->created_at->format('M d, Y') }}</small><br>
                                    <small class="text-muted">{{ $log->created_at->format('H:i:s') }}</small>
                                </td>
                                <td>{{ $log->staff ? $log->staff->firstname . ' ' . $log->staff->lastname : 'N/A' }}</td>
                                <td class="email-cell" title="{{ $log->from_email }}">{{ $log->from_email }}</td>
                                <td class="email-cell" title="{{ $log->to_email }}">{{ $log->to_email }}</td>
                                <td class="subject-cell" title="{{ $log->subject }}">{{ $log->subject }}</td>
                                <td>
                                    <span class="module-badge module-badge-info">{{ $log->email_type_label }}</span>
                                </td>
                                <td>
                                    @if($log->status == 'sent')
                                        <span class="module-badge module-badge-success"><i class="fa fa-check"></i> Sent</span>
                                    @elseif($log->status == 'failed')
                                        <span class="module-badge module-badge-danger" title="{{ $log->error_message }}">
                                            <i class="fa fa-times"></i> Failed
                                        </span>
                                    @else
                                        <span class="module-badge module-badge-warning"><i class="fa fa-clock-o"></i> Pending</span>
                                    @endif
                                </td>
                                <td>
                                    <form action="{{ route('admin.advancedemail.logs.destroy', $log->id) }}" method="POST" 
                                          style="display: inline;" onsubmit="return confirm('Delete this log?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="module-btn module-btn-sm module-btn-danger">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @endif
        </div>

        @if($logs->hasPages())
            <div class="pagination-wrapper">
                {{ $logs->appends(request()->query())->links() }}
            </div>
        @endif
    </div>
</div>
