<style>
:root {
    --primary: #3b82f6;
    --primary-dark: #2563eb;
    --success: #10b981;
    --danger: #ef4444;
    --warning: #f59e0b;
    --info: #06b6d4;
    --card-bg: #ffffff;
    --card-border: #e5e7eb;
    --text-primary: #1f2937;
    --text-secondary: #6b7280;
    --text-muted: #9ca3af;
    --hover-bg: #f9fafb;
    --input-border: #d1d5db;
    --input-focus: #3b82f6;
}

.module-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 20px;
}

.module-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 24px;
}

.module-header h1 {
    font-size: 24px;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0;
}

.module-card {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 12px;
    margin-bottom: 20px;
}

.module-card-header {
    padding: 16px 20px;
    border-bottom: 1px solid var(--card-border);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.module-card-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0;
}

.module-card-body {
    padding: 20px;
}

.module-btn {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 10px 16px;
    border-radius: 8px;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    border: none;
    text-decoration: none;
    transition: all 0.2s;
}

.module-btn-primary {
    background: var(--primary);
    color: white;
}

.module-btn-primary:hover {
    background: var(--primary-dark);
    color: white;
}

.module-btn-secondary {
    background: #f3f4f6;
    color: var(--text-primary);
    border: 1px solid var(--card-border);
}

.module-btn-success {
    background: var(--success);
    color: white;
}

.module-btn-danger {
    background: var(--danger);
    color: white;
}

.module-form-group {
    margin-bottom: 16px;
}

.module-label {
    display: block;
    font-size: 13px;
    font-weight: 500;
    color: var(--text-primary);
    margin-bottom: 6px;
}

.module-input, .module-select, .module-textarea {
    width: 100%;
    padding: 10px 12px;
    border: 1px solid var(--input-border);
    border-radius: 8px;
    font-size: 14px;
    color: var(--text-primary);
    background: white;
    transition: border-color 0.2s, box-shadow 0.2s;
}

.module-input:focus, .module-select:focus, .module-textarea:focus {
    outline: none;
    border-color: var(--input-focus);
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.module-input:disabled {
    background: #f9fafb;
    cursor: not-allowed;
}

.module-alert {
    padding: 12px 16px;
    border-radius: 8px;
    margin-bottom: 16px;
    font-size: 14px;
}

.module-alert-success { background: #d1fae5; color: #065f46; border: 1px solid #a7f3d0; }
.module-alert-danger { background: #fee2e2; color: #991b1b; border: 1px solid #fecaca; }
.module-alert-warning { background: #fef3c7; color: #92400e; border: 1px solid #fde68a; }
.module-alert-info { background: #dbeafe; color: #1e40af; border: 1px solid #bfdbfe; }

.module-badge {
    display: inline-block;
    padding: 4px 10px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 500;
}

.module-badge-success { background: #d1fae5; color: #065f46; }
.module-badge-danger { background: #fee2e2; color: #991b1b; }
.module-badge-warning { background: #fef3c7; color: #92400e; }
.module-badge-info { background: #dbeafe; color: #1e40af; }

.form-row {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 16px;
}

@media (max-width: 768px) {
    .form-row {
        grid-template-columns: 1fr;
    }
}

.switch-container {
    display: flex;
    align-items: center;
    gap: 12px;
}

.switch {
    position: relative;
    width: 48px;
    height: 24px;
}

.switch input {
    opacity: 0;
    width: 0;
    height: 0;
}

.slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    transition: 0.3s;
    border-radius: 24px;
}

.slider:before {
    position: absolute;
    content: "";
    height: 18px;
    width: 18px;
    left: 3px;
    bottom: 3px;
    background-color: white;
    transition: 0.3s;
    border-radius: 50%;
}

input:checked + .slider {
    background-color: var(--success);
}

input:checked + .slider:before {
    transform: translateX(24px);
}

.test-email-section {
    background: var(--hover-bg);
    border-radius: 8px;
    padding: 16px;
    margin-top: 16px;
}

.test-email-row {
    display: flex;
    gap: 12px;
    align-items: flex-end;
}

.test-email-row .module-form-group {
    flex: 1;
    margin-bottom: 0;
}

.permission-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
    gap: 12px;
}

.permission-item {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 12px;
    background: var(--hover-bg);
    border-radius: 8px;
}

.permission-item input[type="checkbox"] {
    width: 18px;
    height: 18px;
    accent-color: var(--primary);
}

.status-indicator {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
}

.status-dot {
    width: 8px;
    height: 8px;
    border-radius: 50%;
}

.status-dot.active { background: var(--success); }
.status-dot.inactive { background: var(--danger); }
.status-dot.pending { background: var(--warning); }
</style>

<div class="module-container">
    <div class="module-header">
        <h1><i class="fa fa-envelope"></i> My Email Settings</h1>
        @if($settings && $settings->is_active)
            <span class="module-badge module-badge-success"><i class="fa fa-check"></i> Active</span>
        @elseif($settings)
            <span class="module-badge module-badge-warning"><i class="fa fa-pause"></i> Inactive</span>
        @else
            <span class="module-badge module-badge-info"><i class="fa fa-info"></i> Not Configured</span>
        @endif
    </div>

    @if(session('success'))
        <div class="module-alert module-alert-success">
            <i class="fa fa-check-circle"></i> {{ session('success') }}
        </div>
    @endif

    @if(session('error'))
        <div class="module-alert module-alert-danger">
            <i class="fa fa-exclamation-circle"></i> {{ session('error') }}
        </div>
    @endif

    @if($errors->any())
        <div class="module-alert module-alert-danger">
            <ul style="margin: 0; padding-left: 20px;">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    @if(!$canConfigure)
        <div class="module-alert module-alert-warning">
            <i class="fa fa-lock"></i> 
            <strong>Permission Required:</strong> You do not have permission to configure email settings. 
            Please contact your administrator to enable this feature.
        </div>
    @else
        <form action="{{ route('admin.advancedemail.settings.store') }}" method="POST" id="emailSettingsForm">
            @csrf

            <!-- SMTP Settings Card -->
            <div class="module-card">
                <div class="module-card-header">
                    <h3 class="module-card-title"><i class="fa fa-server"></i> SMTP Configuration</h3>
                    <div class="switch-container">
                        <span class="text-muted">Enable</span>
                        <label class="switch">
                            <input type="checkbox" name="is_active" value="1" {{ $settings && $settings->is_active ? 'checked' : '' }}>
                            <span class="slider"></span>
                        </label>
                    </div>
                </div>
                <div class="module-card-body">
                    <div class="form-row">
                        <div class="module-form-group">
                            <label class="module-label">Email Address <span class="text-danger">*</span></label>
                            <input type="email" name="email" class="module-input" 
                                   value="{{ old('email', $settings->email ?? $staff->email) }}" required>
                            <small class="text-muted">This email will be used as the "From" address</small>
                        </div>
                        <div class="module-form-group">
                            <label class="module-label">From Name <span class="text-danger">*</span></label>
                            <input type="text" name="from_name" class="module-input" 
                                   value="{{ old('from_name', $settings->from_name ?? $staff->firstname . ' ' . $staff->lastname) }}" required>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="module-form-group">
                            <label class="module-label">Mail Driver</label>
                            <select name="mail_driver" class="module-select" id="mailDriver">
                                <option value="smtp" {{ old('mail_driver', $settings->mail_driver ?? 'smtp') == 'smtp' ? 'selected' : '' }}>SMTP</option>
                                <option value="sendmail" {{ old('mail_driver', $settings->mail_driver ?? '') == 'sendmail' ? 'selected' : '' }}>Sendmail</option>
                                <option value="mail" {{ old('mail_driver', $settings->mail_driver ?? '') == 'mail' ? 'selected' : '' }}>PHP Mail</option>
                            </select>
                        </div>
                        <div class="module-form-group">
                            <label class="module-label">Encryption</label>
                            <select name="smtp_encryption" class="module-select">
                                <option value="" {{ old('smtp_encryption', $settings->smtp_encryption ?? '') == '' ? 'selected' : '' }}>None</option>
                                <option value="ssl" {{ old('smtp_encryption', $settings->smtp_encryption ?? '') == 'ssl' ? 'selected' : '' }}>SSL</option>
                                <option value="tls" {{ old('smtp_encryption', $settings->smtp_encryption ?? 'tls') == 'tls' ? 'selected' : '' }}>TLS</option>
                            </select>
                        </div>
                    </div>

                    <div id="smtpFields">
                        <div class="form-row">
                            <div class="module-form-group">
                                <label class="module-label">SMTP Host <span class="text-danger">*</span></label>
                                <input type="text" name="smtp_host" class="module-input" 
                                       value="{{ old('smtp_host', $settings->smtp_host ?? '') }}"
                                       placeholder="e.g., smtp.gmail.com">
                            </div>
                            <div class="module-form-group">
                                <label class="module-label">SMTP Port <span class="text-danger">*</span></label>
                                <input type="number" name="smtp_port" class="module-input" 
                                       value="{{ old('smtp_port', $settings->smtp_port ?? 587) }}"
                                       placeholder="587">
                                <small class="text-muted">Common ports: 25, 465 (SSL), 587 (TLS)</small>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="module-form-group">
                                <label class="module-label">SMTP Username <span class="text-danger">*</span></label>
                                <input type="text" name="smtp_username" class="module-input" 
                                       value="{{ old('smtp_username', $settings->smtp_username ?? '') }}"
                                       placeholder="Usually your email address">
                            </div>
                            <div class="module-form-group">
                                <label class="module-label">SMTP Password <span class="text-danger">*</span></label>
                                <input type="password" name="smtp_password" class="module-input" 
                                       placeholder="{{ $settings && $settings->smtp_password ? '••••••••' : 'Enter password' }}"
                                       autocomplete="new-password">
                                <small class="text-muted">Leave empty to keep current password</small>
                            </div>
                        </div>
                    </div>

                    <div class="module-form-group">
                        <label class="module-label">Email Charset</label>
                        <input type="text" name="email_charset" class="module-input" 
                               value="{{ old('email_charset', $settings->email_charset ?? 'utf-8') }}">
                    </div>

                    <!-- Test Email Section -->
                    <div class="test-email-section">
                        <h4 style="margin: 0 0 12px 0; font-size: 14px; font-weight: 600;">
                            <i class="fa fa-paper-plane"></i> Send Test Email
                        </h4>
                        <p class="text-muted" style="margin-bottom: 12px; font-size: 13px;">
                            Test your SMTP settings by sending a test email. Make sure to save your settings first.
                        </p>
                        <div class="test-email-row">
                            <div class="module-form-group">
                                <input type="email" id="testEmail" class="module-input" 
                                       placeholder="Enter email address to send test">
                            </div>
                            <button type="button" class="module-btn module-btn-secondary" id="sendTestBtn">
                                <i class="fa fa-send"></i> Send Test
                            </button>
                        </div>
                        <div id="testResult" style="margin-top: 12px; display: none;"></div>
                    </div>
                </div>
            </div>

            <!-- Email Type Preferences Card -->
            <div class="module-card">
                <div class="module-card-header">
                    <h3 class="module-card-title"><i class="fa fa-sliders"></i> Email Type Preferences</h3>
                </div>
                <div class="module-card-body">
                    <p class="text-muted" style="margin-bottom: 16px;">
                        Choose which types of emails should use your personal SMTP settings. 
                        Unchecked types will use the system default email.
                    </p>
                    <div class="permission-grid">
                        <label class="permission-item">
                            <input type="checkbox" name="use_own_email_for_invoices" value="1"
                                   {{ old('use_own_email_for_invoices', $permission->use_own_email_for_invoices ?? true) ? 'checked' : '' }}>
                            <span>Invoice Emails</span>
                        </label>
                        <label class="permission-item">
                            <input type="checkbox" name="use_own_email_for_proposals" value="1"
                                   {{ old('use_own_email_for_proposals', $permission->use_own_email_for_proposals ?? true) ? 'checked' : '' }}>
                            <span>Proposal Emails</span>
                        </label>
                        <label class="permission-item">
                            <input type="checkbox" name="use_own_email_for_estimates" value="1"
                                   {{ old('use_own_email_for_estimates', $permission->use_own_email_for_estimates ?? true) ? 'checked' : '' }}>
                            <span>Estimate Emails</span>
                        </label>
                        <label class="permission-item">
                            <input type="checkbox" name="use_own_email_for_tasks" value="1"
                                   {{ old('use_own_email_for_tasks', $permission->use_own_email_for_tasks ?? true) ? 'checked' : '' }}>
                            <span>Task Notifications</span>
                        </label>
                        <label class="permission-item">
                            <input type="checkbox" name="use_own_email_for_projects" value="1"
                                   {{ old('use_own_email_for_projects', $permission->use_own_email_for_projects ?? true) ? 'checked' : '' }}>
                            <span>Project Notifications</span>
                        </label>
                    </div>
                </div>
            </div>

            <!-- Status Card -->
            @if($settings)
            <div class="module-card">
                <div class="module-card-header">
                    <h3 class="module-card-title"><i class="fa fa-info-circle"></i> Status Information</h3>
                </div>
                <div class="module-card-body">
                    <div class="form-row">
                        <div>
                            <strong>Verification Status:</strong>
                            @if($settings->is_verified)
                                <span class="module-badge module-badge-success">Verified</span>
                            @else
                                <span class="module-badge module-badge-warning">Not Verified</span>
                            @endif
                        </div>
                        <div>
                            <strong>Last Verified:</strong>
                            {{ $settings->last_verified_at ? $settings->last_verified_at->format('M d, Y H:i') : 'Never' }}
                        </div>
                    </div>
                </div>
            </div>
            @endif

            <!-- Submit Button -->
            <div style="display: flex; gap: 12px; justify-content: flex-end;">
                <button type="submit" class="module-btn module-btn-primary">
                    <i class="fa fa-save"></i> Save Settings
                </button>
            </div>
        </form>
    @endif
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const mailDriver = document.getElementById('mailDriver');
    const smtpFields = document.getElementById('smtpFields');
    
    function toggleSmtpFields() {
        if (mailDriver.value === 'smtp') {
            smtpFields.style.display = 'block';
        } else {
            smtpFields.style.display = 'none';
        }
    }
    
    mailDriver.addEventListener('change', toggleSmtpFields);
    toggleSmtpFields();

    // Test Email
    const sendTestBtn = document.getElementById('sendTestBtn');
    const testEmail = document.getElementById('testEmail');
    const testResult = document.getElementById('testResult');

    sendTestBtn.addEventListener('click', function() {
        const email = testEmail.value.trim();
        if (!email) {
            alert('Please enter an email address');
            return;
        }

        sendTestBtn.disabled = true;
        sendTestBtn.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Sending...';
        testResult.style.display = 'none';

        fetch('{{ route("admin.advancedemail.settings.test") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({ test_email: email })
        })
        .then(response => response.json())
        .then(data => {
            testResult.style.display = 'block';
            if (data.success) {
                testResult.innerHTML = '<div class="module-alert module-alert-success"><i class="fa fa-check"></i> ' + data.message + '</div>';
            } else {
                testResult.innerHTML = '<div class="module-alert module-alert-danger"><i class="fa fa-times"></i> ' + data.message + '</div>';
            }
        })
        .catch(error => {
            testResult.style.display = 'block';
            testResult.innerHTML = '<div class="module-alert module-alert-danger"><i class="fa fa-times"></i> An error occurred. Please try again.</div>';
        })
        .finally(() => {
            sendTestBtn.disabled = false;
            sendTestBtn.innerHTML = '<i class="fa fa-send"></i> Send Test';
        });
    });
});
</script>
