<style>
:root {
    --primary: #3b82f6;
    --primary-dark: #2563eb;
    --success: #10b981;
    --danger: #ef4444;
    --warning: #f59e0b;
    --info: #06b6d4;
    --card-bg: #ffffff;
    --card-border: #e5e7eb;
    --text-primary: #1f2937;
    --text-secondary: #6b7280;
    --text-muted: #9ca3af;
    --hover-bg: #f9fafb;
    --input-border: #d1d5db;
    --input-focus: #3b82f6;
}

.module-container {
    max-width: 1000px;
    margin: 0 auto;
    padding: 20px;
}

.module-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 24px;
    flex-wrap: wrap;
    gap: 16px;
}

.module-header h1 {
    font-size: 24px;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0;
}

.module-card {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 12px;
    margin-bottom: 20px;
}

.module-card-header {
    padding: 16px 20px;
    border-bottom: 1px solid var(--card-border);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.module-card-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0;
}

.module-card-body {
    padding: 20px;
}

.module-btn {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 10px 16px;
    border-radius: 8px;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    border: none;
    text-decoration: none;
    transition: all 0.2s;
}

.module-btn-primary {
    background: var(--primary);
    color: white;
}

.module-btn-primary:hover {
    background: var(--primary-dark);
    color: white;
}

.module-btn-secondary {
    background: #f3f4f6;
    color: var(--text-primary);
    border: 1px solid var(--card-border);
}

.module-btn-secondary:hover {
    background: #e5e7eb;
    color: var(--text-primary);
}

.module-form-group {
    margin-bottom: 16px;
}

.module-label {
    display: block;
    font-size: 13px;
    font-weight: 500;
    color: var(--text-primary);
    margin-bottom: 6px;
}

.module-input, .module-select {
    width: 100%;
    padding: 10px 12px;
    border: 1px solid var(--input-border);
    border-radius: 8px;
    font-size: 14px;
    color: var(--text-primary);
    background: white;
    transition: border-color 0.2s, box-shadow 0.2s;
}

.module-input:focus, .module-select:focus {
    outline: none;
    border-color: var(--input-focus);
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.module-alert {
    padding: 12px 16px;
    border-radius: 8px;
    margin-bottom: 16px;
    font-size: 14px;
}

.module-alert-success { background: #d1fae5; color: #065f46; border: 1px solid #a7f3d0; }
.module-alert-danger { background: #fee2e2; color: #991b1b; border: 1px solid #fecaca; }
.module-alert-info { background: #dbeafe; color: #1e40af; border: 1px solid #bfdbfe; }

.form-row {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 16px;
}

@media (max-width: 768px) {
    .form-row {
        grid-template-columns: 1fr;
    }
}

.switch-container {
    display: flex;
    align-items: center;
    gap: 12px;
}

.switch {
    position: relative;
    width: 48px;
    height: 24px;
}

.switch input {
    opacity: 0;
    width: 0;
    height: 0;
}

.slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    transition: 0.3s;
    border-radius: 24px;
}

.slider:before {
    position: absolute;
    content: "";
    height: 18px;
    width: 18px;
    left: 3px;
    bottom: 3px;
    background-color: white;
    transition: 0.3s;
    border-radius: 50%;
}

input:checked + .slider {
    background-color: var(--success);
}

input:checked + .slider:before {
    transform: translateX(24px);
}

.staff-info-card {
    display: flex;
    align-items: center;
    gap: 16px;
    padding: 16px;
    background: var(--hover-bg);
    border-radius: 8px;
    margin-bottom: 20px;
}

.staff-avatar {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    background: var(--primary);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    font-size: 24px;
}

.staff-details h3 {
    margin: 0 0 4px 0;
    font-size: 18px;
    color: var(--text-primary);
}

.staff-details p {
    margin: 0;
    font-size: 14px;
    color: var(--text-muted);
}

.test-email-section {
    background: var(--hover-bg);
    border-radius: 8px;
    padding: 16px;
    margin-top: 16px;
}

.test-email-row {
    display: flex;
    gap: 12px;
    align-items: flex-end;
}

.test-email-row .module-form-group {
    flex: 1;
    margin-bottom: 0;
}

.permission-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
    gap: 12px;
}

.permission-item {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 12px;
    background: var(--hover-bg);
    border-radius: 8px;
}

.permission-item input[type="checkbox"] {
    width: 18px;
    height: 18px;
    accent-color: var(--primary);
}
</style>

@php
    $staffId = $staff->id ?? $staff->staffid;
    $staffFirstName = $staff->first_name ?? $staff->firstname ?? '';
    $staffLastName = $staff->last_name ?? $staff->lastname ?? '';
    $staffFullName = trim($staffFirstName . ' ' . $staffLastName);
@endphp

<div class="module-container">
    <div class="module-header">
        <h1><i class="fa fa-user-cog"></i> Configure Staff Email</h1>
        <a href="{{ route('admin.advancedemail.staff.index') }}" class="module-btn module-btn-secondary">
            <i class="fa fa-arrow-left"></i> Back to Staff List
        </a>
    </div>

    @if(session('success'))
        <div class="module-alert module-alert-success">
            <i class="fa fa-check-circle"></i> {{ session('success') }}
        </div>
    @endif

    @if(session('error'))
        <div class="module-alert module-alert-danger">
            <i class="fa fa-exclamation-circle"></i> {{ session('error') }}
        </div>
    @endif

    @if($errors->any())
        <div class="module-alert module-alert-danger">
            <ul style="margin: 0; padding-left: 20px;">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <!-- Staff Info Card -->
    <div class="staff-info-card">
        <div class="staff-avatar">
            {{ strtoupper(substr($staffFirstName, 0, 1)) }}
        </div>
        <div class="staff-details">
            <h3>{{ $staffFullName }}</h3>
            <p><i class="fa fa-envelope"></i> {{ $staff->email }}</p>
        </div>
    </div>

    <form action="{{ route('admin.advancedemail.staff.update', $staffId) }}" method="POST" id="staffEmailForm">
        @csrf
        @method('PUT')

        <!-- SMTP Settings Card -->
        <div class="module-card">
            <div class="module-card-header">
                <h3 class="module-card-title"><i class="fa fa-server"></i> SMTP Configuration</h3>
                <div class="switch-container">
                    <span class="text-muted">Enable</span>
                    <label class="switch">
                        <input type="checkbox" name="is_active" value="1" {{ $settings && $settings->is_active ? 'checked' : '' }}>
                        <span class="slider"></span>
                    </label>
                </div>
            </div>
            <div class="module-card-body">
                <div class="form-row">
                    <div class="module-form-group">
                        <label class="module-label">Email Address <span class="text-danger">*</span></label>
                        <input type="email" name="email" class="module-input" 
                               value="{{ old('email', $settings->email ?? $staff->email) }}" required>
                    </div>
                    <div class="module-form-group">
                        <label class="module-label">From Name <span class="text-danger">*</span></label>
                        <input type="text" name="from_name" class="module-input" 
                               value="{{ old('from_name', $settings->from_name ?? $staffFullName) }}" required>
                    </div>
                </div>

                <div class="form-row">
                    <div class="module-form-group">
                        <label class="module-label">Mail Driver</label>
                        <select name="mail_driver" class="module-select" id="mailDriver">
                            <option value="smtp" {{ old('mail_driver', $settings->mail_driver ?? 'smtp') == 'smtp' ? 'selected' : '' }}>SMTP</option>
                            <option value="sendmail" {{ old('mail_driver', $settings->mail_driver ?? '') == 'sendmail' ? 'selected' : '' }}>Sendmail</option>
                            <option value="mail" {{ old('mail_driver', $settings->mail_driver ?? '') == 'mail' ? 'selected' : '' }}>PHP Mail</option>
                        </select>
                    </div>
                    <div class="module-form-group">
                        <label class="module-label">Encryption</label>
                        <select name="smtp_encryption" class="module-select">
                            <option value="" {{ old('smtp_encryption', $settings->smtp_encryption ?? '') == '' ? 'selected' : '' }}>None</option>
                            <option value="ssl" {{ old('smtp_encryption', $settings->smtp_encryption ?? '') == 'ssl' ? 'selected' : '' }}>SSL</option>
                            <option value="tls" {{ old('smtp_encryption', $settings->smtp_encryption ?? 'tls') == 'tls' ? 'selected' : '' }}>TLS</option>
                        </select>
                    </div>
                </div>

                <div id="smtpFields">
                    <div class="form-row">
                        <div class="module-form-group">
                            <label class="module-label">SMTP Host <span class="text-danger">*</span></label>
                            <input type="text" name="smtp_host" class="module-input" 
                                   value="{{ old('smtp_host', $settings->smtp_host ?? '') }}"
                                   placeholder="e.g., smtp.gmail.com">
                        </div>
                        <div class="module-form-group">
                            <label class="module-label">SMTP Port <span class="text-danger">*</span></label>
                            <input type="number" name="smtp_port" class="module-input" 
                                   value="{{ old('smtp_port', $settings->smtp_port ?? 587) }}"
                                   placeholder="587">
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="module-form-group">
                            <label class="module-label">SMTP Username <span class="text-danger">*</span></label>
                            <input type="text" name="smtp_username" class="module-input" 
                                   value="{{ old('smtp_username', $settings->smtp_username ?? '') }}">
                        </div>
                        <div class="module-form-group">
                            <label class="module-label">SMTP Password</label>
                            <input type="password" name="smtp_password" class="module-input" 
                                   placeholder="{{ $settings && $settings->smtp_password ? '••••••••' : 'Enter password' }}"
                                   autocomplete="new-password">
                            <small class="text-muted">Leave empty to keep current password</small>
                        </div>
                    </div>
                </div>

                <div class="module-form-group">
                    <label class="module-label">Email Charset</label>
                    <input type="text" name="email_charset" class="module-input" 
                           value="{{ old('email_charset', $settings->email_charset ?? 'utf-8') }}">
                </div>

                <!-- Test Email Section -->
                <div class="test-email-section">
                    <h4 style="margin: 0 0 12px 0; font-size: 14px; font-weight: 600;">
                        <i class="fa fa-paper-plane"></i> Send Test Email
                    </h4>
                    <div class="test-email-row">
                        <div class="module-form-group">
                            <input type="email" id="testEmail" class="module-input" 
                                   placeholder="Enter email address to send test"
                                   value="{{ $staff->email }}">
                        </div>
                        <button type="button" class="module-btn module-btn-secondary" id="sendTestBtn">
                            <i class="fa fa-send"></i> Send Test
                        </button>
                    </div>
                    <div id="testResult" style="margin-top: 12px; display: none;"></div>
                </div>
            </div>
        </div>

        <!-- Permissions Card -->
        <div class="module-card">
            <div class="module-card-header">
                <h3 class="module-card-title"><i class="fa fa-shield"></i> Email Permissions</h3>
            </div>
            <div class="module-card-body">
                <div class="module-form-group">
                    <label class="permission-item" style="background: #dbeafe;">
                        <input type="checkbox" name="can_configure_email" value="1"
                               {{ $permission && $permission->can_configure_email ? 'checked' : '' }}>
                        <span><strong>Allow staff to configure their own email settings</strong></span>
                    </label>
                </div>

                <hr style="margin: 16px 0;">
                
                <p class="text-muted" style="margin-bottom: 16px;">Email types to use this staff's SMTP settings:</p>
                
                <div class="permission-grid">
                    <label class="permission-item">
                        <input type="checkbox" name="use_own_email_for_invoices" value="1"
                               {{ $permission && $permission->use_own_email_for_invoices ? 'checked' : '' }}>
                        <span>Invoice Emails</span>
                    </label>
                    <label class="permission-item">
                        <input type="checkbox" name="use_own_email_for_proposals" value="1"
                               {{ $permission && $permission->use_own_email_for_proposals ? 'checked' : '' }}>
                        <span>Proposal Emails</span>
                    </label>
                    <label class="permission-item">
                        <input type="checkbox" name="use_own_email_for_estimates" value="1"
                               {{ $permission && $permission->use_own_email_for_estimates ? 'checked' : '' }}>
                        <span>Estimate Emails</span>
                    </label>
                    <label class="permission-item">
                        <input type="checkbox" name="use_own_email_for_tasks" value="1"
                               {{ $permission && $permission->use_own_email_for_tasks ? 'checked' : '' }}>
                        <span>Task Notifications</span>
                    </label>
                    <label class="permission-item">
                        <input type="checkbox" name="use_own_email_for_projects" value="1"
                               {{ $permission && $permission->use_own_email_for_projects ? 'checked' : '' }}>
                        <span>Project Notifications</span>
                    </label>
                </div>
            </div>
        </div>

        <!-- Submit Buttons -->
        <div style="display: flex; gap: 12px; justify-content: flex-end;">
            <a href="{{ route('admin.advancedemail.staff.index') }}" class="module-btn module-btn-secondary">
                Cancel
            </a>
            <button type="submit" class="module-btn module-btn-primary">
                <i class="fa fa-save"></i> Save Settings
            </button>
        </div>
    </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const mailDriver = document.getElementById('mailDriver');
    const smtpFields = document.getElementById('smtpFields');
    
    function toggleSmtpFields() {
        smtpFields.style.display = mailDriver.value === 'smtp' ? 'block' : 'none';
    }
    
    mailDriver.addEventListener('change', toggleSmtpFields);
    toggleSmtpFields();

    // Test Email
    const sendTestBtn = document.getElementById('sendTestBtn');
    const testEmail = document.getElementById('testEmail');
    const testResult = document.getElementById('testResult');

    sendTestBtn.addEventListener('click', function() {
        const email = testEmail.value.trim();
        if (!email) {
            alert('Please enter an email address');
            return;
        }

        sendTestBtn.disabled = true;
        sendTestBtn.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Sending...';
        testResult.style.display = 'none';

        fetch('{{ route("admin.advancedemail.staff.test", $staffId) }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({ test_email: email })
        })
        .then(response => response.json())
        .then(data => {
            testResult.style.display = 'block';
            if (data.success) {
                testResult.innerHTML = '<div class="module-alert module-alert-success"><i class="fa fa-check"></i> ' + data.message + '</div>';
            } else {
                testResult.innerHTML = '<div class="module-alert module-alert-danger"><i class="fa fa-times"></i> ' + data.message + '</div>';
            }
        })
        .catch(error => {
            testResult.style.display = 'block';
            testResult.innerHTML = '<div class="module-alert module-alert-danger"><i class="fa fa-times"></i> An error occurred.</div>';
        })
        .finally(() => {
            sendTestBtn.disabled = false;
            sendTestBtn.innerHTML = '<i class="fa fa-send"></i> Send Test';
        });
    });
});
</script>