<style>
:root {
    --primary: #3b82f6;
    --primary-dark: #2563eb;
    --success: #10b981;
    --danger: #ef4444;
    --warning: #f59e0b;
    --info: #06b6d4;
    --card-bg: #ffffff;
    --card-border: #e5e7eb;
    --text-primary: #1f2937;
    --text-secondary: #6b7280;
    --text-muted: #9ca3af;
    --hover-bg: #f9fafb;
    --input-border: #d1d5db;
    --input-focus: #3b82f6;
}

.module-container {
    max-width: 1400px;
    margin: 0 auto;
    padding: 20px;
}

.module-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 24px;
    flex-wrap: wrap;
    gap: 16px;
}

.module-header h1 {
    font-size: 24px;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0;
}

.module-card {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 12px;
    margin-bottom: 20px;
    overflow: hidden;
}

.module-card-header {
    padding: 16px 20px;
    border-bottom: 1px solid var(--card-border);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.module-card-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0;
}

.module-card-body {
    padding: 0;
}

.module-btn {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 8px 14px;
    border-radius: 8px;
    font-size: 13px;
    font-weight: 500;
    cursor: pointer;
    border: none;
    text-decoration: none;
    transition: all 0.2s;
}

.module-btn-sm {
    padding: 6px 10px;
    font-size: 12px;
}

.module-btn-primary {
    background: var(--primary);
    color: white;
}

.module-btn-primary:hover {
    background: var(--primary-dark);
    color: white;
}

.module-btn-secondary {
    background: #f3f4f6;
    color: var(--text-primary);
    border: 1px solid var(--card-border);
}

.module-btn-success {
    background: var(--success);
    color: white;
}

.module-btn-danger {
    background: var(--danger);
    color: white;
}

.module-btn-warning {
    background: var(--warning);
    color: white;
}

.module-table {
    width: 100%;
    border-collapse: collapse;
}

.module-table th {
    background: var(--hover-bg);
    padding: 14px 16px;
    text-align: left;
    font-size: 12px;
    font-weight: 600;
    color: var(--text-secondary);
    text-transform: uppercase;
    letter-spacing: 0.5px;
    border-bottom: 1px solid var(--card-border);
}

.module-table td {
    padding: 14px 16px;
    border-bottom: 1px solid var(--card-border);
    font-size: 14px;
    color: var(--text-primary);
    vertical-align: middle;
}

.module-table tbody tr:hover {
    background: var(--hover-bg);
}

.module-table tbody tr:last-child td {
    border-bottom: none;
}

.module-badge {
    display: inline-flex;
    align-items: center;
    gap: 4px;
    padding: 4px 10px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 500;
}

.module-badge-success { background: #d1fae5; color: #065f46; }
.module-badge-danger { background: #fee2e2; color: #991b1b; }
.module-badge-warning { background: #fef3c7; color: #92400e; }
.module-badge-info { background: #dbeafe; color: #1e40af; }
.module-badge-secondary { background: #f3f4f6; color: #6b7280; }

.module-alert {
    padding: 12px 16px;
    border-radius: 8px;
    margin-bottom: 16px;
    font-size: 14px;
}

.module-alert-success { background: #d1fae5; color: #065f46; border: 1px solid #a7f3d0; }
.module-alert-danger { background: #fee2e2; color: #991b1b; border: 1px solid #fecaca; }

.staff-info {
    display: flex;
    align-items: center;
    gap: 12px;
}

.staff-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: var(--primary);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    font-size: 14px;
}

.staff-details {
    display: flex;
    flex-direction: column;
}

.staff-name {
    font-weight: 600;
    color: var(--text-primary);
}

.staff-email {
    font-size: 12px;
    color: var(--text-muted);
}

.status-indicator {
    display: flex;
    align-items: center;
    gap: 6px;
}

.status-dot {
    width: 8px;
    height: 8px;
    border-radius: 50%;
}

.status-dot.active { background: var(--success); }
.status-dot.inactive { background: var(--danger); }
.status-dot.pending { background: var(--warning); }

.action-buttons {
    display: flex;
    gap: 8px;
    flex-wrap: wrap;
}

.switch {
    position: relative;
    width: 44px;
    height: 22px;
}

.switch input {
    opacity: 0;
    width: 0;
    height: 0;
}

.slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    transition: 0.3s;
    border-radius: 22px;
}

.slider:before {
    position: absolute;
    content: "";
    height: 16px;
    width: 16px;
    left: 3px;
    bottom: 3px;
    background-color: white;
    transition: 0.3s;
    border-radius: 50%;
}

input:checked + .slider {
    background-color: var(--success);
}

input:checked + .slider:before {
    transform: translateX(22px);
}

.stats-row {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 16px;
    margin-bottom: 24px;
}

.stat-card {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 12px;
    padding: 20px;
    text-align: center;
}

.stat-value {
    font-size: 28px;
    font-weight: 700;
    color: var(--text-primary);
}

.stat-label {
    font-size: 13px;
    color: var(--text-muted);
    margin-top: 4px;
}

.empty-state {
    text-align: center;
    padding: 60px 20px;
    color: var(--text-muted);
}

.empty-state i {
    font-size: 48px;
    opacity: 0.3;
    margin-bottom: 16px;
}
</style>

<div class="module-container">
    <div class="module-header">
        <h1><i class="fa fa-users"></i> Manage Staff Email Settings</h1>
    </div>

    @if(session('success'))
        <div class="module-alert module-alert-success">
            <i class="fa fa-check-circle"></i> {{ session('success') }}
        </div>
    @endif

    @if(session('error'))
        <div class="module-alert module-alert-danger">
            <i class="fa fa-exclamation-circle"></i> {{ session('error') }}
        </div>
    @endif

    <!-- Stats Row -->
    <div class="stats-row">
        <div class="stat-card">
            <div class="stat-value">{{ $staffList->count() }}</div>
            <div class="stat-label">Total Staff</div>
        </div>
        <div class="stat-card">
            <div class="stat-value" style="color: var(--success);">{{ $staffList->where('is_active', true)->count() }}</div>
            <div class="stat-label">Active Email Configs</div>
        </div>
        <div class="stat-card">
            <div class="stat-value" style="color: var(--info);">{{ $staffList->where('is_configured', true)->count() }}</div>
            <div class="stat-label">Configured</div>
        </div>
        <div class="stat-card">
            <div class="stat-value" style="color: var(--warning);">{{ $staffList->where('can_configure', true)->count() }}</div>
            <div class="stat-label">With Permission</div>
        </div>
    </div>

    <!-- Staff Table -->
    <div class="module-card">
        <div class="module-card-header">
            <h3 class="module-card-title">Staff Email Configuration Status</h3>
        </div>
        <div class="module-card-body">
            @if($staffList->isEmpty())
                <div class="empty-state">
                    <i class="fa fa-users"></i>
                    <p>No staff members found.</p>
                </div>
            @else
                <table class="module-table">
                    <thead>
                        <tr>
                            <th>Staff Member</th>
                            <th>Custom Email</th>
                            <th>Configuration</th>
                            <th>Status</th>
                            <th>Permission</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($staffList as $member)
                            <tr>
                                <td>
                                    <div class="staff-info">
                                        <div class="staff-avatar">
                                            {{ strtoupper(substr($member['name'], 0, 1)) }}
                                        </div>
                                        <div class="staff-details">
                                            <span class="staff-name">
                                                {{ $member['name'] }}
                                              @if($member['is_admin'] ?? false)
                                                    <span class="module-badge module-badge-info" style="font-size: 10px; padding: 2px 6px;">Admin</span>
                                                @endif
                                            </span>
                                            <span class="staff-email">{{ $member['default_email'] }}</span>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    @if($member['custom_email'])
                                        <span style="color: var(--primary);">{{ $member['custom_email'] }}</span>
                                    @else
                                        <span class="text-muted">Not set</span>
                                    @endif
                                </td>
                                <td>
                                    @if($member['is_configured'])
                                        <span class="module-badge module-badge-success">
                                            <i class="fa fa-check"></i> Configured
                                        </span>
                                        @if($member['is_verified'])
                                            <span class="module-badge module-badge-success" style="margin-left: 4px;">
                                                <i class="fa fa-shield"></i> Verified
                                            </span>
                                        @endif
                                    @elseif($member['has_settings'])
                                        <span class="module-badge module-badge-warning">
                                            <i class="fa fa-exclamation"></i> Incomplete
                                        </span>
                                    @else
                                        <span class="module-badge module-badge-secondary">
                                            <i class="fa fa-times"></i> Not Set
                                        </span>
                                    @endif
                                </td>
                                <td>
                                    <div class="switch-container">
                                        <label class="switch">
                                            <input type="checkbox" class="toggle-active" 
                                                   data-staff-id="{{ $member['staffid'] }}"
                                                   {{ $member['is_active'] ? 'checked' : '' }}
                                                   {{ !$member['is_configured'] ? 'disabled' : '' }}>
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                </td>
                                <td>
                                    @if($member['is_admin'])
                                        <span class="module-badge module-badge-info">Always Allowed</span>
                                    @else
                                        <label class="switch">
                                            <input type="checkbox" class="toggle-permission" 
                                                   data-staff-id="{{ $member['staffid'] }}"
                                                   {{ $member['can_configure'] ? 'checked' : '' }}>
                                            <span class="slider"></span>
                                        </label>
                                    @endif
                                </td>
                                <td>
                                    <div class="action-buttons">
                                        <a href="{{ route('admin.advancedemail.staff.edit', $member['staffid']) }}" 
                                           class="module-btn module-btn-sm module-btn-primary">
                                            <i class="fa fa-edit"></i> Configure
                                        </a>
                                        @if($member['has_settings'])
                                            <form action="{{ route('admin.advancedemail.staff.destroy', $member['staffid']) }}" 
                                                  method="POST" style="display: inline;" 
                                                  onsubmit="return confirm('Are you sure you want to delete this staff\'s email settings?');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="module-btn module-btn-sm module-btn-danger">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </form>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @endif
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Toggle Active Status
    document.querySelectorAll('.toggle-active').forEach(function(toggle) {
        toggle.addEventListener('change', function() {
            const staffId = this.dataset.staffId;
            const isActive = this.checked;
            
            fetch(`{{ url('admin/advancedemail/staff') }}/${staffId}/toggle-active`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ is_active: isActive })
            })
            .then(response => response.json())
            .then(data => {
                if (!data.success) {
                    this.checked = !isActive;
                    alert(data.message || 'Failed to update status');
                }
            })
            .catch(error => {
                this.checked = !isActive;
                alert('An error occurred');
            });
        });
    });

    // Toggle Permission
    document.querySelectorAll('.toggle-permission').forEach(function(toggle) {
        toggle.addEventListener('change', function() {
            const staffId = this.dataset.staffId;
            const canConfigure = this.checked;
            
            fetch(`{{ url('admin/advancedemail/staff') }}/${staffId}/toggle-permission`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ can_configure: canConfigure })
            })
            .then(response => response.json())
            .then(data => {
                if (!data.success) {
                    this.checked = !canConfigure;
                    alert(data.message || 'Failed to update permission');
                }
            })
            .catch(error => {
                this.checked = !canConfigure;
                alert('An error occurred');
            });
        });
    });
});
</script>
