<?php

use Illuminate\Support\Facades\Route;
use Modules\AdvancedEmail\Http\Controllers\EmailSettingsController;
use Modules\AdvancedEmail\Http\Controllers\StaffEmailController;
use Modules\AdvancedEmail\Http\Controllers\EmailLogsController;
use Modules\AdvancedEmail\Http\Controllers\ActivityLogsController;
use App\Http\Middleware\EnsureIsAdmin;

Route::prefix('admin/advancedemail')
    ->middleware([EnsureIsAdmin::class])
    ->name('admin.advancedemail.')
    ->group(function () {

        // ===== MY EMAIL SETTINGS =====
        Route::get('/settings', [EmailSettingsController::class, 'index'])->name('settings.index');
        Route::post('/settings', [EmailSettingsController::class, 'store'])->name('settings.store');
        Route::post('/settings/test', [EmailSettingsController::class, 'sendMyTestEmail'])->name('settings.test');
        Route::post('/settings/toggle', [EmailSettingsController::class, 'toggleActive'])->name('settings.toggle');
        Route::post('/settings/permissions', [EmailSettingsController::class, 'updateTypePermissions'])->name('settings.permissions');

        // ===== MANAGE STAFF EMAILS (Admin) =====
        Route::get('/staff', [StaffEmailController::class, 'index'])->name('staff.index');
        Route::get('/staff/{id}/edit', [StaffEmailController::class, 'edit'])->name('staff.edit');
        Route::put('/staff/{id}', [StaffEmailController::class, 'update'])->name('staff.update');
        Route::delete('/staff/{id}', [StaffEmailController::class, 'destroy'])->name('staff.destroy');
        Route::post('/staff/{id}/toggle-permission', [StaffEmailController::class, 'togglePermission'])->name('staff.toggle-permission');
        Route::post('/staff/{id}/toggle-active', [StaffEmailController::class, 'toggleActive'])->name('staff.toggle-active');
        Route::post('/staff/{id}/type-permissions', [StaffEmailController::class, 'updateTypePermissions'])->name('staff.type-permissions');
        Route::post('/staff/{id}/test', [StaffEmailController::class, 'sendStaffTestEmail'])->name('staff.test');
        Route::get('/staff/{id}/settings', [StaffEmailController::class, 'getSettings'])->name('staff.get-settings');

        // ===== EMAIL LOGS =====
        Route::get('/logs', [EmailLogsController::class, 'index'])->name('logs.index');
        Route::get('/logs/{id}', [EmailLogsController::class, 'show'])->name('logs.show');
        Route::delete('/logs/{id}', [EmailLogsController::class, 'destroy'])->name('logs.destroy');
        Route::post('/logs/bulk-delete', [EmailLogsController::class, 'bulkDelete'])->name('logs.bulk-delete');
        Route::delete('/logs/clear-all', [EmailLogsController::class, 'clearAll'])->name('logs.clear-all');
        Route::get('/logs/export/csv', [EmailLogsController::class, 'export'])->name('logs.export');

        // ===== ACTIVITY LOGS =====
        Route::get('/activity', [ActivityLogsController::class, 'index'])->name('activity.index');
        Route::delete('/activity/clear-all', [ActivityLogsController::class, 'clearAll'])->name('activity.clear-all');
        Route::delete('/activity/clear-old/{days}', [ActivityLogsController::class, 'clearOld'])->name('activity.clear-old');



        Route::get('/test-staff-email/{id}/{email?}', [StaffEmailController::class, 'testStaffEmailSimple'])
        ->name('staff.test-email');

        Route::get('/mailservice-test/{id}', [StaffEmailController::class, 'testUsingMailService'])
        ->name('staff.test-email');

        Route::get('/hostingerSettings', [StaffEmailController::class, 'hostingerSettings'])
        ->name('staff.hostinger-settings');


        Route::get('/sendTestEmail/{id}/{email?}', [StaffEmailController::class, 'sendTestEmail'])
        ->name('staff.sendTestEmail');

    });
