<?php

return [
    'name' => 'Attendance',
    
    /*
    |--------------------------------------------------------------------------
    | Permissions
    |--------------------------------------------------------------------------
    | These permissions will be seeded when the module is installed
    */
    'permissions' => [
        // Dashboard & View
        'attendance.view' => 'View Attendance Dashboard',
        'attendance.my' => 'View My Attendance',
        
        // Mark Attendance
        'attendance.mark' => 'Mark Attendance for Others',
        'attendance.checkin' => 'Self Check-in/Check-out',
        
        // Manage
        'attendance.edit' => 'Edit Attendance Records',
        'attendance.delete' => 'Delete Attendance Records',
        'attendance.export' => 'Export Attendance',
        
        // Shift Types
        'attendance.shift_types.view' => 'View Shift Types',
        'attendance.shift_types.create' => 'Create Shift Types',
        'attendance.shift_types.edit' => 'Edit Shift Types',
        'attendance.shift_types.delete' => 'Delete Shift Types',
        
        // Shift Assignments
        'attendance.shifts.view' => 'View Shift Assignments',
        'attendance.shifts.create' => 'Create Shift Assignments',
        'attendance.shifts.edit' => 'Edit Shift Assignments',
        'attendance.shifts.delete' => 'Delete Shift Assignments',
        
        // Leave
        'attendance.leave.view' => 'View Leave Applications',
        'attendance.leave.apply' => 'Apply for Leave',
        'attendance.leave.approve' => 'Approve/Reject Leave',
        'attendance.leave.delete' => 'Delete Leave Applications',
        
        // Additional Hours
        'attendance.additional_hours.view' => 'View Additional Hours',
        'attendance.additional_hours.apply' => 'Apply for Additional Hours',
        'attendance.additional_hours.approve' => 'Approve/Reject Additional Hours',
        
        // Settings
        'attendance.settings' => 'Manage Attendance Settings',
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Menu Items
    |--------------------------------------------------------------------------
    | Note: "My Attendance" is accessible via navbar check-in modal for all staff
    */
    'menu' => [
        // Main menu for admins
        [
            'name' => 'Attendance',
            'icon' => 'clock',
            'permission' => 'attendance.view',
            'children' => [
                ['name' => 'Dashboard', 'route' => 'admin.attendance.index', 'permission' => 'attendance.view'],
                ['name' => 'Mark Attendance', 'route' => 'admin.attendance.mark', 'permission' => 'attendance.mark'],
                ['name' => 'Shift Types', 'route' => 'admin.attendance.shift_types.index', 'permission' => 'attendance.shift_types.view'],
                ['name' => 'Shift Assignments', 'route' => 'admin.attendance.shifts.index', 'permission' => 'attendance.shifts.view'],
                ['name' => 'Work Shift', 'route' => 'admin.attendance.work_shift.index', 'permission' => 'attendance.shifts.view'],
                ['name' => 'Leave Applications', 'route' => 'admin.attendance.leave.index', 'permission' => 'attendance.leave.view'],
                ['name' => 'Additional Hours', 'route' => 'admin.attendance.additional_hours.index', 'permission' => 'attendance.additional_hours.view'],
                ['name' => 'Settings', 'route' => 'admin.attendance.settings.index', 'permission' => 'attendance.settings'],
            ],
        ],
    ],
];
