<?php

namespace Modules\Attendance\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\Admin\Staff;

class AnnualLeaveSetting extends Model
{
    protected $table = 'att_annual_leave_settings';

    protected $fillable = ['staff_id', 'leave_type_id', 'annual_days'];

    protected $casts = ['annual_days' => 'decimal:1'];

    public function staff(): BelongsTo
    {
        return $this->belongsTo(Staff::class, 'staff_id');
    }

    public function leaveType(): BelongsTo
    {
        return $this->belongsTo(LeaveType::class, 'leave_type_id');
    }
}
