<?php

namespace Modules\Attendance\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use App\Models\Admin\Staff;

class LeaveApplication extends Model
{
    protected $table = 'att_leave_applications';

    protected $fillable = [
        'staff_id',
        'subject',
        'request_type_id',
        'leave_type_id',
        'number_of_days',
        'from_date',
        'to_date',
        'reason',
        'attachment',
        'status',
        'approved_by',
        'approved_at',
        'reject_reason',
    ];

    protected $casts = [
        'from_date' => 'datetime',
        'to_date' => 'datetime',
        'approved_at' => 'datetime',
        'number_of_days' => 'decimal:1',
    ];

    public function staff(): BelongsTo
    {
        return $this->belongsTo(Staff::class, 'staff_id');
    }

    public function requestType(): BelongsTo
    {
        return $this->belongsTo(RequestType::class, 'request_type_id');
    }

    public function leaveType(): BelongsTo
    {
        return $this->belongsTo(LeaveType::class, 'leave_type_id');
    }

    public function approver(): BelongsTo
    {
        return $this->belongsTo(Staff::class, 'approved_by');
    }

    public function followers(): BelongsToMany
    {
        return $this->belongsToMany(Staff::class, 'att_leave_followers', 'leave_application_id', 'staff_id');
    }

    public function handovers(): BelongsToMany
    {
        return $this->belongsToMany(Staff::class, 'att_leave_handovers', 'leave_application_id', 'staff_id');
    }

    // Status badge
    public function getStatusBadgeAttribute(): string
    {
        return match($this->status) {
            'new' => '<span class="status-badge status-new">New</span>',
            'approved' => '<span class="status-badge status-approved">Approved</span>',
            'rejected' => '<span class="status-badge status-rejected">Rejected</span>',
            default => $this->status,
        };
    }
}
