<?php

namespace Modules\Attendance\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\Admin\Staff;

class StaffLeaveSetting extends Model
{
    protected $table = 'att_staff_leave_settings';

    protected $fillable = [
        'staff_id',
        'leave_type_id',
        'days_per_month',
        'days_per_year',
    ];

    protected $casts = [
        'days_per_month' => 'integer',
        'days_per_year' => 'integer',
    ];

    public function staff(): BelongsTo
    {
        return $this->belongsTo(Staff::class, 'staff_id');
    }

    public function leaveType(): BelongsTo
    {
        return $this->belongsTo(LeaveType::class, 'leave_type_id');
    }
}
