<style>
    .mark-header {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 24px;
        flex-wrap: wrap;
        gap: 16px;
    }
    .mark-header-title {
        font-size: 22px;
        font-weight: 700;
        color: var(--text-primary);
        margin: 0;
    }
    .mark-header-subtitle {
        font-size: 13px;
        color: var(--text-secondary);
        margin: 4px 0 0;
    }
    .mark-header-actions {
        display: flex;
        gap: 12px;
        align-items: center;
    }
    
    /* Table Card */
    .mark-table-card {
        background: var(--card-bg);
        border: 1px solid var(--card-border);
        border-radius: 12px;
        overflow: hidden;
    }
    .mark-table {
        width: 100%;
        border-collapse: collapse;
    }
    .mark-table th {
        background: var(--body-bg);
        padding: 14px 16px;
        font-size: 11px;
        font-weight: 600;
        color: var(--text-muted);
        text-transform: uppercase;
        letter-spacing: 0.5px;
        text-align: left;
        border-bottom: 1px solid var(--card-border);
        position: sticky;
        top: 0;
        z-index: 10;
    }
    .mark-table td {
        padding: 12px 16px;
        font-size: 14px;
        color: var(--text-primary);
        border-bottom: 1px solid var(--card-border);
        vertical-align: middle;
    }
    .mark-table tbody tr:hover {
        background: var(--body-bg);
    }
    .mark-table tbody tr:last-child td {
        border-bottom: none;
    }
    
    /* Staff Cell */
    .mark-staff {
        display: flex;
        align-items: center;
        gap: 12px;
    }
    .mark-staff-avatar {
        width: 38px;
        height: 38px;
        border-radius: 10px;
        background: linear-gradient(135deg, var(--primary), var(--primary-dark, #4f46e5));
        display: flex;
        align-items: center;
        justify-content: center;
        color: #fff;
        font-weight: 600;
        font-size: 13px;
        flex-shrink: 0;
    }
    .mark-staff-name {
        font-weight: 600;
        color: var(--text-primary);
        margin-bottom: 2px;
    }
    .mark-staff-role {
        font-size: 12px;
        color: var(--text-muted);
    }
    
    /* Form Inputs */
    .mark-table .form-control {
        height: 36px;
        font-size: 13px;
        border-radius: 8px;
    }
    .mark-table select.form-control {
        min-width: 110px;
    }
    .mark-table input[type="time"] {
        width: 120px;
    }
    .mark-table input[type="text"] {
        width: 100%;
        min-width: 140px;
    }
    
    /* Footer Actions */
    .mark-footer {
        padding: 16px 20px;
        border-top: 1px solid var(--card-border);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 12px;
        background: var(--body-bg);
    }
    .mark-footer-left {
        display: flex;
        gap: 10px;
        flex-wrap: wrap;
    }
    
    /* Quick Fill Buttons */
    .quick-btn {
        padding: 8px 14px;
        font-size: 13px;
        border-radius: 8px;
        border: 1px solid var(--card-border);
        background: var(--card-bg);
        color: var(--text-secondary);
        cursor: pointer;
        transition: all 0.15s;
        display: inline-flex;
        align-items: center;
        gap: 6px;
    }
    .quick-btn:hover {
        border-color: var(--primary);
        color: var(--primary);
        background: var(--primary-light);
    }
    .quick-btn svg {
        width: 14px;
        height: 14px;
    }
</style>

{{-- Header --}}
<div class="mark-header">
    <div>
        <h1 class="mark-header-title">{{ $pageTitle }}</h1>
        <p class="mark-header-subtitle">Mark attendance for {{ \Carbon\Carbon::parse($date)->format('l, d F Y') }}</p>
    </div>
    <div class="mark-header-actions">
        <input type="date" id="dateSelect" value="{{ $date }}" 
               onchange="window.location='{{ route('admin.attendance.mark') }}?date='+this.value"
               class="form-control" style="width: auto;">
        <a href="{{ route('admin.attendance.index', ['date' => $date]) }}" class="btn btn-secondary">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="width:16px;height:16px;">
                <path d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
            </svg>
            Back
        </a>
    </div>
</div>

<form action="{{ route('admin.attendance.mark.store') }}" method="POST">
    @csrf
    <input type="hidden" name="date" value="{{ $date }}">

    <div class="mark-table-card">
        <div style="overflow-x: auto; max-height: 70vh;">
            <table class="mark-table">
                <thead>
                    <tr>
                        <th style="width:50px;">#</th>
                        <th style="min-width: 200px;">Staff</th>
                        <th style="width: 130px;">Check In</th>
                        <th style="width: 130px;">Check Out</th>
                        <th style="width: 130px;">Status</th>
                        <th style="min-width: 160px;">Remarks</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($staffList as $index => $staff)
                        @php
                            $att = $attendances->get($staff->id);
                        @endphp
                        <tr data-staff="{{ $staff->id }}">
                            <td style="color: var(--text-muted);">{{ $index + 1 }}</td>
                            <td>
                                <div class="mark-staff">
                                    <div class="mark-staff-avatar">
                                        {{ strtoupper(substr($staff->first_name, 0, 1)) }}{{ strtoupper(substr($staff->last_name, 0, 1)) }}
                                    </div>
                                    <div>
                                        <div class="mark-staff-name">{{ $staff->first_name }} {{ $staff->last_name }}</div>
                                        <div class="mark-staff-role">{{ $staff->designation ?? 'Staff' }}</div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <input type="time" 
                                       name="attendance[{{ $staff->id }}][check_in]" 
                                       value="{{ $att && $att->check_in ? \Carbon\Carbon::parse($att->check_in)->format('H:i') : '' }}"
                                       class="form-control check-in-input"
                                       onchange="updateStatus({{ $staff->id }})">
                            </td>
                            <td>
                                <input type="time" 
                                       name="attendance[{{ $staff->id }}][check_out]" 
                                       value="{{ $att && $att->check_out ? \Carbon\Carbon::parse($att->check_out)->format('H:i') : '' }}"
                                       class="form-control">
                            </td>
                            <td>
                                <select name="attendance[{{ $staff->id }}][status]" 
                                        id="status_{{ $staff->id }}"
                                        class="form-control status-select">
                                    <option value="present" {{ $att && $att->status == 'present' ? 'selected' : '' }}>Present</option>
                                    <option value="absent" {{ (!$att || $att->status == 'absent') ? 'selected' : '' }}>Absent</option>
                                    <option value="late" {{ $att && $att->status == 'late' ? 'selected' : '' }}>Late</option>
                                    <option value="half_day" {{ $att && $att->status == 'half_day' ? 'selected' : '' }}>Half Day</option>
                                    <option value="on_leave" {{ $att && $att->status == 'on_leave' ? 'selected' : '' }}>On Leave</option>
                                    <option value="holiday" {{ $att && $att->status == 'holiday' ? 'selected' : '' }}>Holiday</option>
                                    <option value="weekend" {{ $att && $att->status == 'weekend' ? 'selected' : '' }}>Weekend</option>
                                </select>
                            </td>
                            <td>
                                <input type="text" 
                                       name="attendance[{{ $staff->id }}][remarks]" 
                                       value="{{ $att->remarks ?? '' }}"
                                       placeholder="Optional"
                                       class="form-control">
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        
        <div class="mark-footer">
            <div class="mark-footer-left">
                <button type="button" class="quick-btn" onclick="markAllPresent()">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    All Present (9:00 AM)
                </button>
                <button type="button" class="quick-btn" onclick="markAllHoliday()">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                    </svg>
                    All Holiday
                </button>
                <button type="button" class="quick-btn" onclick="clearAll()">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                    </svg>
                    Clear All
                </button>
            </div>
            <button type="submit" class="btn btn-primary btn-lg">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="width:18px;height:18px;">
                    <path d="M5 13l4 4L19 7"/>
                </svg>
                Save Attendance
            </button>
        </div>
    </div>
</form>

<script>
function updateStatus(staffId) {
    const checkIn = document.querySelector(`input[name="attendance[${staffId}][check_in]"]`).value;
    const statusSelect = document.getElementById('status_' + staffId);
    
    if (checkIn) {
        statusSelect.value = 'present';
    }
}

function markAllPresent() {
    document.querySelectorAll('.check-in-input').forEach(input => {
        if (!input.value) input.value = '09:00';
    });
    document.querySelectorAll('.status-select').forEach(select => {
        const row = select.closest('tr');
        if (row.querySelector('.check-in-input').value) {
            select.value = 'present';
        }
    });
}

function markAllHoliday() {
    document.querySelectorAll('.check-in-input').forEach(input => input.value = '');
    document.querySelectorAll('input[name*="[check_out]"]').forEach(input => input.value = '');
    document.querySelectorAll('.status-select').forEach(select => select.value = 'holiday');
}

function clearAll() {
    if (!confirm('Clear all attendance data for this day?')) return;
    document.querySelectorAll('.check-in-input').forEach(input => input.value = '');
    document.querySelectorAll('input[name*="[check_out]"]').forEach(input => input.value = '');
    document.querySelectorAll('input[name*="[remarks]"]').forEach(input => input.value = '');
    document.querySelectorAll('.status-select').forEach(select => select.value = 'absent');
}
</script>
