<style>
.leave-form-container { max-width: 700px; margin: 0 auto; padding: 20px; }
.leave-form-header { margin-bottom: 24px; }
.leave-form-back { display: inline-flex; align-items: center; gap: 6px; color: var(--text-muted); text-decoration: none; font-size: 14px; margin-bottom: 12px; }
.leave-form-back:hover { color: var(--primary); }
.leave-form-title { font-size: 24px; font-weight: 700; color: var(--text-primary); margin: 0; display: flex; align-items: center; gap: 10px; }
.leave-form-title svg { width: 28px; height: 28px; color: var(--primary); }

.leave-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; }
.leave-card-body { padding: 24px; }

.alert { padding: 12px 16px; border-radius: 8px; margin-bottom: 20px; font-size: 14px; }
.alert-error { background: rgba(239, 68, 68, 0.1); border: 1px solid #ef4444; color: #ef4444; }
.alert-success { background: rgba(16, 185, 129, 0.1); border: 1px solid #10b981; color: #10b981; }
.alert ul { margin: 0; padding-left: 20px; }

.form-section { margin-bottom: 24px; padding-bottom: 20px; border-bottom: 1px solid var(--card-border); }
.form-section:last-child { margin-bottom: 0; padding-bottom: 0; border-bottom: none; }
.form-section-title { font-size: 14px; font-weight: 700; color: var(--text-primary); margin-bottom: 16px; display: flex; align-items: center; gap: 8px; text-transform: uppercase; letter-spacing: 0.5px; }

.form-row { display: grid; grid-template-columns: 1fr 1fr; gap: 16px; }
.form-row-3 { display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 16px; }
.form-group { margin-bottom: 16px; }
.form-label { display: block; font-size: 14px; font-weight: 500; color: var(--text-primary); margin-bottom: 6px; }
.form-label .req { color: #dc2626; }
.form-input, .form-select, .form-textarea { 
    width: 100%; padding: 10px 14px; 
    border: 1px solid var(--input-border); border-radius: 8px; 
    font-size: 14px; background: var(--input-bg); color: var(--input-text); 
    transition: all 0.2s; 
}
.form-input:focus, .form-select:focus, .form-textarea:focus { 
    outline: none; border-color: var(--primary); 
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1); 
}
.form-textarea { min-height: 80px; resize: vertical; }
.form-hint { font-size: 12px; color: var(--text-muted); margin-top: 4px; }

.balance-card { 
    background: linear-gradient(135deg, #3b82f6, #1d4ed8); 
    border-radius: 10px; padding: 16px; color: white; margin-bottom: 20px;
    display: flex; justify-content: space-between; align-items: center;
}
.balance-card-left { }
.balance-card-label { font-size: 12px; opacity: 0.9; margin-bottom: 4px; }
.balance-card-value { font-size: 28px; font-weight: 700; }
.balance-card-value span { font-size: 14px; font-weight: 400; opacity: 0.8; }
.balance-card-right { text-align: right; }
.balance-detail { font-size: 12px; opacity: 0.8; }

.balance-warning {
    display: none; background: rgba(245, 158, 11, 0.1); border: 1px solid #f59e0b; 
    color: #b45309; padding: 10px 14px; border-radius: 8px; margin-bottom: 16px; font-size: 13px;
}

.request-type-tabs { display: flex; gap: 8px; flex-wrap: wrap; margin-bottom: 16px; }
.request-type-tab { 
    padding: 10px 18px; border: 2px solid var(--card-border); border-radius: 8px; 
    font-size: 13px; font-weight: 500; color: var(--text-primary); cursor: pointer; 
    transition: all 0.2s; background: var(--card-bg);
}
.request-type-tab:hover { border-color: var(--primary); }
.request-type-tab.active { border-color: var(--primary); background: rgba(59, 130, 246, 0.1); color: var(--primary); }
.request-type-tab input { display: none; }

.form-actions { 
    display: flex; gap: 12px; padding-top: 20px; 
    border-top: 1px solid var(--card-border); margin-top: 24px; 
    justify-content: flex-end;
}
.btn { 
    padding: 10px 24px; border-radius: 8px; font-weight: 600; font-size: 14px; 
    cursor: pointer; transition: all 0.2s; border: none; 
    display: inline-flex; align-items: center; gap: 8px; text-decoration: none; 
}
.btn-primary { background: var(--primary); color: #fff; }
.btn-primary:hover { background: var(--primary-hover); }
.btn-secondary { background: var(--card-bg); color: var(--text-primary); border: 1px solid var(--card-border); }
.btn-secondary:hover { background: var(--hover-bg); }

/* Select2 Custom Styling */
.select2-container { width: 100% !important; }
.select2-container--default .select2-selection--multiple {
    min-height: 44px;
    border: 1px solid var(--input-border, #ced4da);
    border-radius: 8px;
    background: var(--input-bg, #fff);
    padding: 4px 8px;
}
.select2-container--default.select2-container--focus .select2-selection--multiple {
    border-color: var(--primary, #3b82f6);
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}
.select2-container--default .select2-selection--multiple .select2-selection__choice {
    background-color: var(--primary, #3b82f6);
    border: none;
    color: #fff;
    padding: 4px 10px;
    border-radius: 6px;
    font-size: 13px;
    margin: 3px 4px 3px 0;
}
.select2-container--default .select2-selection--multiple .select2-selection__choice__remove {
    color: rgba(255,255,255,0.7);
    margin-right: 6px;
    font-size: 14px;
}
.select2-container--default .select2-selection--multiple .select2-selection__choice__remove:hover {
    color: #fff;
}
.select2-dropdown {
    border: 1px solid var(--input-border, #ced4da);
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}
.select2-container--default .select2-results__option--highlighted[aria-selected] {
    background-color: var(--primary, #3b82f6);
}
.select2-container--default .select2-search--inline .select2-search__field {
    font-size: 14px;
    margin-top: 4px;
}

@media (max-width: 600px) { 
    .form-row, .form-row-3 { grid-template-columns: 1fr; } 
    .balance-card { flex-direction: column; text-align: center; gap: 12px; }
    .balance-card-right { text-align: center; }
}
</style>

{{-- Select2 CSS --}}
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<div class="leave-form-container">
    <div class="leave-form-header">
        <a href="{{ route('admin.attendance.my_leaves') }}" class="leave-form-back">
            <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M19 12H5m7-7l-7 7 7 7"/></svg>
            Back to My Leaves
        </a>
        <h1 class="leave-form-title">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
            </svg>
            Apply for Leave
        </h1>
    </div>

    <div class="leave-card">
        <div class="leave-card-body">
            @if ($errors->any())
                <div class="alert alert-error">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-error">{{ session('error') }}</div>
            @endif

            @if(session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif

            <form action="{{ route('admin.attendance.leave.store') }}" method="POST" enctype="multipart/form-data" id="leaveForm">
                @csrf

                {{-- Request Type Tabs --}}
                <div class="form-section">
                    <div class="form-section-title">Request Type</div>
                    <div class="request-type-tabs">
                        @forelse($requestTypes ?? [] as $rt)
                            <label class="request-type-tab {{ $loop->first ? 'active' : '' }}" onclick="this.parentElement.querySelectorAll('.request-type-tab').forEach(t => t.classList.remove('active')); this.classList.add('active');">
                                <input type="radio" name="request_type_id" value="{{ $rt->id }}" {{ $loop->first ? 'checked' : '' }}>
                                {{ $rt->name }}
                            </label>
                        @empty
                            <label class="request-type-tab active">
                                <input type="radio" name="request_type_id" value="" checked>
                                Leave
                            </label>
                        @endforelse
                    </div>
                </div>

                {{-- Leave Type & Balance --}}
                <div class="form-section" id="leaveTypeSection">
                    <div class="form-section-title">Leave Details</div>
                    
                    <div class="balance-card" id="balanceCard">
                        <div class="balance-card-left">
                            <div class="balance-card-label">This Month Balance</div>
                            <div class="balance-card-value"><span id="remainingDays">--</span> <span>days</span></div>
                        </div>
                        <div class="balance-card-right">
                            <div class="balance-detail">Limit: <span id="totalDays">--</span> days/month</div>
                            <div class="balance-detail">Used: <span id="usedDays">--</span> days</div>
                        </div>
                    </div>
                    
                    <div id="balanceWarning" class="balance-warning">
                        ⚠️ You have exceeded your monthly leave limit. You can still apply, but it may require special approval.
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label">Leave Type<span class="req">*</span></label>
                            <select name="leave_type_id" id="leaveType" class="form-select" required onchange="fetchLeaveBalance()">
                                @forelse($leaveTypes ?? [] as $lt)
                                    <option value="{{ $lt->id }}">{{ $lt->name }}{{ $lt->code ? ' ('.$lt->code.')' : '' }}</option>
                                @empty
                                    <option value="">-- No leave types available --</option>
                                @endforelse
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Number of Days<span class="req">*</span></label>
                            <input type="number" name="number_of_days" id="numberOfDays" class="form-input" value="1" min="0.5" step="0.5" required>
                            <div class="form-hint">Half day = 0.5</div>
                        </div>
                    </div>
                </div>

                {{-- Date Range --}}
                <div class="form-section">
                    <div class="form-section-title">Duration</div>
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label">From Date<span class="req">*</span></label>
                            <input type="date" name="from_date" id="fromDate" class="form-input" value="{{ date('Y-m-d') }}" required onchange="calculateDays()">
                        </div>
                        <div class="form-group">
                            <label class="form-label">To Date<span class="req">*</span></label>
                            <input type="date" name="to_date" id="toDate" class="form-input" value="{{ date('Y-m-d') }}" required onchange="calculateDays()">
                        </div>
                    </div>
                </div>

                {{-- Reason --}}
                <div class="form-section">
                    <div class="form-section-title">Details</div>
                    <div class="form-group">
                        <label class="form-label">Reason</label>
                        <textarea name="reason" class="form-textarea" placeholder="Enter reason for leave...">{{ old('reason') }}</textarea>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Attachment</label>
                        <input type="file" name="attachment" class="form-input" accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                        <div class="form-hint">Optional. Max 5MB (PDF, DOC, Images)</div>
                    </div>
                </div>

                {{-- Followers & Handovers with Select2 --}}
                <div class="form-section">
                    <div class="form-section-title">Notify & Handover</div>
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label">Notify (Followers)</label>
                            <select name="followers[]" id="followers" class="select2-staff" multiple="multiple">
                                @foreach($staffList ?? [] as $staff)
                                    <option value="{{ $staff->id }}"
                                        {{ in_array($staff->id, old('followers', $selectedFollowers ?? [])) ? 'selected' : '' }}>
                                        {{ $staff->first_name }} {{ $staff->last_name }}
                                    </option>
                                @endforeach
                            </select>
                            <div class="form-hint">Select staff members to notify</div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Handover Work To</label>
                            <select name="handovers[]" id="handovers" class="select2-staff" multiple="multiple">
                                @foreach($staffList ?? [] as $staff)
                                    <option value="{{ $staff->id }}"
                                        {{ in_array($staff->id, old('handovers', $selectedHandovers ?? [])) ? 'selected' : '' }}>
                                        {{ $staff->first_name }} {{ $staff->last_name }}
                                    </option>
                                @endforeach
                            </select>
                            <div class="form-hint">Who will handle your work</div>
                        </div>
                    </div>
                </div>

                <div class="form-actions">
                    <a href="{{ route('admin.attendance.my_leaves') }}" class="btn btn-secondary">Cancel</a>
                    <button type="submit" class="btn btn-primary">
                        <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M5 13l4 4L19 7"/></svg>
                        Submit Application
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

{{-- jQuery (required for Select2) --}}
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
{{-- Select2 JS --}}
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
function calculateDays() {
    var from = document.getElementById('fromDate').value;
    var to = document.getElementById('toDate').value;
    if (from && to) {
        var fromDate = new Date(from);
        var toDate = new Date(to);
        var diffTime = toDate - fromDate;
        var diffDays = Math.max(1, Math.ceil(diffTime / (1000 * 60 * 60 * 24)) + 1);
        document.getElementById('numberOfDays').value = diffDays;
    }
}

function fetchLeaveBalance() {
    var leaveTypeId = document.getElementById('leaveType').value;
    if (!leaveTypeId) return;
    
    fetch('{{ route("admin.attendance.leave.balance") }}?leave_type_id=' + leaveTypeId)
        .then(function(r) { return r.json(); })
        .then(function(data) {
            document.getElementById('remainingDays').textContent = data.remaining ?? 0;
            document.getElementById('totalDays').textContent = data.limit ?? data.total ?? 0;
            document.getElementById('usedDays').textContent = data.used ?? 0;
            
            var warningEl = document.getElementById('balanceWarning');
            var balanceCard = document.getElementById('balanceCard');
            if (data.warning || (data.limit > 0 && data.remaining <= 0)) {
                warningEl.style.display = 'block';
                balanceCard.style.background = 'linear-gradient(135deg, #f59e0b, #d97706)';
            } else {
                warningEl.style.display = 'none';
                balanceCard.style.background = 'linear-gradient(135deg, #3b82f6, #1d4ed8)';
            }
        })
        .catch(function() {
            document.getElementById('remainingDays').textContent = '0';
            document.getElementById('totalDays').textContent = '0';
            document.getElementById('usedDays').textContent = '0';
            document.getElementById('balanceWarning').style.display = 'none';
        });
}

document.addEventListener('DOMContentLoaded', function() {
    calculateDays();
    fetchLeaveBalance();
    
    // Initialize Select2 for staff selects
    $('.select2-staff').select2({
        placeholder: 'Search and select staff...',
        allowClear: true,
        closeOnSelect: false,
        width: '100%'
    });
});
</script>   