<style>
.leave-view-container { max-width: 800px; margin: 0 auto; padding: 20px; }
.leave-view-header { margin-bottom: 24px; }
.leave-view-back { display: inline-flex; align-items: center; gap: 6px; color: var(--text-muted); text-decoration: none; font-size: 13px; margin-bottom: 12px; }
.leave-view-back:hover { color: var(--primary); }
.leave-view-title { font-size: 22px; font-weight: 700; color: var(--text-primary); margin: 0; }

.leave-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; margin-bottom: 20px; }
.leave-card-header { padding: 16px 20px; border-bottom: 1px solid var(--card-border); display: flex; justify-content: space-between; align-items: center; }
.leave-card-title { font-size: 16px; font-weight: 600; color: var(--text-primary); }
.leave-card-body { padding: 20px; }

.status-badge { padding: 6px 16px; border-radius: 20px; font-size: 13px; font-weight: 600; }
.status-new { background: rgba(245, 158, 11, 0.1); color: #f59e0b; }
.status-approved { background: rgba(16, 185, 129, 0.1); color: #10b981; }
.status-rejected { background: rgba(239, 68, 68, 0.1); color: #ef4444; }

.info-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 20px; }
.info-item { }
.info-label { font-size: 12px; color: var(--text-muted); text-transform: uppercase; margin-bottom: 4px; }
.info-value { font-size: 15px; color: var(--text-primary); font-weight: 500; }

.reason-box { background: var(--hover-bg); border-radius: 8px; padding: 16px; margin-top: 20px; }
.reason-box-title { font-size: 12px; color: var(--text-muted); text-transform: uppercase; margin-bottom: 8px; }
.reason-box-text { font-size: 14px; color: var(--text-primary); line-height: 1.6; }

.reject-reason { background: rgba(239, 68, 68, 0.05); border: 1px solid rgba(239, 68, 68, 0.2); border-radius: 8px; padding: 16px; margin-top: 20px; }
.reject-reason-title { font-size: 12px; color: #ef4444; text-transform: uppercase; margin-bottom: 8px; }
.reject-reason-text { font-size: 14px; color: #ef4444; }

.action-buttons { display: flex; gap: 12px; margin-top: 20px; }
.btn { padding: 10px 20px; border-radius: 8px; font-weight: 600; font-size: 14px; cursor: pointer; transition: all 0.2s; border: none; text-decoration: none; display: inline-flex; align-items: center; gap: 8px; }
.btn-approve { background: #10b981; color: white; }
.btn-approve:hover { background: #059669; }
.btn-reject { background: #ef4444; color: white; }
.btn-reject:hover { background: #dc2626; }
.btn-secondary { background: var(--card-bg); color: var(--text-primary); border: 1px solid var(--card-border); }
.btn-secondary:hover { background: var(--hover-bg); }

@media (max-width: 600px) { .info-grid { grid-template-columns: 1fr; } }
</style>

<div class="leave-view-container">
    <div class="leave-view-header">
        <a href="{{ route('admin.attendance.leave.index') }}" class="leave-view-back">
            <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M19 12H5m7-7l-7 7 7 7"/></svg>
            Back to Leave Applications
        </a>
        <h1 class="leave-view-title">{{ $pageTitle ?? 'Leave Application Details' }}</h1>
    </div>

    @if(session('success'))
        <div style="background: rgba(16, 185, 129, 0.1); border: 1px solid #10b981; color: #10b981; padding: 12px 16px; border-radius: 8px; margin-bottom: 20px;">
            {{ session('success') }}
        </div>
    @endif

    <div class="leave-card">
        <div class="leave-card-header">
            <span class="leave-card-title">Application #{{ $leave->id }}</span>
            <span class="status-badge status-{{ $leave->status }}">
                @if($leave->status == 'new') Pending
                @elseif($leave->status == 'approved') Approved
                @elseif($leave->status == 'rejected') Rejected
                @else {{ ucfirst($leave->status) }}
                @endif
            </span>
        </div>
        <div class="leave-card-body">
            <div class="info-grid">
                <div class="info-item">
                    <div class="info-label">Staff Name</div>
                    <div class="info-value">{{ $leave->staff->first_name ?? '' }} {{ $leave->staff->last_name ?? '' }}</div>
                </div>
                <div class="info-item">
                    <div class="info-label">Leave Type</div>
                    <div class="info-value">{{ $leave->leaveType->name ?? 'Leave' }}</div>
                </div>
                <div class="info-item">
                    <div class="info-label">From Date</div>
                    <div class="info-value">{{ \Carbon\Carbon::parse($leave->from_date)->format('d M Y') }}</div>
                </div>
                <div class="info-item">
                    <div class="info-label">To Date</div>
                    <div class="info-value">{{ \Carbon\Carbon::parse($leave->to_date)->format('d M Y') }}</div>
                </div>
                <div class="info-item">
                    <div class="info-label">Number of Days</div>
                    <div class="info-value">{{ $leave->number_of_days }} day(s)</div>
                </div>
                <div class="info-item">
                    <div class="info-label">Applied On</div>
                    <div class="info-value">{{ $leave->created_at->format('d M Y, h:i A') }}</div>
                </div>
                @if($leave->approver)
                <div class="info-item">
                    <div class="info-label">{{ $leave->status == 'approved' ? 'Approved' : 'Processed' }} By</div>
                    <div class="info-value">{{ $leave->approver->first_name ?? '' }} {{ $leave->approver->last_name ?? '' }}</div>
                </div>
                @endif
                @if($leave->approved_at)
                <div class="info-item">
                    <div class="info-label">{{ $leave->status == 'approved' ? 'Approved' : 'Processed' }} On</div>
                    <div class="info-value">{{ $leave->approved_at->format('d M Y, h:i A') }}</div>
                </div>
                @endif
            </div>

            @if($leave->reason)
            <div class="reason-box">
                <div class="reason-box-title">Reason</div>
                <div class="reason-box-text">{{ $leave->reason }}</div>
            </div>
            @endif

            @if($leave->status == 'rejected' && $leave->reject_reason)
            <div class="reject-reason">
                <div class="reject-reason-title">Rejection Reason</div>
                <div class="reject-reason-text">{{ $leave->reject_reason }}</div>
            </div>
            @endif

            @if($leave->status == 'new')
            <div class="action-buttons">
                <form action="{{ route('admin.attendance.leave.approve', $leave->id) }}" method="POST" style="display:inline;">
                    @csrf
                    <button type="submit" class="btn btn-approve" onclick="return confirm('Approve this leave?')">
                        <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M5 13l4 4L19 7"/></svg>
                        Approve
                    </button>
                </form>
                <form action="{{ route('admin.attendance.leave.reject', $leave->id) }}" method="POST" style="display:inline;">
                    @csrf
                    <button type="submit" class="btn btn-reject" onclick="return confirm('Reject this leave?')">
                        <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M6 18L18 6M6 6l12 12"/></svg>
                        Reject
                    </button>
                </form>
                <a href="{{ route('admin.attendance.leave.index') }}" class="btn btn-secondary">Back</a>
            </div>
            @else
            <div class="action-buttons">
                <a href="{{ route('admin.attendance.leave.index') }}" class="btn btn-secondary">Back to List</a>
            </div>
            @endif
        </div>
    </div>

    @if($leave->followers->count() > 0 || $leave->handovers->count() > 0)
    <div class="leave-card">
        <div class="leave-card-header">
            <span class="leave-card-title">Followers & Handover</span>
        </div>
        <div class="leave-card-body">
            <div class="info-grid">
                <div class="info-item">
                    <div class="info-label">Followers</div>
                    <div class="info-value">
                        @if($leave->followers->count() > 0)
                            {{ $leave->followers->map(fn($f) => $f->first_name . ' ' . $f->last_name)->implode(', ') }}
                        @else
                            None
                        @endif
                    </div>
                </div>
                <div class="info-item">
                    <div class="info-label">Handover To</div>
                    <div class="info-value">
                        @if($leave->handovers->count() > 0)
                            {{ $leave->handovers->map(fn($h) => $h->first_name . ' ' . $h->last_name)->implode(', ') }}
                        @else
                            None
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>
