<div>
    <style>
        .ws-container { padding: 20px; }
        
        /* Header */
        .ws-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px; flex-wrap: wrap; gap: 16px; }
        .ws-title { font-size: 24px; font-weight: 700; color: var(--text-primary); margin: 0; display: flex; align-items: center; gap: 10px; }
        .ws-title svg { width: 28px; height: 28px; color: var(--primary); }
        
        /* Month Navigator */
        .ws-month-nav { display: flex; align-items: center; gap: 12px; background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 10px; padding: 8px 16px; }
        .ws-month-btn { background: none; border: none; cursor: pointer; padding: 6px; color: var(--text-muted); border-radius: 6px; display: flex; align-items: center; justify-content: center; transition: all 0.15s; }
        .ws-month-btn:hover { background: var(--hover-bg); color: var(--primary); }
        .ws-month-btn svg { width: 20px; height: 20px; }
        .ws-month-label { font-size: 16px; font-weight: 600; color: var(--text-primary); min-width: 140px; text-align: center; }
        
        /* Filters Card */
        .ws-filters { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; padding: 16px 20px; margin-bottom: 20px; }
        .ws-filters-row { display: flex; gap: 16px; flex-wrap: wrap; align-items: flex-end; }
        .ws-filter-group { flex: 1; min-width: 180px; }
        .ws-filter-label { font-size: 12px; font-weight: 600; color: var(--text-muted); text-transform: uppercase; letter-spacing: 0.5px; margin-bottom: 6px; }
        .ws-filter-select { width: 100%; padding: 10px 14px; background: var(--input-bg); border: 1px solid var(--input-border); border-radius: 8px; font-size: 14px; color: var(--text-primary); cursor: pointer; }
        .ws-filter-select:focus { outline: none; border-color: var(--primary); }
        
        /* Staff Multi-Select */
        .ws-staff-select { position: relative; }
        .ws-staff-btn { width: 100%; padding: 10px 14px; background: var(--input-bg); border: 1px solid var(--input-border); border-radius: 8px; font-size: 14px; color: var(--text-primary); cursor: pointer; display: flex; align-items: center; justify-content: space-between; min-height: 44px; }
        .ws-staff-btn:hover { border-color: var(--primary); }
        .ws-staff-tags { display: flex; flex-wrap: wrap; gap: 4px; flex: 1; }
        .ws-staff-tag { display: inline-flex; align-items: center; gap: 4px; padding: 3px 8px; background: rgba(59, 130, 246, 0.1); color: var(--primary); border-radius: 4px; font-size: 11px; font-weight: 500; }
        .ws-staff-tag-x { cursor: pointer; opacity: 0.7; }
        .ws-staff-tag-x:hover { opacity: 1; }
        .ws-staff-placeholder { color: var(--text-muted); }
        .ws-staff-dropdown { position: absolute; top: calc(100% + 4px); left: 0; right: 0; background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 10px; box-shadow: 0 10px 40px rgba(0,0,0,0.15); z-index: 1000; display: none; }
        .ws-staff-dropdown.show { display: block; }
        .ws-staff-search { padding: 10px; border-bottom: 1px solid var(--card-border); }
        .ws-staff-search input { width: 100%; padding: 8px 12px; background: var(--input-bg); border: 1px solid var(--input-border); border-radius: 6px; font-size: 13px; color: var(--text-primary); }
        .ws-staff-search input:focus { outline: none; border-color: var(--primary); }
        .ws-staff-options { max-height: 240px; overflow-y: auto; padding: 8px; }
        .ws-staff-option { display: flex; align-items: center; gap: 10px; padding: 8px 10px; border-radius: 6px; cursor: pointer; font-size: 13px; color: var(--text-primary); }
        .ws-staff-option:hover { background: var(--hover-bg); }
        .ws-staff-option.selected { background: rgba(59, 130, 246, 0.05); }
        .ws-staff-check { width: 18px; height: 18px; border: 2px solid var(--input-border); border-radius: 4px; display: flex; align-items: center; justify-content: center; flex-shrink: 0; }
        .ws-staff-option.selected .ws-staff-check { background: var(--primary); border-color: var(--primary); }
        .ws-staff-check svg { width: 12px; height: 12px; color: #fff; opacity: 0; }
        .ws-staff-option.selected .ws-staff-check svg { opacity: 1; }
        
        /* Grid Card */
        .ws-grid-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; }
        .ws-grid-header { padding: 14px 20px; border-bottom: 1px solid var(--card-border); display: flex; justify-content: space-between; align-items: center; background: var(--hover-bg); }
        .ws-grid-title { font-size: 15px; font-weight: 600; color: var(--text-primary); }
        .ws-grid-info { font-size: 13px; color: var(--text-muted); }
        .ws-grid-scroll { overflow-x: auto; }
        .ws-grid-hint { font-size: 11px; color: var(--text-muted); padding: 8px 20px; background: var(--hover-bg); border-bottom: 1px solid var(--card-border); }
        
        /* Table */
        .ws-table { width: 100%; border-collapse: collapse; min-width: 1200px; }
        .ws-table th { padding: 10px 8px; text-align: center; font-size: 11px; font-weight: 600; color: var(--text-muted); text-transform: uppercase; letter-spacing: 0.3px; background: var(--card-bg); border-bottom: 1px solid var(--card-border); position: sticky; top: 0; z-index: 10; white-space: nowrap; }
        .ws-table th.col-num { width: 45px; text-align: center; }
        .ws-table th.col-staff { min-width: 150px; text-align: left; padding-left: 16px; position: sticky; left: 0; background: var(--card-bg); z-index: 20; }
        .ws-table th.col-day { min-width: 65px; }
        .ws-table th.weekend { background: rgba(239, 68, 68, 0.05); color: #ef4444; }
        .ws-table th.today { background: rgba(59, 130, 246, 0.1); color: var(--primary); }
        .ws-table th .day-num { font-size: 14px; font-weight: 700; display: block; margin-top: 2px; }
        
        .ws-table td { padding: 8px 6px; text-align: center; border-bottom: 1px solid var(--card-border); vertical-align: middle; }
        .ws-table tr:hover td { background: var(--hover-bg); }
        .ws-table td.col-num { color: var(--text-muted); font-weight: 600; font-size: 12px; }
        .ws-table td.col-staff { text-align: left; padding-left: 16px; position: sticky; left: 0; background: var(--card-bg); z-index: 5; }
        .ws-table tr:hover td.col-staff { background: var(--hover-bg); }
        .ws-table td.weekend { background: rgba(239, 68, 68, 0.02); }
        .ws-table td.today { background: rgba(59, 130, 246, 0.05); }
        
        .ws-staff-name { font-weight: 500; font-size: 13px; color: var(--text-primary); white-space: nowrap; }
        
        /* Shift Cell */
        .ws-shift-cell { display: inline-flex; align-items: center; justify-content: center; padding: 4px 8px; border-radius: 6px; font-size: 10px; font-weight: 600; white-space: nowrap; min-width: 50px; }
        .ws-shift-cell.has-shift { color: #fff; }
        .ws-shift-cell.no-shift { color: var(--text-muted); background: var(--hover-bg); }
        
        /* Load More */
        .ws-load-more { padding: 16px; text-align: center; border-top: 1px solid var(--card-border); }
        .ws-load-btn { padding: 10px 24px; background: var(--hover-bg); border: 1px solid var(--card-border); border-radius: 8px; font-size: 13px; font-weight: 500; color: var(--text-primary); cursor: pointer; transition: all 0.15s; }
        .ws-load-btn:hover { background: var(--primary); color: #fff; border-color: var(--primary); }
        
        /* Empty State */
        .ws-empty { text-align: center; padding: 60px 20px; color: var(--text-muted); }
        .ws-empty svg { width: 48px; height: 48px; margin-bottom: 12px; opacity: 0.5; }
        
        /* Loading */
        .ws-loading { display: flex; align-items: center; justify-content: center; padding: 40px; color: var(--text-muted); gap: 10px; }
        .ws-spinner { width: 20px; height: 20px; border: 2px solid var(--card-border); border-top-color: var(--primary); border-radius: 50%; animation: spin 0.8s linear infinite; }
        @keyframes spin { to { transform: rotate(360deg); } }
        
        @media (max-width: 768px) {
            .ws-header { flex-direction: column; align-items: flex-start; }
            .ws-filters-row { flex-direction: column; }
            .ws-filter-group { min-width: 100%; }
        }
    </style>
    
    <div class="ws-container">
        <!-- Header -->
        <div class="ws-header">
            <h1 class="ws-title">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2" />
                </svg>
                Work Shift Table
            </h1>
            
            <!-- Month Navigator -->
            <div class="ws-month-nav">
                <button class="ws-month-btn" wire:click="previousMonth" title="Previous Month">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M15 19l-7-7 7-7"/></svg>
                </button>
                <span class="ws-month-label">{{ $monthName }}</span>
                <button class="ws-month-btn" wire:click="nextMonth" title="Next Month">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 5l7 7-7 7"/></svg>
                </button>
            </div>
        </div>
        
        <!-- Filters -->
        <div class="ws-filters">
            <div class="ws-filters-row">
                <!-- Department -->
                <div class="ws-filter-group">
                    <div class="ws-filter-label">Department</div>
                    <select class="ws-filter-select" wire:model.live="filterDepartment">
                        <option value="">All Departments</option>
                        @foreach($departments as $dept)
                            <option value="{{ $dept }}">{{ $dept }}</option>
                        @endforeach
                    </select>
                </div>
                
                <!-- Role -->
                <div class="ws-filter-group">
                    <div class="ws-filter-label">Role</div>
                    <select class="ws-filter-select" wire:model.live="filterRole">
                        <option value="">All Roles</option>
                        @foreach($roles as $role)
                            <option value="{{ $role }}">{{ $role }}</option>
                        @endforeach
                    </select>
                </div>
                
                <!-- Staff Multi-Select -->
                <div class="ws-filter-group" style="flex:2;">
                    <div class="ws-filter-label">Staff</div>
                    <div class="ws-staff-select" x-data="{ open: false }" @click.away="open = false">
                        <div class="ws-staff-btn" @click="open = !open">
                            <div class="ws-staff-tags">
                                @if(count($filterStaff) > 0)
                                    @foreach($staffList->whereIn('id', $filterStaff)->take(3) as $s)
                                        <span class="ws-staff-tag">
                                            {{ $s->first_name }}
                                            <span class="ws-staff-tag-x" wire:click.stop="toggleStaffFilter({{ $s->id }})">×</span>
                                        </span>
                                    @endforeach
                                    @if(count($filterStaff) > 3)
                                        <span class="ws-staff-tag">+{{ count($filterStaff) - 3 }} more</span>
                                    @endif
                                @else
                                    <span class="ws-staff-placeholder">All Staff</span>
                                @endif
                            </div>
                            <svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M19 9l-7 7-7-7"/></svg>
                        </div>
                        <div class="ws-staff-dropdown" :class="{ 'show': open }">
                            <div class="ws-staff-search">
                                <input type="text" placeholder="Search staff..." wire:model.live.debounce.300ms="staffSearch">
                            </div>
                            <div class="ws-staff-options">
                                @foreach($filteredStaffOptions as $staff)
                                    <div class="ws-staff-option {{ in_array($staff->id, $filterStaff) ? 'selected' : '' }}" 
                                         wire:click="toggleStaffFilter({{ $staff->id }})">
                                        <span class="ws-staff-check">
                                            <svg fill="none" stroke="currentColor" stroke-width="3" viewBox="0 0 24 24"><path d="M5 13l4 4L19 7"/></svg>
                                        </span>
                                        <span>{{ $staff->first_name }} {{ $staff->last_name }}</span>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Grid Card -->
        <div class="ws-grid-card" wire:loading.class="opacity-50">
            <div class="ws-grid-header">
                <div class="ws-grid-title">Shift Schedule</div>
                <div class="ws-grid-info">Showing {{ $staffList->count() }} of {{ $totalStaffCount }} staff</div>
            </div>
            <div class="ws-grid-hint">💡 Shift + Mouse scroll to scroll horizontally</div>
            
            <div class="ws-grid-scroll">
                @if($staffList->count() > 0)
                    <table class="ws-table">
                        <thead>
                            <tr>
                                <th class="col-num">#</th>
                                <th class="col-staff">Staff</th>
                                @foreach($daysInMonth as $day)
                                    <th class="col-day {{ $day['isWeekend'] ? 'weekend' : '' }} {{ $day['isToday'] ? 'today' : '' }}">
                                        {{ $day['dayName'] }}
                                        <span class="day-num">{{ $day['day'] }}</span>
                                    </th>
                                @endforeach
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($staffList as $index => $staff)
                                <tr>
                                    <td class="col-num">{{ $index + 1 }}</td>
                                    <td class="col-staff">
                                        <span class="ws-staff-name">{{ $staff->first_name }} {{ $staff->last_name }}</span>
                                    </td>
                                    @foreach($daysInMonth as $day)
                                        @php
                                            $shiftInfo = $shiftsData[$staff->id][$day['date']] ?? null;
                                        @endphp
                                        <td class="col-day {{ $day['isWeekend'] ? 'weekend' : '' }} {{ $day['isToday'] ? 'today' : '' }}">
                                            @if($shiftInfo)
                                                @if($shiftInfo['type'] === 'off')
                                                    <span class="ws-shift-cell" style="background: #f3f4f6; color: #6b7280;" title="Day Off">
                                                        OFF
                                                    </span>
                                                @else
                                                    <span class="ws-shift-cell has-shift" 
                                                          style="background: {{ $shiftInfo['color'] ?? '#3b82f6' }}"
                                                          title="{{ $shiftInfo['name'] }}{{ $shiftInfo['start'] ? ' ('.$shiftInfo['start'].'-'.$shiftInfo['end'].')' : '' }}">
                                                        {{ $shiftInfo['code'] ?? substr($shiftInfo['name'], 0, 3) }}
                                                    </span>
                                                @endif
                                            @else
                                                <span class="ws-shift-cell no-shift">—</span>
                                            @endif
                                        </td>
                                    @endforeach
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @else
                    <div class="ws-empty">
                        <svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path d="M18 18.72a9.094 9.094 0 003.741-.479 3 3 0 00-4.682-2.72m.94 3.198l.001.031c0 .225-.012.447-.037.666A11.944 11.944 0 0112 21c-2.17 0-4.207-.576-5.963-1.584A6.062 6.062 0 016 18.719m12 0a5.971 5.971 0 00-.941-3.197m0 0A5.995 5.995 0 0012 12.75a5.995 5.995 0 00-5.058 2.772m0 0a3 3 0 00-4.681 2.72 8.986 8.986 0 003.74.477m.94-3.197a5.971 5.971 0 00-.94 3.197M15 6.75a3 3 0 11-6 0 3 3 0 016 0zm6 3a2.25 2.25 0 11-4.5 0 2.25 2.25 0 014.5 0zm-13.5 0a2.25 2.25 0 11-4.5 0 2.25 2.25 0 014.5 0z"/>
                        </svg>
                        <div>No staff found matching your filters</div>
                    </div>
                @endif
            </div>
            
            @if($staffList->count() < $totalStaffCount)
                <div class="ws-load-more">
                    <button class="ws-load-btn" wire:click="loadMore">
                        <span wire:loading.remove wire:target="loadMore">Load More ({{ $totalStaffCount - $staffList->count() }} remaining)</span>
                        <span wire:loading wire:target="loadMore">Loading...</span>
                    </button>
                </div>
            @endif
        </div>
    </div>
    
    <!-- Loading Overlay -->
    <div wire:loading.flex wire:target="previousMonth, nextMonth, filterDepartment, filterRole" class="ws-loading" style="position:fixed;inset:0;background:rgba(0,0,0,0.1);z-index:9999;">
        <div class="ws-spinner"></div>
        <span>Loading...</span>
    </div>
</div>
