<style>
    .att-settings { padding: 20px; max-width: 1400px; }
    .att-settings h1 { font-size: 24px; font-weight: 700; margin: 0 0 24px 0; color: var(--text-primary); }
    
    /* Tabs */
    .att-tabs { display: flex; gap: 0; border-bottom: 2px solid var(--card-border); margin-bottom: 24px; overflow-x: auto; }
    .att-tab { padding: 12px 20px; font-size: 14px; font-weight: 600; color: var(--text-muted); background: none; border: none; cursor: pointer; position: relative; white-space: nowrap; }
    .att-tab:hover { color: var(--text-primary); }
    .att-tab.active { color: var(--primary); }
    .att-tab.active::after { content: ''; position: absolute; bottom: -2px; left: 0; right: 0; height: 2px; background: var(--primary); }
    
    /* Tab Content */
    .att-tab-content { display: none; }
    .att-tab-content.active { display: block; }
    
    /* Card */
    .att-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 10px; margin-bottom: 20px; }
    .att-card-header { padding: 16px 20px; border-bottom: 1px solid var(--card-border); display: flex; justify-content: space-between; align-items: center; }
    .att-card-title { font-size: 16px; font-weight: 600; color: var(--text-primary); margin: 0; }
    .att-card-body { padding: 20px; }
    
    /* Form */
    .att-form-group { margin-bottom: 20px; }
    .att-label { display: block; font-size: 14px; font-weight: 600; color: var(--text-primary); margin-bottom: 6px; }
    .att-help { font-size: 12px; color: var(--text-muted); margin-top: 4px; }
    .att-input, .att-select { width: 100%; padding: 10px 14px; border: 1px solid var(--input-border); border-radius: 8px; font-size: 14px; background: var(--input-bg); color: var(--text-primary); }
    .att-input:focus, .att-select:focus { outline: none; border-color: var(--primary); box-shadow: 0 0 0 3px rgba(59,130,246,0.1); }
    .att-input-sm { max-width: 200px; }
    
    /* Checkbox */
    .att-checkbox { display: flex; align-items: flex-start; gap: 12px; padding: 12px 16px; background: var(--hover-bg, #f8fafc); border-radius: 8px; margin-bottom: 12px; }
    .att-checkbox input[type="checkbox"] { width: 20px; height: 20px; margin-top: 2px; accent-color: var(--primary); flex-shrink: 0; }
    .att-checkbox-content { flex: 1; }
    .att-checkbox-label { font-size: 14px; font-weight: 600; color: var(--text-primary); margin-bottom: 2px; }
    .att-checkbox-desc { font-size: 12px; color: var(--text-muted); line-height: 1.4; }
    
    /* Buttons */
    .att-btn { padding: 10px 20px; border-radius: 8px; font-size: 14px; font-weight: 600; cursor: pointer; border: none; display: inline-flex; align-items: center; gap: 8px; }
    .att-btn-primary { background: var(--primary); color: #fff; }
    .att-btn-primary:hover { background: var(--primary-hover); }
    .att-btn-secondary { background: var(--card-bg); color: var(--text-primary); border: 1px solid var(--card-border); }
    .att-btn-sm { padding: 6px 12px; font-size: 13px; }
    .att-btn-danger { background: #fee2e2; color: #dc2626; }
    
    /* Table */
    .att-table { width: 100%; border-collapse: collapse; }
    .att-table th { padding: 10px 14px; text-align: left; font-size: 12px; font-weight: 600; color: var(--text-muted); text-transform: uppercase; background: var(--hover-bg, #f8fafc); border-bottom: 1px solid var(--card-border); }
    .att-table td { padding: 12px 14px; border-bottom: 1px solid var(--card-border); font-size: 14px; }
    .att-table tr:hover td { background: var(--hover-bg, #f8fafc); }
    .att-table input[type="number"] { width: 80px; padding: 6px 10px; border: 1px solid var(--input-border); border-radius: 6px; text-align: center; }
    
    /* Row layout */
    .att-row { display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; }
    
    /* Alert */
    .att-alert { padding: 12px 16px; border-radius: 8px; font-size: 13px; margin-bottom: 16px; }
    .att-alert-info { background: #eff6ff; color: #1e40af; border: 1px solid #bfdbfe; }
    .att-alert-success { background: #f0fdf4; color: #166534; border: 1px solid #bbf7d0; }
    
    /* Save Bar */
    .att-save-bar { padding: 16px 20px; border-top: 1px solid var(--card-border); background: var(--hover-bg, #f8fafc); border-radius: 0 0 10px 10px; }
    
    /* Empty */
    .att-empty { text-align: center; padding: 40px 20px; color: var(--text-muted); }
    
    /* Badge */
    .att-badge { display: inline-flex; padding: 4px 10px; border-radius: 20px; font-size: 12px; font-weight: 600; }
    .att-badge-success { background: #dcfce7; color: #166534; }
    .att-badge-warning { background: #fef3c7; color: #92400e; }
    
    /* Modal */
    .att-modal-overlay { position: fixed; inset: 0; background: rgba(0,0,0,0.5); z-index: 9998; display: none; align-items: center; justify-content: center; padding: 20px; }
    .att-modal-overlay.show { display: flex; }
    .att-modal { background: var(--card-bg); border-radius: 12px; width: 100%; max-width: 500px; max-height: 90vh; overflow: hidden; }
    .att-modal-header { padding: 16px 20px; border-bottom: 1px solid var(--card-border); display: flex; justify-content: space-between; align-items: center; }
    .att-modal-title { font-size: 16px; font-weight: 600; }
    .att-modal-close { background: none; border: none; font-size: 20px; cursor: pointer; color: var(--text-muted); }
    .att-modal-body { padding: 20px; overflow-y: auto; max-height: 60vh; }
    .att-modal-footer { padding: 16px 20px; border-top: 1px solid var(--card-border); display: flex; gap: 12px; justify-content: flex-end; }
    
    /* Dropdown with checkboxes */
    .att-dropdown-wrap { position: relative; }
    .att-dropdown-btn { width: 100%; padding: 10px 14px; border: 1px solid var(--input-border); border-radius: 8px; font-size: 14px; background: var(--input-bg); color: var(--text-primary); text-align: left; cursor: pointer; display: flex; justify-content: space-between; align-items: center; }
    .att-dropdown-btn::after { content: '▼'; font-size: 10px; color: var(--text-muted); }
    .att-dropdown-menu { position: absolute; top: 100%; left: 0; right: 0; background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 8px; box-shadow: 0 10px 40px rgba(0,0,0,0.15); z-index: 100; max-height: 250px; overflow-y: auto; display: none; }
    .att-dropdown-menu.show { display: block; }
    .att-dropdown-item { display: flex; align-items: center; gap: 10px; padding: 10px 14px; cursor: pointer; }
    .att-dropdown-item:hover { background: var(--hover-bg, #f8fafc); }
    .att-dropdown-item input { width: 18px; height: 18px; accent-color: var(--primary); }
    .att-selected-tags { display: flex; flex-wrap: wrap; gap: 6px; margin-top: 8px; }
    .att-tag { display: inline-flex; align-items: center; gap: 4px; padding: 4px 10px; background: var(--primary); color: #fff; border-radius: 20px; font-size: 12px; }
    .att-tag-remove { cursor: pointer; opacity: 0.8; }
    .att-tag-remove:hover { opacity: 1; }
</style>

@if(session('success'))
<div class="att-alert att-alert-success" style="margin:20px 20px 0;">{{ session('success') }}</div>
@endif

<div class="att-settings">
    <h1>Attendance Settings</h1>
    
    {{-- Tabs --}}
    <div class="att-tabs">
        <button class="att-tab active" onclick="switchAttTab('general')">General Settings</button>
        <button class="att-tab" onclick="switchAttTab('annual-leave')">Annual Leave</button>
        <button class="att-tab" onclick="switchAttTab('leave-types')">Leave Types</button>
        <button class="att-tab" onclick="switchAttTab('work-types')">Work Types</button>
        <button class="att-tab" onclick="switchAttTab('holidays')">Holidays</button>
    </div>
    
    {{-- ============================================== --}}
    {{-- GENERAL SETTINGS TAB --}}
    {{-- ============================================== --}}
    <div id="tab-general" class="att-tab-content active">
        <form action="{{ route('admin.attendance.settings.general.update') }}" method="POST">
            @csrf
            
            {{-- Check-in Options --}}
            <div class="att-card">
                <div class="att-card-header">
                    <h3 class="att-card-title">Check-in Options</h3>
                </div>
                <div class="att-card-body">
                    <div class="att-checkbox">
                        <input type="checkbox" name="settings[allow_self_checkin]" value="1" id="allow_self_checkin" {{ ($settings['allow_self_checkin'] ?? '1') == '1' ? 'checked' : '' }}>
                        <div class="att-checkbox-content">
                            <div class="att-checkbox-label">Allow Self Check-in</div>
                            <div class="att-checkbox-desc">Staff can check-in themselves using the navbar button</div>
                        </div>
                    </div>
                    
                    <div class="att-checkbox">
                        <input type="checkbox" name="settings[require_location]" value="1" id="require_location" {{ ($settings['require_location'] ?? '0') == '1' ? 'checked' : '' }}>
                        <div class="att-checkbox-content">
                            <div class="att-checkbox-label">Require Location for Check-in</div>
                            <div class="att-checkbox-desc">GPS location will be recorded with each check-in/out</div>
                        </div>
                    </div>
                </div>
            </div>
            
            {{-- Location Settings --}}
            <div class="att-card">
                <div class="att-card-header">
                    <h3 class="att-card-title">Location Settings</h3>
                </div>
                <div class="att-card-body">
                    <div class="att-form-group">
                        <label class="att-label">Company/Office Name</label>
                        <input type="text" name="settings[company_location_name]" class="att-input" value="{{ $settings['company_location_name'] ?? '' }}" placeholder="e.g., EchoPx Technologies Office">
                        <div class="att-help">This name will be shown in attendance logs when staff check-in from office</div>
                    </div>
                    
                    <div class="att-row">
                        <div class="att-form-group">
                            <label class="att-label">Office Latitude</label>
                            <input type="text" name="settings[company_latitude]" id="companyLat" class="att-input" value="{{ $settings['company_latitude'] ?? '' }}" placeholder="e.g., 12.9716">
                        </div>
                        <div class="att-form-group">
                            <label class="att-label">Office Longitude</label>
                            <input type="text" name="settings[company_longitude]" id="companyLng" class="att-input" value="{{ $settings['company_longitude'] ?? '' }}" placeholder="e.g., 77.5946">
                        </div>
                    </div>
                    
                    <div class="att-form-group">
                        <label class="att-label">Allowed Radius (meters)</label>
                        <input type="number" name="settings[allowed_radius]" class="att-input att-input-sm" value="{{ $settings['allowed_radius'] ?? '100' }}" min="10" max="5000" step="10">
                        <div class="att-help">Staff must be within this distance from office to check-in. Set 0 to allow from anywhere.</div>
                    </div>
                    
                    <div style="margin-top:12px;">
                        <button type="button" class="att-btn att-btn-secondary" onclick="getCurrentLocation()" style="font-size:13px;">
                            📍 Get Current Location
                        </button>
                        <span id="locationStatus" style="margin-left:10px;font-size:12px;color:var(--text-muted);"></span>
                    </div>
                    
                    <div class="att-form-group" style="margin-top:16px;">
                        <label class="att-label">Google Maps API Key (Optional)</label>
                        <input type="text" name="settings[google_map_api_key]" class="att-input" value="{{ $settings['google_map_api_key'] ?? '' }}" placeholder="AIzaSy...">
                        <div class="att-help">For showing map in attendance records. Leave empty to use OpenStreetMap.</div>
                    </div>
                </div>
            </div>
            
            {{-- Work Hours --}}
            <div class="att-card">
                <div class="att-card-header">
                    <h3 class="att-card-title">Default Work Hours</h3>
                </div>
                <div class="att-card-body">
                    <div class="att-row">
                        <div class="att-form-group">
                            <label class="att-label">Work Hours Per Day</label>
                            <input type="number" name="settings[work_hours_per_day]" class="att-input att-input-sm" value="{{ $settings['work_hours_per_day'] ?? '8' }}" min="1" max="24">
                        </div>
                        <div class="att-form-group">
                            <label class="att-label">Overtime Multiplier</label>
                            <input type="number" name="settings[overtime_multiplier]" class="att-input att-input-sm" value="{{ $settings['overtime_multiplier'] ?? '1.5' }}" step="0.1" min="1" max="5">
                            <div class="att-help">e.g., 1.5 = 150% pay for overtime</div>
                        </div>
                    </div>
                </div>
                <div class="att-save-bar">
                    <button type="submit" class="att-btn att-btn-primary">Save Settings</button>
                </div>
            </div>
        </form>
    </div>
    
    {{-- ============================================== --}}
    {{-- ANNUAL LEAVE TAB --}}
    {{-- ============================================== --}}
    <div id="tab-annual-leave" class="att-tab-content">
        {{-- Default Leave Days Card --}}
        <div class="att-card">
            <div class="att-card-header">
                <h3 class="att-card-title">Default Annual Leave Days</h3>
            </div>
            <div class="att-card-body">
                <div class="att-alert att-alert-info" style="margin-bottom:16px;">
                    Set default leave days for all staff. Individual adjustments can be made in the table below.
                </div>
                <form action="{{ route('admin.attendance.settings.general.update') }}" method="POST" style="display:flex;gap:16px;align-items:flex-end;flex-wrap:wrap;">
                    @csrf
                    <div class="att-form-group" style="margin-bottom:0;min-width:200px;">
                        <label class="att-label">Default Days Per Year</label>
                        <input type="number" name="settings[default_annual_leave_days]" class="att-input" value="{{ $settings['default_annual_leave_days'] ?? '12' }}" min="0" max="365" step="0.5">
                    </div>
                    <button type="submit" class="att-btn att-btn-primary">Update Default</button>
                </form>
            </div>
        </div>

        {{-- Per-Staff Adjustment --}}
        <div class="att-card">
            <div class="att-card-header">
                <h3 class="att-card-title">Staff-wise Leave Adjustment</h3>
            </div>
            <form action="{{ route('admin.attendance.settings.annual_leave.update') }}" method="POST">
                @csrf
                <div class="att-card-body" style="padding:0;">
                    <div style="overflow-x:auto;">
                        <table class="att-table">
                            <thead>
                                <tr>
                                    <th>Staff</th>
                                    <th>Department</th>
                                    <th>Role</th>
                                    <th style="width:140px;">Leave Days / Year</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($staffList ?? [] as $staff)
                                @php
                                    $currentDays = $settings['default_annual_leave_days'] ?? 12;
                                    if (isset($annualSettings[$staff->id])) {
                                        $setting = $annualSettings[$staff->id]->first();
                                        if ($setting && $setting->annual_days > 0) {
                                            $currentDays = $setting->annual_days;
                                        }
                                    }
                                @endphp
                                <tr>
                                    <td><strong>{{ $staff->first_name }} {{ $staff->last_name }}</strong></td>
                                    <td>{{ $staff->department ?? '-' }}</td>
                                    <td>{{ $staff->admin?->roles?->first()?->name ?? '-' }}</td>
                                    <td>
                                        <input type="number" name="settings[{{ $staff->id }}]" value="{{ $currentDays }}" min="0" max="365" step="0.5" style="width:80px;">
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="4" class="att-empty">No staff found</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="att-save-bar">
                    <button type="submit" class="att-btn att-btn-primary">Save Staff Leave Days</button>
                </div>
            </form>
        </div>
    </div>
    
    {{-- ============================================== --}}
    {{-- LEAVE TYPES TAB --}}
    {{-- ============================================== --}}
    <div id="tab-leave-types" class="att-tab-content">
        <div class="att-card">
            <div class="att-card-header">
                <h3 class="att-card-title">Leave Types</h3>
                <button class="att-btn att-btn-primary att-btn-sm" onclick="openLeaveTypeModal()">+ Add Leave Type</button>
            </div>
            <div class="att-card-body" style="padding:0;">
                <table class="att-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Code</th>
                            <th>Days/Month</th>
                            <th>Days/Year</th>
                            <th>Paid</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($leaveTypes ?? [] as $i => $type)
                        <tr>
                            <td>{{ $i + 1 }}</td>
                            <td>
                                <div style="display:flex; align-items:center; gap:8px;">
                                    <span style="width:12px; height:12px; border-radius:50%; background:{{ $type->color ?? '#3b82f6' }};"></span>
                                    <strong>{{ $type->name }}</strong>
                                </div>
                            </td>
                            <td><span class="att-badge att-badge-success">{{ $type->code ?? '-' }}</span></td>
                            <td>
                                <input type="number" class="att-input" style="width:70px; padding:6px 10px; text-align:center;" 
                                    value="{{ $type->days_per_month ?? 0 }}" min="0"
                                    onchange="updateLeaveTypeLimit({{ $type->id }}, 'days_per_month', this.value)">
                            </td>
                            <td>
                                <input type="number" class="att-input" style="width:70px; padding:6px 10px; text-align:center;" 
                                    value="{{ $type->days_per_year ?? 0 }}" min="0"
                                    onchange="updateLeaveTypeLimit({{ $type->id }}, 'days_per_year', this.value)">
                            </td>
                            <td>{{ $type->is_paid ? 'Yes' : 'No' }}</td>
                            <td>
                                <button class="att-btn att-btn-danger att-btn-sm" onclick="deleteLeaveType({{ $type->id }})">Delete</button>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="att-empty">No leave types. Click "Add Leave Type" to create one.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        
        <div class="att-alert att-alert-info">
            <strong>How it works:</strong><br>
            • <strong>Days/Month:</strong> Maximum leaves allowed per month (e.g., 2 sick leaves per month)<br>
            • <strong>Days/Year:</strong> Maximum leaves allowed per year (e.g., 12 annual leaves per year)<br>
            • Set to <strong>0</strong> for unlimited leaves<br>
            • Staff can still apply even if limit exceeded - it just shows a warning
        </div>
    </div>
    
    {{-- ============================================== --}}
    {{-- WORK TYPES TAB (for Extra Work / Timesheet) --}}
    {{-- ============================================== --}}
    <div id="tab-work-types" class="att-tab-content">
        <div class="att-card">
            <div class="att-card-header">
                <h3 class="att-card-title">Work Types</h3>
                <button class="att-btn att-btn-primary att-btn-sm" onclick="openWorkTypeModal()">+ Add Work Type</button>
            </div>
            <div class="att-card-body" style="padding:0;">
                <table class="att-table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Color</th>
                            <th>Multiplier</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($timesheetTypes ?? [] as $type)
                        <tr>
                            <td><strong>{{ $type->name }}</strong></td>
                            <td>
                                <span style="display:inline-flex; align-items:center; gap:6px;">
                                    <span style="width:16px; height:16px; border-radius:4px; background:{{ $type->color ?? '#3b82f6' }};"></span>
                                    {{ $type->color ?? '#3b82f6' }}
                                </span>
                            </td>
                            <td>
                                <span class="att-badge att-badge-success">{{ $type->multiplier ?? 1 }}x</span>
                            </td>
                            <td>
                                @if($type->status)
                                    <span class="att-badge att-badge-success">Active</span>
                                @else
                                    <span class="att-badge att-badge-warning">Inactive</span>
                                @endif
                            </td>
                            <td>
                                <button class="att-btn att-btn-secondary att-btn-sm" onclick="editWorkType({{ $type->id }}, '{{ $type->name }}', '{{ $type->color ?? '#3b82f6' }}', {{ $type->multiplier ?? 1 }})">Edit</button>
                                <form action="{{ route('admin.attendance.settings.work_type.destroy', $type->id) }}" method="POST" style="display:inline;" onsubmit="return confirm('Delete this work type?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="att-btn att-btn-danger att-btn-sm">Delete</button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="5" class="att-empty">No work types defined. Add one to get started.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        
        <div class="att-alert att-alert-info">
            <strong>About Work Types:</strong><br>
            • Work types are used for extra work / overtime assignments<br>
            • <strong>Multiplier:</strong> Pay rate multiplier (e.g., 1.5x for overtime, 2x for holidays)<br>
            • Standard work has 1x multiplier
        </div>
    </div>
    
    {{-- ============================================== --}}
    {{-- HOLIDAYS TAB --}}
    {{-- ============================================== --}}
    <div id="tab-holidays" class="att-tab-content">
        <div class="att-card">
            <div class="att-card-header">
                <h3 class="att-card-title">Holidays {{ now()->year }}</h3>
                <button class="att-btn att-btn-primary att-btn-sm" onclick="openHolidayModal()">+ Add Holiday</button>
            </div>
            <div class="att-card-body" style="padding:0;">
                <table class="att-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Date</th>
                            <th>Holiday Name</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($dayOffs ?? [] as $i => $holiday)
                        <tr>
                            <td>{{ $i + 1 }}</td>
                            <td>{{ \Carbon\Carbon::parse($holiday->off_date)->format('d M Y, l') }}</td>
                            <td><strong>{{ $holiday->reason }}</strong></td>
                            <td>
                                <button class="att-btn att-btn-danger att-btn-sm" onclick="deleteHoliday({{ $holiday->id }})">Delete</button>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="4" class="att-empty">No holidays configured. Click "Add Holiday" to add one.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        
        <div class="att-alert att-alert-info">
            <strong>Note:</strong> Weekly days off (Saturday, Sunday) are configured in <a href="{{ route('admin.attendance.shift_types.index') }}">Shift Types</a>.
            Holidays listed here are specific dates like New Year, Diwali, etc.
        </div>
    </div>
</div>

{{-- Leave Type Modal --}}
<div id="leaveTypeModal" class="att-modal-overlay">
    <div class="att-modal">
        <div class="att-modal-header">
            <h3 class="att-modal-title">Add Leave Type</h3>
            <button class="att-modal-close" onclick="closeLeaveTypeModal()">&times;</button>
        </div>
        <form action="{{ route('admin.attendance.settings.leave-types.store') }}" method="POST">
            @csrf
            <div class="att-modal-body">
                <div class="att-form-group">
                    <label class="att-label">Leave Type Name *</label>
                    <input type="text" name="name" class="att-input" required placeholder="e.g., Sick Leave">
                </div>
                <div class="att-row">
                    <div class="att-form-group">
                        <label class="att-label">Code *</label>
                        <input type="text" name="code" class="att-input" required maxlength="5" placeholder="e.g., SL" style="text-transform:uppercase;">
                        <div class="att-help">Short code shown in calendar</div>
                    </div>
                    <div class="att-form-group">
                        <label class="att-label">Color</label>
                        <input type="color" name="color" class="att-input" value="#3b82f6" style="height:42px; padding:4px;">
                    </div>
                </div>
                <div class="att-row">
                    <div class="att-form-group">
                        <label class="att-label">Days Per Month</label>
                        <input type="number" name="days_per_month" class="att-input" min="0" value="0" placeholder="e.g., 2">
                        <div class="att-help">Max leaves per month (0 = unlimited)</div>
                    </div>
                    <div class="att-form-group">
                        <label class="att-label">Days Per Year</label>
                        <input type="number" name="days_per_year" class="att-input" min="0" value="0" placeholder="e.g., 12">
                        <div class="att-help">Max leaves per year (0 = unlimited)</div>
                    </div>
                </div>
                <div class="att-checkbox" style="margin-top:12px;">
                    <input type="checkbox" name="is_paid" value="1" id="modal_is_paid" checked>
                    <div class="att-checkbox-content">
                        <div class="att-checkbox-label">Paid Leave</div>
                        <div class="att-checkbox-desc">Staff will receive salary during this leave</div>
                    </div>
                </div>
            </div>
            <div class="att-modal-footer">
                <button type="button" class="att-btn att-btn-secondary" onclick="closeLeaveTypeModal()">Cancel</button>
                <button type="submit" class="att-btn att-btn-primary">Save</button>
            </div>
        </form>
    </div>
</div>

{{-- Holiday Modal --}}
<div id="holidayModal" class="att-modal-overlay">
    <div class="att-modal">
        <div class="att-modal-header">
            <h3 class="att-modal-title">Add Holiday</h3>
            <button class="att-modal-close" onclick="closeHolidayModal()">&times;</button>
        </div>
        <form action="{{ route('admin.attendance.settings.holidays.store') }}" method="POST">
            @csrf
            <div class="att-modal-body">
                <div class="att-form-group">
                    <label class="att-label">Holiday Name *</label>
                    <input type="text" name="name" class="att-input" required placeholder="e.g., New Year, Diwali">
                </div>
                <div class="att-form-group">
                    <label class="att-label">Date *</label>
                    <input type="date" name="date" class="att-input" required>
                </div>
            </div>
            <div class="att-modal-footer">
                <button type="button" class="att-btn att-btn-secondary" onclick="closeHolidayModal()">Cancel</button>
                <button type="submit" class="att-btn att-btn-primary">Save</button>
            </div>
        </form>
    </div>
</div>

{{-- Work Type Modal --}}
<div id="workTypeModal" class="att-modal-overlay">
    <div class="att-modal">
        <div class="att-modal-header">
            <h3 class="att-modal-title" id="workTypeModalTitle">Add Work Type</h3>
            <button class="att-modal-close" onclick="closeWorkTypeModal()">&times;</button>
        </div>
        <form id="workTypeForm" action="{{ route('admin.attendance.settings.work_type.store') }}" method="POST">
            @csrf
            <input type="hidden" name="_method" id="workTypeMethod" value="POST">
            <div class="att-modal-body">
                <div class="att-form-group">
                    <label class="att-label">Work Type Name *</label>
                    <input type="text" name="name" id="workTypeName" class="att-input" required placeholder="e.g., Overtime, Holiday Work">
                </div>
                <div class="att-row">
                    <div class="att-form-group">
                        <label class="att-label">Color</label>
                        <input type="color" name="color" id="workTypeColor" class="att-input" value="#3b82f6" style="height:42px; padding:4px;">
                    </div>
                    <div class="att-form-group">
                        <label class="att-label">Pay Multiplier</label>
                        <input type="number" name="multiplier" id="workTypeMultiplier" class="att-input" value="1" min="0.5" max="5" step="0.25">
                        <div class="att-help">1 = normal, 1.5 = time and half, 2 = double</div>
                    </div>
                </div>
            </div>
            <div class="att-modal-footer">
                <button type="button" class="att-btn att-btn-secondary" onclick="closeWorkTypeModal()">Cancel</button>
                <button type="submit" class="att-btn att-btn-primary">Save</button>
            </div>
        </form>
    </div>
</div>

<script>
// Tab switching
function switchAttTab(tabId) {
    document.querySelectorAll('.att-tab').forEach(t => t.classList.remove('active'));
    document.querySelectorAll('.att-tab-content').forEach(c => c.classList.remove('active'));
    event.target.classList.add('active');
    document.getElementById('tab-' + tabId).classList.add('active');
}

// Dropdown toggle
function toggleDropdown(id) {
    var menu = document.getElementById(id).querySelector('.att-dropdown-menu');
    menu.classList.toggle('show');
}

// Close dropdown when clicking outside
document.addEventListener('click', function(e) {
    if (!e.target.closest('.att-dropdown-wrap')) {
        document.querySelectorAll('.att-dropdown-menu').forEach(m => m.classList.remove('show'));
    }
});

// Modals
function openLeaveTypeModal() { document.getElementById('leaveTypeModal').classList.add('show'); }
function closeLeaveTypeModal() { document.getElementById('leaveTypeModal').classList.remove('show'); }
function openHolidayModal() { document.getElementById('holidayModal').classList.add('show'); }
function closeHolidayModal() { document.getElementById('holidayModal').classList.remove('show'); }

// Work Type Modal
function openWorkTypeModal() {
    document.getElementById('workTypeModalTitle').textContent = 'Add Work Type';
    document.getElementById('workTypeForm').action = '{{ route("admin.attendance.settings.work_type.store") }}';
    document.getElementById('workTypeMethod').value = 'POST';
    document.getElementById('workTypeName').value = '';
    document.getElementById('workTypeColor').value = '#3b82f6';
    document.getElementById('workTypeMultiplier').value = '1';
    document.getElementById('workTypeModal').classList.add('show');
}

function editWorkType(id, name, color, multiplier) {
    document.getElementById('workTypeModalTitle').textContent = 'Edit Work Type';
    document.getElementById('workTypeForm').action = '{{ url("admin/attendance/settings/work-types") }}/' + id;
    document.getElementById('workTypeMethod').value = 'PUT';
    document.getElementById('workTypeName').value = name;
    document.getElementById('workTypeColor').value = color;
    document.getElementById('workTypeMultiplier').value = multiplier;
    document.getElementById('workTypeModal').classList.add('show');
}

function closeWorkTypeModal() { document.getElementById('workTypeModal').classList.remove('show'); }

// Delete functions
function deleteLeaveType(id) {
    if (confirm('Delete this leave type?')) {
        fetch('{{ url("admin/attendance/settings/leave-types") }}/' + id, {
            method: 'DELETE',
            headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' }
        }).then(() => location.reload());
    }
}

// Update leave type limit inline
function updateLeaveTypeLimit(id, field, value) {
    fetch('{{ url("admin/attendance/settings/leave-types") }}/' + id + '/update-limit', {
        method: 'POST',
        headers: { 
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Content-Type': 'application/json',
            'Accept': 'application/json'
        },
        body: JSON.stringify({ field: field, value: value })
    })
    .then(r => r.json())
    .then(data => {
        if (data.success) {
            // Brief visual feedback
            event.target.style.borderColor = '#10b981';
            setTimeout(() => { event.target.style.borderColor = ''; }, 1000);
        }
    })
    .catch(err => {
        alert('Failed to update');
        console.error(err);
    });
}

function deleteHoliday(id) {
    if (confirm('Delete this holiday?')) {
        fetch('{{ url("admin/attendance/settings/holidays") }}/' + id, {
            method: 'DELETE',
            headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' }
        }).then(() => location.reload());
    }
}

// Close modal on escape
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeLeaveTypeModal();
        closeHolidayModal();
        closeWorkTypeModal();
    }
});

// Close modal on overlay click
document.querySelectorAll('.att-modal-overlay').forEach(function(m) {
    m.addEventListener('click', function(e) {
        if (e.target === m) m.classList.remove('show');
    });
});
</script>
