<style>
    .page-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px; flex-wrap: wrap; gap: 16px; }
    .page-header h1 { font-size: 24px; font-weight: 700; color: var(--text-primary); margin: 0; display: flex; align-items: center; gap: 10px; }
    .page-header h1 svg { width: 28px; height: 28px; color: var(--primary); }
    .btn-back { display: inline-flex; align-items: center; gap: 6px; color: var(--text-muted); text-decoration: none; font-size: 14px; }
    .btn-back:hover { color: var(--primary); }
    
    .form-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; max-width: 900px; }
    .form-card-header { padding: 16px 20px; border-bottom: 1px solid var(--card-border); }
    .form-card-title { font-size: 16px; font-weight: 600; color: var(--text-primary); }
    .form-card-body { padding: 24px; }
    
    .form-section { margin-bottom: 24px; padding-bottom: 20px; border-bottom: 1px solid var(--card-border); }
    .form-section:last-child { margin-bottom: 0; padding-bottom: 0; border-bottom: none; }
    .form-section-title { font-size: 14px; font-weight: 700; color: var(--text-primary); margin-bottom: 16px; display: flex; align-items: center; gap: 8px; }
    .form-section-title svg { width: 18px; height: 18px; color: var(--primary); }
    
    .form-group { margin-bottom: 16px; }
    .form-label { display: block; font-size: 14px; font-weight: 500; color: var(--text-primary); margin-bottom: 6px; }
    .form-label .required { color: #dc2626; }
    .form-input, .form-select, .form-textarea { width: 100%; padding: 10px 14px; border: 1px solid var(--input-border); border-radius: 8px; font-size: 14px; background: var(--input-bg); color: var(--input-text); transition: border-color 0.2s; }
    .form-input:focus, .form-select:focus, .form-textarea:focus { outline: none; border-color: var(--primary); box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1); }
    .form-textarea { min-height: 80px; resize: vertical; }
    .form-hint { font-size: 12px; color: var(--text-muted); margin-top: 4px; }
    
    .form-row { display: grid; grid-template-columns: repeat(2, 1fr); gap: 16px; }
    .form-row-3 { display: grid; grid-template-columns: repeat(3, 1fr); gap: 16px; }
    @media (max-width: 600px) { .form-row, .form-row-3 { grid-template-columns: 1fr; } }
    
    .color-input-wrap { display: flex; gap: 10px; align-items: center; }
    .color-input-wrap input[type="color"] { width: 50px; height: 40px; border: 1px solid var(--input-border); border-radius: 8px; cursor: pointer; padding: 2px; }
    .color-input-wrap input[type="text"] { flex: 1; }
    
    .days-grid { display: flex; flex-wrap: wrap; gap: 8px; }
    .day-checkbox { display: flex; align-items: center; gap: 6px; padding: 8px 14px; background: var(--hover-bg); border: 1px solid var(--card-border); border-radius: 8px; cursor: pointer; transition: all 0.2s; }
    .day-checkbox:hover { border-color: var(--primary); }
    .day-checkbox.checked { background: rgba(59,130,246,0.1); border-color: var(--primary); }
    .day-checkbox input { accent-color: var(--primary); }
    
    .location-section { background: var(--hover-bg); border: 1px solid var(--card-border); border-radius: 10px; padding: 16px; margin-top: 16px; display: none; }
    .location-section.show { display: block; }
    
    .map-container { height: 300px; border-radius: 8px; overflow: hidden; margin-top: 12px; border: 1px solid var(--card-border); }
    #locationMap { height: 100%; width: 100%; }
    
    .form-actions { display: flex; gap: 12px; padding-top: 20px; border-top: 1px solid var(--card-border); margin-top: 24px; }
    .btn { padding: 10px 24px; border-radius: 8px; font-weight: 600; font-size: 14px; cursor: pointer; transition: all 0.2s; border: none; display: inline-flex; align-items: center; gap: 6px; }
    .btn-primary { background: var(--primary); color: #fff; }
    .btn-primary:hover { background: var(--primary-hover); }
    .btn-secondary { background: var(--card-bg); color: var(--text-primary); border: 1px solid var(--card-border); }
    .btn-secondary:hover { background: var(--hover-bg); }
    .btn-sm { padding: 8px 14px; font-size: 13px; }
    
    .toggle-switch { display: flex; align-items: center; gap: 12px; cursor: pointer; }
    .toggle-switch input { width: 20px; height: 20px; accent-color: var(--primary); }
    .toggle-switch span { font-size: 14px; font-weight: 500; color: var(--text-primary); }
</style>

<!-- Leaflet CSS -->
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />

<div style="padding: 20px;">
    <div class="page-header">
        <div>
            <a href="{{ route('admin.attendance.shift_types.index') }}" class="btn-back">
                <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M19 12H5m7-7l-7 7 7 7"/></svg>
                Back to Shift Types
            </a>
            <h1>
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 6v6l4 2m6-2a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                {{ $pageTitle ?? 'Create Shift Type' }}
            </h1>
        </div>
    </div>

    <div class="form-card">
        <div class="form-card-header">
            <div class="form-card-title">Shift Type Details</div>
        </div>
        <div class="form-card-body">
            <form action="{{ route('admin.attendance.shift_types.store') }}" method="POST">
                @csrf
                
                {{-- Basic Info Section --}}
                <div class="form-section">
                    <div class="form-section-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                        Basic Information
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label">Shift Name <span class="required">*</span></label>
                            <input type="text" name="name" class="form-input" value="{{ old('name') }}" placeholder="e.g., General Shift, Morning Shift" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Color <span class="required">*</span></label>
                            <div class="color-input-wrap">
                                <input type="color" id="colorPicker" value="{{ old('color', '#3b82f6') }}" onchange="document.getElementById('colorText').value = this.value">
                                <input type="text" name="color" id="colorText" class="form-input" value="{{ old('color', '#3b82f6') }}" placeholder="#3b82f6" required>
                            </div>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label">Work Start Time <span class="required">*</span></label>
                            <input type="time" name="start_time" class="form-input" value="{{ old('start_time', '09:00') }}" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Work End Time <span class="required">*</span></label>
                            <input type="time" name="end_time" class="form-input" value="{{ old('end_time', '18:00') }}" required>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label">Lunch Break Start</label>
                            <input type="time" name="lunch_start_time" class="form-input" value="{{ old('lunch_start_time') }}">
                            <div class="form-hint">Leave empty if no lunch break</div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Lunch Break End</label>
                            <input type="time" name="lunch_end_time" class="form-input" value="{{ old('lunch_end_time') }}">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="form-label">Description</label>
                        <textarea name="description" class="form-textarea" placeholder="Optional description...">{{ old('description') }}</textarea>
                    </div>
                </div>

                {{-- Days Off Section --}}
                <div class="form-section">
                    <div class="form-section-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
                        Weekly Days Off
                    </div>
                    
                    <div class="days-grid">
                        @foreach(['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'] as $day)
                        <label class="day-checkbox" onclick="this.classList.toggle('checked')">
                            <input type="checkbox" name="days_off[]" value="{{ $day }}" {{ in_array($day, old('days_off', ['saturday', 'sunday'])) ? 'checked' : '' }}>
                            {{ ucfirst($day) }}
                        </label>
                        @endforeach
                    </div>
                    <div class="form-hint" style="margin-top:8px;">Select which days are weekly off for this shift</div>
                </div>

                {{-- Location Restriction Section --}}
                <div class="form-section">
                    <div class="form-section-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                        Location Restriction (Optional)
                    </div>
                    
                    <label class="toggle-switch">
                        <input type="checkbox" name="location_restricted" id="locationRestricted" value="1" {{ old('location_restricted') ? 'checked' : '' }} onchange="toggleLocationSection()">
                        <span>Enable location restriction for this shift</span>
                    </label>
                    <div class="form-hint">When enabled, staff can only check-in within the specified radius</div>
                    
                    <div class="location-section" id="locationSection">
                        <div class="form-group">
                            <label class="form-label">Location Name</label>
                            <input type="text" name="location_name" id="locationName" class="form-input" value="{{ old('location_name') }}" placeholder="e.g., Main Office, Branch Office">
                            <div class="form-hint">This name will be shown in attendance logs</div>
                        </div>
                        
                        <div class="form-row-3">
                            <div class="form-group">
                                <label class="form-label">Latitude</label>
                                <input type="text" name="location_latitude" id="locationLat" class="form-input" value="{{ old('location_latitude') }}" placeholder="e.g., 12.9716">
                            </div>
                            <div class="form-group">
                                <label class="form-label">Longitude</label>
                                <input type="text" name="location_longitude" id="locationLng" class="form-input" value="{{ old('location_longitude') }}" placeholder="e.g., 77.5946">
                            </div>
                            <div class="form-group">
                                <label class="form-label">Allowed Radius (meters)</label>
                                <input type="number" name="allowed_radius" id="allowedRadius" class="form-input" value="{{ old('allowed_radius', 100) }}" min="10" max="5000" step="10" onchange="updateMapCircle()">
                            </div>
                        </div>
                        
                        <div style="display:flex;gap:10px;margin-top:8px;">
                            <button type="button" class="btn btn-secondary btn-sm" onclick="getCurrentLocation()">
                                📍 Get My Current Location
                            </button>
                            <span id="locationStatus" style="font-size:12px;color:var(--text-muted);line-height:32px;"></span>
                        </div>
                        
                        <div class="map-container">
                            <div id="locationMap"></div>
                        </div>
                        <div class="form-hint" style="margin-top:8px;">
                            <strong>Click on map</strong> to set location, or use "Get My Current Location" button. 
                            The blue circle shows the allowed check-in area.
                        </div>
                    </div>
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M5 13l4 4L19 7"/></svg>
                        Create Shift Type
                    </button>
                    <a href="{{ route('admin.attendance.shift_types.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Leaflet JS -->
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

<script>
var map = null;
var marker = null;
var circle = null;

// Initialize day checkbox styling
document.querySelectorAll('.day-checkbox input').forEach(function(cb) {
    if (cb.checked) cb.closest('.day-checkbox').classList.add('checked');
});

// Toggle location section
function toggleLocationSection() {
    var section = document.getElementById('locationSection');
    var checkbox = document.getElementById('locationRestricted');
    
    if (checkbox.checked) {
        section.classList.add('show');
        setTimeout(initMap, 100);
    } else {
        section.classList.remove('show');
    }
}

// Initialize map
function initMap() {
    if (map) return;
    
    var lat = parseFloat(document.getElementById('locationLat').value) || 12.9716;
    var lng = parseFloat(document.getElementById('locationLng').value) || 77.5946;
    var radius = parseInt(document.getElementById('allowedRadius').value) || 100;
    
    map = L.map('locationMap').setView([lat, lng], 16);
    
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap'
    }).addTo(map);
    
    // Add marker
    marker = L.marker([lat, lng], { draggable: true }).addTo(map);
    
    // Add circle
    circle = L.circle([lat, lng], {
        color: '#3b82f6',
        fillColor: '#3b82f6',
        fillOpacity: 0.2,
        radius: radius
    }).addTo(map);
    
    // Update on marker drag
    marker.on('dragend', function(e) {
        var pos = marker.getLatLng();
        updateLocation(pos.lat, pos.lng);
    });
    
    // Update on map click
    map.on('click', function(e) {
        updateLocation(e.latlng.lat, e.latlng.lng);
    });
}

// Update location
function updateLocation(lat, lng) {
    document.getElementById('locationLat').value = lat.toFixed(6);
    document.getElementById('locationLng').value = lng.toFixed(6);
    
    if (marker) marker.setLatLng([lat, lng]);
    if (circle) circle.setLatLng([lat, lng]);
    if (map) map.panTo([lat, lng]);
}

// Update circle radius
function updateMapCircle() {
    var radius = parseInt(document.getElementById('allowedRadius').value) || 100;
    if (circle) circle.setRadius(radius);
}

// Get current location
function getCurrentLocation() {
    var status = document.getElementById('locationStatus');
    
    if (!navigator.geolocation) {
        status.textContent = '❌ Geolocation not supported';
        return;
    }
    
    status.textContent = '⏳ Getting location...';
    
    navigator.geolocation.getCurrentPosition(
        function(pos) {
            var lat = pos.coords.latitude;
            var lng = pos.coords.longitude;
            
            updateLocation(lat, lng);
            if (map) map.setView([lat, lng], 16);
            
            status.textContent = '✅ Location set!';
            setTimeout(function() { status.textContent = ''; }, 3000);
        },
        function(err) {
            status.textContent = '❌ ' + (err.code === 1 ? 'Permission denied' : 'Location error');
        },
        { enableHighAccuracy: true, timeout: 15000 }
    );
}

// Init on load
document.addEventListener('DOMContentLoaded', function() {
    if (document.getElementById('locationRestricted').checked) {
        toggleLocationSection();
    }
});
</script>
