<style>
    .page-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px; flex-wrap: wrap; gap: 16px; }
    .page-header h1 { font-size: 24px; font-weight: 700; color: var(--text-primary); margin: 0; display: flex; align-items: center; gap: 10px; }
    .page-header h1 svg { width: 28px; height: 28px; color: var(--primary); }
    .btn-add { display: inline-flex; align-items: center; gap: 8px; background: linear-gradient(135deg, var(--primary), var(--primary-hover)); color: #fff; padding: 10px 20px; border-radius: 8px; text-decoration: none; font-weight: 600; font-size: 14px; box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3); transition: all 0.2s; }
    .btn-add:hover { transform: translateY(-2px); box-shadow: 0 6px 16px rgba(59, 130, 246, 0.4); color: #fff; }
    .btn-add svg { width: 18px; height: 18px; }
    
    .table-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; }
    .table-card-header { padding: 16px 20px; border-bottom: 1px solid var(--card-border); display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 12px; }
    .table-card-title { font-size: 16px; font-weight: 600; color: var(--text-primary); display: flex; align-items: center; gap: 8px; }
    .table-card-title svg { width: 20px; height: 20px; color: var(--text-muted); }
    .table-card-body { padding: 0; }
    
    .cell-dash { color: var(--text-muted); }
    .cell-value { font-weight: 500; color: var(--text-primary); }
    .shift-badge { display: inline-flex; align-items: center; gap: 6px; padding: 4px 10px; border-radius: 6px; font-size: 12px; font-weight: 600; }
    
    @media (max-width: 768px) {
        .page-header { flex-direction: column; align-items: flex-start; }
        .btn-add { width: 100%; justify-content: center; }
    }
</style>

<div style="padding: 20px;">
    <div class="page-header">
        <h1>
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
            </svg>
            {{ $pageTitle ?? 'Shift Assignments' }}
        </h1>
        <a href="{{ route('admin.attendance.shifts.create') }}" class="btn-add">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M12 4v16m8-8H4"></path></svg>
            Assign Shift
        </a>
    </div>

    <div class="table-card">
        <div class="table-card-header">
            <div class="table-card-title">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M4 6h16M4 10h16M4 14h16M4 18h16"></path></svg>
                All Shift Assignments
            </div>
        </div>
        <div class="table-card-body">
            <table id="shiftsTable" 
                   class="dt-table dt-search dt-export dt-perpage" 
                   data-route="{{ route('admin.attendance.shifts.data') }}">
                <thead>
                    <tr>
                        <th data-col="_row_num" style="width:50px;">#</th>
                        <th data-col="staff_name">Staff</th>
                        <th data-col="shift_type_name" data-render="shift_render">Shift Type</th>
                        <th class="dt-sort" data-col="from_date">From</th>
                        <th data-col="to_date">To</th>
                        <th data-col="created_at">Created</th>
                        <th data-render="actions" style="width:100px;">Actions</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
</div>

@include('components.datatable')

<script>
window.dtRenders = window.dtRenders || {};

window.dtRenders.shift_render = function(value, row) {
    var color = row.shift_type_color || '#3b82f6';
    return '<span class="shift-badge" style="background:' + color + '20;color:' + color + ';">' +
           '<span style="width:8px;height:8px;border-radius:50%;background:' + color + ';"></span>' +
           value + '</span>';
};

window.dtRenders.actions = function(value, row) {
    var html = '<div style="display:flex;gap:6px;align-items:center;">';
    if (row._edit_url) {
        html += '<a href="' + row._edit_url + '" style="color:var(--warning);padding:5px;display:inline-flex;" title="Edit"><svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg></a>';
    }
    if (row._delete_url) {
        html += '<button onclick="dtDelete(\'' + row._delete_url + '\')" style="color:var(--danger);padding:5px;display:inline-flex;background:none;border:none;cursor:pointer;" title="Delete"><svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg></button>';
    }
    html += '</div>';
    return html;
};
</script>
