<?php

namespace Modules\Attendance\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\Admin\Staff;

class AdditionalHour extends Model
{
    protected $table = 'att_additional_hours';

    protected $fillable = [
        'staff_id',
        'assigned_by',
        'work_date',
        'time_in',
        'time_out',
        'work_type_id',
        'hours',
        'reason',
        'status',
        'acknowledged_at',
    ];

    protected $casts = [
        'work_date' => 'date',
        'acknowledged_at' => 'datetime',
        'hours' => 'decimal:2',
    ];

    public function staff(): BelongsTo
    {
        return $this->belongsTo(Staff::class, 'staff_id');
    }

    public function workType(): BelongsTo
    {
        return $this->belongsTo(TimesheetType::class, 'work_type_id');
    }

    public function assigner(): BelongsTo
    {
        return $this->belongsTo(Staff::class, 'assigned_by');
    }

    // Status badge
    public function getStatusBadgeAttribute(): string
    {
        return match($this->status) {
            'assigned' => '<span class="status-badge status-pending">Assigned</span>',
            'acknowledged' => '<span class="status-badge status-info">Acknowledged</span>',
            'completed' => '<span class="status-badge status-approved">Completed</span>',
            'cancelled' => '<span class="status-badge status-rejected">Cancelled</span>',
            default => $this->status,
        };
    }
}
