<?php

namespace Modules\Attendance\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\Admin;

class AttendanceLog extends Model
{
    protected $table = 'att_attendance_logs';

    protected $fillable = [
        'attendance_id',
        'action',
        'action_time',
        'ip_address',
        'location',
        'latitude',
        'longitude',
        'device_info',
        'performed_by', // admin_id
        'notes',
    ];

    protected $casts = [
        'action_time' => 'datetime:H:i:s',
        'latitude' => 'decimal:8',
        'longitude' => 'decimal:8',
    ];

    // =====================
    // RELATIONSHIPS
    // =====================
    
    public function attendance(): BelongsTo
    {
        return $this->belongsTo(Attendance::class);
    }

    public function performedByAdmin(): BelongsTo
    {
        return $this->belongsTo(Admin::class, 'performed_by');
    }

    // =====================
    // ACCESSORS
    // =====================
    
    public function getActionLabelAttribute(): string
    {
        $labels = [
            'check_in' => 'Check In',
            'check_out' => 'Check Out',
            'break_start' => 'Break Start',
            'break_end' => 'Break End',
            'manual_edit' => 'Manual Edit',
        ];

        return $labels[$this->action] ?? ucfirst($this->action);
    }

    public function getActionColorAttribute(): string
    {
        $colors = [
            'check_in' => 'success',
            'check_out' => 'danger',
            'break_start' => 'warning',
            'break_end' => 'info',
            'manual_edit' => 'secondary',
        ];

        return $colors[$this->action] ?? 'secondary';
    }

    public function getPerformerNameAttribute(): string
    {
        if ($this->performedByAdmin) {
            return $this->performedByAdmin->name;
        }
        return 'System';
    }
}
