<?php

namespace Modules\Attendance\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class LeaveType extends Model
{
    protected $table = 'att_leave_types';

    protected $fillable = [
        'name',
        'code',
        'color',
        'days_per_month',
        'days_per_year',
        'is_paid',
        'description',
        'status',
    ];

    protected $casts = [
        'days_per_month' => 'integer',
        'days_per_year' => 'integer',
        'is_paid' => 'boolean',
        'status' => 'boolean',
    ];

    public function leaveApplications(): HasMany
    {
        return $this->hasMany(LeaveApplication::class, 'leave_type_id');
    }

    public function staffSettings(): HasMany
    {
        return $this->hasMany(StaffLeaveSetting::class, 'leave_type_id');
    }
}
